/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ContextHelpProviderInput;
import org.eclipse.help.ui.internal.views.ContextHelpSorter;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.RelatedTopicsPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ContextHelpPart
extends SectionPart
implements IHelpPart {
    private ReusableHelpPart parent;
    private static final String HELP_KEY = "org.eclipse.ui.help";
    private FormText text;
    private Control lastControl;
    private IContextProvider lastProvider;
    private IContext lastContext;
    private IWorkbenchPart lastPart;
    private String defaultText = "";
    private String id;
    private Font codeFont;

    public ContextHelpPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 322);
        Section section = this.getSection();
        section.marginWidth = 5;
        section.setText(Messages.ContextHelpPart_about);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState() && (ContextHelpPart.this.lastProvider != null || ContextHelpPart.this.lastControl != null)) {
                    String helpText = ContextHelpPart.this.createContextHelp(ContextHelpPart.this.lastProvider, ContextHelpPart.this.lastControl);
                    ContextHelpPart.this.updateText(helpText);
                }
            }
        });
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.topMargin = 0;
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.text = toolkit.createFormText(container, false);
        this.text.setWhitespaceNormalized(false);
        this.text.setLayoutData((Object)new TableWrapData(256));
        this.text.setColor("org.eclipse.ui.forms.TITLE", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.codeFont = ContextHelpPart.createCodeFont(parent.getDisplay(), parent.getFont(), JFaceResources.getTextFont());
        this.text.setFont("code", this.codeFont);
        String key = "obj16/topic_small.gif";
        this.text.setImage(key, HelpUIResources.getImage(key));
        this.text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ContextHelpPart.this.doOpenLink(e.getHref());
            }

            public void linkEntered(HyperlinkEvent e) {
                ContextHelpPart.this.parent.handleLinkEntered(e);
            }

            public void linkExited(HyperlinkEvent e) {
                ContextHelpPart.this.parent.handleLinkExited(e);
            }
        });
        this.text.setText(this.defaultText, false, false);
    }

    private static Font createCodeFont(Display display, Font regularFont, Font textFont) {
        FontData[] rfontData = regularFont.getFontData();
        FontData[] tfontData = textFont.getFontData();
        int height = 0;
        int i = 0;
        while (i < rfontData.length) {
            FontData data = rfontData[i];
            height = Math.max(height, data.getHeight());
            ++i;
        }
        i = 0;
        while (i < tfontData.length) {
            tfontData[i].setHeight(height);
            ++i;
        }
        return new Font((Device)display, tfontData);
    }

    public void dispose() {
        if (this.codeFont != null) {
            this.codeFont.dispose();
        }
        this.codeFont = null;
        super.dispose();
    }

    public Control getControl() {
        return this.getSection();
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        parent.hookFormText(this.text);
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.getSection().setVisible(visible);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
        if (this.text != null) {
            this.text.setText(defaultText, false, false);
        }
    }

    private void doOpenLink(Object href) {
        this.parent.showURL((String)href);
    }

    public void handleActivation(Control c, IWorkbenchPart part) {
        if (this.text.isDisposed()) {
            return;
        }
        this.lastControl = c;
        this.lastPart = part;
        this.lastProvider = null;
        String helpText = this.createContextHelp(c);
        if (this.getSection().isExpanded()) {
            this.updateText(helpText);
        }
        this.updateDynamicHelp(false);
    }

    private void updateDynamicHelp(boolean explicitContext) {
        String title;
        if (explicitContext && this.lastContext instanceof IContext2 && (title = ((IContext2)this.lastContext).getTitle()) != null) {
            this.updateDynamicHelp(this.stripMnemonic(title), this.lastControl);
            return;
        }
        if (this.lastProvider != null || this.lastControl != null) {
            this.updateDynamicHelp(this.lastProvider != null ? this.lastProvider.getSearchExpression((Object)this.lastControl) : null, this.lastControl);
        }
    }

    public void handleActivation(IContextProvider provider, IContext context, Control c, IWorkbenchPart part) {
        if (this.text.isDisposed()) {
            return;
        }
        this.lastControl = c;
        this.lastProvider = provider;
        this.lastContext = context;
        this.lastPart = part;
        if (context == null && provider != null) {
            this.lastContext = provider.getContext((Object)c);
        }
        String helpText = this.lastContext != null ? this.formatHelpContext(this.lastContext) : this.createContextHelp(c);
        this.updateTitle(context != null);
        if (this.getSection().isExpanded()) {
            this.updateText(helpText);
        }
        this.updateDynamicHelp(context != null);
    }

    private void updateTitle(boolean contextSupplied) {
        String title = null;
        if (this.lastContext != null && this.lastContext instanceof IContext2) {
            IContext2 c2 = (IContext2)this.lastContext;
            title = c2.getTitle();
        }
        if (title == null && !contextSupplied && this.lastPart != null) {
            title = NLS.bind((String)Messages.ContextHelpPart_aboutP, (Object)this.lastPart.getSite().getRegisteredName());
        }
        if (title == null) {
            title = Messages.ContextHelpPart_about;
        }
        this.getSection().setText(title);
    }

    private void updateText(String helpText) {
        this.text.setText(helpText != null ? helpText : this.defaultText, helpText != null, false);
        this.getSection().layout();
        this.getManagedForm().reflow(true);
    }

    private void updateDynamicHelp(String expression, Control c) {
        RelatedTopicsPart part;
        if (expression == null) {
            expression = this.computeDefaultSearchExpression(c);
        }
        if ((part = (RelatedTopicsPart)this.parent.findPart("related-topics")) != null && expression != null) {
            part.startSearch(expression, this.lastContext);
        }
    }

    private String computeDefaultSearchExpression(Control c) {
        StringBuffer buff = new StringBuffer();
        Composite parent = c.getParent();
        while (parent != null) {
            Object data = parent.getData();
            if (data instanceof IWizardContainer) {
                IWizardContainer wc = (IWizardContainer)data;
                buff.append("\"");
                buff.append(wc.getCurrentPage().getTitle());
                buff.append("\" OR \"");
                buff.append(wc.getCurrentPage().getWizard().getWindowTitle());
                buff.append("\"");
                break;
            }
            if (data instanceof IWorkbenchWindow) {
                IPerspectiveDescriptor persp;
                IWorkbenchWindow window = (IWorkbenchWindow)data;
                IWorkbenchPage page = window.getActivePage();
                if (page == null) break;
                IWorkbenchPart part = this.lastPart;
                if (part != null) {
                    buff.append("\"");
                    if (part instanceof IViewPart) {
                        buff.append(NLS.bind((String)Messages.ContextHelpPart_query_view, (Object)part.getSite().getRegisteredName()));
                    }
                    buff.append("\" ");
                }
                if ((persp = page.getPerspective()) == null) break;
                if (buff.length() > 0) {
                    buff.append("OR ");
                }
                buff.append("\"");
                buff.append(NLS.bind((String)Messages.ContextHelpPart_query_perspective, (Object)persp.getLabel()));
                buff.append("\"");
                break;
            }
            if (data instanceof Window) {
                Object page;
                String pageName;
                Window w = (Window)data;
                if (w instanceof IPageChangeProvider && (pageName = this.getPageName(c, page = ((IPageChangeProvider)w).getSelectedPage())) != null) {
                    buff.append("\"");
                    buff.append(pageName);
                    buff.append("\" ");
                }
                if (buff.length() > 0) {
                    buff.append("OR ");
                }
                buff.append("\"");
                buff.append(w.getShell().getText());
                buff.append("\"");
                break;
            }
            parent = parent.getParent();
        }
        return buff.length() > 0 ? buff.toString().trim() : null;
    }

    private String getPageName(Control focusControl, Object page) {
        if (page instanceof IDialogPage) {
            return ((IDialogPage)page).getTitle();
        }
        if (focusControl == null) {
            return null;
        }
        Composite parent = focusControl.getParent();
        while (parent != null) {
            CTabItem selection;
            if (parent instanceof TabFolder) {
                selection = ((TabFolder)parent).getSelection();
                if (((TabItem[])selection).length == 1) {
                    return this.stripMnemonic(selection[0].getText());
                }
            } else if (parent instanceof CTabFolder) {
                selection = ((CTabFolder)parent).getSelection();
                return this.stripMnemonic(selection.getText());
            }
            parent = parent.getParent();
        }
        return null;
    }

    private String stripMnemonic(String name) {
        int loc = name.indexOf(38);
        if (loc != -1) {
            return String.valueOf(name.substring(0, loc)) + name.substring(loc + 1);
        }
        return name;
    }

    private String createContextHelp(IContextProvider provider, Control c) {
        if (provider == null) {
            return this.createContextHelp(c);
        }
        this.lastContext = provider.getContext((Object)c);
        if (this.lastContext != null) {
            return this.formatHelpContext(this.lastContext);
        }
        return null;
    }

    private String createContextHelp(Control page) {
        IContext helpContext;
        String text = null;
        this.lastContext = null;
        if (page != null && page != null && !page.isDisposed() && (helpContext = ContextHelpPart.findHelpContext(page)) != null) {
            text = this.formatHelpContext(helpContext);
            this.lastContext = helpContext;
        }
        return text;
    }

    public static IContext findHelpContext(Control c) {
        String contextId = null;
        Control node = c;
        while ((contextId = (String)node.getData(HELP_KEY)) == null && (node = node.getParent()) != null) {
        }
        if (contextId != null) {
            return HelpSystem.getContext((String)contextId);
        }
        return null;
    }

    private String formatHelpContext(IContext context) {
        String locale = Platform.getNL();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<form>");
        sbuf.append("<p>");
        sbuf.append(this.decodeContextBoldTags(context));
        sbuf.append("</p>");
        Object[] links = context.getRelatedTopics();
        IContext2 context2 = null;
        if (links != null && context instanceof IContext2) {
            context2 = (IContext2)context;
            ContextHelpSorter sorter = new ContextHelpSorter(context2);
            sorter.sort(null, links);
        }
        if (links != null && links.length > 0) {
            String category = null;
            if (context2 == null) {
                this.addCategory(sbuf, null);
            }
            int i = 0;
            while (i < links.length) {
                Object link = links[i];
                if (!UAContentFilter.isFiltered((Object)link)) {
                    if (context2 != null) {
                        String cat = context2.getCategory((IHelpResource)link);
                        if (cat == null && category != null || cat != null && category == null || cat != null && category != null && !cat.equals(category)) {
                            this.addCategory(sbuf, cat);
                        }
                        category = cat;
                    }
                    sbuf.append("<li style=\"image\" value=\"");
                    sbuf.append("obj16/topic_small.gif");
                    sbuf.append("\" indent=\"21\">");
                    sbuf.append("<a href=\"");
                    sbuf.append(link.getHref());
                    String tcat = this.getTopicCategory(link.getHref(), locale);
                    if (tcat != null && !Platform.getWS().equals("gtk")) {
                        sbuf.append("\" alt=\"");
                        sbuf.append(tcat);
                    }
                    sbuf.append("\">");
                    sbuf.append(this.parent.escapeSpecialChars(link.getLabel()));
                    sbuf.append("</a>");
                    sbuf.append("</li>");
                }
                ++i;
            }
        }
        sbuf.append("</form>");
        return sbuf.toString();
    }

    private void addCategory(StringBuffer sbuf, String category) {
        if (category == null) {
            category = Messages.ContextHelpPart_seeAlso;
        }
        sbuf.append("<p><span color=\"");
        sbuf.append("org.eclipse.ui.forms.TITLE");
        sbuf.append("\">");
        sbuf.append(category);
        sbuf.append("</span></p>");
    }

    private String getTopicCategory(String href, String locale) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i].getLabel();
            }
            ++i;
        }
        return null;
    }

    private String decodeContextBoldTags(IContext context) {
        String styledText = context instanceof IContext2 ? ((IContext2)context).getStyledText() : context.getText();
        if (styledText == null) {
            return "";
        }
        String decodedString = styledText.replaceAll("<@#\\$b>", "<b>");
        decodedString = decodedString.replaceAll("</@#\\$b>", "</b>");
        decodedString = this.parent.escapeSpecialChars(decodedString, true);
        decodedString = decodedString.replaceAll("\r\n|\n|\r", "<br/>");
        return decodedString;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ContextHelpProviderInput) {
            ContextHelpProviderInput chinput = (ContextHelpProviderInput)input;
            this.handleActivation(chinput.getProvider(), chinput.getContext(), chinput.getControl(), chinput.getPart());
            return true;
        }
        return false;
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillFormContextMenu(this.text, manager);
    }

    public boolean hasFocusControl(Control control) {
        return this.text.equals(control);
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    public void stop() {
    }

    public void toggleRoleFilter() {
    }

    public void refilter() {
    }

    public void saveState(IMemento memento) {
    }
}

