/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class RetargetAction
implements IWorkbenchWindowActionDelegate,
IPartListener,
IUpdate {
    protected IWorkbenchWindow fWindow = null;
    private IWorkbenchPart fActivePart = null;
    private Object fTargetAdapter = null;
    private IAction fAction = null;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    private ISelection getTargetSelection() {
        ISelectionProvider selectionProvider;
        if (this.fActivePart != null && (selectionProvider = this.fActivePart.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return EMPTY_SELECTION;
    }

    public void dispose() {
        this.fWindow.getPartService().removePartListener((IPartListener)this);
        this.fActivePart = null;
        this.fTargetAdapter = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        IPartService partService = window.getPartService();
        partService.addPartListener((IPartListener)this);
        IWorkbenchPart part = partService.getActivePart();
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void run(IAction action) {
        if (this.fTargetAdapter != null) {
            try {
                this.performAction(this.fTargetAdapter, this.getTargetSelection(), this.fActivePart);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fWindow.getShell(), ActionMessages.RetargetAction_2, ActionMessages.RetargetAction_3, e.getStatus());
            }
        }
    }

    protected abstract void performAction(Object var1, ISelection var2, IWorkbenchPart var3) throws CoreException;

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        this.fAction = action;
        if (this.fTargetAdapter == null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (object = ss.getFirstElement()) instanceof IAdaptable) {
            this.fTargetAdapter = this.getAdapter((IAdaptable)object);
        }
        this.update();
    }

    public void partActivated(IWorkbenchPart part) {
        this.fActivePart = part;
        this.fTargetAdapter = this.getAdapter((IAdaptable)part);
        this.update();
    }

    protected Object getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        Object adapter = adaptable.getAdapter(this.getAdapterClass());
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getAdapterClass().getName())) {
            this.fTargetAdapter = adapterManager.loadAdapter((Object)adaptable, this.getAdapterClass().getName());
        }
        return adapter;
    }

    protected abstract Class getAdapterClass();

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.clearPart(part);
    }

    protected void clearPart(IWorkbenchPart part) {
        if (part.equals(this.fActivePart)) {
            this.fActivePart = null;
            this.fTargetAdapter = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.clearPart(part);
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        final Object target = this.fTargetAdapter;
        if (target != null) {
            Runnable r = new Runnable(){

                public void run() {
                    if (RetargetAction.this.fActivePart != null) {
                        RetargetAction.this.fAction.setEnabled(RetargetAction.this.canPerformAction(target, RetargetAction.this.getTargetSelection(), RetargetAction.this.fActivePart));
                    }
                }
            };
            DebugUIPlugin.getStandardDisplay().asyncExec(r);
        } else {
            this.fAction.setEnabled(false);
        }
    }

    protected abstract boolean canPerformAction(Object var1, ISelection var2, IWorkbenchPart var3);

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

