/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationFileInfo
extends ProductObject
implements IConfigurationFileInfo {
    private static final long serialVersionUID = 1L;
    private String fUse;
    private String fPath;

    public ConfigurationFileInfo(IProductModel model) {
        super(model);
    }

    public void setPath(String path) {
        String old = this.fPath;
        this.fPath = path;
        if (this.isEditable()) {
            this.firePropertyChanged("path", old, this.fPath);
        }
    }

    public String getPath() {
        return this.fPath;
    }

    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fPath = element.getAttribute("path");
            this.fUse = element.getAttribute("use");
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<configIni");
        if (this.fUse != null) {
            writer.print(" use=\"" + this.fUse + "\"");
        }
        if (this.fPath != null && this.fPath.trim().length() > 0) {
            writer.print(" path=\"" + this.getWritableString(this.fPath.trim()) + "\"");
        }
        writer.println("/>");
    }

    public void setUse(String use) {
        String old = this.fUse;
        this.fUse = use;
        if (this.isEditable()) {
            this.firePropertyChanged("use", old, this.fUse);
        }
    }

    public String getUse() {
        return this.fUse;
    }
}

