/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaMainTab
extends SharedJavaMainTab {
    public static final String ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";
    public static final String ATTR_CONSIDER_INHERITED_MAIN = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CONSIDER_INHERITED_MAIN";
    private Button fSearchExternalJarsCheckButton;
    private Button fConsiderInheritedMainButton;
    private Button fStopInMainCheckButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.fSearchExternalJarsCheckButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_E_xt__jars_6);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fSearchExternalJarsCheckButton.setLayoutData((Object)gd);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fConsiderInheritedMainButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_22);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fConsiderInheritedMainButton.setLayoutData((Object)gd);
        this.fConsiderInheritedMainButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fStopInMainCheckButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_St_op_in_main_1);
        gd = new GridData();
        this.fStopInMainCheckButton.setLayoutData((Object)gd);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.createMainTypeEditor(comp, LauncherMessages.JavaMainTab_Main_cla_ss__4, new Button[]{this.fSearchExternalJarsCheckButton, this.fConsiderInheritedMainButton, this.fStopInMainCheckButton});
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public String getName() {
        return LauncherMessages.JavaMainTab__Main_19;
    }

    protected void handleSearchButtonSelected() {
        IJavaProject project = this.getJavaProject();
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 2;
            constraints |= 4;
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        IType[] types = null;
        try {
            types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), searchScope, this.fConsiderInheritedMainButton.getSelection());
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])types), (int)2, (boolean)false, (String)"**");
        }
        catch (JavaModelException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        dialog.setTitle(LauncherMessages.JavaMainTab_Choose_Main_Type_11);
        dialog.setMessage(LauncherMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
        this.updateInheritedMainsFromConfig(config);
        this.updateExternalJars(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format((String)LauncherMessages.JavaMainTab_20, (Object[])new String[]{name}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format((String)LauncherMessages.JavaMainTab_21, (Object[])new String[]{name}));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format((String)LauncherMessages.JavaMainTab_19, (Object[])new String[]{status.getMessage()}));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage(LauncherMessages.JavaMainTab_Main_type_not_specified_16);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText().trim());
        this.mapResources(config);
        if (this.fStopInMainCheckButton.getSelection()) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        }
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
        if (this.fConsiderInheritedMainButton.getSelection()) {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, true);
        } else {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, null);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    private void updateExternalJars(ILaunchConfiguration config) {
        boolean search = false;
        try {
            search = config.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }

    private void updateInheritedMainsFromConfig(ILaunchConfiguration config) {
        boolean inherit = false;
        try {
            inherit = config.getAttribute(ATTR_CONSIDER_INHERITED_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fConsiderInheritedMainButton.setSelection(inherit);
    }

    private void updateStopInMainFromConfig(ILaunchConfiguration config) {
        boolean stop = false;
        try {
            stop = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }
}

