/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.editorlaunch;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorage;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorageEditorInput;

public class LaunchEditor {

   public static int incNumber = 0;
   
   public void launchSQLEditor(String ddl, ConnectionInfo conInfo, String title) {
       
       // If no title passed in, used a default one
       if (title == null | (title.length() == 0))
           title = ServerExtensionsPlugin.getString("DEFAULT_TITLE"); //$NON-NLS-1$
       
       // Make title unique by adding an integer and append the connection name
       title = title + "_" + Integer.toString(++incNumber); //$NON-NLS-1$ /
       
       // Launch the SQl Editor with a DDL statement
       SQLEditorStorage stor = new SQLEditorStorage(title, ddl);
       SQLEditorStorageEditorInput input = new SQLEditorStorageEditorInput(stor);
       input.setConnectionInfo(conInfo);
       
       try {
           ServerExtensionsPlugin.getDefault().getWorkbench()
           .getActiveWorkbenchWindow().getActivePage().openEditor(
                   input,
           "org.eclipse.wst.rdb.server.extensions.editorlaunch.SQLEditorForServerExplorer"); //$NON-NLS-1$
       } catch (Exception ex) {
           ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0,
                   ex.getMessage(), ex);
       }
   }   

}