/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class HostnameComposite
extends Composite {
    private static final String LOCALHOST = "localhost";
    protected String host;
    protected IHostnameSelectionListener listener;
    protected Combo combo;

    public HostnameComposite(Composite parent, IHostnameSelectionListener listener2) {
        super(parent, 0);
        this.listener = listener2;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 64);
        label.setText(Messages.hostname);
        label.setLayoutData((Object)new GridData(256));
        List hosts = ServerUIPlugin.getPreferences().getHostnames();
        String[] s = new String[hosts.size()];
        hosts.toArray(s);
        this.combo = new Combo((Composite)this, 4);
        this.combo.setItems(s);
        this.combo.setText(LOCALHOST);
        GridData data = new GridData(772);
        data.horizontalSpan = 2;
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostnameComposite.this.hostnameChanged(HostnameComposite.this.combo.getText());
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point p = HostnameComposite.this.combo.getSelection();
                HostnameComposite.this.hostnameChanged(HostnameComposite.this.combo.getText());
                HostnameComposite.this.combo.setSelection(p);
            }
        });
        Dialog.applyDialogFont((Control)this);
    }

    protected void hostnameChanged(String newHost) {
        if (newHost == null) {
            return;
        }
        if (newHost.equals(this.host)) {
            return;
        }
        this.host = newHost;
        this.listener.hostnameSelected(this.host);
    }

    public String getHostname() {
        return this.host;
    }

    public void setHostname(String hostname) {
        this.combo.setText(hostname);
    }

    public static interface IHostnameSelectionListener {
        public void hostnameSelected(String var1);
    }
}

