/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.repository.RepositoryFilters;
import org.tigris.subversion.subclipse.ui.repository.model.AllRootsElement;
import org.tigris.subversion.subclipse.ui.repository.model.RemoteContentProvider;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class NewRemoteFolderWizardMainPage
extends SVNWizardPage {
    private static final int LIST_WIDTH = 250;
    private static final int LIST_HEIGHT = 300;
    private Text urlParentText;
    private Text folderNameText;
    private TreeViewer viewer;
    private ISVNRemoteFolder parentFolder;
    private ISelectionChangedListener treeSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection instanceof ISVNRemoteFolder) {
                NewRemoteFolderWizardMainPage.this.parentFolder = (ISVNRemoteFolder)selection;
            } else if (selection instanceof IAdaptable) {
                IAdaptable a = (IAdaptable)selection;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.tigris.subversion.subclipse.core.ISVNRemoteFolder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object adapter = a.getAdapter((Class)clazz);
                NewRemoteFolderWizardMainPage.this.parentFolder = (ISVNRemoteFolder)adapter;
            }
            if (NewRemoteFolderWizardMainPage.this.parentFolder != null) {
                NewRemoteFolderWizardMainPage.this.urlParentText.setText(NewRemoteFolderWizardMainPage.this.parentFolder.getUrl().toString());
            }
        }
    };
    static /* synthetic */ Class class$0;

    public NewRemoteFolderWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.create_remote_folder_page_context");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                NewRemoteFolderWizardMainPage.this.validateFields();
            }
        };
        NewRemoteFolderWizardMainPage.createLabel(composite, Policy.bind("NewRemoteFolderWizardMainPage.selectParentUrl"));
        this.urlParentText = NewRemoteFolderWizardMainPage.createTextField(composite);
        this.urlParentText.addListener(13, listener);
        this.urlParentText.addListener(24, listener);
        this.urlParentText.setEditable(false);
        DrillDownComposite drillDown = new DrillDownComposite(composite, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        this.viewer = new TreeViewer((Composite)drillDown, 768);
        drillDown.setChildTree(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.viewer.setInput((Object)new AllRootsElement());
        this.viewer.addFilter(RepositoryFilters.FOLDERS_ONLY);
        this.viewer.addSelectionChangedListener(this.treeSelectionChangedListener);
        NewRemoteFolderWizardMainPage.createLabel(composite, Policy.bind("NewRemoteFolderWizardMainPage.folderName"));
        this.folderNameText = NewRemoteFolderWizardMainPage.createTextField(composite);
        this.folderNameText.addListener(13, listener);
        this.folderNameText.addListener(24, listener);
        this.validateFields();
        this.folderNameText.setFocus();
        this.setControl((Control)composite);
        if (this.parentFolder != null) {
            Object toSelect = null;
            toSelect = this.parentFolder.getParent() == null ? this.parentFolder.getRepository() : this.parentFolder;
            this.viewer.expandToLevel(toSelect, 0);
            this.viewer.setSelection((ISelection)new StructuredSelection(toSelect), true);
        }
    }

    private void validateFields() {
        if (this.folderNameText.getText().length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        try {
            new SVNUrl(Util.appendPath((String)this.urlParentText.getText(), (String)this.folderNameText.getText()));
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Policy.bind("NewRemoteFolderWizardMainPage.invalidUrl"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.folderNameText.setFocus();
        }
    }

    public String getFolderName() {
        return this.folderNameText.getText();
    }

    public ISVNRemoteFolder getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(ISVNRemoteFolder parentFolder) {
        this.parentFolder = parentFolder;
    }
}

