/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ExportOperation
extends RepositoryProviderOperation {
    private String directory;

    public ExportOperation(IWorkbenchPart part, IResource[] resources, String directory) {
        super(part, resources);
        this.directory = directory;
    }

    protected String getTaskName() {
        return Policy.bind("ExportOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ExportOperation.0", provider.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        try {
            try {
                ISVNClientAdapter client = null;
                int i = 0;
                while (i < resources.length) {
                    if (client == null) {
                        client = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]).getRepository().getSVNClient();
                    }
                    File srcPath = new File(resources[i].getLocation().toString());
                    File destPath = new File(String.valueOf(this.directory) + File.separator + resources[i].getName());
                    try {
                        client.doExport(srcPath, destPath, true);
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                    ++i;
                }
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        monitor.done();
    }
}

