/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.CheckoutAsProjectAction;
import org.tigris.subversion.subclipse.ui.operations.CheckoutAsProjectOperation;
import org.tigris.subversion.subclipse.ui.util.PromptingDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutIntoAction
extends CheckoutAsProjectAction {
    protected IPath intoDir;
    private ISVNRemoteFolder[] selectedFolders;
    private String projectName;
    private String intoDirectory;
    private SVNRevision svnRevision = SVNRevision.HEAD;

    public CheckoutIntoAction(ISVNRemoteFolder[] selectedFolders, String projectName, String intoDirectory, Shell shell) {
        this.selectedFolders = selectedFolders;
        this.projectName = projectName;
        this.intoDirectory = intoDirectory;
        this.shell = shell;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (this.intoDirectory == null) {
            if (!WorkspacePathValidator.validateWorkspacePath()) {
                return;
            }
            DirectoryDialog intoDirDia = new DirectoryDialog(this.shell);
            intoDirDia.setMessage(Policy.bind("CheckoutInto.message"));
            String intoDirString = intoDirDia.open();
            if (intoDirString == null) {
                return;
            }
            this.intoDir = new Path(intoDirString);
        } else {
            this.intoDir = new Path(this.intoDirectory);
        }
        this.checkoutSelectionIntoWorkspaceDirectory();
    }

    protected void checkoutSelectionIntoWorkspaceDirectory() throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                block9: {
                    block11: {
                        try {
                            try {
                                int i;
                                HashMap<String, ISVNRemoteFolder> targetFolders;
                                block10: {
                                    ISVNRemoteFolder[] folders = CheckoutIntoAction.this.getSelectedRemoteFolders();
                                    ArrayList<IProject> targetProjects = new ArrayList<IProject>();
                                    targetFolders = new HashMap<String, ISVNRemoteFolder>();
                                    monitor.beginTask(null, 100);
                                    int i2 = 0;
                                    while (true) {
                                        if (i2 >= folders.length) {
                                            CheckoutIntoAction.this.projects = targetProjects.toArray(new IResource[targetProjects.size()]);
                                            PromptingDialog prompt = new PromptingDialog(CheckoutIntoAction.this.getShell(), CheckoutIntoAction.this.projects, CheckoutIntoAction.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
                                            CheckoutIntoAction.this.projects = prompt.promptForMultiple();
                                            if (CheckoutIntoAction.this.projects.length == 0) break block9;
                                            CheckoutIntoAction.this.localFolders = new IProject[CheckoutIntoAction.this.projects.length];
                                            CheckoutIntoAction.this.remoteFolders = new ISVNRemoteFolder[CheckoutIntoAction.this.projects.length];
                                            i = 0;
                                            break block10;
                                        }
                                        CheckoutIntoAction.this.proceed = true;
                                        if (folders[i2].getRepository().getRepositoryRoot().toString().equals(folders[i2].getUrl().toString())) {
                                            CheckoutIntoAction.this.shell.getDisplay().syncExec(new Runnable(this){
                                                final /* synthetic */ 1 this$1;
                                                {
                                                    this.this$1 = var1_1;
                                                }

                                                public void run() {
                                                    1.access$0(this.this$1).proceed = MessageDialog.openQuestion((Shell)CheckoutIntoAction.access$0(1.access$0(this.this$1)), (String)Policy.bind("CheckoutAsProjectAction.title"), (String)Policy.bind("AddToWorkspaceAction.checkingOutRoot"));
                                                }
                                            });
                                        }
                                        if (!CheckoutIntoAction.this.proceed) break;
                                        IProject project = CheckoutIntoAction.this.projectName == null ? SVNWorkspaceRoot.getProject((ISVNRemoteFolder)folders[i2], (IProgressMonitor)monitor) : ResourcesPlugin.getWorkspace().getRoot().getProject(CheckoutIntoAction.this.projectName);
                                        targetFolders.put(project.getName(), folders[i2]);
                                        targetProjects.add(project);
                                        ++i2;
                                    }
                                    Object var7_10 = null;
                                    break block11;
                                }
                                while (i < CheckoutIntoAction.this.projects.length) {
                                    CheckoutIntoAction.this.localFolders[i] = (IProject)CheckoutIntoAction.this.projects[i];
                                    CheckoutIntoAction.this.remoteFolders[i] = (ISVNRemoteFolder)targetFolders.get(CheckoutIntoAction.this.projects[i].getName());
                                    ++i;
                                }
                                break block9;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var7_12 = null;
                monitor.done();
            }

            static /* synthetic */ CheckoutIntoAction access$0(1 var0) {
                return var0.CheckoutIntoAction.this;
            }
        }, true, 1);
        if (this.proceed) {
            CheckoutAsProjectOperation checkoutAsProjectOperation = new CheckoutAsProjectOperation(this.getTargetPart(), this.remoteFolders, this.localFolders, this.intoDir);
            checkoutAsProjectOperation.setSvnRevision(this.svnRevision);
            checkoutAsProjectOperation.run();
        }
    }

    protected ISVNRemoteFolder[] getSelectedRemoteFolders() {
        if (this.selectedFolders != null) {
            return this.selectedFolders;
        }
        return super.getSelectedRemoteFolders();
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }
}

