/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.model;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.SuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;

public class RubyDebugTarget
extends PlatformObject
implements IRubyDebugTarget {
    private static int DEFAULT_PORT = 1098;
    private IProcess process;
    private boolean isTerminated;
    private ILaunch launch;
    private RubyThread[] threads;
    private RubyDebuggerProxy rubyDebuggerProxy;
    private int port = -1;
    private File debugParameterFile;

    public RubyDebugTarget(ILaunch iLaunch) {
        this(iLaunch, null);
    }

    public RubyDebugTarget(ILaunch iLaunch, IProcess iProcess) {
        this.launch = iLaunch;
        this.process = iProcess;
        this.threads = new RubyThread[0];
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        iBreakpointManager.addBreakpointListener((IBreakpointListener)this);
    }

    /*
     * Unable to fully structure code
     */
    public void updateThreads() {
        RdtDebugCorePlugin.debug("udpating threads");
        var1_1 = this.getRubyDebuggerProxy().readThreads();
        var2_2 = new RubyThread[var1_1.length];
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl12
        {
            ++var3_3;
            do {
                if (var3_3 < this.threads.length && var1_1[var4_4].getId() != this.threads[var3_3].getId()) continue block0;
                var2_2[var4_4] = var3_3 == this.threads.length ? new RubyThread(this, var1_1[var4_4].getId()) : this.threads[var3_3];
                ++var4_4;
lbl12:
                // 2 sources

            } while (var4_4 < var1_1.length);
        }
        this.threads = var2_2;
        var4_5 = new DebugEvent((Object)this, 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{var4_5});
    }

    protected RubyThread getThreadById(int n) {
        int n2 = 0;
        while (n2 < this.threads.length) {
            if (this.threads[n2].getId() == n) {
                return this.threads[n2];
            }
            ++n2;
        }
        return null;
    }

    public void suspensionOccurred(SuspensionPoint suspensionPoint) {
        this.updateThreads();
        RubyThread rubyThread = this.getThreadById(suspensionPoint.getThreadId());
        if (rubyThread == null) {
            RdtDebugCorePlugin.log(4, "Thread with id " + suspensionPoint.getThreadId() + " was not found");
            return;
        }
        rubyThread.doSuspend(suspensionPoint);
    }

    public IThread[] getThreads() {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads.length > 0;
    }

    public String getName() throws DebugException {
        return "Ruby";
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return false;
    }

    public String getModelIdentifier() {
        return "org.rubypeople.rdt.debug";
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() {
        boolean bl;
        if (this.isTerminated) {
            return;
        }
        try {
            this.getProcess().terminate();
            this.threads = new RubyThread[0];
            this.isTerminated = true;
            this.rubyDebuggerProxy.stop();
        }
        catch (DebugException debugException) {
            RdtDebugCorePlugin.debug("Exception while terminating process.", debugException);
        }
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        if (this.debugParameterFile.exists() && !(bl = this.debugParameterFile.delete())) {
            RdtDebugCorePlugin.debug("Could not delete debugParameteFile:" + this.debugParameterFile.toURI());
        }
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (this.isTerminated) {
            return;
        }
        this.getRubyDebuggerProxy().addBreakpoint(iBreakpoint);
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.isTerminated) {
            return;
        }
        this.getRubyDebuggerProxy().removeBreakpoint(iBreakpoint);
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.isTerminated) {
            return;
        }
        this.getRubyDebuggerProxy().updateBreakpoint(iBreakpoint, iMarkerDelta);
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess iProcess) {
        this.process = iProcess;
    }

    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return this.rubyDebuggerProxy;
    }

    public void setRubyDebuggerProxy(RubyDebuggerProxy rubyDebuggerProxy) {
        this.rubyDebuggerProxy = rubyDebuggerProxy;
    }

    public File getDebugParameterFile() {
        if (this.debugParameterFile == null) {
            try {
                this.debugParameterFile = File.createTempFile("eclipseDebug", ".rb");
            }
            catch (IOException iOException) {
                RdtDebugCorePlugin.log("Could not create debugParameterFile", iOException);
            }
        }
        return this.debugParameterFile;
    }

    public boolean addDebugParameter(String string) {
        try {
            FileWriter fileWriter = new FileWriter(this.getDebugParameterFile());
            new PrintWriter(fileWriter).println(string);
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.log(iOException);
            return false;
        }
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = SocketUtil.findFreePort();
            if (this.port != -1 && !this.addDebugParameter("$EclipseListenPort=" + this.port)) {
                this.port = -1;
            }
            if (this.port == -1) {
                this.port = DEFAULT_PORT;
            }
            RdtDebugCorePlugin.debug("Using port: " + this.port);
        }
        return this.port;
    }

    public boolean isUsingDefaultPort() {
        return this.getPort() == DEFAULT_PORT;
    }
}

