/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.viewsupport.MemberFilter;
import org.rubypeople.rdt.internal.ui.viewsupport.MemberFilterAction;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class MemberFilterActionGroup
extends ActionGroup {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    public static final int ALL_FILTERS = 15;
    private static final String TAG_HIDEFIELDS = "hidefields";
    private static final String TAG_HIDESTATIC = "hidestatic";
    private static final String TAG_HIDENONPUBLIC = "hidenonpublic";
    private static final String TAG_HIDELOCALTYPES = "hidelocaltypes";
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    private StructuredViewer fViewer;
    private String fViewerId;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer structuredViewer, String string) {
        this(structuredViewer, string, false);
    }

    public MemberFilterActionGroup(StructuredViewer structuredViewer, String string, boolean bl) {
        this(structuredViewer, string, bl, 15);
    }

    public MemberFilterActionGroup(StructuredViewer structuredViewer, String string, boolean bl, int n) {
        MemberFilterAction memberFilterAction;
        String string2;
        String string3;
        boolean bl2;
        this.fViewer = structuredViewer;
        this.fViewerId = string;
        this.fInViewMenu = bl;
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        this.fFilter = new MemberFilter();
        ArrayList<MemberFilterAction> arrayList = new ArrayList<MemberFilterAction>(4);
        int n2 = 4;
        if (this.isSet(n2, n)) {
            bl2 = iPreferenceStore.getBoolean(this.getPreferenceKey(n2));
            if (bl2) {
                this.fFilter.addFilter(n2);
            }
            string3 = ActionMessages.MemberFilterActionGroup_hide_fields_label;
            string2 = "org.rubypeople.rdt.ui.filter_fields_action";
            memberFilterAction = new MemberFilterAction(this, string3, n2, string2, bl2);
            memberFilterAction.setDescription(ActionMessages.MemberFilterActionGroup_hide_fields_description);
            memberFilterAction.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_fields_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)memberFilterAction, "fields_co.gif");
            arrayList.add(memberFilterAction);
        }
        if (this.isSet(n2 = 2, n)) {
            bl2 = iPreferenceStore.getBoolean(this.getPreferenceKey(n2));
            if (bl2) {
                this.fFilter.addFilter(n2);
            }
            string3 = ActionMessages.MemberFilterActionGroup_hide_static_label;
            string2 = "org.rubypeople.rdt.ui.filter_static_action";
            memberFilterAction = new MemberFilterAction(this, string3, 2, string2, bl2);
            memberFilterAction.setDescription(ActionMessages.MemberFilterActionGroup_hide_static_description);
            memberFilterAction.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_static_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)memberFilterAction, "static_co.gif");
            arrayList.add(memberFilterAction);
        }
        if (this.isSet(n2 = 1, n)) {
            bl2 = iPreferenceStore.getBoolean(this.getPreferenceKey(n2));
            if (bl2) {
                this.fFilter.addFilter(n2);
            }
            string3 = ActionMessages.MemberFilterActionGroup_hide_nonpublic_label;
            string2 = "org.rubypeople.rdt.ui.filter_public_action";
            memberFilterAction = new MemberFilterAction(this, string3, n2, string2, bl2);
            memberFilterAction.setDescription(ActionMessages.MemberFilterActionGroup_hide_nonpublic_description);
            memberFilterAction.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_nonpublic_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)memberFilterAction, "public_co.gif");
            arrayList.add(memberFilterAction);
        }
        if (this.isSet(n2 = 8, n)) {
            bl2 = iPreferenceStore.getBoolean(this.getPreferenceKey(n2));
            if (bl2) {
                this.fFilter.addFilter(n2);
            }
            string3 = ActionMessages.MemberFilterActionGroup_hide_localtypes_label;
            string2 = "org.rubypeople.rdt.ui.filter_localtypes_action";
            memberFilterAction = new MemberFilterAction(this, string3, n2, string2, bl2);
            memberFilterAction.setDescription(ActionMessages.MemberFilterActionGroup_hide_localtypes_description);
            memberFilterAction.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_localtypes_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)memberFilterAction, "localtypes_co.gif");
            arrayList.add(memberFilterAction);
        }
        this.fFilterActions = arrayList.toArray(new MemberFilterAction[arrayList.size()]);
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    private String getPreferenceKey(int n) {
        return "MemberFilterActionGroup." + this.fViewerId + '.' + String.valueOf(n);
    }

    public void setMemberFilter(int n, boolean bl) {
        this.setMemberFilters(new int[]{n}, new boolean[]{bl}, true);
    }

    private void setMemberFilters(int[] nArray, boolean[] blArray, boolean bl) {
        if (nArray.length == 0) {
            return;
        }
        Assert.isTrue((nArray.length == blArray.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            boolean bl2 = blArray[n];
            IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
            boolean bl3 = false;
            int n3 = 0;
            while (n3 < this.fFilterActions.length) {
                int n4 = this.fFilterActions[n3].getFilterProperty();
                if (n4 == n2) {
                    this.fFilterActions[n3].setChecked(bl2);
                    bl3 = true;
                    iPreferenceStore.setValue(this.getPreferenceKey(n2), bl2);
                }
                ++n3;
            }
            if (bl3) {
                if (bl2) {
                    this.fFilter.addFilter(n2);
                } else {
                    this.fFilter.removeFilter(n2);
                }
            }
            ++n;
        }
        if (bl) {
            this.fViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    MemberFilterActionGroup.this.fViewer.refresh();
                }
            });
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public boolean hasMemberFilter(int n) {
        return this.fFilter.hasFilter(n);
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(TAG_HIDEFIELDS, String.valueOf(this.hasMemberFilter(4)));
        iMemento.putString(TAG_HIDESTATIC, String.valueOf(this.hasMemberFilter(2)));
        iMemento.putString(TAG_HIDENONPUBLIC, String.valueOf(this.hasMemberFilter(1)));
        iMemento.putString(TAG_HIDELOCALTYPES, String.valueOf(this.hasMemberFilter(8)));
    }

    public void restoreState(IMemento iMemento) {
        this.setMemberFilters(new int[]{4, 2, 1, 8}, new boolean[]{Boolean.valueOf(iMemento.getString(TAG_HIDEFIELDS)), Boolean.valueOf(iMemento.getString(TAG_HIDESTATIC)), Boolean.valueOf(iMemento.getString(TAG_HIDENONPUBLIC)), Boolean.valueOf(iMemento.getString(TAG_HIDELOCALTYPES))}, false);
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.contributeToToolBar(iActionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        if (this.fInViewMenu) {
            return;
        }
        int n = 0;
        while (n < this.fFilterActions.length) {
            iToolBarManager.add((IAction)this.fFilterActions[n]);
            ++n;
        }
    }

    public void contributeToViewMenu(IMenuManager iMenuManager) {
        if (!this.fInViewMenu) {
            return;
        }
        if (iMenuManager.find("filters") != null) {
            int n = 0;
            while (n < this.fFilterActions.length) {
                iMenuManager.prependToGroup("filters", (IAction)this.fFilterActions[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fFilterActions.length) {
                iMenuManager.add((IAction)this.fFilterActions[n]);
                ++n;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }
}

