/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.HostFileNameParser;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.commons.vfs.provider.smb.SmbFileName;

public class SmbFileNameParser
extends URLFileNameParser {
    private static final SmbFileNameParser INSTANCE = new SmbFileNameParser();

    public SmbFileNameParser() {
        super(139);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        HostFileNameParser.Authority auth = this.extractToPath(filename, name);
        String username = auth.userName;
        String domain = this.extractDomain(username);
        if (domain != null) {
            username = username.substring(domain.length() + 1);
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        String share = UriParser.extractFirstElement(name);
        if (share == null || share.length() == 0) {
            throw new FileSystemException("vfs.provider.smb/missing-share-name.error", filename);
        }
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new SmbFileName(auth.scheme, auth.hostName, auth.port, username, auth.password, domain, share, path, fileType);
    }

    private String extractDomain(String username) {
        if (username == null) {
            return null;
        }
        for (int i = 0; i < username.length(); ++i) {
            if (username.charAt(i) != '\\') continue;
            return username.substring(0, i);
        }
        return null;
    }
}

