/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildNonNullAnnotationDatabase
extends AnnotationVisitor {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug.annotation");
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, String> defaultKind = new HashMap<String, String>();

    static String lastPortion(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    public void visit(Synthetic a) {
        if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)XFactory.createXMethod((PreorderVisitor)this));
        } else if (this.visitingField()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)XFactory.createXField((PreorderVisitor)this));
        } else {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)this.getDottedClassName());
        }
    }

    public void visit(JavaClass obj) {
        if (obj.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)this.getDottedClassName());
        }
    }

    public void visit(Field f) {
        if (f.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)XFactory.createXField((PreorderVisitor)this));
        }
    }

    public void visit(Method m) {
        if (m.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addSyntheticElement((Object)XFactory.createXMethod((PreorderVisitor)this));
        }
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        NullnessAnnotation n = NullnessAnnotation.Parser.parse((String)annotationClass);
        annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass);
        if (n == null) {
            if (annotationClass.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
                Object v = map.get("value");
                if (v == null || !(v instanceof Object[])) {
                    return;
                }
                String annotationTarget = defaultKind.get(annotationClass = annotationClass.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
                if (annotationTarget != null) {
                    for (Object aClass : (Object[])v) {
                        n = NullnessAnnotation.Parser.parse((String)((String)aClass));
                        if (n == null) continue;
                        AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addDefaultAnnotation(annotationTarget, this.getDottedClassName(), (AnnotationEnumeration)n);
                    }
                }
            }
        } else if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addDirectAnnotation((Object)XFactory.createXMethod((PreorderVisitor)this), (AnnotationEnumeration)n);
        } else if (this.visitingField()) {
            AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addDirectAnnotation((Object)XFactory.createXField((PreorderVisitor)this), (AnnotationEnumeration)n);
        }
    }

    public void visitSyntheticParameterAnnotation(int p, boolean runtimeVisible) {
        XMethod xmethod = XFactory.createXMethod((PreorderVisitor)this);
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addDirectAnnotation((Object)xparameter, (AnnotationEnumeration)NullnessAnnotation.UNKNOWN_NULLNESS);
    }

    public void visitParameterAnnotation(int p, String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        NullnessAnnotation n = NullnessAnnotation.Parser.parse((String)(annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass)));
        if (n == null) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod((PreorderVisitor)this);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Parameter ").append(p).append(" @").append(annotationClass.substring(annotationClass.lastIndexOf(47) + 1)).append(" in ").append(xmethod.toString()).toString());
        }
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().addDirectAnnotation((Object)xparameter, (AnnotationEnumeration)n);
    }

    static {
        defaultKind.put("", "Any");
        defaultKind.put("ForParameters", "Parameter");
        defaultKind.put("ForMethods", "Method");
        defaultKind.put("ForFields", "Field");
    }
}

