/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.BugTreeView;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Calendar;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class UserAnnotationsView
extends ViewPart {
    private static UserAnnotationsView userAnnotationsView;
    private String userAnnotation = "";
    private String firstVersionText = "";
    @CheckForNull
    private BugInstance theBug;
    private Text userAnnotationTextField;
    private Label firstVersionLabel;
    private Combo designationComboBox;
    private Composite visibilityTester;
    private ISelectionListener selectionListener;
    private Composite main;

    public void createPartControl(Composite parent) {
        this.main = new Composite(parent, 512);
        this.main.setLayout((Layout)new GridLayout(2, false));
        this.designationComboBox = new Combo(this.main, 16396);
        this.designationComboBox.setToolTipText("User-specified bug designation");
        this.designationComboBox.setLayoutData((Object)new GridData());
        Iterator i$ = I18N.instance().getUserDesignationKeys(true).iterator();
        while (i$.hasNext()) {
            String s = (String)i$.next();
            this.designationComboBox.add(I18N.instance().getUserDesignation(s));
        }
        this.designationComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UserAnnotationsView.this.theBug != null) {
                    UserAnnotationsView.this.theBug.getNonnullUserDesignation().setDesignationKey((String)I18N.instance().getUserDesignationKeys(true).get(UserAnnotationsView.this.designationComboBox.getSelectionIndex()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.designationComboBox.setSize(this.designationComboBox.computeSize(-1, -1));
        this.designationComboBox.setEnabled(false);
        this.firstVersionLabel = new Label(this.main, 16384);
        this.firstVersionLabel.setToolTipText("The earliest version in which the bug was present");
        this.firstVersionLabel.setLayoutData((Object)new GridData(768));
        this.userAnnotationTextField = new Text(this.main, 16384);
        this.userAnnotationTextField.setToolTipText("Type comments about the selected bug here");
        this.userAnnotationTextField.setEnabled(false);
        GridData uatfData = new GridData(1808);
        uatfData.horizontalSpan = 2;
        this.userAnnotationTextField.setLayoutData((Object)uatfData);
        this.userAnnotationTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UserAnnotationsView.this.theBug != null) {
                    UserAnnotationsView.this.theBug.getUserDesignation().setAnnotationText(UserAnnotationsView.this.userAnnotationTextField.getText());
                }
            }
        });
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
                if (theSelection instanceof IStructuredSelection) {
                    IMarker theMarker;
                    Object elt = ((IStructuredSelection)theSelection).getFirstElement();
                    if (elt instanceof IMarker) {
                        UserAnnotationsView.showMarker((IMarker)elt, false);
                    }
                    if (elt instanceof TreeItem && (theMarker = BugTreeView.getMarkerForTreeItem((TreeItem)elt)) != null) {
                        UserAnnotationsView.showMarker(theMarker, false);
                    }
                }
            }
        };
        theService.addSelectionListener(this.selectionListener);
        this.visibilityTester = this.main;
        userAnnotationsView = this;
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        this.main.dispose();
        userAnnotationsView = null;
        super.dispose();
    }

    private void updateDisplay() {
        this.userAnnotationTextField.setText(this.userAnnotation);
        this.firstVersionLabel.setText(this.firstVersionText);
        if (this.theBug == null) {
            return;
        }
        int comboIndex = I18N.instance().getUserDesignationKeys(true).indexOf(this.theBug.getNonnullUserDesignation().getDesignationKey());
        if (comboIndex == -1) {
            FindbugsPlugin.getDefault().logError("Cannot find user designation");
        } else {
            this.designationComboBox.select(comboIndex);
        }
    }

    public void setContent(String userAnnotation, BugInstance bug, String firstVersionText) {
        this.userAnnotation = userAnnotation == null ? "" : userAnnotation.trim();
        this.firstVersionText = firstVersionText == null ? "" : firstVersionText.trim();
        this.theBug = bug;
        this.userAnnotationTextField.setEnabled(this.theBug != null);
        this.designationComboBox.setEnabled(this.theBug != null);
        this.updateDisplay();
    }

    public static void showMarker(IMarker marker, boolean focus) {
        if (userAnnotationsView == null) {
            return;
        }
        IWorkbenchPage[] pages = FindbugsPlugin.getActiveWorkbenchWindow().getPages();
        if (pages.length > 0) {
            try {
                if (focus) {
                    pages[0].showView("de.tobject.findbugs.view.userannotationsview");
                }
                String bugType = marker.getAttribute("BUGTYPE", "");
                Long theTimestamp = new Long(Long.parseLong(marker.getAttribute("FIRST_VERSION", "-2")));
                String firstVersionText = "Bug present since: " + UserAnnotationsView.convertTimestamp(theTimestamp);
                DetectorFactoryCollection.instance().ensureLoaded();
                BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                String userAnnotation = "";
                userAnnotation = bug == null ? "Error - BugInstance not found." : bug.getNonnullUserDesignation().getAnnotationText();
                if (pattern != null && UserAnnotationsView.getuserAnnotationsView() != null) {
                    UserAnnotationsView.getuserAnnotationsView().setContent(userAnnotation, bug, firstVersionText);
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not update bug details view");
            }
        }
    }

    private static String convertTimestamp(long timestamp) {
        if (timestamp == -2L) {
            return "ERROR - Timestamp not found";
        }
        if (timestamp == -1L) {
            return "First version analyzed";
        }
        Calendar theCalendar = Calendar.getInstance();
        theCalendar.setTimeInMillis(System.currentTimeMillis());
        theCalendar.set(theCalendar.get(1), theCalendar.get(2), theCalendar.get(5), 0, 0, 0);
        long beginningOfToday = theCalendar.getTimeInMillis();
        long beginningOfYesterday = beginningOfToday - 86400000L;
        theCalendar.setTimeInMillis(timestamp);
        String timeString = theCalendar.getTime().toString();
        if (timestamp >= beginningOfToday) {
            return "Today " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        if (timestamp >= beginningOfYesterday) {
            return "Yesterday " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        return timeString.substring(0, timeString.indexOf(":") + 3);
    }

    public static UserAnnotationsView getuserAnnotationsView() {
        return userAnnotationsView;
    }

    public static boolean isVisible() {
        if (userAnnotationsView == null) {
            return false;
        }
        return UserAnnotationsView.userAnnotationsView.visibilityTester.isVisible();
    }

    public static void setuserAnnotationsView(UserAnnotationsView view) {
        userAnnotationsView = view;
    }

    public void setFocus() {
        this.designationComboBox.setFocus();
    }
}

