/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FuncallableStandardClass;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SlotClass;
import org.armedbear.lisp.SlotDefinition;
import org.armedbear.lisp.SlotDefinitionClass;
import org.armedbear.lisp.StandardGenericFunctionClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public class StandardClass
extends SlotClass {
    public static Symbol symName = Lisp.PACKAGE_MOP.intern("NAME");
    public static Symbol symLayout = Lisp.PACKAGE_MOP.intern("LAYOUT");
    public static Symbol symDirectSuperclasses = Lisp.PACKAGE_MOP.intern("DIRECT-SUPERCLASSES");
    public static Symbol symDirectSubclasses = Lisp.PACKAGE_MOP.intern("DIRECT-SUBCLASSES");
    public static Symbol symPrecedenceList = Lisp.PACKAGE_MOP.intern("PRECEDENCE-LIST");
    public static Symbol symDirectMethods = Lisp.PACKAGE_MOP.intern("DIRECT-METHODS");
    public static Symbol symDirectSlots = Lisp.PACKAGE_MOP.intern("DIRECT-SLOTS");
    public static Symbol symSlots = Lisp.PACKAGE_MOP.intern("SLOTS");
    public static Symbol symDirectDefaultInitargs = Lisp.PACKAGE_MOP.intern("DIRECT-DEFAULT-INITARGS");
    public static Symbol symDefaultInitargs = Lisp.PACKAGE_MOP.intern("DEFAULT-INITARGS");
    public static Symbol symFinalizedP = Lisp.PACKAGE_MOP.intern("FINALIZED-P");
    static Function constantlyNil = new Function(){

        public LispObject execute() {
            return Lisp.NIL;
        }
    };
    static Layout layoutStandardClass = new Layout(null, Lisp.list(symName, symLayout, symDirectSuperclasses, symDirectSubclasses, symPrecedenceList, symDirectMethods, symDirectSlots, symSlots, symDirectDefaultInitargs, symDefaultInitargs, symFinalizedP, Symbol._DOCUMENTATION), (LispObject)Lisp.NIL){

        public LispClass getLispClass() {
            return STANDARD_CLASS;
        }
    };
    static Layout layoutFuncallableStandardClass = new Layout(null, Lisp.list(symName, symLayout, symDirectSuperclasses, symDirectSubclasses, symPrecedenceList, symDirectMethods, symDirectSlots, symSlots, symDirectDefaultInitargs, symDefaultInitargs, symFinalizedP, Symbol._DOCUMENTATION), (LispObject)Lisp.NIL){

        public LispClass getLispClass() {
            return FUNCALLABLE_STANDARD_CLASS;
        }
    };
    public static final StandardClass STANDARD_CLASS = StandardClass.addStandardClass(Symbol.STANDARD_CLASS, Lisp.list(BuiltInClass.CLASS_T, new LispObject[0]));
    public static final StandardClass STANDARD_OBJECT = StandardClass.addStandardClass(Symbol.STANDARD_OBJECT, Lisp.list(BuiltInClass.CLASS_T, new LispObject[0]));
    public static final StandardClass METAOBJECT = StandardClass.addStandardClass(Symbol.METAOBJECT, Lisp.list(STANDARD_OBJECT, new LispObject[0]));
    public static final StandardClass SPECIALIZER = StandardClass.addStandardClass(Symbol.SPECIALIZER, Lisp.list(METAOBJECT, new LispObject[0]));
    public static final StandardClass SLOT_DEFINITION = StandardClass.addStandardClass(Symbol.SLOT_DEFINITION, Lisp.list(METAOBJECT, new LispObject[0]));
    public static final StandardClass STANDARD_SLOT_DEFINITION = StandardClass.addClass(Symbol.STANDARD_SLOT_DEFINITION, new SlotDefinitionClass(Symbol.STANDARD_SLOT_DEFINITION, Lisp.list(SLOT_DEFINITION, new LispObject[0])));
    public static final StandardClass DIRECT_SLOT_DEFINITION;
    public static final StandardClass EFFECTIVE_SLOT_DEFINITION;
    public static final StandardClass STANDARD_DIRECT_SLOT_DEFINITION;
    public static final StandardClass STANDARD_EFFECTIVE_SLOT_DEFINITION;
    public static final StandardClass FUNCALLABLE_STANDARD_OBJECT;
    public static final StandardClass GENERIC_FUNCTION;
    public static final StandardClass CLASS;
    public static final StandardClass BUILT_IN_CLASS;
    public static final StandardClass FORWARD_REFERENCED_CLASS;
    public static final StandardClass STRUCTURE_CLASS;
    public static final StandardClass FUNCALLABLE_STANDARD_CLASS;
    public static final StandardClass CONDITION;
    public static final StandardClass SIMPLE_CONDITION;
    public static final StandardClass WARNING;
    public static final StandardClass SIMPLE_WARNING;
    public static final StandardClass STYLE_WARNING;
    public static final StandardClass SERIOUS_CONDITION;
    public static final StandardClass STORAGE_CONDITION;
    public static final StandardClass ERROR;
    public static final StandardClass ARITHMETIC_ERROR;
    public static final StandardClass CELL_ERROR;
    public static final StandardClass CONTROL_ERROR;
    public static final StandardClass FILE_ERROR;
    public static final StandardClass DIVISION_BY_ZERO;
    public static final StandardClass FLOATING_POINT_INEXACT;
    public static final StandardClass FLOATING_POINT_INVALID_OPERATION;
    public static final StandardClass FLOATING_POINT_OVERFLOW;
    public static final StandardClass FLOATING_POINT_UNDERFLOW;
    public static final StandardClass PROGRAM_ERROR;
    public static final StandardClass PACKAGE_ERROR;
    public static final StandardClass STREAM_ERROR;
    public static final StandardClass PARSE_ERROR;
    public static final StandardClass PRINT_NOT_READABLE;
    public static final StandardClass READER_ERROR;
    public static final StandardClass END_OF_FILE;
    public static final StandardClass SIMPLE_ERROR;
    public static final StandardClass TYPE_ERROR;
    public static final StandardClass SIMPLE_TYPE_ERROR;
    public static final StandardClass UNBOUND_SLOT;
    public static final StandardClass UNBOUND_VARIABLE;
    public static final StandardClass UNDEFINED_FUNCTION;
    public static final StandardClass JAVA_EXCEPTION;
    public static final StandardClass METHOD;
    public static final StandardClass STANDARD_METHOD;
    public static final StandardClass STANDARD_GENERIC_FUNCTION;

    public StandardClass() {
        super(layoutStandardClass);
        this.setDirectSuperclasses(Lisp.NIL);
        this.setDirectSubclasses(Lisp.NIL);
        this.setClassLayout(layoutStandardClass);
        this.setCPL(Lisp.NIL);
        this.setDirectMethods(Lisp.NIL);
        this.setDocumentation(Lisp.NIL);
        this.setDirectSlotDefinitions(Lisp.NIL);
        this.setSlotDefinitions(Lisp.NIL);
        this.setDirectDefaultInitargs(Lisp.NIL);
        this.setDefaultInitargs(Lisp.NIL);
        this.setFinalized(false);
    }

    public StandardClass(Symbol symbol, LispObject directSuperclasses) {
        super(layoutStandardClass, symbol, directSuperclasses);
        this.setDirectSubclasses(Lisp.NIL);
        this.setClassLayout(layoutStandardClass);
        this.setCPL(Lisp.NIL);
        this.setDirectMethods(Lisp.NIL);
        this.setDocumentation(Lisp.NIL);
        this.setDirectSlotDefinitions(Lisp.NIL);
        this.setSlotDefinitions(Lisp.NIL);
        this.setDirectDefaultInitargs(Lisp.NIL);
        this.setDefaultInitargs(Lisp.NIL);
        this.setFinalized(false);
    }

    public StandardClass(Layout layout) {
        super(layout);
        this.setDirectSuperclasses(Lisp.NIL);
        this.setDirectSubclasses(Lisp.NIL);
        this.setClassLayout(layout);
        this.setCPL(Lisp.NIL);
        this.setDirectMethods(Lisp.NIL);
        this.setDocumentation(Lisp.NIL);
        this.setDirectSlotDefinitions(Lisp.NIL);
        this.setSlotDefinitions(Lisp.NIL);
        this.setDirectDefaultInitargs(Lisp.NIL);
        this.setDefaultInitargs(Lisp.NIL);
        this.setFinalized(false);
    }

    public StandardClass(Layout layout, Symbol symbol, LispObject directSuperclasses) {
        super(layout, symbol, directSuperclasses);
        this.setDirectSubclasses(Lisp.NIL);
        this.setClassLayout(layout);
        this.setCPL(Lisp.NIL);
        this.setDirectMethods(Lisp.NIL);
        this.setDocumentation(Lisp.NIL);
        this.setDirectSlotDefinitions(Lisp.NIL);
        this.setSlotDefinitions(Lisp.NIL);
        this.setDirectDefaultInitargs(Lisp.NIL);
        this.setDefaultInitargs(Lisp.NIL);
        this.setFinalized(false);
    }

    public LispObject getName() {
        return this.getInstanceSlotValue(symName);
    }

    public void setName(LispObject newName) {
        this.setInstanceSlotValue(symName, newName);
    }

    public Layout getClassLayout() {
        LispObject layout = this.getInstanceSlotValue(symLayout);
        if (layout == Lisp.UNBOUND_VALUE) {
            return null;
        }
        if (!(layout instanceof Layout)) {
            return (Layout)Lisp.error(Symbol.TYPE_ERROR, new SimpleString("The value " + layout.princToString() + " is not of expected type " + Symbol.LAYOUT.princToString() + " in class " + this.princToString() + "."));
        }
        return layout == Lisp.UNBOUND_VALUE ? null : (Layout)layout;
    }

    public void setClassLayout(LispObject newLayout) {
        this.setInstanceSlotValue(symLayout, newLayout);
    }

    public LispObject getDirectSuperclasses() {
        return this.getInstanceSlotValue(symDirectSuperclasses);
    }

    public void setDirectSuperclasses(LispObject directSuperclasses) {
        this.setInstanceSlotValue(symDirectSuperclasses, directSuperclasses);
    }

    public final boolean isFinalized() {
        return this.getInstanceSlotValue(symFinalizedP) != Lisp.NIL;
    }

    public final void setFinalized(boolean b) {
        this.setInstanceSlotValue(symFinalizedP, b ? Lisp.T : Lisp.NIL);
    }

    public LispObject getDirectSubclasses() {
        return this.getInstanceSlotValue(symDirectSubclasses);
    }

    public void setDirectSubclasses(LispObject directSubclasses) {
        this.setInstanceSlotValue(symDirectSubclasses, directSubclasses);
    }

    public LispObject getCPL() {
        return this.getInstanceSlotValue(symPrecedenceList);
    }

    public void setCPL(LispObject ... cpl) {
        LispObject obj1 = cpl[0];
        if (obj1.listp() && cpl.length == 1) {
            this.setInstanceSlotValue(symPrecedenceList, obj1);
        } else {
            Debug.assertTrue(obj1 == this);
            LispObject l = Lisp.NIL;
            int i = cpl.length;
            while (i-- > 0) {
                l = new Cons(cpl[i], l);
            }
            this.setInstanceSlotValue(symPrecedenceList, l);
        }
    }

    public LispObject getDirectMethods() {
        return this.getInstanceSlotValue(symDirectMethods);
    }

    public void setDirectMethods(LispObject methods) {
        this.setInstanceSlotValue(symDirectMethods, methods);
    }

    public LispObject getDocumentation() {
        return this.getInstanceSlotValue(Symbol._DOCUMENTATION);
    }

    public void setDocumentation(LispObject doc) {
        this.setInstanceSlotValue(Symbol._DOCUMENTATION, doc);
    }

    public LispObject getDirectSlotDefinitions() {
        return this.getInstanceSlotValue(symDirectSlots);
    }

    public void setDirectSlotDefinitions(LispObject directSlotDefinitions) {
        this.setInstanceSlotValue(symDirectSlots, directSlotDefinitions);
    }

    public LispObject getSlotDefinitions() {
        return this.getInstanceSlotValue(symSlots);
    }

    public void setSlotDefinitions(LispObject slotDefinitions) {
        this.setInstanceSlotValue(symSlots, slotDefinitions);
    }

    public LispObject getDirectDefaultInitargs() {
        return this.getInstanceSlotValue(symDirectDefaultInitargs);
    }

    public void setDirectDefaultInitargs(LispObject directDefaultInitargs) {
        this.setInstanceSlotValue(symDirectDefaultInitargs, directDefaultInitargs);
    }

    public LispObject getDefaultInitargs() {
        return this.getInstanceSlotValue(symDefaultInitargs);
    }

    public void setDefaultInitargs(LispObject defaultInitargs) {
        this.setInstanceSlotValue(symDefaultInitargs, defaultInitargs);
    }

    public LispObject typeOf() {
        return Symbol.STANDARD_CLASS;
    }

    public LispObject classOf() {
        return STANDARD_CLASS;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.STANDARD_CLASS) {
            return Lisp.T;
        }
        if (type == STANDARD_CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject allocateInstance() {
        Layout layout = this.getClassLayout();
        if (layout == null) {
            Symbol.ERROR.execute(Symbol.SIMPLE_ERROR, Keyword.FORMAT_CONTROL, new SimpleString("No layout for class ~S."), Keyword.FORMAT_ARGUMENTS, Lisp.list(this, new LispObject[0]));
        }
        return new StandardObject(this, layout.getLength());
    }

    public String printObject() {
        StringBuilder sb = new StringBuilder(Symbol.STANDARD_CLASS.printObject());
        if (this.getName() != null) {
            sb.append(' ');
            sb.append(this.getName().printObject());
        }
        return this.unreadableString(sb.toString());
    }

    private static final LispObject standardClassSlotDefinitions() {
        return Lisp.list(StandardClass.helperMakeSlotDefinition("NAME", constantlyNil), StandardClass.helperMakeSlotDefinition("LAYOUT", constantlyNil), StandardClass.helperMakeSlotDefinition("DIRECT-SUPERCLASSES", constantlyNil), StandardClass.helperMakeSlotDefinition("DIRECT-SUBCLASSES", constantlyNil), StandardClass.helperMakeSlotDefinition("PRECEDENCE-LIST", constantlyNil), StandardClass.helperMakeSlotDefinition("DIRECT-METHODS", constantlyNil), StandardClass.helperMakeSlotDefinition("DIRECT-SLOTS", constantlyNil), StandardClass.helperMakeSlotDefinition("SLOTS", constantlyNil), StandardClass.helperMakeSlotDefinition("DIRECT-DEFAULT-INITARGS", constantlyNil), StandardClass.helperMakeSlotDefinition("DEFAULT-INITARGS", constantlyNil), StandardClass.helperMakeSlotDefinition("FINALIZED-P", constantlyNil), new SlotDefinition(Symbol._DOCUMENTATION, Lisp.list(Lisp.PACKAGE_MOP.intern("CLASS-DOCUMENTATION"), new LispObject[0]), constantlyNil, Lisp.list(Lisp.internKeyword("DOCUMENTATION"), new LispObject[0])));
    }

    private static final SlotDefinition helperMakeSlotDefinition(String name, Function init) {
        return new SlotDefinition((LispObject)Lisp.PACKAGE_MOP.intern(name), (LispObject)Lisp.list(Lisp.PACKAGE_MOP.intern("CLASS-" + name), new LispObject[0]), init);
    }

    private static final StandardClass addStandardClass(Symbol name, LispObject directSuperclasses) {
        StandardClass c = new StandardClass(name, directSuperclasses);
        StandardClass.addClass(name, c);
        return c;
    }

    public static void initializeStandardClasses() {
        STANDARD_CLASS.setDirectSuperclass(CLASS);
        STANDARD_OBJECT.setDirectSuperclass(BuiltInClass.CLASS_T);
        FUNCALLABLE_STANDARD_OBJECT.setDirectSuperclasses(Lisp.list(STANDARD_OBJECT, BuiltInClass.FUNCTION));
        GENERIC_FUNCTION.setDirectSuperclasses(Lisp.list(METAOBJECT, FUNCALLABLE_STANDARD_OBJECT));
        ARITHMETIC_ERROR.setCPL(ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        ARITHMETIC_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.OPERATION, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("ARITHMETIC-ERROR-OPERATION"), new LispObject[0])), new SlotDefinition(Symbol.OPERANDS, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("ARITHMETIC-ERROR-OPERANDS"), new LispObject[0]))));
        BUILT_IN_CLASS.setCPL(BUILT_IN_CLASS, CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CELL_ERROR.setCPL(CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CELL_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.NAME, (LispObject)Lisp.list(Symbol.CELL_ERROR_NAME, new LispObject[0])), new LispObject[0]));
        CLASS.setCPL(CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CONDITION.setCPL(CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        CONDITION.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.FORMAT_CONTROL, (LispObject)Lisp.list(Symbol.SIMPLE_CONDITION_FORMAT_CONTROL, new LispObject[0])), new SlotDefinition((LispObject)Symbol.FORMAT_ARGUMENTS, (LispObject)Lisp.list(Symbol.SIMPLE_CONDITION_FORMAT_ARGUMENTS, new LispObject[0]), Lisp.NIL)));
        CONDITION.setDirectDefaultInitargs(Lisp.list(Lisp.list(Keyword.FORMAT_ARGUMENTS, Lisp.NIL, constantlyNil), new LispObject[0]));
        CONTROL_ERROR.setCPL(CONTROL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        DIVISION_BY_ZERO.setCPL(DIVISION_BY_ZERO, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        END_OF_FILE.setCPL(END_OF_FILE, STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        ERROR.setCPL(ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FILE_ERROR.setCPL(FILE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FILE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.PATHNAME, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("FILE-ERROR-PATHNAME"), new LispObject[0])), new LispObject[0]));
        FLOATING_POINT_INEXACT.setCPL(FLOATING_POINT_INEXACT, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_INVALID_OPERATION.setCPL(FLOATING_POINT_INVALID_OPERATION, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_OVERFLOW.setCPL(FLOATING_POINT_OVERFLOW, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FLOATING_POINT_UNDERFLOW.setCPL(FLOATING_POINT_UNDERFLOW, ARITHMETIC_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FORWARD_REFERENCED_CLASS.setCPL(FORWARD_REFERENCED_CLASS, CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FORWARD_REFERENCED_CLASS.setClassLayout(layoutStandardClass);
        FORWARD_REFERENCED_CLASS.setDirectSlotDefinitions(StandardClass.standardClassSlotDefinitions());
        FUNCALLABLE_STANDARD_OBJECT.setCPL(FUNCALLABLE_STANDARD_OBJECT, STANDARD_OBJECT, BuiltInClass.FUNCTION, BuiltInClass.CLASS_T);
        GENERIC_FUNCTION.setCPL(GENERIC_FUNCTION, METAOBJECT, FUNCALLABLE_STANDARD_OBJECT, STANDARD_OBJECT, BuiltInClass.FUNCTION, BuiltInClass.CLASS_T);
        JAVA_EXCEPTION.setCPL(JAVA_EXCEPTION, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        JAVA_EXCEPTION.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.CAUSE, (LispObject)Lisp.list(Symbol.JAVA_EXCEPTION_CAUSE, new LispObject[0])), new LispObject[0]));
        METAOBJECT.setCPL(METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SPECIALIZER.setCPL(SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        METHOD.setCPL(METHOD, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_METHOD.setCPL(STANDARD_METHOD, METHOD, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_METHOD.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol._GENERIC_FUNCTION, Lisp.NIL, constantlyNil, Lisp.list(Lisp.internKeyword("GENERIC-FUNCTION"), new LispObject[0])), new SlotDefinition((LispObject)Symbol.LAMBDA_LIST, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Symbol.KEYWORDS, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Symbol.OTHER_KEYWORDS_P, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Symbol.SPECIALIZERS, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Symbol.QUALIFIERS, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition(Symbol._FUNCTION, Lisp.NIL, constantlyNil, Lisp.list(Lisp.internKeyword("FUNCTION"), new LispObject[0])), new SlotDefinition((LispObject)Symbol.FAST_FUNCTION, (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition(Symbol._DOCUMENTATION, Lisp.NIL, constantlyNil, Lisp.list(Lisp.internKeyword("DOCUMENTATION"), new LispObject[0]))));
        PACKAGE_ERROR.setCPL(PACKAGE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PACKAGE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.PACKAGE, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("PACKAGE-ERROR-PACKAGE"), new LispObject[0])), new LispObject[0]));
        PARSE_ERROR.setCPL(PARSE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PRINT_NOT_READABLE.setCPL(PRINT_NOT_READABLE, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        PRINT_NOT_READABLE.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.OBJECT, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("PRINT-NOT-READABLE-OBJECT"), new LispObject[0])), new LispObject[0]));
        PROGRAM_ERROR.setCPL(PROGRAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        READER_ERROR.setCPL(READER_ERROR, PARSE_ERROR, STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SERIOUS_CONDITION.setCPL(SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_CONDITION.setCPL(SIMPLE_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_ERROR.setCPL(SIMPLE_ERROR, SIMPLE_CONDITION, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_TYPE_ERROR.setDirectSuperclasses(Lisp.list(SIMPLE_CONDITION, TYPE_ERROR));
        SIMPLE_TYPE_ERROR.setCPL(SIMPLE_TYPE_ERROR, SIMPLE_CONDITION, TYPE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SIMPLE_WARNING.setDirectSuperclasses(Lisp.list(SIMPLE_CONDITION, WARNING));
        SIMPLE_WARNING.setCPL(SIMPLE_WARNING, SIMPLE_CONDITION, WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_CLASS.setCPL(STANDARD_CLASS, CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FUNCALLABLE_STANDARD_CLASS.setCPL(FUNCALLABLE_STANDARD_CLASS, CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        FUNCALLABLE_STANDARD_CLASS.setClassLayout(layoutStandardClass);
        FUNCALLABLE_STANDARD_CLASS.setDirectSlotDefinitions(StandardClass.standardClassSlotDefinitions());
        STANDARD_OBJECT.setCPL(STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STORAGE_CONDITION.setCPL(STORAGE_CONDITION, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STREAM_ERROR.setCPL(STREAM_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STREAM_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.STREAM, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("STREAM-ERROR-STREAM"), new LispObject[0])), new LispObject[0]));
        STRUCTURE_CLASS.setCPL(STRUCTURE_CLASS, CLASS, SPECIALIZER, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STYLE_WARNING.setCPL(STYLE_WARNING, WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        TYPE_ERROR.setCPL(TYPE_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        TYPE_ERROR.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.DATUM, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("TYPE-ERROR-DATUM"), new LispObject[0])), new SlotDefinition(Symbol.EXPECTED_TYPE, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("TYPE-ERROR-EXPECTED-TYPE"), new LispObject[0]))));
        UNBOUND_SLOT.setCPL(UNBOUND_SLOT, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        UNBOUND_SLOT.setDirectSlotDefinitions(Lisp.list(new SlotDefinition(Symbol.INSTANCE, (LispObject)Lisp.list(Lisp.PACKAGE_CL.intern("UNBOUND-SLOT-INSTANCE"), new LispObject[0])), new LispObject[0]));
        UNBOUND_VARIABLE.setCPL(UNBOUND_VARIABLE, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        UNDEFINED_FUNCTION.setCPL(UNDEFINED_FUNCTION, CELL_ERROR, ERROR, SERIOUS_CONDITION, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        WARNING.setCPL(WARNING, CONDITION, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_CLASS.finalizeClass();
        STANDARD_OBJECT.finalizeClass();
        FUNCALLABLE_STANDARD_OBJECT.finalizeClass();
        FUNCALLABLE_STANDARD_CLASS.finalizeClass();
        FORWARD_REFERENCED_CLASS.finalizeClass();
        GENERIC_FUNCTION.finalizeClass();
        ARITHMETIC_ERROR.finalizeClass();
        CELL_ERROR.finalizeClass();
        CONDITION.finalizeClass();
        CONTROL_ERROR.finalizeClass();
        DIVISION_BY_ZERO.finalizeClass();
        END_OF_FILE.finalizeClass();
        ERROR.finalizeClass();
        FILE_ERROR.finalizeClass();
        FLOATING_POINT_INEXACT.finalizeClass();
        FLOATING_POINT_INVALID_OPERATION.finalizeClass();
        FLOATING_POINT_OVERFLOW.finalizeClass();
        FLOATING_POINT_UNDERFLOW.finalizeClass();
        JAVA_EXCEPTION.finalizeClass();
        METAOBJECT.finalizeClass();
        METHOD.finalizeClass();
        STANDARD_METHOD.finalizeClass();
        SPECIALIZER.finalizeClass();
        CLASS.finalizeClass();
        BUILT_IN_CLASS.finalizeClass();
        PACKAGE_ERROR.finalizeClass();
        PARSE_ERROR.finalizeClass();
        PRINT_NOT_READABLE.finalizeClass();
        PROGRAM_ERROR.finalizeClass();
        READER_ERROR.finalizeClass();
        SERIOUS_CONDITION.finalizeClass();
        SIMPLE_CONDITION.finalizeClass();
        SIMPLE_ERROR.finalizeClass();
        SIMPLE_TYPE_ERROR.finalizeClass();
        SIMPLE_WARNING.finalizeClass();
        STORAGE_CONDITION.finalizeClass();
        STREAM_ERROR.finalizeClass();
        STYLE_WARNING.finalizeClass();
        TYPE_ERROR.finalizeClass();
        UNBOUND_SLOT.finalizeClass();
        UNBOUND_VARIABLE.finalizeClass();
        UNDEFINED_FUNCTION.finalizeClass();
        WARNING.finalizeClass();
        Debug.assertTrue(SLOT_DEFINITION.isFinalized());
        SLOT_DEFINITION.setCPL(SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        SLOT_DEFINITION.setDirectSlotDefinitions(SLOT_DEFINITION.getClassLayout().generateSlotDefinitions());
        SLOT_DEFINITION.setSlotDefinitions(SLOT_DEFINITION.getDirectSlotDefinitions());
        DIRECT_SLOT_DEFINITION.setCPL(DIRECT_SLOT_DEFINITION, SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        DIRECT_SLOT_DEFINITION.finalizeClass();
        EFFECTIVE_SLOT_DEFINITION.setCPL(EFFECTIVE_SLOT_DEFINITION, SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        EFFECTIVE_SLOT_DEFINITION.finalizeClass();
        STANDARD_SLOT_DEFINITION.setCPL(STANDARD_SLOT_DEFINITION, SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_SLOT_DEFINITION.finalizeClass();
        STANDARD_DIRECT_SLOT_DEFINITION.setCPL(STANDARD_DIRECT_SLOT_DEFINITION, STANDARD_SLOT_DEFINITION, DIRECT_SLOT_DEFINITION, SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_DIRECT_SLOT_DEFINITION.finalizeClass();
        STANDARD_EFFECTIVE_SLOT_DEFINITION.setCPL(STANDARD_EFFECTIVE_SLOT_DEFINITION, STANDARD_SLOT_DEFINITION, EFFECTIVE_SLOT_DEFINITION, SLOT_DEFINITION, METAOBJECT, STANDARD_OBJECT, BuiltInClass.CLASS_T);
        STANDARD_EFFECTIVE_SLOT_DEFINITION.finalizeClass();
        Debug.assertTrue(STANDARD_GENERIC_FUNCTION.isFinalized());
        STANDARD_GENERIC_FUNCTION.setCPL(STANDARD_GENERIC_FUNCTION, GENERIC_FUNCTION, METAOBJECT, FUNCALLABLE_STANDARD_OBJECT, STANDARD_OBJECT, BuiltInClass.FUNCTION, BuiltInClass.CLASS_T);
        STANDARD_GENERIC_FUNCTION.setDirectSlotDefinitions(Lisp.list(new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("NAME"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("LAMBDA-LIST"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("REQUIRED-ARGS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("OPTIONAL-ARGS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("INITIAL-METHODS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("METHODS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("METHOD-CLASS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition(Lisp.PACKAGE_SYS.intern("%METHOD-COMBINATION"), Lisp.NIL, constantlyNil, Lisp.list(Lisp.internKeyword("METHOD-COMBINATION"), new LispObject[0])), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("ARGUMENT-PRECEDENCE-ORDER"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("DECLARATIONS"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition((LispObject)Lisp.PACKAGE_SYS.intern("CLASSES-TO-EMF-TABLE"), (LispObject)Lisp.NIL, constantlyNil), new SlotDefinition(Symbol._DOCUMENTATION, Lisp.NIL, constantlyNil, Lisp.list(Lisp.internKeyword("DOCUMENTATION"), new LispObject[0]))));
        STANDARD_GENERIC_FUNCTION.setSlotDefinitions(STANDARD_GENERIC_FUNCTION.getDirectSlotDefinitions());
    }

    static {
        SLOT_DEFINITION.finalizeClass();
        STANDARD_CLASS.setClassLayout(layoutStandardClass);
        STANDARD_CLASS.setDirectSlotDefinitions(StandardClass.standardClassSlotDefinitions());
        DIRECT_SLOT_DEFINITION = StandardClass.addStandardClass(Symbol.DIRECT_SLOT_DEFINITION, Lisp.list(SLOT_DEFINITION, new LispObject[0]));
        EFFECTIVE_SLOT_DEFINITION = StandardClass.addStandardClass(Symbol.EFFECTIVE_SLOT_DEFINITION, Lisp.list(SLOT_DEFINITION, new LispObject[0]));
        STANDARD_DIRECT_SLOT_DEFINITION = StandardClass.addClass(Symbol.STANDARD_DIRECT_SLOT_DEFINITION, new SlotDefinitionClass(Symbol.STANDARD_DIRECT_SLOT_DEFINITION, Lisp.list(STANDARD_SLOT_DEFINITION, DIRECT_SLOT_DEFINITION)));
        STANDARD_EFFECTIVE_SLOT_DEFINITION = StandardClass.addClass(Symbol.STANDARD_EFFECTIVE_SLOT_DEFINITION, new SlotDefinitionClass(Symbol.STANDARD_EFFECTIVE_SLOT_DEFINITION, Lisp.list(STANDARD_SLOT_DEFINITION, EFFECTIVE_SLOT_DEFINITION)));
        FUNCALLABLE_STANDARD_OBJECT = StandardClass.addStandardClass(Symbol.FUNCALLABLE_STANDARD_OBJECT, Lisp.list(STANDARD_OBJECT, BuiltInClass.FUNCTION));
        GENERIC_FUNCTION = new FuncallableStandardClass(Symbol.GENERIC_FUNCTION, Lisp.list(METAOBJECT, FUNCALLABLE_STANDARD_OBJECT));
        StandardClass.addClass(Symbol.GENERIC_FUNCTION, GENERIC_FUNCTION);
        CLASS = StandardClass.addStandardClass(Symbol.CLASS, Lisp.list(SPECIALIZER, new LispObject[0]));
        BUILT_IN_CLASS = StandardClass.addStandardClass(Symbol.BUILT_IN_CLASS, Lisp.list(CLASS, new LispObject[0]));
        FORWARD_REFERENCED_CLASS = StandardClass.addStandardClass(Symbol.FORWARD_REFERENCED_CLASS, Lisp.list(CLASS, new LispObject[0]));
        STRUCTURE_CLASS = StandardClass.addStandardClass(Symbol.STRUCTURE_CLASS, Lisp.list(CLASS, new LispObject[0]));
        FUNCALLABLE_STANDARD_CLASS = StandardClass.addStandardClass(Symbol.FUNCALLABLE_STANDARD_CLASS, Lisp.list(CLASS, new LispObject[0]));
        CONDITION = StandardClass.addStandardClass(Symbol.CONDITION, Lisp.list(STANDARD_OBJECT, new LispObject[0]));
        SIMPLE_CONDITION = StandardClass.addStandardClass(Symbol.SIMPLE_CONDITION, Lisp.list(CONDITION, new LispObject[0]));
        WARNING = StandardClass.addStandardClass(Symbol.WARNING, Lisp.list(CONDITION, new LispObject[0]));
        SIMPLE_WARNING = StandardClass.addStandardClass(Symbol.SIMPLE_WARNING, Lisp.list(SIMPLE_CONDITION, WARNING));
        STYLE_WARNING = StandardClass.addStandardClass(Symbol.STYLE_WARNING, Lisp.list(WARNING, new LispObject[0]));
        SERIOUS_CONDITION = StandardClass.addStandardClass(Symbol.SERIOUS_CONDITION, Lisp.list(CONDITION, new LispObject[0]));
        STORAGE_CONDITION = StandardClass.addStandardClass(Symbol.STORAGE_CONDITION, Lisp.list(SERIOUS_CONDITION, new LispObject[0]));
        ERROR = StandardClass.addStandardClass(Symbol.ERROR, Lisp.list(SERIOUS_CONDITION, new LispObject[0]));
        ARITHMETIC_ERROR = StandardClass.addStandardClass(Symbol.ARITHMETIC_ERROR, Lisp.list(ERROR, new LispObject[0]));
        CELL_ERROR = StandardClass.addStandardClass(Symbol.CELL_ERROR, Lisp.list(ERROR, new LispObject[0]));
        CONTROL_ERROR = StandardClass.addStandardClass(Symbol.CONTROL_ERROR, Lisp.list(ERROR, new LispObject[0]));
        FILE_ERROR = StandardClass.addStandardClass(Symbol.FILE_ERROR, Lisp.list(ERROR, new LispObject[0]));
        DIVISION_BY_ZERO = StandardClass.addStandardClass(Symbol.DIVISION_BY_ZERO, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
        FLOATING_POINT_INEXACT = StandardClass.addStandardClass(Symbol.FLOATING_POINT_INEXACT, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
        FLOATING_POINT_INVALID_OPERATION = StandardClass.addStandardClass(Symbol.FLOATING_POINT_INVALID_OPERATION, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
        FLOATING_POINT_OVERFLOW = StandardClass.addStandardClass(Symbol.FLOATING_POINT_OVERFLOW, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
        FLOATING_POINT_UNDERFLOW = StandardClass.addStandardClass(Symbol.FLOATING_POINT_UNDERFLOW, Lisp.list(ARITHMETIC_ERROR, new LispObject[0]));
        PROGRAM_ERROR = StandardClass.addStandardClass(Symbol.PROGRAM_ERROR, Lisp.list(ERROR, new LispObject[0]));
        PACKAGE_ERROR = StandardClass.addStandardClass(Symbol.PACKAGE_ERROR, Lisp.list(ERROR, new LispObject[0]));
        STREAM_ERROR = StandardClass.addStandardClass(Symbol.STREAM_ERROR, Lisp.list(ERROR, new LispObject[0]));
        PARSE_ERROR = StandardClass.addStandardClass(Symbol.PARSE_ERROR, Lisp.list(ERROR, new LispObject[0]));
        PRINT_NOT_READABLE = StandardClass.addStandardClass(Symbol.PRINT_NOT_READABLE, Lisp.list(ERROR, new LispObject[0]));
        READER_ERROR = StandardClass.addStandardClass(Symbol.READER_ERROR, Lisp.list(PARSE_ERROR, STREAM_ERROR));
        END_OF_FILE = StandardClass.addStandardClass(Symbol.END_OF_FILE, Lisp.list(STREAM_ERROR, new LispObject[0]));
        SIMPLE_ERROR = StandardClass.addStandardClass(Symbol.SIMPLE_ERROR, Lisp.list(SIMPLE_CONDITION, ERROR));
        TYPE_ERROR = StandardClass.addStandardClass(Symbol.TYPE_ERROR, Lisp.list(ERROR, new LispObject[0]));
        SIMPLE_TYPE_ERROR = StandardClass.addStandardClass(Symbol.SIMPLE_TYPE_ERROR, Lisp.list(SIMPLE_CONDITION, TYPE_ERROR));
        UNBOUND_SLOT = StandardClass.addStandardClass(Symbol.UNBOUND_SLOT, Lisp.list(CELL_ERROR, new LispObject[0]));
        UNBOUND_VARIABLE = StandardClass.addStandardClass(Symbol.UNBOUND_VARIABLE, Lisp.list(CELL_ERROR, new LispObject[0]));
        UNDEFINED_FUNCTION = StandardClass.addStandardClass(Symbol.UNDEFINED_FUNCTION, Lisp.list(CELL_ERROR, new LispObject[0]));
        JAVA_EXCEPTION = StandardClass.addStandardClass(Symbol.JAVA_EXCEPTION, Lisp.list(ERROR, new LispObject[0]));
        METHOD = StandardClass.addStandardClass(Symbol.METHOD, Lisp.list(METAOBJECT, new LispObject[0]));
        STANDARD_METHOD = StandardClass.addStandardClass(Symbol.STANDARD_METHOD, Lisp.list(METHOD, new LispObject[0]));
        STANDARD_GENERIC_FUNCTION = new StandardGenericFunctionClass();
        StandardClass.addClass(Symbol.STANDARD_GENERIC_FUNCTION, STANDARD_GENERIC_FUNCTION);
    }
}

