/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class Complex
extends LispObject {
    public final LispObject realpart;
    public final LispObject imagpart;

    private Complex(LispObject realpart, LispObject imagpart) {
        this.realpart = realpart;
        this.imagpart = imagpart;
    }

    public static LispObject getInstance(LispObject realpart, LispObject imagpart) {
        if (!realpart.realp()) {
            return Lisp.type_error(realpart, Symbol.REAL);
        }
        if (!imagpart.realp()) {
            return Lisp.type_error(imagpart, Symbol.REAL);
        }
        if (realpart instanceof DoubleFloat) {
            imagpart = DoubleFloat.coerceToFloat(imagpart);
        } else if (imagpart instanceof DoubleFloat) {
            realpart = DoubleFloat.coerceToFloat(realpart);
        } else if (realpart instanceof SingleFloat) {
            imagpart = SingleFloat.coerceToFloat(imagpart);
        } else if (imagpart instanceof SingleFloat) {
            realpart = SingleFloat.coerceToFloat(realpart);
        }
        if (imagpart instanceof Fixnum && ((Fixnum)imagpart).value == 0) {
            return realpart;
        }
        return new Complex(realpart, imagpart);
    }

    public LispObject getRealPart() {
        return this.realpart;
    }

    public LispObject getImaginaryPart() {
        return this.imagpart;
    }

    public LispObject coerceToDoubleFloat() {
        return Complex.getInstance(DoubleFloat.coerceToFloat(this.realpart), DoubleFloat.coerceToFloat(this.imagpart));
    }

    public LispObject typeOf() {
        return Symbol.COMPLEX;
    }

    public LispObject classOf() {
        return BuiltInClass.COMPLEX;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.COMPLEX) {
            return Lisp.T;
        }
        if (type == Symbol.NUMBER) {
            return Lisp.T;
        }
        if (type == BuiltInClass.COMPLEX) {
            return Lisp.T;
        }
        if (type == BuiltInClass.NUMBER) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean numberp() {
        return true;
    }

    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return this.realpart.eql(c.realpart) && this.imagpart.eql(c.imagpart);
        }
        return false;
    }

    public boolean equal(LispObject obj) {
        return this.eql(obj);
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return this.realpart.isEqualTo(c.realpart) && this.imagpart.isEqualTo(c.imagpart);
        }
        if (obj.numberp()) {
            if (this.imagpart instanceof SingleFloat && ((SingleFloat)this.imagpart).value == 0.0f) {
                if (obj instanceof Fixnum) {
                    return (float)((Fixnum)obj).value == ((SingleFloat)this.realpart).value;
                }
                if (obj instanceof SingleFloat) {
                    return ((SingleFloat)obj).value == ((SingleFloat)this.realpart).value;
                }
            }
            if (this.imagpart instanceof DoubleFloat && ((DoubleFloat)this.imagpart).value == 0.0) {
                if (obj instanceof Fixnum) {
                    return (double)((Fixnum)obj).value == ((DoubleFloat)this.realpart).value;
                }
                if (obj instanceof DoubleFloat) {
                    return ((DoubleFloat)obj).value == ((DoubleFloat)this.realpart).value;
                }
            }
        }
        return false;
    }

    public final LispObject incr() {
        return new Complex(this.realpart.add(Fixnum.ONE), this.imagpart);
    }

    public final LispObject decr() {
        return new Complex(this.realpart.subtract(Fixnum.ONE), this.imagpart);
    }

    public LispObject add(LispObject obj) {
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.realpart.add(c.realpart), this.imagpart.add(c.imagpart));
        }
        return Complex.getInstance(this.realpart.add(obj), this.imagpart);
    }

    public LispObject subtract(LispObject obj) {
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.realpart.subtract(c.realpart), this.imagpart.subtract(c.imagpart));
        }
        return Complex.getInstance(this.realpart.subtract(obj), this.imagpart);
    }

    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Complex) {
            LispObject a = this.realpart;
            LispObject b = this.imagpart;
            LispObject c = ((Complex)obj).getRealPart();
            LispObject d = ((Complex)obj).getImaginaryPart();
            LispObject ac = a.multiplyBy(c);
            LispObject bd = b.multiplyBy(d);
            LispObject ad = a.multiplyBy(d);
            LispObject bc = b.multiplyBy(c);
            return Complex.getInstance(ac.subtract(bd), ad.add(bc));
        }
        return Complex.getInstance(this.realpart.multiplyBy(obj), this.imagpart.multiplyBy(obj));
    }

    public LispObject divideBy(LispObject obj) {
        if (obj instanceof Complex) {
            LispObject a = this.realpart;
            LispObject b = this.imagpart;
            LispObject c = ((Complex)obj).getRealPart();
            LispObject d = ((Complex)obj).getImaginaryPart();
            LispObject ac = a.multiplyBy(c);
            LispObject bd = b.multiplyBy(d);
            LispObject bc = b.multiplyBy(c);
            LispObject ad = a.multiplyBy(d);
            LispObject denominator = c.multiplyBy(c).add(d.multiplyBy(d));
            return Complex.getInstance(ac.add(bd).divideBy(denominator), bc.subtract(ad).divideBy(denominator));
        }
        return Complex.getInstance(this.realpart.divideBy(obj), this.imagpart.divideBy(obj));
    }

    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return this.realpart.isEqualTo(c.realpart) && this.imagpart.isEqualTo(c.imagpart);
        }
        if (obj.numberp()) {
            if (this.imagpart instanceof SingleFloat && ((SingleFloat)this.imagpart).value == 0.0f) {
                if (obj instanceof Fixnum) {
                    return (float)((Fixnum)obj).value == ((SingleFloat)this.realpart).value;
                }
                if (obj instanceof SingleFloat) {
                    return ((SingleFloat)obj).value == ((SingleFloat)this.realpart).value;
                }
                if (obj instanceof DoubleFloat) {
                    return ((DoubleFloat)obj).value == (double)((SingleFloat)this.realpart).value;
                }
            }
            if (this.imagpart instanceof DoubleFloat && ((DoubleFloat)this.imagpart).value == 0.0) {
                if (obj instanceof Fixnum) {
                    return (double)((Fixnum)obj).value == ((DoubleFloat)this.realpart).value;
                }
                if (obj instanceof SingleFloat) {
                    return (double)((SingleFloat)obj).value == ((DoubleFloat)this.realpart).value;
                }
                if (obj instanceof DoubleFloat) {
                    return ((DoubleFloat)obj).value == ((DoubleFloat)this.realpart).value;
                }
            }
            return false;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isNotEqualTo(LispObject obj) {
        return !this.isEqualTo(obj);
    }

    public LispObject ABS() {
        if (this.realpart.zerop()) {
            return this.imagpart.ABS();
        }
        double real = DoubleFloat.coerceToFloat((LispObject)this.realpart).value;
        double imag = DoubleFloat.coerceToFloat((LispObject)this.imagpart).value;
        if (this.realpart instanceof DoubleFloat) {
            return new DoubleFloat(Math.hypot(real, imag));
        }
        return new SingleFloat((float)Math.hypot(real, imag));
    }

    public boolean zerop() {
        return this.realpart.zerop() && this.imagpart.zerop();
    }

    public LispObject COMPLEXP() {
        return Lisp.T;
    }

    public int sxhash() {
        return Lisp.mix(this.realpart.sxhash(), this.imagpart.sxhash()) & Integer.MAX_VALUE;
    }

    public int psxhash() {
        return Lisp.mix(this.realpart.psxhash(), this.imagpart.psxhash()) & Integer.MAX_VALUE;
    }

    public String printObject() {
        StringBuilder sb = new StringBuilder("#C(");
        sb.append(this.realpart.printObject());
        sb.append(' ');
        sb.append(this.imagpart.printObject());
        sb.append(')');
        return sb.toString();
    }
}

