/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.MSPSequence;
import jalview.QuickSort;
import jalview.Sequence;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MSPFile
extends FileParse {
    int noSeqs;
    int maxLength;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector words = new Vector();
    long start;
    long end;

    public MSPFile(String string) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.readLines(string);
        this.parse();
    }

    public MSPFile(String string, String string2) throws IOException {
        super(string, string2);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        int n = 0;
        while (n < this.lineArray.size()) {
            StringTokenizer stringTokenizer;
            String string = (String)this.lineArray.elementAt(n);
            if (string.indexOf("#") == -1 && (stringTokenizer = new StringTokenizer(string)).countTokens() == 8) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(string2);
                    String string3 = stringTokenizer.nextToken();
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    String string6 = "";
                    if (string4.indexOf("|") != -1) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string7 = stringTokenizer2.nextToken();
                            if (string7.equals("")) continue;
                            string4 = string7;
                        }
                    } else if (string4.indexOf(":") != -1) {
                        string6 = string4.substring(0, string4.indexOf(":"));
                        string4 = string4.substring(string4.indexOf(":") + 1);
                    }
                    this.seqs.addElement(new MSPSequence(string4, string5, n5, n6, n3, n4, n2, string3, string6));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("NumberFormatException " + numberFormatException);
                }
            }
            ++n;
        }
        this.noSeqs = this.seqs.size();
    }

    public static String print(Sequence[] sequenceArray) {
        return MSPFile.print(sequenceArray, true);
    }

    public static String print(Sequence[] sequenceArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            if (sequenceArray[n] instanceof MSPSequence) {
                MSPSequence mSPSequence = (MSPSequence)sequenceArray[n];
                stringBuffer.append(String.valueOf(mSPSequence.score) + " (" + mSPSequence.frame + ")  " + mSPSequence.qstart + " " + mSPSequence.qend + " " + mSPSequence.start + " " + mSPSequence.end + " " + mSPSequence.name + " " + mSPSequence.sequence.substring(mSPSequence.qstart - 1) + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void extractSeqs(int n, int n2, boolean bl) {
        Object object;
        Object object2;
        Sequence[] sequenceArray = new MSPSequence[this.seqs.size()];
        new Vector();
        Vector<DrawableSequence> vector = new Vector<DrawableSequence>();
        int n3 = 0;
        while (n3 < this.seqs.size()) {
            sequenceArray[n3] = (MSPSequence)this.seqs.elementAt(n3);
            ++n3;
        }
        Alignment alignment = new Alignment(sequenceArray);
        alignment.sortByID();
        int n4 = 0;
        while (n4 < alignment.sequences.length) {
            System.out.println(String.valueOf(n4) + " " + alignment.sequences[n4].name);
            ++n4;
        }
        int n5 = 0;
        while (n5 < alignment.sequences.length) {
            object2 = alignment.sequences[n5].name;
            Vector<Sequence> vector2 = new Vector<Sequence>();
            vector2.addElement(alignment.sequences[n5]);
            while (++n5 < alignment.sequences.length && alignment.sequences[n5].name.equals(object2)) {
                System.out.println(String.valueOf(object2) + " " + n5);
                vector2.addElement(alignment.sequences[n5]);
                object2 = alignment.sequences[n5].name;
            }
            System.out.println("ID  " + n5 + " " + alignment.sequences[n5 - 1].name + " has " + vector2.size() + " elements ");
            ((Sequence)vector2.elementAt(0)).getFeatures("srs.ebi.ac.uk/srs5bin/cgi-bin/", "swall");
            object = ((Sequence)vector2.elementAt((int)0)).sp.sequence;
            if (object != null) {
                if (!bl) {
                    Object object3;
                    Object[] objectArray;
                    if (vector2.size() > 1) {
                        int n6;
                        int n7;
                        objectArray = new MSPSequence[vector2.size()];
                        object3 = new float[vector2.size()];
                        int n8 = 0;
                        while (n8 < objectArray.length) {
                            objectArray[n8] = (MSPSequence)vector2.elementAt(n8);
                            object3[n8] = ((Sequence)objectArray[n8]).start;
                            ++n8;
                        }
                        QuickSort.sort(object3, objectArray);
                        int n9 = ((Sequence)objectArray[0]).start;
                        int n10 = ((Sequence)objectArray[0]).end;
                        int n11 = ((MSPSequence)objectArray[0]).qend;
                        Vector<Integer> vector3 = new Vector<Integer>();
                        Vector<Integer> vector4 = new Vector<Integer>();
                        vector3.addElement(new Integer(n9));
                        int n12 = 1;
                        while (n12 < objectArray.length) {
                            n7 = ((Sequence)objectArray[n12]).start - n10;
                            n6 = ((MSPSequence)objectArray[n12]).qstart - n11;
                            if (((Sequence)objectArray[n12]).start < n10 && ((Sequence)objectArray[n12]).end > n10) {
                                n10 = ((Sequence)objectArray[n12]).end;
                                n11 = ((MSPSequence)objectArray[n12]).qend;
                            } else if (n7 == n6 && n7 < n) {
                                n10 = ((Sequence)objectArray[n12]).end;
                            } else if ((n6 - n7) / n6 < n2) {
                                n10 = ((Sequence)objectArray[n12]).end;
                            } else {
                                vector4.addElement(new Integer(n10));
                                vector3.addElement(new Integer(((Sequence)objectArray[n12]).start));
                                n9 = ((Sequence)objectArray[n12]).start;
                                n10 = ((Sequence)objectArray[n12]).end;
                            }
                            ++n12;
                        }
                        vector4.addElement(new Integer(n10));
                        n7 = 0;
                        while (n7 < vector3.size()) {
                            n6 = (Integer)vector3.elementAt(n7);
                            int n13 = (Integer)vector4.elementAt(n7);
                            vector.addElement(new DrawableSequence(((Sequence)object).name, ((Sequence)object).sequence.substring(n6 - 1, n13 - 1), n6, n13));
                            ++n7;
                        }
                        continue;
                    }
                    objectArray = (Sequence)vector2.elementAt(0);
                    object3 = this.unPad(objectArray.sequence, true);
                    object3 = this.unPad((String)object3, false);
                    vector.addElement(new DrawableSequence(objectArray.name, (String)object3, objectArray.start, objectArray.end));
                    continue;
                }
                System.out.println("Adding " + ((Sequence)object).name);
                vector.addElement(new DrawableSequence(((Sequence)object).name, ((Sequence)object).sequence, ((Sequence)object).start, ((Sequence)object).end));
                continue;
            }
            System.out.println("ERROR: Couldn't fetch SRS sequence");
        }
        object2 = new DrawableSequence[vector.size()];
        int n14 = 0;
        while (n14 < vector.size()) {
            object2[n14] = object = (DrawableSequence)vector.elementAt(n14);
            System.out.println(String.valueOf(((Sequence)object).name) + " " + ((Sequence)object).start + " " + ((Sequence)object).end + " " + ((Sequence)object).sequence);
            ++n14;
        }
        object = new AlignFrame((DrawableSequence[])object2);
        ((Component)object).resize(700, 500);
        ((Window)object).show();
    }

    public String unPad(String string, boolean bl) {
        if (bl) {
            while (string.length() > 0 && (string.substring(0, 1).equals(" ") || string.substring(0, 1).equals("-") || string.substring(0, 1).equals("."))) {
                string = string.substring(1);
            }
            return string;
        }
        if (!bl) {
            while (string.length() > 0 && (string.substring(string.length() - 1).equals(" ") || string.substring(string.length() - 1).equals("-") || string.substring(string.length() - 1).equals("."))) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            MSPFile mSPFile = new MSPFile(stringArray[0], "File");
            Sequence[] sequenceArray = new MSPSequence[mSPFile.seqs.size()];
            mSPFile.extractSeqs(5, 20, true);
            int n = 0;
            while (n < mSPFile.seqs.size()) {
                sequenceArray[n] = (MSPSequence)mSPFile.seqs.elementAt(n);
                ++n;
            }
            String string = MSPFile.print(sequenceArray);
            AlignFrame alignFrame = new AlignFrame((DrawableSequence[])sequenceArray);
            alignFrame.resize(700, 500);
            alignFrame.show();
            ConsThread consThread = new ConsThread(alignFrame);
            consThread.start();
            System.out.println(string);
            System.out.println("done");
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }
}

