require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IF_ETREG_H)) {
    eval 'sub _IF_ETREG_H () {1;}' unless defined(&_IF_ETREG_H);
    eval 'sub ET_INTERN_MEM_SIZE () {0x400;}' unless defined(&ET_INTERN_MEM_SIZE);
    eval 'sub ET_INTERN_MEM_END () {( &ET_INTERN_MEM_SIZE - 1);}' unless defined(&ET_INTERN_MEM_END);
    eval 'sub ET_PCIR_BAR () {0x10;}' unless defined(&ET_PCIR_BAR);
    eval 'sub ET_PCIR_DEVICE_CAPS () {0x4c;}' unless defined(&ET_PCIR_DEVICE_CAPS);
    eval 'sub ET_PCIM_DEVICE_CAPS_MAX_PLSZ () {0x7;}' unless defined(&ET_PCIM_DEVICE_CAPS_MAX_PLSZ);
    eval 'sub ET_PCIV_DEVICE_CAPS_PLSZ_128 () {0x;}' unless defined(&ET_PCIV_DEVICE_CAPS_PLSZ_128);
    eval 'sub ET_PCIV_DEVICE_CAPS_PLSZ_256 () {0x1;}' unless defined(&ET_PCIV_DEVICE_CAPS_PLSZ_256);
    eval 'sub ET_PCIR_DEVICE_CTRL () {0x50;}' unless defined(&ET_PCIR_DEVICE_CTRL);
    eval 'sub ET_PCIM_DEVICE_CTRL_MAX_RRSZ () {0x7000;}' unless defined(&ET_PCIM_DEVICE_CTRL_MAX_RRSZ);
    eval 'sub ET_PCIV_DEVICE_CTRL_RRSZ_2K () {0x4000;}' unless defined(&ET_PCIV_DEVICE_CTRL_RRSZ_2K);
    eval 'sub ET_PCIR_MACADDR_LO () {0xa4;}' unless defined(&ET_PCIR_MACADDR_LO);
    eval 'sub ET_PCIR_MACADDR_HI () {0xa8;}' unless defined(&ET_PCIR_MACADDR_HI);
    eval 'sub ET_PCIR_EEPROM_MISC () {0xb0;}' unless defined(&ET_PCIR_EEPROM_MISC);
    eval 'sub ET_PCIR_EEPROM_STATUS_MASK () {0xff00;}' unless defined(&ET_PCIR_EEPROM_STATUS_MASK);
    eval 'sub ET_PCIM_EEPROM_STATUS_ERROR () {0x4c00;}' unless defined(&ET_PCIM_EEPROM_STATUS_ERROR);
    eval 'sub ET_PCIR_ACK_LATENCY () {0xc0;}' unless defined(&ET_PCIR_ACK_LATENCY);
    eval 'sub ET_PCIV_ACK_LATENCY_128 () {237;}' unless defined(&ET_PCIV_ACK_LATENCY_128);
    eval 'sub ET_PCIV_ACK_LATENCY_256 () {416;}' unless defined(&ET_PCIV_ACK_LATENCY_256);
    eval 'sub ET_PCIR_REPLAY_TIMER () {0xc2;}' unless defined(&ET_PCIR_REPLAY_TIMER);
    eval 'sub ET_REPLAY_TIMER_RX_L0S_ADJ () {250;}' unless defined(&ET_REPLAY_TIMER_RX_L0S_ADJ);
    eval 'sub ET_PCIV_REPLAY_TIMER_128 () {(711+  &ET_REPLAY_TIMER_RX_L0S_ADJ);}' unless defined(&ET_PCIV_REPLAY_TIMER_128);
    eval 'sub ET_PCIV_REPLAY_TIMER_256 () {(1248+  &ET_REPLAY_TIMER_RX_L0S_ADJ);}' unless defined(&ET_PCIV_REPLAY_TIMER_256);
    eval 'sub ET_PCIR_L0S_L1_LATENCY () {0xcf;}' unless defined(&ET_PCIR_L0S_L1_LATENCY);
    eval 'sub ET_PCIM_L0S_LATENCY () {(7<< 0);}' unless defined(&ET_PCIM_L0S_LATENCY);
    eval 'sub ET_PCIM_L1_LATENCY () {(7<< 3);}' unless defined(&ET_PCIM_L1_LATENCY);
    eval 'sub ET_TXQ_START () {0x;}' unless defined(&ET_TXQ_START);
    eval 'sub ET_TXQ_END () {0x4;}' unless defined(&ET_TXQ_END);
    eval 'sub ET_RXQ_START () {0x8;}' unless defined(&ET_RXQ_START);
    eval 'sub ET_RXQ_END () {0xc;}' unless defined(&ET_RXQ_END);
    eval 'sub ET_PM () {0x10;}' unless defined(&ET_PM);
    eval 'sub ET_PM_SYSCLK_GATE () {(1<< 3);}' unless defined(&ET_PM_SYSCLK_GATE);
    eval 'sub ET_PM_TXCLK_GATE () {(1<< 4);}' unless defined(&ET_PM_TXCLK_GATE);
    eval 'sub ET_PM_RXCLK_GATE () {(1<< 5);}' unless defined(&ET_PM_RXCLK_GATE);
    eval 'sub ET_INTR_STATUS () {0x18;}' unless defined(&ET_INTR_STATUS);
    eval 'sub ET_INTR_MASK () {0x1c;}' unless defined(&ET_INTR_MASK);
    eval 'sub ET_SWRST () {0x28;}' unless defined(&ET_SWRST);
    eval 'sub ET_SWRST_TXDMA () {(1 << 0);}' unless defined(&ET_SWRST_TXDMA);
    eval 'sub ET_SWRST_RXDMA () {(1 << 1);}' unless defined(&ET_SWRST_RXDMA);
    eval 'sub ET_SWRST_TXMAC () {(1 << 2);}' unless defined(&ET_SWRST_TXMAC);
    eval 'sub ET_SWRST_RXMAC () {(1 << 3);}' unless defined(&ET_SWRST_RXMAC);
    eval 'sub ET_SWRST_MAC () {(1 << 4);}' unless defined(&ET_SWRST_MAC);
    eval 'sub ET_SWRST_MAC_STAT () {(1 << 5);}' unless defined(&ET_SWRST_MAC_STAT);
    eval 'sub ET_SWRST_MMC () {(1 << 6);}' unless defined(&ET_SWRST_MMC);
    eval 'sub ET_SWRST_SELFCLR_DISABLE () {(1 << 31);}' unless defined(&ET_SWRST_SELFCLR_DISABLE);
    eval 'sub ET_MSI_CFG () {0x30;}' unless defined(&ET_MSI_CFG);
    eval 'sub ET_LOOPBACK () {0x34;}' unless defined(&ET_LOOPBACK);
    eval 'sub ET_TIMER () {0x38;}' unless defined(&ET_TIMER);
    eval 'sub ET_TXDMA_CTRL () {0x1000;}' unless defined(&ET_TXDMA_CTRL);
    eval 'sub ET_TXDMA_CTRL_HALT () {(1<< 0);}' unless defined(&ET_TXDMA_CTRL_HALT);
    eval 'sub ET_TXDMA_CTRL_CACHE_THR () {0xf0;}' unless defined(&ET_TXDMA_CTRL_CACHE_THR);
    eval 'sub ET_TXDMA_CTRL_SINGLE_EPKT () {(1<< 8);}' unless defined(&ET_TXDMA_CTRL_SINGLE_EPKT);
    eval 'sub ET_TX_RING_HI () {0x1004;}' unless defined(&ET_TX_RING_HI);
    eval 'sub ET_TX_RING_LO () {0x1008;}' unless defined(&ET_TX_RING_LO);
    eval 'sub ET_TX_RING_CNT () {0x100c;}' unless defined(&ET_TX_RING_CNT);
    eval 'sub ET_TX_STATUS_HI () {0x101c;}' unless defined(&ET_TX_STATUS_HI);
    eval 'sub ET_TX_STATUS_LO () {0x1020;}' unless defined(&ET_TX_STATUS_LO);
    eval 'sub ET_TX_READY_POS () {0x1024;}' unless defined(&ET_TX_READY_POS);
    eval 'sub ET_TX_READY_POS_INDEX () {0x3ff;}' unless defined(&ET_TX_READY_POS_INDEX);
    eval 'sub ET_TX_READY_POS_WRAP () {(1<< 10);}' unless defined(&ET_TX_READY_POS_WRAP);
    eval 'sub ET_TX_DONE_POS () {0x1060;}' unless defined(&ET_TX_DONE_POS);
    eval 'sub ET_TX_DONE_POS_INDEX () {0x3ff;}' unless defined(&ET_TX_DONE_POS_INDEX);
    eval 'sub ET_TX_DONE_POS_WRAP () {(1<< 10);}' unless defined(&ET_TX_DONE_POS_WRAP);
    eval 'sub ET_RXDMA_CTRL () {0x2000;}' unless defined(&ET_RXDMA_CTRL);
    eval 'sub ET_RXDMA_CTRL_HALT () {(1<< 0);}' unless defined(&ET_RXDMA_CTRL_HALT);
    eval 'sub ET_RXDMA_CTRL_RING0_SIZE () {(3<< 8);}' unless defined(&ET_RXDMA_CTRL_RING0_SIZE);
    eval 'sub ET_RXDMA_CTRL_RING0_ENABLE () {(1<< 10);}' unless defined(&ET_RXDMA_CTRL_RING0_ENABLE);
    eval 'sub ET_RXDMA_CTRL_RING1_SIZE () {(3<< 11);}' unless defined(&ET_RXDMA_CTRL_RING1_SIZE);
    eval 'sub ET_RXDMA_CTRL_RING1_ENABLE () {(1<< 13);}' unless defined(&ET_RXDMA_CTRL_RING1_ENABLE);
    eval 'sub ET_RXDMA_CTRL_HALTED () {(1<< 17);}' unless defined(&ET_RXDMA_CTRL_HALTED);
    eval 'sub ET_RX_STATUS_LO () {0x2004;}' unless defined(&ET_RX_STATUS_LO);
    eval 'sub ET_RX_STATUS_HI () {0x2008;}' unless defined(&ET_RX_STATUS_HI);
    eval 'sub ET_RX_INTR_NPKTS () {0x200c;}' unless defined(&ET_RX_INTR_NPKTS);
    eval 'sub ET_RX_INTR_DELAY () {0x2010;}' unless defined(&ET_RX_INTR_DELAY);
    eval 'sub ET_RXSTAT_LO () {0x2020;}' unless defined(&ET_RXSTAT_LO);
    eval 'sub ET_RXSTAT_HI () {0x2024;}' unless defined(&ET_RXSTAT_HI);
    eval 'sub ET_RXSTAT_CNT () {0x2028;}' unless defined(&ET_RXSTAT_CNT);
    eval 'sub ET_RXSTAT_POS () {0x2030;}' unless defined(&ET_RXSTAT_POS);
    eval 'sub ET_RXSTAT_POS_INDEX () {0xfff;}' unless defined(&ET_RXSTAT_POS_INDEX);
    eval 'sub ET_RXSTAT_POS_WRAP () {(1<< 12);}' unless defined(&ET_RXSTAT_POS_WRAP);
    eval 'sub ET_RXSTAT_MINCNT () {0x2038;}' unless defined(&ET_RXSTAT_MINCNT);
    eval 'sub ET_RX_RING0_LO () {0x203c;}' unless defined(&ET_RX_RING0_LO);
    eval 'sub ET_RX_RING0_HI () {0x2040;}' unless defined(&ET_RX_RING0_HI);
    eval 'sub ET_RX_RING0_CNT () {0x2044;}' unless defined(&ET_RX_RING0_CNT);
    eval 'sub ET_RX_RING0_POS () {0x204c;}' unless defined(&ET_RX_RING0_POS);
    eval 'sub ET_RX_RING0_POS_INDEX () {0x3ff;}' unless defined(&ET_RX_RING0_POS_INDEX);
    eval 'sub ET_RX_RING0_POS_WRAP () {(1<< 10);}' unless defined(&ET_RX_RING0_POS_WRAP);
    eval 'sub ET_RX_RING0_MINCNT () {0x2054;}' unless defined(&ET_RX_RING0_MINCNT);
    eval 'sub ET_RX_RING1_LO () {0x2058;}' unless defined(&ET_RX_RING1_LO);
    eval 'sub ET_RX_RING1_HI () {0x205c;}' unless defined(&ET_RX_RING1_HI);
    eval 'sub ET_RX_RING1_CNT () {0x2060;}' unless defined(&ET_RX_RING1_CNT);
    eval 'sub ET_RX_RING1_POS () {0x2068;}' unless defined(&ET_RX_RING1_POS);
    eval 'sub ET_RX_RING1_POS_INDEX () {0x3ff;}' unless defined(&ET_RX_RING1_POS_INDEX);
    eval 'sub ET_RX_RING1_POS_WRAP () {(1<< 10);}' unless defined(&ET_RX_RING1_POS_WRAP);
    eval 'sub ET_RX_RING1_MINCNT () {0x2070;}' unless defined(&ET_RX_RING1_MINCNT);
    eval 'sub ET_TXMAC_CTRL () {0x3000;}' unless defined(&ET_TXMAC_CTRL);
    eval 'sub ET_TXMAC_CTRL_ENABLE () {(1<< 0);}' unless defined(&ET_TXMAC_CTRL_ENABLE);
    eval 'sub ET_TXMAC_CTRL_FC_DISABLE () {(1<< 3);}' unless defined(&ET_TXMAC_CTRL_FC_DISABLE);
    eval 'sub ET_TXMAC_FLOWCTRL () {0x3010;}' unless defined(&ET_TXMAC_FLOWCTRL);
    eval 'sub ET_RXMAC_CTRL () {0x4000;}' unless defined(&ET_RXMAC_CTRL);
    eval 'sub ET_RXMAC_CTRL_ENABLE () {(1<< 0);}' unless defined(&ET_RXMAC_CTRL_ENABLE);
    eval 'sub ET_RXMAC_CTRL_NO_PKTFILT () {(1<< 2);}' unless defined(&ET_RXMAC_CTRL_NO_PKTFILT);
    eval 'sub ET_RXMAC_CTRL_WOL_DISABLE () {(1<< 3);}' unless defined(&ET_RXMAC_CTRL_WOL_DISABLE);
    eval 'sub ET_WOL_CRC () {0x4004;}' unless defined(&ET_WOL_CRC);
    eval 'sub ET_WOL_SA_LO () {0x4010;}' unless defined(&ET_WOL_SA_LO);
    eval 'sub ET_WOL_SA_HI () {0x4014;}' unless defined(&ET_WOL_SA_HI);
    eval 'sub ET_WOL_MASK () {0x4018;}' unless defined(&ET_WOL_MASK);
    eval 'sub ET_UCAST_FILTADDR1 () {0x4068;}' unless defined(&ET_UCAST_FILTADDR1);
    eval 'sub ET_UCAST_FILTADDR2 () {0x406c;}' unless defined(&ET_UCAST_FILTADDR2);
    eval 'sub ET_UCAST_FILTADDR3 () {0x4070;}' unless defined(&ET_UCAST_FILTADDR3);
    eval 'sub ET_MULTI_HASH () {0x4074;}' unless defined(&ET_MULTI_HASH);
    eval 'sub ET_PKTFILT () {0x4084;}' unless defined(&ET_PKTFILT);
    eval 'sub ET_PKTFILT_BCAST () {(1<< 0);}' unless defined(&ET_PKTFILT_BCAST);
    eval 'sub ET_PKTFILT_MCAST () {(1<< 1);}' unless defined(&ET_PKTFILT_MCAST);
    eval 'sub ET_PKTFILT_UCAST () {(1<< 2);}' unless defined(&ET_PKTFILT_UCAST);
    eval 'sub ET_PKTFILT_FRAG () {(1<< 3);}' unless defined(&ET_PKTFILT_FRAG);
    eval 'sub ET_PKTFILT_MINLEN () {0x7f0000;}' unless defined(&ET_PKTFILT_MINLEN);
    eval 'sub ET_RXMAC_MC_SEGSZ () {0x4088;}' unless defined(&ET_RXMAC_MC_SEGSZ);
    eval 'sub ET_RXMAC_MC_SEGSZ_ENABLE () {(1<< 0);}' unless defined(&ET_RXMAC_MC_SEGSZ_ENABLE);
    eval 'sub ET_RXMAC_MC_SEGSZ_FC () {(1<< 1);}' unless defined(&ET_RXMAC_MC_SEGSZ_FC);
    eval 'sub ET_RXMAC_MC_SEGSZ_MAX () {0x3fc;}' unless defined(&ET_RXMAC_MC_SEGSZ_MAX);
    eval 'sub ET_RXMAC_MC_WATERMARK () {0x408c;}' unless defined(&ET_RXMAC_MC_WATERMARK);
    eval 'sub ET_RXMAC_SPACE_AVL () {0x4094;}' unless defined(&ET_RXMAC_SPACE_AVL);
    eval 'sub ET_RXMAC_MGT () {0x4098;}' unless defined(&ET_RXMAC_MGT);
    eval 'sub ET_RXMAC_MGT_PASS_ECRC () {(1<< 4);}' unless defined(&ET_RXMAC_MGT_PASS_ECRC);
    eval 'sub ET_RXMAC_MGT_PASS_ELEN () {(1<< 5);}' unless defined(&ET_RXMAC_MGT_PASS_ELEN);
    eval 'sub ET_RXMAC_MGT_PASS_ETRUNC () {(1<< 16);}' unless defined(&ET_RXMAC_MGT_PASS_ETRUNC);
    eval 'sub ET_RXMAC_MGT_CHECK_PKT () {(1<< 17);}' unless defined(&ET_RXMAC_MGT_CHECK_PKT);
    eval 'sub ET_MAC_CFG1 () {0x5000;}' unless defined(&ET_MAC_CFG1);
    eval 'sub ET_MAC_CFG1_TXEN () {(1 << 0);}' unless defined(&ET_MAC_CFG1_TXEN);
    eval 'sub ET_MAC_CFG1_SYNC_TXEN () {(1 << 1);}' unless defined(&ET_MAC_CFG1_SYNC_TXEN);
    eval 'sub ET_MAC_CFG1_RXEN () {(1 << 2);}' unless defined(&ET_MAC_CFG1_RXEN);
    eval 'sub ET_MAC_CFG1_SYNC_RXEN () {(1 << 3);}' unless defined(&ET_MAC_CFG1_SYNC_RXEN);
    eval 'sub ET_MAC_CFG1_TXFLOW () {(1 << 4);}' unless defined(&ET_MAC_CFG1_TXFLOW);
    eval 'sub ET_MAC_CFG1_RXFLOW () {(1 << 5);}' unless defined(&ET_MAC_CFG1_RXFLOW);
    eval 'sub ET_MAC_CFG1_LOOPBACK () {(1 << 8);}' unless defined(&ET_MAC_CFG1_LOOPBACK);
    eval 'sub ET_MAC_CFG1_RST_TXFUNC () {(1 << 16);}' unless defined(&ET_MAC_CFG1_RST_TXFUNC);
    eval 'sub ET_MAC_CFG1_RST_RXFUNC () {(1 << 17);}' unless defined(&ET_MAC_CFG1_RST_RXFUNC);
    eval 'sub ET_MAC_CFG1_RST_TXMC () {(1 << 18);}' unless defined(&ET_MAC_CFG1_RST_TXMC);
    eval 'sub ET_MAC_CFG1_RST_RXMC () {(1 << 19);}' unless defined(&ET_MAC_CFG1_RST_RXMC);
    eval 'sub ET_MAC_CFG1_SIM_RST () {(1 << 30);}' unless defined(&ET_MAC_CFG1_SIM_RST);
    eval 'sub ET_MAC_CFG1_SOFT_RST () {(1 << 31);}' unless defined(&ET_MAC_CFG1_SOFT_RST);
    eval 'sub ET_MAC_CFG2 () {0x5004;}' unless defined(&ET_MAC_CFG2);
    eval 'sub ET_MAC_CFG2_FDX () {(1<< 0);}' unless defined(&ET_MAC_CFG2_FDX);
    eval 'sub ET_MAC_CFG2_CRC () {(1<< 1);}' unless defined(&ET_MAC_CFG2_CRC);
    eval 'sub ET_MAC_CFG2_PADCRC () {(1<< 2);}' unless defined(&ET_MAC_CFG2_PADCRC);
    eval 'sub ET_MAC_CFG2_LENCHK () {(1<< 4);}' unless defined(&ET_MAC_CFG2_LENCHK);
    eval 'sub ET_MAC_CFG2_BIGFRM () {(1<< 5);}' unless defined(&ET_MAC_CFG2_BIGFRM);
    eval 'sub ET_MAC_CFG2_MODE_MII () {(1<< 8);}' unless defined(&ET_MAC_CFG2_MODE_MII);
    eval 'sub ET_MAC_CFG2_MODE_GMII () {(1<< 9);}' unless defined(&ET_MAC_CFG2_MODE_GMII);
    eval 'sub ET_MAC_CFG2_PREAMBLE_LEN () {0xf000;}' unless defined(&ET_MAC_CFG2_PREAMBLE_LEN);
    eval 'sub ET_IPG () {0x5008;}' unless defined(&ET_IPG);
    eval 'sub ET_IPG_B2B () {0x7f;}' unless defined(&ET_IPG_B2B);
    eval 'sub ET_IPG_MINIFG () {0xff00;}' unless defined(&ET_IPG_MINIFG);
    eval 'sub ET_IPG_NONB2B_2 () {0x7f0000;}' unless defined(&ET_IPG_NONB2B_2);
    eval 'sub ET_IPG_NONB2B_1 () {0x7f000000;}' unless defined(&ET_IPG_NONB2B_1);
    eval 'sub ET_MAC_HDX () {0x500c;}' unless defined(&ET_MAC_HDX);
    eval 'sub ET_MAC_HDX_COLLWIN () {0x3ff;}' unless defined(&ET_MAC_HDX_COLLWIN);
    eval 'sub ET_MAC_HDX_REXMIT_MAX () {0xf000;}' unless defined(&ET_MAC_HDX_REXMIT_MAX);
    eval 'sub ET_MAC_HDX_REXMIT_MAX () {0xf000;}' unless defined(&ET_MAC_HDX_REXMIT_MAX);
    eval 'sub ET_MAC_HDX_EXC_DEFER () {(1<< 16);}' unless defined(&ET_MAC_HDX_EXC_DEFER);
    eval 'sub ET_MAC_HDX_NOBACKOFF () {(1<< 17);}' unless defined(&ET_MAC_HDX_NOBACKOFF);
    eval 'sub ET_MAC_HDX_BP_NOBACKOFF () {(1<< 18);}' unless defined(&ET_MAC_HDX_BP_NOBACKOFF);
    eval 'sub ET_MAC_HDX_ALT_BEB () {(1<< 19);}' unless defined(&ET_MAC_HDX_ALT_BEB);
    eval 'sub ET_MAC_HDX_ALT_BEB_TRUNC () {0xf00000;}' unless defined(&ET_MAC_HDX_ALT_BEB_TRUNC);
    eval 'sub ET_MAX_FRMLEN () {0x5010;}' unless defined(&ET_MAX_FRMLEN);
    eval 'sub ET_MII_CFG () {0x5020;}' unless defined(&ET_MII_CFG);
    eval 'sub ET_MII_CFG_CLKRST () {(7 << 0);}' unless defined(&ET_MII_CFG_CLKRST);
    eval 'sub ET_MII_CFG_PREAMBLE_SUP () {(1 << 4);}' unless defined(&ET_MII_CFG_PREAMBLE_SUP);
    eval 'sub ET_MII_CFG_SCAN_AUTOINC () {(1 << 5);}' unless defined(&ET_MII_CFG_SCAN_AUTOINC);
    eval 'sub ET_MII_CFG_RST () {(1 << 31);}' unless defined(&ET_MII_CFG_RST);
    eval 'sub ET_MII_CMD () {0x5024;}' unless defined(&ET_MII_CMD);
    eval 'sub ET_MII_CMD_READ () {(1<< 0);}' unless defined(&ET_MII_CMD_READ);
    eval 'sub ET_MII_ADDR () {0x5028;}' unless defined(&ET_MII_ADDR);
    eval 'sub ET_MII_ADDR_REG () {0x1f;}' unless defined(&ET_MII_ADDR_REG);
    eval 'sub ET_MII_ADDR_PHY () {0x1f00;}' unless defined(&ET_MII_ADDR_PHY);
    eval 'sub ET_MII_ADDR_SHIFT () {8;}' unless defined(&ET_MII_ADDR_SHIFT);
    eval 'sub ET_MII_CTRL () {0x502c;}' unless defined(&ET_MII_CTRL);
    eval 'sub ET_MII_CTRL_VALUE () {0xffff;}' unless defined(&ET_MII_CTRL_VALUE);
    eval 'sub ET_MII_STAT () {0x5030;}' unless defined(&ET_MII_STAT);
    eval 'sub ET_MII_STAT_VALUE () {0xffff;}' unless defined(&ET_MII_STAT_VALUE);
    eval 'sub ET_MII_IND () {0x5034;}' unless defined(&ET_MII_IND);
    eval 'sub ET_MII_IND_BUSY () {(1<< 0);}' unless defined(&ET_MII_IND_BUSY);
    eval 'sub ET_MII_IND_INVALID () {(1<< 2);}' unless defined(&ET_MII_IND_INVALID);
    eval 'sub ET_MAC_CTRL () {0x5038;}' unless defined(&ET_MAC_CTRL);
    eval 'sub ET_MAC_CTRL_MODE_MII () {(1<< 24);}' unless defined(&ET_MAC_CTRL_MODE_MII);
    eval 'sub ET_MAC_CTRL_LHDX () {(1<< 25);}' unless defined(&ET_MAC_CTRL_LHDX);
    eval 'sub ET_MAC_CTRL_GHDX () {(1<< 26);}' unless defined(&ET_MAC_CTRL_GHDX);
    eval 'sub ET_MAC_ADDR1 () {0x5040;}' unless defined(&ET_MAC_ADDR1);
    eval 'sub ET_MAC_ADDR2 () {0x5044;}' unless defined(&ET_MAC_ADDR2);
    eval 'sub ET_MMC_CTRL () {0x7000;}' unless defined(&ET_MMC_CTRL);
    eval 'sub ET_MMC_CTRL_ENABLE () {(1<< 0);}' unless defined(&ET_MMC_CTRL_ENABLE);
    eval 'sub ET_MMC_CTRL_ARB_DISABLE () {(1<< 1);}' unless defined(&ET_MMC_CTRL_ARB_DISABLE);
    eval 'sub ET_MMC_CTRL_RXMAC_DISABLE () {(1<< 2);}' unless defined(&ET_MMC_CTRL_RXMAC_DISABLE);
    eval 'sub ET_MMC_CTRL_TXMAC_DISABLE () {(1<< 3);}' unless defined(&ET_MMC_CTRL_TXMAC_DISABLE);
    eval 'sub ET_MMC_CTRL_TXDMA_DISABLE () {(1<< 4);}' unless defined(&ET_MMC_CTRL_TXDMA_DISABLE);
    eval 'sub ET_MMC_CTRL_RXDMA_DISABLE () {(1<< 5);}' unless defined(&ET_MMC_CTRL_RXDMA_DISABLE);
    eval 'sub ET_MMC_CTRL_FORCE_CE () {(1<< 6);}' unless defined(&ET_MMC_CTRL_FORCE_CE);
    eval 'sub ET_INTR_TXEOF () {(1<< 3);}' unless defined(&ET_INTR_TXEOF);
    eval 'sub ET_INTR_TXDMA_ERROR () {(1<< 4);}' unless defined(&ET_INTR_TXDMA_ERROR);
    eval 'sub ET_INTR_RXEOF () {(1<< 5);}' unless defined(&ET_INTR_RXEOF);
    eval 'sub ET_INTR_RXRING0_LOW () {(1<< 6);}' unless defined(&ET_INTR_RXRING0_LOW);
    eval 'sub ET_INTR_RXRING1_LOW () {(1<< 7);}' unless defined(&ET_INTR_RXRING1_LOW);
    eval 'sub ET_INTR_RXSTAT_LOW () {(1<< 8);}' unless defined(&ET_INTR_RXSTAT_LOW);
    eval 'sub ET_INTR_RXDMA_ERROR () {(1<< 9);}' unless defined(&ET_INTR_RXDMA_ERROR);
    eval 'sub ET_INTR_TIMER () {(1<< 10);}' unless defined(&ET_INTR_TIMER);
    eval 'sub ET_INTR_WOL () {(1<< 15);}' unless defined(&ET_INTR_WOL);
    eval 'sub ET_INTR_PHY () {(1<< 16);}' unless defined(&ET_INTR_PHY);
    eval 'sub ET_INTR_TXMAC () {(1<< 17);}' unless defined(&ET_INTR_TXMAC);
    eval 'sub ET_INTR_RXMAC () {(1<< 18);}' unless defined(&ET_INTR_RXMAC);
    eval 'sub ET_INTR_MAC_STATS () {(1<< 19);}' unless defined(&ET_INTR_MAC_STATS);
    eval 'sub ET_INTR_SLAVE_TO () {(1<< 20);}' unless defined(&ET_INTR_SLAVE_TO);
    eval 'sub ET_INTRS () {( &ET_INTR_TXEOF |  &ET_INTR_RXEOF |  &ET_INTR_TIMER);}' unless defined(&ET_INTRS);
    eval 'sub ET_RX_RING_POS_INDEX () {(0x3ff << 0);}' unless defined(&ET_RX_RING_POS_INDEX);
    eval 'sub ET_RX_RING_POS_WRAP () {(1<< 10);}' unless defined(&ET_RX_RING_POS_WRAP);
    eval 'sub ET_ALIGN () {0x1000;}' unless defined(&ET_ALIGN);
    eval 'sub ET_NSEG_MAX () {32;}' unless defined(&ET_NSEG_MAX);
    eval 'sub ET_NSEG_SPARE () {5;}' unless defined(&ET_NSEG_SPARE);
    eval 'sub ET_TX_NDESC () {512;}' unless defined(&ET_TX_NDESC);
    eval 'sub ET_RX_NDESC () {512;}' unless defined(&ET_RX_NDESC);
    eval 'sub ET_RX_NRING () {2;}' unless defined(&ET_RX_NRING);
    eval 'sub ET_RX_NSTAT () {( &ET_RX_NRING *  &ET_RX_NDESC);}' unless defined(&ET_RX_NSTAT);
    eval 'sub ET_TX_RING_SIZE () {( &ET_TX_NDESC * $sizeof{\'struct et_txdesc\'});}' unless defined(&ET_TX_RING_SIZE);
    eval 'sub ET_RX_RING_SIZE () {( &ET_RX_NDESC * $sizeof{\'struct et_rxdesc\'});}' unless defined(&ET_RX_RING_SIZE);
    eval 'sub ET_RXSTAT_RING_SIZE () {( &ET_RX_NSTAT * $sizeof{\'struct et_rxstat\'});}' unless defined(&ET_RXSTAT_RING_SIZE);
    eval 'sub CSR_WRITE_4 {
        my($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg), ($val)));
    }' unless defined(&CSR_WRITE_4);
    eval 'sub CSR_READ_4 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_4(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg)));
    }' unless defined(&CSR_READ_4);
    eval 'sub ET_ADDR_HI {
        my($addr) = @_;
	    eval q((( &uint64_t) ($addr) >> 32));
    }' unless defined(&ET_ADDR_HI);
    eval 'sub ET_ADDR_LO {
        my($addr) = @_;
	    eval q((( &uint64_t) ($addr) & 0xffffffff));
    }' unless defined(&ET_ADDR_LO);
    eval 'sub ET_TDCTRL1_LEN () {0xffff;}' unless defined(&ET_TDCTRL1_LEN);
    eval 'sub ET_TDCTRL2_LAST_FRAG () {(1<< 0);}' unless defined(&ET_TDCTRL2_LAST_FRAG);
    eval 'sub ET_TDCTRL2_FIRST_FRAG () {(1<< 1);}' unless defined(&ET_TDCTRL2_FIRST_FRAG);
    eval 'sub ET_TDCTRL2_INTR () {(1<< 2);}' unless defined(&ET_TDCTRL2_INTR);
    eval 'sub ET_RDCTRL_BUFIDX () {0x3ff;}' unless defined(&ET_RDCTRL_BUFIDX);
    eval 'sub ET_RXST_INFO2_LEN () {0xffff;}' unless defined(&ET_RXST_INFO2_LEN);
    eval 'sub ET_RXST_INFO2_BUFIDX () {0x3ff0000;}' unless defined(&ET_RXST_INFO2_BUFIDX);
    eval 'sub ET_RXST_INFO2_RINGIDX () {(3<< 26);}' unless defined(&ET_RXST_INFO2_RINGIDX);
    eval 'sub ET_RXS_STATRING_INDEX () {0xfff0000;}' unless defined(&ET_RXS_STATRING_INDEX);
    eval 'sub ET_RXS_STATRING_WRAP () {(1<< 28);}' unless defined(&ET_RXS_STATRING_WRAP);
}
1;
