require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_X509_H)) {
    eval 'sub HEADER_X509_H () {1;}' unless defined(&HEADER_X509_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_BUFFER)) {
	require 'openssl/buffer.ph';
    }
    unless(defined(&OPENSSL_NO_EVP)) {
	require 'openssl/evp.ph';
    }
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    require 'openssl/stack.ph';
    require 'openssl/asn1.ph';
    require 'openssl/safestack.ph';
    unless(defined(&OPENSSL_NO_EC)) {
	require 'openssl/ec.ph';
    }
    unless(defined(&OPENSSL_NO_ECDSA)) {
	require 'openssl/ecdsa.ph';
    }
    unless(defined(&OPENSSL_NO_ECDH)) {
	require 'openssl/ecdh.ph';
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	unless(defined(&OPENSSL_NO_RSA)) {
	    require 'openssl/rsa.ph';
	}
	unless(defined(&OPENSSL_NO_DSA)) {
	    require 'openssl/dsa.ph';
	}
	unless(defined(&OPENSSL_NO_DH)) {
	    require 'openssl/dh.ph';
	}
    }
    unless(defined(&OPENSSL_NO_SHA)) {
	require 'openssl/sha.ph';
    }
    require 'openssl/ossl_typ.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub X509_FILETYPE_PEM () {1;}' unless defined(&X509_FILETYPE_PEM);
    eval 'sub X509_FILETYPE_ASN1 () {2;}' unless defined(&X509_FILETYPE_ASN1);
    eval 'sub X509_FILETYPE_DEFAULT () {3;}' unless defined(&X509_FILETYPE_DEFAULT);
    eval 'sub X509v3_KU_DIGITAL_SIGNATURE () {0x80;}' unless defined(&X509v3_KU_DIGITAL_SIGNATURE);
    eval 'sub X509v3_KU_NON_REPUDIATION () {0x40;}' unless defined(&X509v3_KU_NON_REPUDIATION);
    eval 'sub X509v3_KU_KEY_ENCIPHERMENT () {0x20;}' unless defined(&X509v3_KU_KEY_ENCIPHERMENT);
    eval 'sub X509v3_KU_DATA_ENCIPHERMENT () {0x10;}' unless defined(&X509v3_KU_DATA_ENCIPHERMENT);
    eval 'sub X509v3_KU_KEY_AGREEMENT () {0x8;}' unless defined(&X509v3_KU_KEY_AGREEMENT);
    eval 'sub X509v3_KU_KEY_CERT_SIGN () {0x4;}' unless defined(&X509v3_KU_KEY_CERT_SIGN);
    eval 'sub X509v3_KU_CRL_SIGN () {0x2;}' unless defined(&X509v3_KU_CRL_SIGN);
    eval 'sub X509v3_KU_ENCIPHER_ONLY () {0x1;}' unless defined(&X509v3_KU_ENCIPHER_ONLY);
    eval 'sub X509v3_KU_DECIPHER_ONLY () {0x8000;}' unless defined(&X509v3_KU_DECIPHER_ONLY);
    eval 'sub X509v3_KU_UNDEF () {0xffff;}' unless defined(&X509v3_KU_UNDEF);
    unless(defined(&OPENSSL_NO_BUFFER)) {
    } else {
    }
    eval 'sub X509_EX_V_NETSCAPE_HACK () {0x8000;}' unless defined(&X509_EX_V_NETSCAPE_HACK);
    eval 'sub X509_EX_V_INIT () {0x1;}' unless defined(&X509_EX_V_INIT);
    unless(defined(&OPENSSL_NO_RFC3779)) {
    }
    unless(defined(&OPENSSL_NO_SHA)) {
    }
    eval 'sub X509_TRUST_DEFAULT () {-1;}' unless defined(&X509_TRUST_DEFAULT);
    eval 'sub X509_TRUST_COMPAT () {1;}' unless defined(&X509_TRUST_COMPAT);
    eval 'sub X509_TRUST_SSL_CLIENT () {2;}' unless defined(&X509_TRUST_SSL_CLIENT);
    eval 'sub X509_TRUST_SSL_SERVER () {3;}' unless defined(&X509_TRUST_SSL_SERVER);
    eval 'sub X509_TRUST_EMAIL () {4;}' unless defined(&X509_TRUST_EMAIL);
    eval 'sub X509_TRUST_OBJECT_SIGN () {5;}' unless defined(&X509_TRUST_OBJECT_SIGN);
    eval 'sub X509_TRUST_OCSP_SIGN () {6;}' unless defined(&X509_TRUST_OCSP_SIGN);
    eval 'sub X509_TRUST_OCSP_REQUEST () {7;}' unless defined(&X509_TRUST_OCSP_REQUEST);
    eval 'sub X509_TRUST_TSA () {8;}' unless defined(&X509_TRUST_TSA);
    eval 'sub X509_TRUST_MIN () {1;}' unless defined(&X509_TRUST_MIN);
    eval 'sub X509_TRUST_MAX () {8;}' unless defined(&X509_TRUST_MAX);
    eval 'sub X509_TRUST_DYNAMIC () {1;}' unless defined(&X509_TRUST_DYNAMIC);
    eval 'sub X509_TRUST_DYNAMIC_NAME () {2;}' unless defined(&X509_TRUST_DYNAMIC_NAME);
    eval 'sub X509_TRUST_TRUSTED () {1;}' unless defined(&X509_TRUST_TRUSTED);
    eval 'sub X509_TRUST_REJECTED () {2;}' unless defined(&X509_TRUST_REJECTED);
    eval 'sub X509_TRUST_UNTRUSTED () {3;}' unless defined(&X509_TRUST_UNTRUSTED);
    eval 'sub X509_FLAG_COMPAT () {0;}' unless defined(&X509_FLAG_COMPAT);
    eval 'sub X509_FLAG_NO_HEADER () {1;}' unless defined(&X509_FLAG_NO_HEADER);
    eval 'sub X509_FLAG_NO_VERSION () {(1 << 1);}' unless defined(&X509_FLAG_NO_VERSION);
    eval 'sub X509_FLAG_NO_SERIAL () {(1 << 2);}' unless defined(&X509_FLAG_NO_SERIAL);
    eval 'sub X509_FLAG_NO_SIGNAME () {(1 << 3);}' unless defined(&X509_FLAG_NO_SIGNAME);
    eval 'sub X509_FLAG_NO_ISSUER () {(1 << 4);}' unless defined(&X509_FLAG_NO_ISSUER);
    eval 'sub X509_FLAG_NO_VALIDITY () {(1 << 5);}' unless defined(&X509_FLAG_NO_VALIDITY);
    eval 'sub X509_FLAG_NO_SUBJECT () {(1 << 6);}' unless defined(&X509_FLAG_NO_SUBJECT);
    eval 'sub X509_FLAG_NO_PUBKEY () {(1 << 7);}' unless defined(&X509_FLAG_NO_PUBKEY);
    eval 'sub X509_FLAG_NO_EXTENSIONS () {(1 << 8);}' unless defined(&X509_FLAG_NO_EXTENSIONS);
    eval 'sub X509_FLAG_NO_SIGDUMP () {(1 << 9);}' unless defined(&X509_FLAG_NO_SIGDUMP);
    eval 'sub X509_FLAG_NO_AUX () {(1 << 10);}' unless defined(&X509_FLAG_NO_AUX);
    eval 'sub X509_FLAG_NO_ATTRIBUTES () {(1 << 11);}' unless defined(&X509_FLAG_NO_ATTRIBUTES);
    eval 'sub XN_FLAG_SEP_MASK () {(0xf << 16);}' unless defined(&XN_FLAG_SEP_MASK);
    eval 'sub XN_FLAG_COMPAT () {0;}' unless defined(&XN_FLAG_COMPAT);
    eval 'sub XN_FLAG_SEP_COMMA_PLUS () {(1<< 16);}' unless defined(&XN_FLAG_SEP_COMMA_PLUS);
    eval 'sub XN_FLAG_SEP_CPLUS_SPC () {(2<< 16);}' unless defined(&XN_FLAG_SEP_CPLUS_SPC);
    eval 'sub XN_FLAG_SEP_SPLUS_SPC () {(3<< 16);}' unless defined(&XN_FLAG_SEP_SPLUS_SPC);
    eval 'sub XN_FLAG_SEP_MULTILINE () {(4<< 16);}' unless defined(&XN_FLAG_SEP_MULTILINE);
    eval 'sub XN_FLAG_DN_REV () {(1<< 20);}' unless defined(&XN_FLAG_DN_REV);
    eval 'sub XN_FLAG_FN_MASK () {(0x3 << 21);}' unless defined(&XN_FLAG_FN_MASK);
    eval 'sub XN_FLAG_FN_SN () {0;}' unless defined(&XN_FLAG_FN_SN);
    eval 'sub XN_FLAG_FN_LN () {(1<< 21);}' unless defined(&XN_FLAG_FN_LN);
    eval 'sub XN_FLAG_FN_OID () {(2<< 21);}' unless defined(&XN_FLAG_FN_OID);
    eval 'sub XN_FLAG_FN_NONE () {(3<< 21);}' unless defined(&XN_FLAG_FN_NONE);
    eval 'sub XN_FLAG_SPC_EQ () {(1<< 23);}' unless defined(&XN_FLAG_SPC_EQ);
    eval 'sub XN_FLAG_DUMP_UNKNOWN_FIELDS () {(1<< 24);}' unless defined(&XN_FLAG_DUMP_UNKNOWN_FIELDS);
    eval 'sub XN_FLAG_FN_ALIGN () {(1<< 25);}' unless defined(&XN_FLAG_FN_ALIGN);
    eval 'sub XN_FLAG_RFC2253 () {( &ASN1_STRFLGS_RFC2253 |  &XN_FLAG_SEP_COMMA_PLUS |  &XN_FLAG_DN_REV |  &XN_FLAG_FN_SN |  &XN_FLAG_DUMP_UNKNOWN_FIELDS);}' unless defined(&XN_FLAG_RFC2253);
    eval 'sub XN_FLAG_ONELINE () {( &ASN1_STRFLGS_RFC2253 |  &ASN1_STRFLGS_ESC_QUOTE |  &XN_FLAG_SEP_CPLUS_SPC |  &XN_FLAG_SPC_EQ |  &XN_FLAG_FN_SN);}' unless defined(&XN_FLAG_ONELINE);
    eval 'sub XN_FLAG_MULTILINE () {( &ASN1_STRFLGS_ESC_CTRL |  &ASN1_STRFLGS_ESC_MSB |  &XN_FLAG_SEP_MULTILINE |  &XN_FLAG_SPC_EQ |  &XN_FLAG_FN_LN |  &XN_FLAG_FN_ALIGN);}' unless defined(&XN_FLAG_MULTILINE);
    unless(defined(&OPENSSL_NO_SHA)) {
    }
    unless(defined(&OPENSSL_NO_EVP)) {
    }
    eval 'sub PKCS8_OK () {0;}' unless defined(&PKCS8_OK);
    eval 'sub PKCS8_NO_OCTET () {1;}' unless defined(&PKCS8_NO_OCTET);
    eval 'sub PKCS8_EMBEDDED_PARAM () {2;}' unless defined(&PKCS8_EMBEDDED_PARAM);
    eval 'sub PKCS8_NS_DB () {3;}' unless defined(&PKCS8_NS_DB);
    eval 'sub PKCS8_NEG_PRIVKEY () {4;}' unless defined(&PKCS8_NEG_PRIVKEY);
    if(defined(&__cplusplus)) {
    }
    require 'openssl/x509_vfy.ph';
    require 'openssl/pkcs7.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub X509_EXT_PACK_UNKNOWN () {1;}' unless defined(&X509_EXT_PACK_UNKNOWN);
    eval 'sub X509_EXT_PACK_STRING () {2;}' unless defined(&X509_EXT_PACK_STRING);
    eval 'sub X509_get_version {
        my($x) = @_;
	    eval q( &ASN1_INTEGER_get(($x)-> ($cert_info->{version})));
    }' unless defined(&X509_get_version);
    eval 'sub X509_get_notBefore {
        my($x) = @_;
	    eval q((($x)-> ($cert_info->{validity}->{notBefore})));
    }' unless defined(&X509_get_notBefore);
    eval 'sub X509_get_notAfter {
        my($x) = @_;
	    eval q((($x)-> ($cert_info->{validity}->{notAfter})));
    }' unless defined(&X509_get_notAfter);
    eval 'sub X509_extract_key {
        my($x) = @_;
	    eval q( &X509_get_pubkey($x));
    }' unless defined(&X509_extract_key);
    eval 'sub X509_REQ_get_version {
        my($x) = @_;
	    eval q( &ASN1_INTEGER_get(($x)-> ($req_info->{version})));
    }' unless defined(&X509_REQ_get_version);
    eval 'sub X509_REQ_get_subject_name {
        my($x) = @_;
	    eval q((($x)-> ($req_info->{subject})));
    }' unless defined(&X509_REQ_get_subject_name);
    eval 'sub X509_REQ_extract_key {
        my($a) = @_;
	    eval q( &X509_REQ_get_pubkey($a));
    }' unless defined(&X509_REQ_extract_key);
    eval 'sub X509_name_cmp {
        my($a,$b) = @_;
	    eval q( &X509_NAME_cmp(($a),($b)));
    }' unless defined(&X509_name_cmp);
    eval 'sub X509_get_signature_type {
        my($x) = @_;
	    eval q( &EVP_PKEY_type( &OBJ_obj2nid(($x)-> ($sig_alg->{algorithm}))));
    }' unless defined(&X509_get_signature_type);
    eval 'sub X509_CRL_get_version {
        my($x) = @_;
	    eval q( &ASN1_INTEGER_get(($x)-> ($crl->{version})));
    }' unless defined(&X509_CRL_get_version);
    eval 'sub X509_CRL_get_lastUpdate {
        my($x) = @_;
	    eval q((($x)-> ($crl->{lastUpdate})));
    }' unless defined(&X509_CRL_get_lastUpdate);
    eval 'sub X509_CRL_get_nextUpdate {
        my($x) = @_;
	    eval q((($x)-> ($crl->{nextUpdate})));
    }' unless defined(&X509_CRL_get_nextUpdate);
    eval 'sub X509_CRL_get_issuer {
        my($x) = @_;
	    eval q((($x)-> ($crl->{issuer})));
    }' unless defined(&X509_CRL_get_issuer);
    eval 'sub X509_CRL_get_REVOKED {
        my($x) = @_;
	    eval q((($x)-> ($crl->{revoked})));
    }' unless defined(&X509_CRL_get_REVOKED);
    eval 'sub X509_get_X509_PUBKEY {
        my($x) = @_;
	    eval q((($x)-> ($cert_info->{key})));
    }' unless defined(&X509_get_X509_PUBKEY);
    unless(defined(&OPENSSL_NO_EVP)) {
    }
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
	unless(defined(&OPENSSL_NO_RSA)) {
	}
	unless(defined(&OPENSSL_NO_DSA)) {
	}
	unless(defined(&OPENSSL_NO_EC)) {
	}
    }
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    unless(defined(&OPENSSL_NO_EVP)) {
    }
    unless(defined(&OPENSSL_NO_MD5)) {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    eval 'sub X509_F_ADD_CERT_DIR () {100;}' unless defined(&X509_F_ADD_CERT_DIR);
    eval 'sub X509_F_BY_FILE_CTRL () {101;}' unless defined(&X509_F_BY_FILE_CTRL);
    eval 'sub X509_F_CHECK_POLICY () {145;}' unless defined(&X509_F_CHECK_POLICY);
    eval 'sub X509_F_DIR_CTRL () {102;}' unless defined(&X509_F_DIR_CTRL);
    eval 'sub X509_F_GET_CERT_BY_SUBJECT () {103;}' unless defined(&X509_F_GET_CERT_BY_SUBJECT);
    eval 'sub X509_F_NETSCAPE_SPKI_B64_DECODE () {129;}' unless defined(&X509_F_NETSCAPE_SPKI_B64_DECODE);
    eval 'sub X509_F_NETSCAPE_SPKI_B64_ENCODE () {130;}' unless defined(&X509_F_NETSCAPE_SPKI_B64_ENCODE);
    eval 'sub X509_F_X509AT_ADD1_ATTR () {135;}' unless defined(&X509_F_X509AT_ADD1_ATTR);
    eval 'sub X509_F_X509V3_ADD_EXT () {104;}' unless defined(&X509_F_X509V3_ADD_EXT);
    eval 'sub X509_F_X509_ATTRIBUTE_CREATE_BY_NID () {136;}' unless defined(&X509_F_X509_ATTRIBUTE_CREATE_BY_NID);
    eval 'sub X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ () {137;}' unless defined(&X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ);
    eval 'sub X509_F_X509_ATTRIBUTE_CREATE_BY_TXT () {140;}' unless defined(&X509_F_X509_ATTRIBUTE_CREATE_BY_TXT);
    eval 'sub X509_F_X509_ATTRIBUTE_GET0_DATA () {139;}' unless defined(&X509_F_X509_ATTRIBUTE_GET0_DATA);
    eval 'sub X509_F_X509_ATTRIBUTE_SET1_DATA () {138;}' unless defined(&X509_F_X509_ATTRIBUTE_SET1_DATA);
    eval 'sub X509_F_X509_CHECK_PRIVATE_KEY () {128;}' unless defined(&X509_F_X509_CHECK_PRIVATE_KEY);
    eval 'sub X509_F_X509_CRL_PRINT_FP () {147;}' unless defined(&X509_F_X509_CRL_PRINT_FP);
    eval 'sub X509_F_X509_EXTENSION_CREATE_BY_NID () {108;}' unless defined(&X509_F_X509_EXTENSION_CREATE_BY_NID);
    eval 'sub X509_F_X509_EXTENSION_CREATE_BY_OBJ () {109;}' unless defined(&X509_F_X509_EXTENSION_CREATE_BY_OBJ);
    eval 'sub X509_F_X509_GET_PUBKEY_PARAMETERS () {110;}' unless defined(&X509_F_X509_GET_PUBKEY_PARAMETERS);
    eval 'sub X509_F_X509_LOAD_CERT_CRL_FILE () {132;}' unless defined(&X509_F_X509_LOAD_CERT_CRL_FILE);
    eval 'sub X509_F_X509_LOAD_CERT_FILE () {111;}' unless defined(&X509_F_X509_LOAD_CERT_FILE);
    eval 'sub X509_F_X509_LOAD_CRL_FILE () {112;}' unless defined(&X509_F_X509_LOAD_CRL_FILE);
    eval 'sub X509_F_X509_NAME_ADD_ENTRY () {113;}' unless defined(&X509_F_X509_NAME_ADD_ENTRY);
    eval 'sub X509_F_X509_NAME_ENTRY_CREATE_BY_NID () {114;}' unless defined(&X509_F_X509_NAME_ENTRY_CREATE_BY_NID);
    eval 'sub X509_F_X509_NAME_ENTRY_CREATE_BY_TXT () {131;}' unless defined(&X509_F_X509_NAME_ENTRY_CREATE_BY_TXT);
    eval 'sub X509_F_X509_NAME_ENTRY_SET_OBJECT () {115;}' unless defined(&X509_F_X509_NAME_ENTRY_SET_OBJECT);
    eval 'sub X509_F_X509_NAME_ONELINE () {116;}' unless defined(&X509_F_X509_NAME_ONELINE);
    eval 'sub X509_F_X509_NAME_PRINT () {117;}' unless defined(&X509_F_X509_NAME_PRINT);
    eval 'sub X509_F_X509_PRINT_EX_FP () {118;}' unless defined(&X509_F_X509_PRINT_EX_FP);
    eval 'sub X509_F_X509_PUBKEY_GET () {119;}' unless defined(&X509_F_X509_PUBKEY_GET);
    eval 'sub X509_F_X509_PUBKEY_SET () {120;}' unless defined(&X509_F_X509_PUBKEY_SET);
    eval 'sub X509_F_X509_REQ_CHECK_PRIVATE_KEY () {144;}' unless defined(&X509_F_X509_REQ_CHECK_PRIVATE_KEY);
    eval 'sub X509_F_X509_REQ_PRINT_EX () {121;}' unless defined(&X509_F_X509_REQ_PRINT_EX);
    eval 'sub X509_F_X509_REQ_PRINT_FP () {122;}' unless defined(&X509_F_X509_REQ_PRINT_FP);
    eval 'sub X509_F_X509_REQ_TO_X509 () {123;}' unless defined(&X509_F_X509_REQ_TO_X509);
    eval 'sub X509_F_X509_STORE_ADD_CERT () {124;}' unless defined(&X509_F_X509_STORE_ADD_CERT);
    eval 'sub X509_F_X509_STORE_ADD_CRL () {125;}' unless defined(&X509_F_X509_STORE_ADD_CRL);
    eval 'sub X509_F_X509_STORE_CTX_GET1_ISSUER () {146;}' unless defined(&X509_F_X509_STORE_CTX_GET1_ISSUER);
    eval 'sub X509_F_X509_STORE_CTX_INIT () {143;}' unless defined(&X509_F_X509_STORE_CTX_INIT);
    eval 'sub X509_F_X509_STORE_CTX_NEW () {142;}' unless defined(&X509_F_X509_STORE_CTX_NEW);
    eval 'sub X509_F_X509_STORE_CTX_PURPOSE_INHERIT () {134;}' unless defined(&X509_F_X509_STORE_CTX_PURPOSE_INHERIT);
    eval 'sub X509_F_X509_TO_X509_REQ () {126;}' unless defined(&X509_F_X509_TO_X509_REQ);
    eval 'sub X509_F_X509_TRUST_ADD () {133;}' unless defined(&X509_F_X509_TRUST_ADD);
    eval 'sub X509_F_X509_TRUST_SET () {141;}' unless defined(&X509_F_X509_TRUST_SET);
    eval 'sub X509_F_X509_VERIFY_CERT () {127;}' unless defined(&X509_F_X509_VERIFY_CERT);
    eval 'sub X509_R_BAD_X509_FILETYPE () {100;}' unless defined(&X509_R_BAD_X509_FILETYPE);
    eval 'sub X509_R_BASE64_DECODE_ERROR () {118;}' unless defined(&X509_R_BASE64_DECODE_ERROR);
    eval 'sub X509_R_CANT_CHECK_DH_KEY () {114;}' unless defined(&X509_R_CANT_CHECK_DH_KEY);
    eval 'sub X509_R_CERT_ALREADY_IN_HASH_TABLE () {101;}' unless defined(&X509_R_CERT_ALREADY_IN_HASH_TABLE);
    eval 'sub X509_R_ERR_ASN1_LIB () {102;}' unless defined(&X509_R_ERR_ASN1_LIB);
    eval 'sub X509_R_INVALID_DIRECTORY () {113;}' unless defined(&X509_R_INVALID_DIRECTORY);
    eval 'sub X509_R_INVALID_FIELD_NAME () {119;}' unless defined(&X509_R_INVALID_FIELD_NAME);
    eval 'sub X509_R_INVALID_TRUST () {123;}' unless defined(&X509_R_INVALID_TRUST);
    eval 'sub X509_R_KEY_TYPE_MISMATCH () {115;}' unless defined(&X509_R_KEY_TYPE_MISMATCH);
    eval 'sub X509_R_KEY_VALUES_MISMATCH () {116;}' unless defined(&X509_R_KEY_VALUES_MISMATCH);
    eval 'sub X509_R_LOADING_CERT_DIR () {103;}' unless defined(&X509_R_LOADING_CERT_DIR);
    eval 'sub X509_R_LOADING_DEFAULTS () {104;}' unless defined(&X509_R_LOADING_DEFAULTS);
    eval 'sub X509_R_METHOD_NOT_SUPPORTED () {124;}' unless defined(&X509_R_METHOD_NOT_SUPPORTED);
    eval 'sub X509_R_NO_CERT_SET_FOR_US_TO_VERIFY () {105;}' unless defined(&X509_R_NO_CERT_SET_FOR_US_TO_VERIFY);
    eval 'sub X509_R_PUBLIC_KEY_DECODE_ERROR () {125;}' unless defined(&X509_R_PUBLIC_KEY_DECODE_ERROR);
    eval 'sub X509_R_PUBLIC_KEY_ENCODE_ERROR () {126;}' unless defined(&X509_R_PUBLIC_KEY_ENCODE_ERROR);
    eval 'sub X509_R_SHOULD_RETRY () {106;}' unless defined(&X509_R_SHOULD_RETRY);
    eval 'sub X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN () {107;}' unless defined(&X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN);
    eval 'sub X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY () {108;}' unless defined(&X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY);
    eval 'sub X509_R_UNKNOWN_KEY_TYPE () {117;}' unless defined(&X509_R_UNKNOWN_KEY_TYPE);
    eval 'sub X509_R_UNKNOWN_NID () {109;}' unless defined(&X509_R_UNKNOWN_NID);
    eval 'sub X509_R_UNKNOWN_PURPOSE_ID () {121;}' unless defined(&X509_R_UNKNOWN_PURPOSE_ID);
    eval 'sub X509_R_UNKNOWN_TRUST_ID () {120;}' unless defined(&X509_R_UNKNOWN_TRUST_ID);
    eval 'sub X509_R_UNSUPPORTED_ALGORITHM () {111;}' unless defined(&X509_R_UNSUPPORTED_ALGORITHM);
    eval 'sub X509_R_WRONG_LOOKUP_TYPE () {112;}' unless defined(&X509_R_WRONG_LOOKUP_TYPE);
    eval 'sub X509_R_WRONG_TYPE () {122;}' unless defined(&X509_R_WRONG_TYPE);
    if(defined(&__cplusplus)) {
    }
}
1;
