require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__KAME_NETINET_IN_H_INCLUDED_)) {
    die("do not include netinet6/in6.h directly, include netinet/in.h.  see RFC2553");
}
unless(defined(&_NETINET6_IN6_H_)) {
    eval 'sub _NETINET6_IN6_H_ () {1;}' unless defined(&_NETINET6_IN6_H_);
    eval 'sub __KAME__ () {1;}' unless defined(&__KAME__);
    eval 'sub s6_addr () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr);
    if(defined(&_KERNEL)) {
	eval 'sub s6_addr8 () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr8);
	eval 'sub s6_addr16 () { ($__u6_addr->{__u6_addr16});}' unless defined(&s6_addr16);
	eval 'sub s6_addr32 () { ($__u6_addr->{__u6_addr32});}' unless defined(&s6_addr32);
    }
    unless(defined(&INET6_ADDRSTRLEN)) {
	eval 'sub INET6_ADDRSTRLEN () {46;}' unless defined(&INET6_ADDRSTRLEN);
    }
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub SIN6_LEN () {1;}' unless defined(&SIN6_LEN);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6MASK0 () {{{{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}};}' unless defined(&IN6MASK0);
	eval 'sub IN6MASK32 () {{{{ 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK32);
	eval 'sub IN6MASK64 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK64);
	eval 'sub IN6MASK96 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK96);
	eval 'sub IN6MASK128 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff }}};}' unless defined(&IN6MASK128);
    }
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub IN6ADDR_ANY_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6ADDR_ANY_INIT);
	eval 'sub IN6ADDR_LOOPBACK_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LOOPBACK_INIT);
	eval 'sub IN6ADDR_NODELOCAL_ALLNODES_INIT () {{{{ 0xff, 0x1, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_NODELOCAL_ALLNODES_INIT);
	eval 'sub IN6ADDR_INTFACELOCAL_ALLNODES_INIT () {{{{ 0xff, 0x1, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_INTFACELOCAL_ALLNODES_INIT);
	eval 'sub IN6ADDR_LINKLOCAL_ALLNODES_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLNODES_INIT);
	eval 'sub IN6ADDR_LINKLOCAL_ALLROUTERS_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x2 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLROUTERS_INIT);
	eval 'sub IN6_ARE_ADDR_EQUAL {
	    my($a, $b) = @_;
    	    eval q(( &memcmp(($a)-> $s6_addr[0], ($b)-> $s6_addr[0], $sizeof{\'struct in6_addr\'}) == 0));
	}' unless defined(&IN6_ARE_ADDR_EQUAL);
    }
    eval 'sub __IPV6_ADDR_INT32_ONE () { &htonl(1);}' unless defined(&__IPV6_ADDR_INT32_ONE);
    eval 'sub __IPV6_ADDR_INT32_TWO () { &htonl(2);}' unless defined(&__IPV6_ADDR_INT32_TWO);
    eval 'sub __IPV6_ADDR_INT32_MNL () { &htonl(0xff010000);}' unless defined(&__IPV6_ADDR_INT32_MNL);
    eval 'sub __IPV6_ADDR_INT32_MLL () { &htonl(0xff020000);}' unless defined(&__IPV6_ADDR_INT32_MLL);
    eval 'sub __IPV6_ADDR_INT32_SMP () { &htonl(0xffff);}' unless defined(&__IPV6_ADDR_INT32_SMP);
    eval 'sub __IPV6_ADDR_INT16_ULL () { &htons(0xfe80);}' unless defined(&__IPV6_ADDR_INT16_ULL);
    eval 'sub __IPV6_ADDR_INT16_USL () { &htons(0xfec0);}' unless defined(&__IPV6_ADDR_INT16_USL);
    eval 'sub __IPV6_ADDR_INT16_MLL () { &htons(0xff02);}' unless defined(&__IPV6_ADDR_INT16_MLL);
    eval 'sub IN6_IS_ADDR_UNSPECIFIED {
        my($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) == 0)));
    }' unless defined(&IN6_IS_ADDR_UNSPECIFIED);
    eval 'sub IN6_IS_ADDR_LOOPBACK {
        my($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) ==  &__IPV6_ADDR_INT32_ONE)));
    }' unless defined(&IN6_IS_ADDR_LOOPBACK);
    eval 'sub IN6_IS_ADDR_V4COMPAT {
        my($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) != 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) !=  &__IPV6_ADDR_INT32_ONE)));
    }' unless defined(&IN6_IS_ADDR_V4COMPAT);
    eval 'sub IN6_IS_ADDR_V4MAPPED {
        my($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) ==  &__IPV6_ADDR_INT32_SMP)));
    }' unless defined(&IN6_IS_ADDR_V4MAPPED);
    eval 'sub IN6_IS_ADDR_LINKLOCAL {
        my($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0x80)));
    }' unless defined(&IN6_IS_ADDR_LINKLOCAL);
    eval 'sub IN6_IS_ADDR_SITELOCAL {
        my($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0xc0)));
    }' unless defined(&IN6_IS_ADDR_SITELOCAL);
    eval 'sub __IPV6_ADDR_MC_SCOPE {
        my($a) = @_;
	    eval q((($a)-> $s6_addr[1] & 0xf));
    }' unless defined(&__IPV6_ADDR_MC_SCOPE);
    eval 'sub IN6_IS_ADDR_MULTICAST {
        my($a) = @_;
	    eval q((($a)-> $s6_addr[0] == 0xff));
    }' unless defined(&IN6_IS_ADDR_MULTICAST);
    eval 'sub __IPV6_ADDR_SCOPE_NODELOCAL () {0x1;}' unless defined(&__IPV6_ADDR_SCOPE_NODELOCAL);
    eval 'sub __IPV6_ADDR_SCOPE_INTFACELOCAL () {0x1;}' unless defined(&__IPV6_ADDR_SCOPE_INTFACELOCAL);
    eval 'sub __IPV6_ADDR_SCOPE_LINKLOCAL () {0x2;}' unless defined(&__IPV6_ADDR_SCOPE_LINKLOCAL);
    eval 'sub __IPV6_ADDR_SCOPE_SITELOCAL () {0x5;}' unless defined(&__IPV6_ADDR_SCOPE_SITELOCAL);
    eval 'sub __IPV6_ADDR_SCOPE_ORGLOCAL () {0x8;}' unless defined(&__IPV6_ADDR_SCOPE_ORGLOCAL);
    eval 'sub __IPV6_ADDR_SCOPE_GLOBAL () {0xe;}' unless defined(&__IPV6_ADDR_SCOPE_GLOBAL);
    eval 'sub IN6_IS_ADDR_MC_NODELOCAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_NODELOCAL)));
    }' unless defined(&IN6_IS_ADDR_MC_NODELOCAL);
    eval 'sub IN6_IS_ADDR_MC_INTFACELOCAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_INTFACELOCAL)));
    }' unless defined(&IN6_IS_ADDR_MC_INTFACELOCAL);
    eval 'sub IN6_IS_ADDR_MC_LINKLOCAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_LINKLOCAL)));
    }' unless defined(&IN6_IS_ADDR_MC_LINKLOCAL);
    eval 'sub IN6_IS_ADDR_MC_SITELOCAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_SITELOCAL)));
    }' unless defined(&IN6_IS_ADDR_MC_SITELOCAL);
    eval 'sub IN6_IS_ADDR_MC_ORGLOCAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_ORGLOCAL)));
    }' unless defined(&IN6_IS_ADDR_MC_ORGLOCAL);
    eval 'sub IN6_IS_ADDR_MC_GLOBAL {
        my($a) = @_;
	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_GLOBAL)));
    }' unless defined(&IN6_IS_ADDR_MC_GLOBAL);
    if(defined(&_KERNEL)) {
	eval 'sub IN6_IS_SCOPE_LINKLOCAL {
	    my($a) = @_;
    	    eval q((( &IN6_IS_ADDR_LINKLOCAL($a)) || ( &IN6_IS_ADDR_MC_LINKLOCAL($a))));
	}' unless defined(&IN6_IS_SCOPE_LINKLOCAL);
	eval 'sub IN6_IS_SCOPE_EMBED {
	    my($a) = @_;
    	    eval q((( &IN6_IS_ADDR_LINKLOCAL($a)) || ( &IN6_IS_ADDR_MC_LINKLOCAL($a)) || ( &IN6_IS_ADDR_MC_INTFACELOCAL($a))));
	}' unless defined(&IN6_IS_SCOPE_EMBED);
	eval 'sub IFA6_IS_DEPRECATED {
	    my($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_pltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_second - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_pltime})));
	}' unless defined(&IFA6_IS_DEPRECATED);
	eval 'sub IFA6_IS_INVALID {
	    my($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_vltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_second - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_vltime})));
	}' unless defined(&IFA6_IS_INVALID);
    }
    eval 'sub IPV6_UNICAST_HOPS () {4;}' unless defined(&IPV6_UNICAST_HOPS);
    eval 'sub IPV6_MULTICAST_IF () {9;}' unless defined(&IPV6_MULTICAST_IF);
    eval 'sub IPV6_MULTICAST_HOPS () {10;}' unless defined(&IPV6_MULTICAST_HOPS);
    eval 'sub IPV6_MULTICAST_LOOP () {11;}' unless defined(&IPV6_MULTICAST_LOOP);
    eval 'sub IPV6_JOIN_GROUP () {12;}' unless defined(&IPV6_JOIN_GROUP);
    eval 'sub IPV6_LEAVE_GROUP () {13;}' unless defined(&IPV6_LEAVE_GROUP);
    eval 'sub IPV6_PORTRANGE () {14;}' unless defined(&IPV6_PORTRANGE);
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub ICMP6_FILTER () {18;}' unless defined(&ICMP6_FILTER);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_2292PKTINFO () {19;}' unless defined(&IPV6_2292PKTINFO);
	eval 'sub IPV6_2292HOPLIMIT () {20;}' unless defined(&IPV6_2292HOPLIMIT);
	eval 'sub IPV6_2292NEXTHOP () {21;}' unless defined(&IPV6_2292NEXTHOP);
	eval 'sub IPV6_2292HOPOPTS () {22;}' unless defined(&IPV6_2292HOPOPTS);
	eval 'sub IPV6_2292DSTOPTS () {23;}' unless defined(&IPV6_2292DSTOPTS);
	eval 'sub IPV6_2292RTHDR () {24;}' unless defined(&IPV6_2292RTHDR);
	eval 'sub IPV6_2292PKTOPTIONS () {25;}' unless defined(&IPV6_2292PKTOPTIONS);
    }
    eval 'sub IPV6_CHECKSUM () {26;}' unless defined(&IPV6_CHECKSUM);
    eval 'sub IPV6_V6ONLY () {27;}' unless defined(&IPV6_V6ONLY);
    eval 'sub IPV6_RTHDRDSTOPTS () {35;}' unless defined(&IPV6_RTHDRDSTOPTS);
    eval 'sub IPV6_RECVPKTINFO () {36;}' unless defined(&IPV6_RECVPKTINFO);
    eval 'sub IPV6_RECVHOPLIMIT () {37;}' unless defined(&IPV6_RECVHOPLIMIT);
    eval 'sub IPV6_RECVRTHDR () {38;}' unless defined(&IPV6_RECVRTHDR);
    eval 'sub IPV6_RECVHOPOPTS () {39;}' unless defined(&IPV6_RECVHOPOPTS);
    eval 'sub IPV6_RECVDSTOPTS () {40;}' unless defined(&IPV6_RECVDSTOPTS);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_RECVRTHDRDSTOPTS () {41;}' unless defined(&IPV6_RECVRTHDRDSTOPTS);
    }
    eval 'sub IPV6_USE_MIN_MTU () {42;}' unless defined(&IPV6_USE_MIN_MTU);
    eval 'sub IPV6_RECVPATHMTU () {43;}' unless defined(&IPV6_RECVPATHMTU);
    eval 'sub IPV6_PATHMTU () {44;}' unless defined(&IPV6_PATHMTU);
    eval 'sub IPV6_PKTINFO () {46;}' unless defined(&IPV6_PKTINFO);
    eval 'sub IPV6_HOPLIMIT () {47;}' unless defined(&IPV6_HOPLIMIT);
    eval 'sub IPV6_NEXTHOP () {48;}' unless defined(&IPV6_NEXTHOP);
    eval 'sub IPV6_HOPOPTS () {49;}' unless defined(&IPV6_HOPOPTS);
    eval 'sub IPV6_DSTOPTS () {50;}' unless defined(&IPV6_DSTOPTS);
    eval 'sub IPV6_RTHDR () {51;}' unless defined(&IPV6_RTHDR);
    eval 'sub IPV6_AUTH_LEVEL () {53;}' unless defined(&IPV6_AUTH_LEVEL);
    eval 'sub IPV6_ESP_TRANS_LEVEL () {54;}' unless defined(&IPV6_ESP_TRANS_LEVEL);
    eval 'sub IPV6_ESP_NETWORK_LEVEL () {55;}' unless defined(&IPV6_ESP_NETWORK_LEVEL);
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub IPSEC6_OUTSA () {56;}' unless defined(&IPSEC6_OUTSA);
    }
    eval 'sub IPV6_RECVTCLASS () {57;}' unless defined(&IPV6_RECVTCLASS);
    eval 'sub IPV6_AUTOFLOWLABEL () {59;}' unless defined(&IPV6_AUTOFLOWLABEL);
    eval 'sub IPV6_IPCOMP_LEVEL () {60;}' unless defined(&IPV6_IPCOMP_LEVEL);
    eval 'sub IPV6_TCLASS () {61;}' unless defined(&IPV6_TCLASS);
    eval 'sub IPV6_DONTFRAG () {62;}' unless defined(&IPV6_DONTFRAG);
    eval 'sub IPV6_PIPEX () {63;}' unless defined(&IPV6_PIPEX);
    eval 'sub IPV6_RECVDSTPORT () {64;}' unless defined(&IPV6_RECVDSTPORT);
    eval 'sub IPV6_RTABLE () {0x1021;}' unless defined(&IPV6_RTABLE);
    eval 'sub IPV6_RTHDR_LOOSE () {0;}' unless defined(&IPV6_RTHDR_LOOSE);
    eval 'sub IPV6_RTHDR_TYPE_0 () {0;}' unless defined(&IPV6_RTHDR_TYPE_0);
    eval 'sub IPV6_DEFAULT_MULTICAST_HOPS () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_HOPS);
    eval 'sub IPV6_DEFAULT_MULTICAST_LOOP () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_LOOP);
    eval 'sub IPV6_PORTRANGE_DEFAULT () {0;}' unless defined(&IPV6_PORTRANGE_DEFAULT);
    eval 'sub IPV6_PORTRANGE_HIGH () {1;}' unless defined(&IPV6_PORTRANGE_HIGH);
    eval 'sub IPV6_PORTRANGE_LOW () {2;}' unless defined(&IPV6_PORTRANGE_LOW);
    if(defined(&__BSD_VISIBLE)) {
	unless(defined(&_SOCKLEN_T_DEFINED_)) {
	    eval 'sub _SOCKLEN_T_DEFINED_ () {1;}' unless defined(&_SOCKLEN_T_DEFINED_);
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub sin6tosa {
	    my($sin6) = @_;
    	    eval q({ (($sin6)); });
	}' unless defined(&sin6tosa);
	eval 'sub ifatoia6 {
	    my($ifa) = @_;
    	    eval q({ (($ifa)); });
	}' unless defined(&ifatoia6);
    }
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub IPV6PROTO_MAXID () {( &IPPROTO_DIVERT + 1);}' unless defined(&IPV6PROTO_MAXID);
	eval 'sub CTL_IPV6PROTO_NAMES () {{ { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "tcp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "udp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "ip6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "ipsec6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "icmp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "pim6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "divert",  &CTLTYPE_NODE }, };}' unless defined(&CTL_IPV6PROTO_NAMES);
	eval 'sub IPV6CTL_FORWARDING () {1;}' unless defined(&IPV6CTL_FORWARDING);
	eval 'sub IPV6CTL_SENDREDIRECTS () {2;}' unless defined(&IPV6CTL_SENDREDIRECTS);
	eval 'sub IPV6CTL_DEFHLIM () {3;}' unless defined(&IPV6CTL_DEFHLIM);
	eval 'sub IPV6CTL_FORWSRCRT () {5;}' unless defined(&IPV6CTL_FORWSRCRT);
	eval 'sub IPV6CTL_STATS () {6;}' unless defined(&IPV6CTL_STATS);
	eval 'sub IPV6CTL_MRTSTATS () {7;}' unless defined(&IPV6CTL_MRTSTATS);
	eval 'sub IPV6CTL_MRTPROTO () {8;}' unless defined(&IPV6CTL_MRTPROTO);
	eval 'sub IPV6CTL_MAXFRAGPACKETS () {9;}' unless defined(&IPV6CTL_MAXFRAGPACKETS);
	eval 'sub IPV6CTL_SOURCECHECK () {10;}' unless defined(&IPV6CTL_SOURCECHECK);
	eval 'sub IPV6CTL_SOURCECHECK_LOGINT () {11;}' unless defined(&IPV6CTL_SOURCECHECK_LOGINT);
	eval 'sub IPV6CTL_ACCEPT_RTADV () {12;}' unless defined(&IPV6CTL_ACCEPT_RTADV);
	eval 'sub IPV6CTL_LOG_INTERVAL () {14;}' unless defined(&IPV6CTL_LOG_INTERVAL);
	eval 'sub IPV6CTL_HDRNESTLIMIT () {15;}' unless defined(&IPV6CTL_HDRNESTLIMIT);
	eval 'sub IPV6CTL_DAD_COUNT () {16;}' unless defined(&IPV6CTL_DAD_COUNT);
	eval 'sub IPV6CTL_AUTO_FLOWLABEL () {17;}' unless defined(&IPV6CTL_AUTO_FLOWLABEL);
	eval 'sub IPV6CTL_DEFMCASTHLIM () {18;}' unless defined(&IPV6CTL_DEFMCASTHLIM);
	eval 'sub IPV6CTL_USE_DEPRECATED () {21;}' unless defined(&IPV6CTL_USE_DEPRECATED);
	eval 'sub IPV6CTL_RR_PRUNE () {22;}' unless defined(&IPV6CTL_RR_PRUNE);
	eval 'sub IPV6CTL_V6ONLY () {24;}' unless defined(&IPV6CTL_V6ONLY);
	eval 'sub IPV6CTL_MAXFRAGS () {41;}' unless defined(&IPV6CTL_MAXFRAGS);
	eval 'sub IPV6CTL_MFORWARDING () {42;}' unless defined(&IPV6CTL_MFORWARDING);
	eval 'sub IPV6CTL_MULTIPATH () {43;}' unless defined(&IPV6CTL_MULTIPATH);
	eval 'sub IPV6CTL_MCAST_PMTU () {44;}' unless defined(&IPV6CTL_MCAST_PMTU);
	eval 'sub IPV6CTL_NEIGHBORGCTHRESH () {45;}' unless defined(&IPV6CTL_NEIGHBORGCTHRESH);
	eval 'sub IPV6CTL_MAXIFPREFIXES () {46;}' unless defined(&IPV6CTL_MAXIFPREFIXES);
	eval 'sub IPV6CTL_MAXIFDEFROUTERS () {47;}' unless defined(&IPV6CTL_MAXIFDEFROUTERS);
	eval 'sub IPV6CTL_MAXDYNROUTES () {48;}' unless defined(&IPV6CTL_MAXDYNROUTES);
	eval 'sub IPV6CTL_DAD_PENDING () {49;}' unless defined(&IPV6CTL_DAD_PENDING);
	eval 'sub IPV6CTL_MTUDISCTIMEOUT () {50;}' unless defined(&IPV6CTL_MTUDISCTIMEOUT);
	eval 'sub IPV6CTL_MAXID () {51;}' unless defined(&IPV6CTL_MAXID);
	eval 'sub IPV6CTL_NAMES () {{ { 0, 0}, { "forwarding",  &CTLTYPE_INT }, { "redirect",  &CTLTYPE_INT }, { "hlim",  &CTLTYPE_INT }, { 0, 0}, { "forwsrcrt",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { "mrtproto",  &CTLTYPE_INT }, { "maxfragpackets",  &CTLTYPE_INT }, { "sourcecheck",  &CTLTYPE_INT }, { "sourcecheck_logint",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { "log_interval",  &CTLTYPE_INT }, { "hdrnestlimit",  &CTLTYPE_INT }, { "dad_count",  &CTLTYPE_INT }, { "auto_flowlabel",  &CTLTYPE_INT }, { "defmcasthlim",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { "use_deprecated",  &CTLTYPE_INT }, { "rr_prune",  &CTLTYPE_INT }, { 0, 0}, { "v6only",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "maxfrags",  &CTLTYPE_INT }, { "mforwarding",  &CTLTYPE_INT }, { "multipath",  &CTLTYPE_INT }, { "multicast_mtudisc",  &CTLTYPE_INT }, { "neighborgcthresh",  &CTLTYPE_INT }, { "maxifprefixes",  &CTLTYPE_INT }, { "maxifdefrouters",  &CTLTYPE_INT }, { "maxdynroutes",  &CTLTYPE_INT }, { "dad_pending",  &CTLTYPE_INT }, { "mtudisctimeout",  &CTLTYPE_INT }, };}' unless defined(&IPV6CTL_NAMES);
	eval 'sub IPV6CTL_VARS () {{  &NULL,  &ip6_forwarding,  &ip6_sendredirects,  &ip6_defhlim,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &ip6_maxfragpackets,  &NULL,  &NULL,  &NULL,  &NULL,  &ip6_log_interval,  &ip6_hdrnestlimit,  &ip6_dad_count,  &ip6_auto_flowlabel,  &ip6_defmcasthlim,  &NULL,  &NULL,  &ip6_use_deprecated,  &ip6_rr_prune,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &ip6_maxfrags,  &ip6_mforwarding,  &ip6_multipath,  &ip6_mcast_pmtu,  &ip6_neighborgcthresh,  &ip6_maxifprefixes,  &ip6_maxifdefrouters,  &ip6_maxdynroutes,  &NULL,  &NULL, };}' unless defined(&IPV6CTL_VARS);
    }
}
1;
