require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M88K_ATOMIC_H_)) {
    eval 'sub _M88K_ATOMIC_H_ () {1;}' unless defined(&_M88K_ATOMIC_H_);
    if(defined(&_KERNEL)) {
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub atomic_add_int_nv () { &atomic_add_int_nv_mp;}' unless defined(&atomic_add_int_nv);
	    eval 'sub atomic_sub_int_nv () { &atomic_sub_int_nv_mp;}' unless defined(&atomic_sub_int_nv);
	    eval 'sub atomic_cas_uint () { &atomic_cas_uint_mp;}' unless defined(&atomic_cas_uint);
	    eval 'sub atomic_swap_uint () { &atomic_swap_uint_mp;}' unless defined(&atomic_swap_uint);
	} else {
	    require 'machine/asm_macro.ph';
	    require 'machine/psl.ph';
	    eval 'sub atomic_setbits_int {
	        my($uip,$v) = @_;
    		eval q({ \'u_int\'  &psr;  &psr =  &get_psr();  &set_psr( &psr |  &PSR_IND); *$uip |= $v;  &set_psr( &psr); });
	    }' unless defined(&atomic_setbits_int);
	    eval 'sub atomic_clearbits_int {
	        my($uip,$v) = @_;
    		eval q({ \'u_int\'  &psr;  &psr =  &get_psr();  &set_psr( &psr |  &PSR_IND); *$uip &= ~$v;  &set_psr( &psr); });
	    }' unless defined(&atomic_clearbits_int);
	    eval 'sub atomic_add_int_nv_sp {
	        my($uip,$v) = @_;
    		eval q({ \'u_int\'  &psr; my $nv;  &psr =  &get_psr();  &set_psr( &psr |  &PSR_IND); *$uip += $v;  $nv = *$uip;  &set_psr( &psr);  $nv; });
	    }' unless defined(&atomic_add_int_nv_sp);
	    eval 'sub atomic_sub_int_nv_sp {
	        my($uip,$v) = @_;
    		eval q({ \'u_int\'  &psr; my $nv;  &psr =  &get_psr();  &set_psr( &psr |  &PSR_IND); *$uip -= $v;  $nv = *$uip;  &set_psr( &psr);  $nv; });
	    }' unless defined(&atomic_sub_int_nv_sp);
	    eval 'sub atomic_add_int_nv () { &atomic_add_int_nv_sp;}' unless defined(&atomic_add_int_nv);
	    eval 'sub atomic_sub_int_nv () { &atomic_sub_int_nv_sp;}' unless defined(&atomic_sub_int_nv);
	    eval 'sub atomic_cas_uint () { &atomic_cas_uint_sp;}' unless defined(&atomic_cas_uint);
	    eval 'sub atomic_swap_uint () { &atomic_swap_uint_sp;}' unless defined(&atomic_swap_uint);
	}
	eval 'sub atomic_add_long_nv {
	    my($p,$v) = @_;
    	    eval q(( &atomic_add_int_nv($p, $v)));
	}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_sub_long_nv {
	    my($p,$v) = @_;
    	    eval q(( &atomic_sub_int_nv($p, $v)));
	}' unless defined(&atomic_sub_long_nv);
	eval 'sub atomic_cas_ulong {
	    my($p,$o,$n) = @_;
    	    eval q(( &atomic_cas_uint($p, $o, $n)));
	}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr {
	    my($p,$o,$n) = @_;
    	    eval q((( &void *) &atomic_cas_uint(( &void *)$p, ( &void *)$o, ( &void *)$n)));
	}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_swap_ulong {
	    my($p,$o) = @_;
    	    eval q(( &atomic_swap_uint($p, $o));
	}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_ptr {
	    my($p,$o) = @_;
    	    eval q((( &void *) &atomic_swap_uint(( &void *)$p, ( &void *)$o)));
	}' unless defined(&atomic_swap_ptr);
    }
}
1;
