require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_XHCIREG_H_)) {
    eval 'sub _XHCIREG_H_ () {1;}' unless defined(&_XHCIREG_H_);
    eval 'sub XHCI_COMMAND_TIMEOUT () {500;}' unless defined(&XHCI_COMMAND_TIMEOUT);
    eval 'sub PCI_CBMEM () {0x10;}' unless defined(&PCI_CBMEM);
    eval 'sub PCI_INTERFACE_XHCI () {0x30;}' unless defined(&PCI_INTERFACE_XHCI);
    eval 'sub PCI_USBREV () {0x60;}' unless defined(&PCI_USBREV);
    eval 'sub PCI_USBREV_MASK () {0xff;}' unless defined(&PCI_USBREV_MASK);
    eval 'sub PCI_USBREV_3_0 () {0x30;}' unless defined(&PCI_USBREV_3_0);
    eval 'sub PCI_XHCI_FLADJ () {0x61;}' unless defined(&PCI_XHCI_FLADJ);
    eval 'sub PCI_XHCI_INTEL_XUSB2PR () {0xd0;}' unless defined(&PCI_XHCI_INTEL_XUSB2PR);
    eval 'sub PCI_XHCI_INTEL_XUSB2PRM () {0xd4;}' unless defined(&PCI_XHCI_INTEL_XUSB2PRM);
    eval 'sub PCI_XHCI_INTEL_USB3_PSSEN () {0xd8;}' unless defined(&PCI_XHCI_INTEL_USB3_PSSEN);
    eval 'sub PCI_XHCI_INTEL_USB3PRM () {0xdc;}' unless defined(&PCI_XHCI_INTEL_USB3PRM);
    eval 'sub XHCI_CAPLENGTH () {0x;}' unless defined(&XHCI_CAPLENGTH);
    eval 'sub XHCI_RESERVED () {0x1;}' unless defined(&XHCI_RESERVED);
    eval 'sub XHCI_HCIVERSION () {0x2;}' unless defined(&XHCI_HCIVERSION);
    eval 'sub XHCI_HCIVERSION_0_9 () {0x90;}' unless defined(&XHCI_HCIVERSION_0_9);
    eval 'sub XHCI_HCIVERSION_1_0 () {0x100;}' unless defined(&XHCI_HCIVERSION_1_0);
    eval 'sub XHCI_HCSPARAMS1 () {0x4;}' unless defined(&XHCI_HCSPARAMS1);
    eval 'sub XHCI_HCS1_DEVSLOT_MAX {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&XHCI_HCS1_DEVSLOT_MAX);
    eval 'sub XHCI_HCS1_IRQ_MAX {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0x3ff));
    }' unless defined(&XHCI_HCS1_IRQ_MAX);
    eval 'sub XHCI_HCS1_N_PORTS {
        my($x) = @_;
	    eval q(((($x) >> 24) & 0xff));
    }' unless defined(&XHCI_HCS1_N_PORTS);
    eval 'sub XHCI_HCSPARAMS2 () {0x8;}' unless defined(&XHCI_HCSPARAMS2);
    eval 'sub XHCI_HCS2_IST {
        my($x) = @_;
	    eval q((($x) & 0xf));
    }' unless defined(&XHCI_HCS2_IST);
    eval 'sub XHCI_HCS2_ERST_MAX {
        my($x) = @_;
	    eval q(((($x) >> 4) & 0xf));
    }' unless defined(&XHCI_HCS2_ERST_MAX);
    eval 'sub XHCI_HCS2_SPR {
        my($x) = @_;
	    eval q(((($x) >> 24) & 0x1));
    }' unless defined(&XHCI_HCS2_SPR);
    eval 'sub XHCI_HCS2_SPB_MAX {
        my($x) = @_;
	    eval q(((($x) >> 27) & 0x7f));
    }' unless defined(&XHCI_HCS2_SPB_MAX);
    eval 'sub XHCI_HCSPARAMS3 () {0xc;}' unless defined(&XHCI_HCSPARAMS3);
    eval 'sub XHCI_HCS3_U1_DEL {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&XHCI_HCS3_U1_DEL);
    eval 'sub XHCI_HCS3_U2_DEL {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&XHCI_HCS3_U2_DEL);
    eval 'sub XHCI_HCCPARAMS () {0x10;}' unless defined(&XHCI_HCCPARAMS);
    eval 'sub XHCI_HCC_AC64 {
        my($x) = @_;
	    eval q(((($x) >> 0) & 0x1));
    }' unless defined(&XHCI_HCC_AC64);
    eval 'sub XHCI_HCC_BNC {
        my($x) = @_;
	    eval q(((($x) >> 1) & 0x1));
    }' unless defined(&XHCI_HCC_BNC);
    eval 'sub XHCI_HCC_CSZ {
        my($x) = @_;
	    eval q(((($x) >> 2) & 0x1));
    }' unless defined(&XHCI_HCC_CSZ);
    eval 'sub XHCI_HCC_PPC {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0x1));
    }' unless defined(&XHCI_HCC_PPC);
    eval 'sub XHCI_HCC_PIND {
        my($x) = @_;
	    eval q(((($x) >> 4) & 0x1));
    }' unless defined(&XHCI_HCC_PIND);
    eval 'sub XHCI_HCC_LHRC {
        my($x) = @_;
	    eval q(((($x) >> 5) & 0x1));
    }' unless defined(&XHCI_HCC_LHRC);
    eval 'sub XHCI_HCC_LTC {
        my($x) = @_;
	    eval q(((($x) >> 6) & 0x1));
    }' unless defined(&XHCI_HCC_LTC);
    eval 'sub XHCI_HCC_NSS {
        my($x) = @_;
	    eval q(((($x) >> 7) & 0x1));
    }' unless defined(&XHCI_HCC_NSS);
    eval 'sub XHCI_HCC_PAE {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0x1));
    }' unless defined(&XHCI_HCC_PAE);
    eval 'sub XHCI_HCC_SPC {
        my($x) = @_;
	    eval q(((($x) >> 9) & 0x1));
    }' unless defined(&XHCI_HCC_SPC);
    eval 'sub XHCI_HCC_SEC {
        my($x) = @_;
	    eval q(((($x) >> 10) & 0xf));
    }' unless defined(&XHCI_HCC_SEC);
    eval 'sub XHCI_HCC_CFC {
        my($x) = @_;
	    eval q(((($x) >> 11) & 0xf));
    }' unless defined(&XHCI_HCC_CFC);
    eval 'sub XHCI_HCC_MAX_PSA_SZ {
        my($x) = @_;
	    eval q(((($x) >> 12) & 0xf));
    }' unless defined(&XHCI_HCC_MAX_PSA_SZ);
    eval 'sub XHCI_HCC_XECP {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&XHCI_HCC_XECP);
    eval 'sub XHCI_DBOFF () {0x14;}' unless defined(&XHCI_DBOFF);
    eval 'sub XHCI_RTSOFF () {0x18;}' unless defined(&XHCI_RTSOFF);
    eval 'sub XHCI_USBCMD () {0x;}' unless defined(&XHCI_USBCMD);
    eval 'sub XHCI_CMD_RS () {0x1;}' unless defined(&XHCI_CMD_RS);
    eval 'sub XHCI_CMD_HCRST () {0x2;}' unless defined(&XHCI_CMD_HCRST);
    eval 'sub XHCI_CMD_INTE () {0x4;}' unless defined(&XHCI_CMD_INTE);
    eval 'sub XHCI_CMD_HSEE () {0x8;}' unless defined(&XHCI_CMD_HSEE);
    eval 'sub XHCI_CMD_LHCRST () {0x80;}' unless defined(&XHCI_CMD_LHCRST);
    eval 'sub XHCI_CMD_CSS () {0x100;}' unless defined(&XHCI_CMD_CSS);
    eval 'sub XHCI_CMD_CRS () {0x200;}' unless defined(&XHCI_CMD_CRS);
    eval 'sub XHCI_CMD_EWE () {0x400;}' unless defined(&XHCI_CMD_EWE);
    eval 'sub XHCI_CMD_EU3S () {0x800;}' unless defined(&XHCI_CMD_EU3S);
    eval 'sub XHCI_USBSTS () {0x4;}' unless defined(&XHCI_USBSTS);
    eval 'sub XHCI_STS_HCH () {0x1;}' unless defined(&XHCI_STS_HCH);
    eval 'sub XHCI_STS_HSE () {0x4;}' unless defined(&XHCI_STS_HSE);
    eval 'sub XHCI_STS_EINT () {0x8;}' unless defined(&XHCI_STS_EINT);
    eval 'sub XHCI_STS_PCD () {0x10;}' unless defined(&XHCI_STS_PCD);
    eval 'sub XHCI_STS_SSS () {0x100;}' unless defined(&XHCI_STS_SSS);
    eval 'sub XHCI_STS_RSS () {0x200;}' unless defined(&XHCI_STS_RSS);
    eval 'sub XHCI_STS_SRE () {0x400;}' unless defined(&XHCI_STS_SRE);
    eval 'sub XHCI_STS_CNR () {0x800;}' unless defined(&XHCI_STS_CNR);
    eval 'sub XHCI_STS_HCE () {0x1000;}' unless defined(&XHCI_STS_HCE);
    eval 'sub XHCI_PAGESIZE () {0x8;}' unless defined(&XHCI_PAGESIZE);
    eval 'sub XHCI_PAGESIZE_4K () {0x1;}' unless defined(&XHCI_PAGESIZE_4K);
    eval 'sub XHCI_PAGESIZE_8K () {0x2;}' unless defined(&XHCI_PAGESIZE_8K);
    eval 'sub XHCI_PAGESIZE_16K () {0x4;}' unless defined(&XHCI_PAGESIZE_16K);
    eval 'sub XHCI_PAGESIZE_32K () {0x8;}' unless defined(&XHCI_PAGESIZE_32K);
    eval 'sub XHCI_PAGESIZE_64K () {0x10;}' unless defined(&XHCI_PAGESIZE_64K);
    eval 'sub XHCI_DNCTRL () {0x14;}' unless defined(&XHCI_DNCTRL);
    eval 'sub XHCI_DNCTRL_MASK {
        my($n) = @_;
	    eval q((1<< ($n)));
    }' unless defined(&XHCI_DNCTRL_MASK);
    eval 'sub XHCI_CRCR_LO () {0x18;}' unless defined(&XHCI_CRCR_LO);
    eval 'sub XHCI_CRCR_LO_RCS () {0x1;}' unless defined(&XHCI_CRCR_LO_RCS);
    eval 'sub XHCI_CRCR_LO_CS () {0x2;}' unless defined(&XHCI_CRCR_LO_CS);
    eval 'sub XHCI_CRCR_LO_CA () {0x4;}' unless defined(&XHCI_CRCR_LO_CA);
    eval 'sub XHCI_CRCR_LO_CRR () {0x8;}' unless defined(&XHCI_CRCR_LO_CRR);
    eval 'sub XHCI_CRCR_LO_MASK () {0xf;}' unless defined(&XHCI_CRCR_LO_MASK);
    eval 'sub XHCI_CRCR_HI () {0x1c;}' unless defined(&XHCI_CRCR_HI);
    eval 'sub XHCI_DCBAAP_LO () {0x30;}' unless defined(&XHCI_DCBAAP_LO);
    eval 'sub XHCI_DCBAAP_HI () {0x34;}' unless defined(&XHCI_DCBAAP_HI);
    eval 'sub XHCI_CONFIG () {0x38;}' unless defined(&XHCI_CONFIG);
    eval 'sub XHCI_CONFIG_SLOTS_MASK () {0xff;}' unless defined(&XHCI_CONFIG_SLOTS_MASK);
    eval 'sub XHCI_PORTSC {
        my($n) = @_;
	    eval q((0x3f0 + (0x10 * ($n))));
    }' unless defined(&XHCI_PORTSC);
    eval 'sub XHCI_PS_CCS () {0x1;}' unless defined(&XHCI_PS_CCS);
    eval 'sub XHCI_PS_PED () {0x2;}' unless defined(&XHCI_PS_PED);
    eval 'sub XHCI_PS_OCA () {0x8;}' unless defined(&XHCI_PS_OCA);
    eval 'sub XHCI_PS_PR () {0x10;}' unless defined(&XHCI_PS_PR);
    eval 'sub XHCI_PS_GET_PLS {
        my($x) = @_;
	    eval q(((($x) >> 5) & 0xf));
    }' unless defined(&XHCI_PS_GET_PLS);
    eval 'sub XHCI_PS_SET_PLS {
        my($x) = @_;
	    eval q(((($x) & 0xf) << 5));
    }' unless defined(&XHCI_PS_SET_PLS);
    eval 'sub XHCI_PS_PP () {0x200;}' unless defined(&XHCI_PS_PP);
    eval 'sub XHCI_PS_SPEED {
        my($x) = @_;
	    eval q(((($x) >> 10) & 0xf));
    }' unless defined(&XHCI_PS_SPEED);
    eval 'sub XHCI_PS_GET_PIC {
        my($x) = @_;
	    eval q(((($x) >> 14) & 0x3));
    }' unless defined(&XHCI_PS_GET_PIC);
    eval 'sub XHCI_PS_SET_PIC {
        my($x) = @_;
	    eval q(((($x) & 0x3) << 14));
    }' unless defined(&XHCI_PS_SET_PIC);
    eval 'sub XHCI_PS_LWS () {0x10000;}' unless defined(&XHCI_PS_LWS);
    eval 'sub XHCI_PS_CSC () {0x20000;}' unless defined(&XHCI_PS_CSC);
    eval 'sub XHCI_PS_PEC () {0x40000;}' unless defined(&XHCI_PS_PEC);
    eval 'sub XHCI_PS_WRC () {0x80000;}' unless defined(&XHCI_PS_WRC);
    eval 'sub XHCI_PS_OCC () {0x100000;}' unless defined(&XHCI_PS_OCC);
    eval 'sub XHCI_PS_PRC () {0x200000;}' unless defined(&XHCI_PS_PRC);
    eval 'sub XHCI_PS_PLC () {0x400000;}' unless defined(&XHCI_PS_PLC);
    eval 'sub XHCI_PS_CEC () {0x800000;}' unless defined(&XHCI_PS_CEC);
    eval 'sub XHCI_PS_CAS () {0x1000000;}' unless defined(&XHCI_PS_CAS);
    eval 'sub XHCI_PS_WCE () {0x2000000;}' unless defined(&XHCI_PS_WCE);
    eval 'sub XHCI_PS_WDE () {0x4000000;}' unless defined(&XHCI_PS_WDE);
    eval 'sub XHCI_PS_WOE () {0x8000000;}' unless defined(&XHCI_PS_WOE);
    eval 'sub XHCI_PS_DR () {0x40000000;}' unless defined(&XHCI_PS_DR);
    eval 'sub XHCI_PS_WPR () {0x80000000;}' unless defined(&XHCI_PS_WPR);
    eval 'sub XHCI_PS_CLEAR () {0x80ff01ff;}' unless defined(&XHCI_PS_CLEAR);
    eval 'sub XHCI_PORTPMSC {
        my($n) = @_;
	    eval q((0x3f4 + (0x10 * ($n))));
    }' unless defined(&XHCI_PORTPMSC);
    eval 'sub XHCI_PM3_U1TO {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 0));
    }' unless defined(&XHCI_PM3_U1TO);
    eval 'sub XHCI_PM3_U2TO {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 8));
    }' unless defined(&XHCI_PM3_U2TO);
    eval 'sub XHCI_PM3_FLA () {0x10000;}' unless defined(&XHCI_PM3_FLA);
    eval 'sub XHCI_PM2_L1S {
        my($x) = @_;
	    eval q(((($x) >> 0) & 0x7));
    }' unless defined(&XHCI_PM2_L1S);
    eval 'sub XHCI_PM2_RWE () {0x8;}' unless defined(&XHCI_PM2_RWE);
    eval 'sub XHCI_PM2_HIRD {
        my($x) = @_;
	    eval q(((($x) & 0xf) << 4));
    }' unless defined(&XHCI_PM2_HIRD);
    eval 'sub XHCI_PM2_L1SLOT {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 8));
    }' unless defined(&XHCI_PM2_L1SLOT);
    eval 'sub XHCI_PM2_HLE () {0x10000;}' unless defined(&XHCI_PM2_HLE);
    eval 'sub XHCI_PORTLI {
        my($n) = @_;
	    eval q((0x3f8 + (0x10 * ($n))));
    }' unless defined(&XHCI_PORTLI);
    eval 'sub XHCI_PORTRSV {
        my($n) = @_;
	    eval q((0x3fc + (0x10 * ($n))));
    }' unless defined(&XHCI_PORTRSV);
    eval 'sub XHCI_MFINDEX () {0x;}' unless defined(&XHCI_MFINDEX);
    eval 'sub XHCI_GET_MFINDEX {
        my($x) = @_;
	    eval q((($x) & 0x3fff));
    }' unless defined(&XHCI_GET_MFINDEX);
    eval 'sub XHCI_IMAN {
        my($n) = @_;
	    eval q((0x20 + (0x20 * ($n))));
    }' unless defined(&XHCI_IMAN);
    eval 'sub XHCI_IMAN_INTR_PEND () {0x1;}' unless defined(&XHCI_IMAN_INTR_PEND);
    eval 'sub XHCI_IMAN_INTR_ENA () {0x2;}' unless defined(&XHCI_IMAN_INTR_ENA);
    eval 'sub XHCI_IMOD {
        my($n) = @_;
	    eval q((0x24 + (0x20 * ($n))));
    }' unless defined(&XHCI_IMOD);
    eval 'sub XHCI_IMOD_IVAL_GET {
        my($x) = @_;
	    eval q(((($x) >> 0) & 0xffff));
    }' unless defined(&XHCI_IMOD_IVAL_GET);
    eval 'sub XHCI_IMOD_IVAL_SET {
        my($x) = @_;
	    eval q(((($x) & 0xffff) << 0));
    }' unless defined(&XHCI_IMOD_IVAL_SET);
    eval 'sub XHCI_IMOD_ICNT_GET {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&XHCI_IMOD_ICNT_GET);
    eval 'sub XHCI_IMOD_ICNT_SET {
        my($x) = @_;
	    eval q(((($x) & 0xffff) << 16));
    }' unless defined(&XHCI_IMOD_ICNT_SET);
    eval 'sub XHCI_IMOD_DEFAULT () {0x1f4;}' unless defined(&XHCI_IMOD_DEFAULT);
    eval 'sub XHCI_IMOD_DEFAULT_LP () {0x3e8;}' unless defined(&XHCI_IMOD_DEFAULT_LP);
    eval 'sub XHCI_ERSTSZ {
        my($n) = @_;
	    eval q((0x28 + (0x20 * ($n))));
    }' unless defined(&XHCI_ERSTSZ);
    eval 'sub XHCI_ERSTS_SET {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&XHCI_ERSTS_SET);
    eval 'sub XHCI_ERSTBA_LO {
        my($n) = @_;
	    eval q((0x30 + (0x20 * ($n))));
    }' unless defined(&XHCI_ERSTBA_LO);
    eval 'sub XHCI_ERSTBA_HI {
        my($n) = @_;
	    eval q((0x34 + (0x20 * ($n))));
    }' unless defined(&XHCI_ERSTBA_HI);
    eval 'sub XHCI_ERDP_LO {
        my($n) = @_;
	    eval q((0x38 + (0x20 * ($n))));
    }' unless defined(&XHCI_ERDP_LO);
    eval 'sub XHCI_ERDP_LO_BUSY () {0x8;}' unless defined(&XHCI_ERDP_LO_BUSY);
    eval 'sub XHCI_ERDP_HI {
        my($n) = @_;
	    eval q((0x3c + (0x20 * ($n))));
    }' unless defined(&XHCI_ERDP_HI);
    eval 'sub XHCI_DOORBELL {
        my($n) = @_;
	    eval q((0x + (4* ($n))));
    }' unless defined(&XHCI_DOORBELL);
    eval 'sub XHCI_DB_GET_SID {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&XHCI_DB_GET_SID);
    eval 'sub XHCI_DB_SET_SID {
        my($x) = @_;
	    eval q(((($x) & 0xffff) << 16));
    }' unless defined(&XHCI_DB_SET_SID);
    eval 'sub XHCI_XECP_ID {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&XHCI_XECP_ID);
    eval 'sub XHCI_XECP_NEXT {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&XHCI_XECP_NEXT);
    eval 'sub XHCI_XECP_BIOS_SEM () {0x2;}' unless defined(&XHCI_XECP_BIOS_SEM);
    eval 'sub XHCI_XECP_OS_SEM () {0x3;}' unless defined(&XHCI_XECP_OS_SEM);
    eval 'sub XHCI_ID_USB_LEGACY () {0x1;}' unless defined(&XHCI_ID_USB_LEGACY);
    eval 'sub XHCI_ID_PROTOCOLS () {0x2;}' unless defined(&XHCI_ID_PROTOCOLS);
    eval 'sub XHCI_ID_POWER_MGMT () {0x3;}' unless defined(&XHCI_ID_POWER_MGMT);
    eval 'sub XHCI_ID_VIRTUALIZATION () {0x4;}' unless defined(&XHCI_ID_VIRTUALIZATION);
    eval 'sub XHCI_ID_MSG_IRQ () {0x5;}' unless defined(&XHCI_ID_MSG_IRQ);
    eval 'sub XHCI_ID_USB_LOCAL_MEM () {0x6;}' unless defined(&XHCI_ID_USB_LOCAL_MEM);
    eval 'sub XHCI_SCTX_ROUTE {
        my($x) = @_;
	    eval q((($x) & 0xfffff));
    }' unless defined(&XHCI_SCTX_ROUTE);
    eval 'sub XHCI_SCTX_SET_SPEED {
        my($x) = @_;
	    eval q(((($x) & 0xf) << 20));
    }' unless defined(&XHCI_SCTX_SET_SPEED);
    eval 'sub XHCI_SCTX_GET_SPEED {
        my($x) = @_;
	    eval q(((($x) >> 20) & 0xf));
    }' unless defined(&XHCI_SCTX_GET_SPEED);
    eval 'sub XHCI_SCTX_SET_MTT {
        my($x) = @_;
	    eval q(((($x) & 0x1) << 25));
    }' unless defined(&XHCI_SCTX_SET_MTT);
    eval 'sub XHCI_SCTX_GET_MTT {
        my($x) = @_;
	    eval q(((($x) >> 25) & 0x1));
    }' unless defined(&XHCI_SCTX_GET_MTT);
    eval 'sub XHCI_SCTX_SET_HUB {
        my($x) = @_;
	    eval q(((($x) & 0x1) << 26));
    }' unless defined(&XHCI_SCTX_SET_HUB);
    eval 'sub XHCI_SCTX_GET_HUB {
        my($x) = @_;
	    eval q(((($x) >> 26) & 0x1));
    }' unless defined(&XHCI_SCTX_GET_HUB);
    eval 'sub XHCI_SCTX_SET_DCI {
        my($x) = @_;
	    eval q(((($x) & 0x1f) << 27));
    }' unless defined(&XHCI_SCTX_SET_DCI);
    eval 'sub XHCI_SCTX_GET_DCI {
        my($x) = @_;
	    eval q(((($x) >> 27) & 0x1f));
    }' unless defined(&XHCI_SCTX_GET_DCI);
    eval 'sub XHCI_SCTX_SET_MAX_EL {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&XHCI_SCTX_SET_MAX_EL);
    eval 'sub XHCI_SCTX_GET_MAX_EL {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&XHCI_SCTX_GET_MAX_EL);
    eval 'sub XHCI_SCTX_SET_RHPORT {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 16));
    }' unless defined(&XHCI_SCTX_SET_RHPORT);
    eval 'sub XHCI_SCTX_GET_RHPORT {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xff));
    }' unless defined(&XHCI_SCTX_GET_RHPORT);
    eval 'sub XHCI_SCTX_SET_NPORTS {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 24));
    }' unless defined(&XHCI_SCTX_SET_NPORTS);
    eval 'sub XHCI_SCTX_GET_NPORTS {
        my($x) = @_;
	    eval q(((($x) >> 24) & 0xff));
    }' unless defined(&XHCI_SCTX_GET_NPORTS);
    eval 'sub XHCI_SCTX_TT_HUB_SID {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&XHCI_SCTX_TT_HUB_SID);
    eval 'sub XHCI_SCTX_SET_TT_PORT_NUM {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 8));
    }' unless defined(&XHCI_SCTX_SET_TT_PORT_NUM);
    eval 'sub XHCI_SCTX_GET_TT_PORT_NUM {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&XHCI_SCTX_GET_TT_PORT_NUM);
    eval 'sub XHCI_SCTX_SET_TT_THINK_TIME {
        my($x) = @_;
	    eval q(((($x) & 0x3) << 16));
    }' unless defined(&XHCI_SCTX_SET_TT_THINK_TIME);
    eval 'sub XHCI_SCTX_GET_TT_THINK_TIME {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x3));
    }' unless defined(&XHCI_SCTX_GET_TT_THINK_TIME);
    eval 'sub XHCI_SCTX_SET_IRQ_TARGET {
        my($x) = @_;
	    eval q(((($x) & 0x3ff) << 22));
    }' unless defined(&XHCI_SCTX_SET_IRQ_TARGET);
    eval 'sub XHCI_SCTX_GET_IRQ_TARGET {
        my($x) = @_;
	    eval q(((($x) >> 22) & 0x3ff));
    }' unless defined(&XHCI_SCTX_GET_IRQ_TARGET);
    eval 'sub XHCI_SCTX_DEV_ADDR {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&XHCI_SCTX_DEV_ADDR);
    eval 'sub XHCI_SCTX_SLOT_STATE {
        my($x) = @_;
	    eval q(((($x) >> 27) & 0x1f));
    }' unless defined(&XHCI_SCTX_SLOT_STATE);
    eval 'sub XHCI_EPCTX_STATE {
        my($x) = @_;
	    eval q((($x) & 0x7));
    }' unless defined(&XHCI_EPCTX_STATE);
    eval 'sub XHCI_EP_DISABLED () {0x;}' unless defined(&XHCI_EP_DISABLED);
    eval 'sub XHCI_EP_RUNNING () {0x1;}' unless defined(&XHCI_EP_RUNNING);
    eval 'sub XHCI_EP_HALTED () {0x2;}' unless defined(&XHCI_EP_HALTED);
    eval 'sub XHCI_EP_STOPPED () {0x3;}' unless defined(&XHCI_EP_STOPPED);
    eval 'sub XHCI_EP_ERROR () {0x4;}' unless defined(&XHCI_EP_ERROR);
    eval 'sub XHCI_EPCTX_SET_MULT {
        my($x) = @_;
	    eval q(((($x) & 0x3) << 8));
    }' unless defined(&XHCI_EPCTX_SET_MULT);
    eval 'sub XHCI_EPCTX_GET_MULT {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0x3));
    }' unless defined(&XHCI_EPCTX_GET_MULT);
    eval 'sub XHCI_EPCTX_SET_MAXP_STREAMS {
        my($x) = @_;
	    eval q(((($x) & 0x1f) << 10));
    }' unless defined(&XHCI_EPCTX_SET_MAXP_STREAMS);
    eval 'sub XHCI_EPCTX_GET_MAXP_STREAMS {
        my($x) = @_;
	    eval q(((($x) >> 10) & 0x1f));
    }' unless defined(&XHCI_EPCTX_GET_MAXP_STREAMS);
    eval 'sub XHCI_EPCTX_SET_LSA {
        my($x) = @_;
	    eval q(((($x) & 0x1) << 15));
    }' unless defined(&XHCI_EPCTX_SET_LSA);
    eval 'sub XHCI_EPCTX_GET_LSA {
        my($x) = @_;
	    eval q(((($x) >> 15) & 0x1));
    }' unless defined(&XHCI_EPCTX_GET_LSA);
    eval 'sub XHCI_EPCTX_SET_IVAL {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 16));
    }' unless defined(&XHCI_EPCTX_SET_IVAL);
    eval 'sub XHCI_EPCTX_GET_IVAL {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xff));
    }' unless defined(&XHCI_EPCTX_GET_IVAL);
    eval 'sub XHCI_EPCTX_SET_CERR {
        my($x) = @_;
	    eval q(((($x) & 0x3) << 1));
    }' unless defined(&XHCI_EPCTX_SET_CERR);
    eval 'sub XHCI_EPCTX_SET_EPTYPE {
        my($x) = @_;
	    eval q(((($x) & 0x7) << 3));
    }' unless defined(&XHCI_EPCTX_SET_EPTYPE);
    eval 'sub XHCI_EPCTX_GET_EPTYPE {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0x7));
    }' unless defined(&XHCI_EPCTX_GET_EPTYPE);
    eval 'sub XHCI_EPCTX_SET_HID {
        my($x) = @_;
	    eval q(((($x) & 0x1) << 7));
    }' unless defined(&XHCI_EPCTX_SET_HID);
    eval 'sub XHCI_EPCTX_GET_HID {
        my($x) = @_;
	    eval q(((($x) >> 7) & 0x1));
    }' unless defined(&XHCI_EPCTX_GET_HID);
    eval 'sub XHCI_EPCTX_SET_MAXB {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 8));
    }' unless defined(&XHCI_EPCTX_SET_MAXB);
    eval 'sub XHCI_EPCTX_GET_MAXB {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&XHCI_EPCTX_GET_MAXB);
    eval 'sub XHCI_EPCTX_SET_MPS {
        my($x) = @_;
	    eval q(((($x) & 0xffff) << 16));
    }' unless defined(&XHCI_EPCTX_SET_MPS);
    eval 'sub XHCI_EPCTX_GET_MPS {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&XHCI_EPCTX_GET_MPS);
    eval 'sub XHCI_SPEED_FULL () {1;}' unless defined(&XHCI_SPEED_FULL);
    eval 'sub XHCI_SPEED_LOW () {2;}' unless defined(&XHCI_SPEED_LOW);
    eval 'sub XHCI_SPEED_HIGH () {3;}' unless defined(&XHCI_SPEED_HIGH);
    eval 'sub XHCI_SPEED_SUPER () {4;}' unless defined(&XHCI_SPEED_SUPER);
    eval 'sub XHCI_EPCTX_DCS () {0x1;}' unless defined(&XHCI_EPCTX_DCS);
    eval 'sub XHCI_EPCTX_AVG_TRB_LEN {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&XHCI_EPCTX_AVG_TRB_LEN);
    eval 'sub XHCI_EPCTX_MAX_ESIT_PAYLOAD {
        my($x) = @_;
	    eval q(((($x) & 0xffff) << 16));
    }' unless defined(&XHCI_EPCTX_MAX_ESIT_PAYLOAD);
    eval 'sub XHCI_INCTX_MASK_DCI {
        my($n) = @_;
	    eval q((0x1 << ($n)));
    }' unless defined(&XHCI_INCTX_MASK_DCI);
    eval 'sub XHCI_TRB_PORTID {
        my($x) = @_;
	    eval q(((($x) & (0xff << 24)) >> 24));
    }' unless defined(&XHCI_TRB_PORTID);
    eval 'sub XHCI_TRB_GET_CODE {
        my($x) = @_;
	    eval q(((($x) >> 24) & 0xff));
    }' unless defined(&XHCI_TRB_GET_CODE);
    eval 'sub XHCI_TRB_TDREM {
        my($x) = @_;
	    eval q(((($x) & 0x1f) << 17));
    }' unless defined(&XHCI_TRB_TDREM);
    eval 'sub XHCI_TRB_REMAIN {
        my($x) = @_;
	    eval q((($x) & 0xffffff));
    }' unless defined(&XHCI_TRB_REMAIN);
    eval 'sub XHCI_TRB_LEN {
        my($x) = @_;
	    eval q((($x) & 0x1ffff));
    }' unless defined(&XHCI_TRB_LEN);
    eval 'sub XHCI_TRB_INTR {
        my($x) = @_;
	    eval q(((($x) & 0x3ff) << 22));
    }' unless defined(&XHCI_TRB_INTR);
    eval 'sub XHCI_TRB_CYCLE () {(1<< 0);}' unless defined(&XHCI_TRB_CYCLE);
    eval 'sub XHCI_TRB_ENT () {(1<< 1);}' unless defined(&XHCI_TRB_ENT);
    eval 'sub XHCI_TRB_LINKSEG () { &XHCI_TRB_ENT;}' unless defined(&XHCI_TRB_LINKSEG);
    eval 'sub XHCI_TRB_ISP () {(1<< 2);}' unless defined(&XHCI_TRB_ISP);
    eval 'sub XHCI_TRB_NOSNOOP () {(1<< 3);}' unless defined(&XHCI_TRB_NOSNOOP);
    eval 'sub XHCI_TRB_CHAIN () {(1<< 4);}' unless defined(&XHCI_TRB_CHAIN);
    eval 'sub XHCI_TRB_IOC () {(1<< 5);}' unless defined(&XHCI_TRB_IOC);
    eval 'sub XHCI_TRB_IDT () {(1<< 6);}' unless defined(&XHCI_TRB_IDT);
    eval 'sub XHCI_TRB_BSR () {(1<< 9);}' unless defined(&XHCI_TRB_BSR);
    eval 'sub XHCI_TRB_DIR_IN () {(1<< 16);}' unless defined(&XHCI_TRB_DIR_IN);
    eval 'sub XHCI_TRB_TRT_OUT () {(2<< 16);}' unless defined(&XHCI_TRB_TRT_OUT);
    eval 'sub XHCI_TRB_TRT_IN () {(3<< 16);}' unless defined(&XHCI_TRB_TRT_IN);
    eval 'sub XHCI_TRB_GET_EP {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x1f));
    }' unless defined(&XHCI_TRB_GET_EP);
    eval 'sub XHCI_TRB_SET_EP {
        my($x) = @_;
	    eval q(((($x) & 0x1f) << 16));
    }' unless defined(&XHCI_TRB_SET_EP);
    eval 'sub XHCI_TRB_GET_SLOT {
        my($x) = @_;
	    eval q(((($x) >> 24) & 0xff));
    }' unless defined(&XHCI_TRB_GET_SLOT);
    eval 'sub XHCI_TRB_SET_SLOT {
        my($x) = @_;
	    eval q(((($x) & 0xff) << 24));
    }' unless defined(&XHCI_TRB_SET_SLOT);
    eval 'sub XHCI_TRB_TYPE_MASK () {0xfc00;}' unless defined(&XHCI_TRB_TYPE_MASK);
    eval 'sub XHCI_TRB_TYPE {
        my($x) = @_;
	    eval q(((($x) &  &XHCI_TRB_TYPE_MASK) >> 10));
    }' unless defined(&XHCI_TRB_TYPE);
    eval 'sub XHCI_TRB_TYPE_NORMAL () {(1<< 10);}' unless defined(&XHCI_TRB_TYPE_NORMAL);
    eval 'sub XHCI_TRB_TYPE_SETUP () {(2<< 10);}' unless defined(&XHCI_TRB_TYPE_SETUP);
    eval 'sub XHCI_TRB_TYPE_DATA () {(3<< 10);}' unless defined(&XHCI_TRB_TYPE_DATA);
    eval 'sub XHCI_TRB_TYPE_STATUS () {(4<< 10);}' unless defined(&XHCI_TRB_TYPE_STATUS);
    eval 'sub XHCI_TRB_TYPE_ISOCH () {(5<< 10);}' unless defined(&XHCI_TRB_TYPE_ISOCH);
    eval 'sub XHCI_TRB_TYPE_LINK () {(6<< 10);}' unless defined(&XHCI_TRB_TYPE_LINK);
    eval 'sub XHCI_TRB_TYPE_EVENT () {(7<< 10);}' unless defined(&XHCI_TRB_TYPE_EVENT);
    eval 'sub XHCI_TRB_TYPE_NOOP () {(8<< 10);}' unless defined(&XHCI_TRB_TYPE_NOOP);
    eval 'sub XHCI_CMD_ENABLE_SLOT () {(9<< 10);}' unless defined(&XHCI_CMD_ENABLE_SLOT);
    eval 'sub XHCI_CMD_DISABLE_SLOT () {(10<< 10);}' unless defined(&XHCI_CMD_DISABLE_SLOT);
    eval 'sub XHCI_CMD_ADDRESS_DEVICE () {(11<< 10);}' unless defined(&XHCI_CMD_ADDRESS_DEVICE);
    eval 'sub XHCI_CMD_CONFIG_EP () {(12<< 10);}' unless defined(&XHCI_CMD_CONFIG_EP);
    eval 'sub XHCI_CMD_EVAL_CTX () {(13<< 10);}' unless defined(&XHCI_CMD_EVAL_CTX);
    eval 'sub XHCI_CMD_RESET_EP () {(14<< 10);}' unless defined(&XHCI_CMD_RESET_EP);
    eval 'sub XHCI_CMD_STOP_EP () {(15<< 10);}' unless defined(&XHCI_CMD_STOP_EP);
    eval 'sub XHCI_CMD_SET_TR_DEQ () {(16<< 10);}' unless defined(&XHCI_CMD_SET_TR_DEQ);
    eval 'sub XHCI_CMD_RESET_DEV () {(17<< 10);}' unless defined(&XHCI_CMD_RESET_DEV);
    eval 'sub XHCI_CMD_FEVENT () {(18<< 10);}' unless defined(&XHCI_CMD_FEVENT);
    eval 'sub XHCI_CMD_NEG_BW () {(19<< 10);}' unless defined(&XHCI_CMD_NEG_BW);
    eval 'sub XHCI_CMD_SET_LT () {(20<< 10);}' unless defined(&XHCI_CMD_SET_LT);
    eval 'sub XHCI_CMD_GET_BW () {(21<< 10);}' unless defined(&XHCI_CMD_GET_BW);
    eval 'sub XHCI_CMD_FHEADER () {(22<< 10);}' unless defined(&XHCI_CMD_FHEADER);
    eval 'sub XHCI_CMD_NOOP () {(23<< 10);}' unless defined(&XHCI_CMD_NOOP);
    eval 'sub XHCI_EVT_XFER () {(32<< 10);}' unless defined(&XHCI_EVT_XFER);
    eval 'sub XHCI_EVT_CMD_COMPLETE () {(33<< 10);}' unless defined(&XHCI_EVT_CMD_COMPLETE);
    eval 'sub XHCI_EVT_PORT_CHANGE () {(34<< 10);}' unless defined(&XHCI_EVT_PORT_CHANGE);
    eval 'sub XHCI_EVT_BW_REQUEST () {(35<< 10);}' unless defined(&XHCI_EVT_BW_REQUEST);
    eval 'sub XHCI_EVT_DOORBELL () {(36<< 10);}' unless defined(&XHCI_EVT_DOORBELL);
    eval 'sub XHCI_EVT_HOST_CTRL () {(37<< 10);}' unless defined(&XHCI_EVT_HOST_CTRL);
    eval 'sub XHCI_EVT_DEVICE_NOTIFY () {(38<< 10);}' unless defined(&XHCI_EVT_DEVICE_NOTIFY);
    eval 'sub XHCI_EVT_MFINDEX_WRAP () {(39<< 10);}' unless defined(&XHCI_EVT_MFINDEX_WRAP);
    eval 'sub XHCI_CODE_INVALID () {0;}' unless defined(&XHCI_CODE_INVALID);
    eval 'sub XHCI_CODE_SUCCESS () {1;}' unless defined(&XHCI_CODE_SUCCESS);
    eval 'sub XHCI_CODE_DATA_BUF () {2;}' unless defined(&XHCI_CODE_DATA_BUF);
    eval 'sub XHCI_CODE_BABBLE () {3;}' unless defined(&XHCI_CODE_BABBLE);
    eval 'sub XHCI_CODE_TXERR () {4;}' unless defined(&XHCI_CODE_TXERR);
    eval 'sub XHCI_CODE_TRB () {5;}' unless defined(&XHCI_CODE_TRB);
    eval 'sub XHCI_CODE_STALL () {6;}' unless defined(&XHCI_CODE_STALL);
    eval 'sub XHCI_CODE_RESOURCE () {7;}' unless defined(&XHCI_CODE_RESOURCE);
    eval 'sub XHCI_CODE_BANDWIDTH () {8;}' unless defined(&XHCI_CODE_BANDWIDTH);
    eval 'sub XHCI_CODE_NO_SLOTS () {9;}' unless defined(&XHCI_CODE_NO_SLOTS);
    eval 'sub XHCI_CODE_STREAM_TYPE () {10;}' unless defined(&XHCI_CODE_STREAM_TYPE);
    eval 'sub XHCI_CODE_SLOT_NOT_ON () {11;}' unless defined(&XHCI_CODE_SLOT_NOT_ON);
    eval 'sub XHCI_CODE_ENDP_NOT_ON () {12;}' unless defined(&XHCI_CODE_ENDP_NOT_ON);
    eval 'sub XHCI_CODE_SHORT_XFER () {13;}' unless defined(&XHCI_CODE_SHORT_XFER);
    eval 'sub XHCI_CODE_RING_UNDERRUN () {14;}' unless defined(&XHCI_CODE_RING_UNDERRUN);
    eval 'sub XHCI_CODE_RING_OVERRUN () {15;}' unless defined(&XHCI_CODE_RING_OVERRUN);
    eval 'sub XHCI_CODE_VF_RING_FULL () {16;}' unless defined(&XHCI_CODE_VF_RING_FULL);
    eval 'sub XHCI_CODE_PARAMETER () {17;}' unless defined(&XHCI_CODE_PARAMETER);
    eval 'sub XHCI_CODE_BW_OVERRUN () {18;}' unless defined(&XHCI_CODE_BW_OVERRUN);
    eval 'sub XHCI_CODE_CONTEXT_STATE () {19;}' unless defined(&XHCI_CODE_CONTEXT_STATE);
    eval 'sub XHCI_CODE_NO_PING_RESP () {20;}' unless defined(&XHCI_CODE_NO_PING_RESP);
    eval 'sub XHCI_CODE_EV_RING_FULL () {21;}' unless defined(&XHCI_CODE_EV_RING_FULL);
    eval 'sub XHCI_CODE_INCOMPAT_DEV () {22;}' unless defined(&XHCI_CODE_INCOMPAT_DEV);
    eval 'sub XHCI_CODE_MISSED_SRV () {23;}' unless defined(&XHCI_CODE_MISSED_SRV);
    eval 'sub XHCI_CODE_CMD_RING_STOP () {24;}' unless defined(&XHCI_CODE_CMD_RING_STOP);
    eval 'sub XHCI_CODE_CMD_ABORTED () {25;}' unless defined(&XHCI_CODE_CMD_ABORTED);
    eval 'sub XHCI_CODE_XFER_STOPPED () {26;}' unless defined(&XHCI_CODE_XFER_STOPPED);
    eval 'sub XHCI_CODE_XFER_INVLEN () {27;}' unless defined(&XHCI_CODE_XFER_INVLEN);
    eval 'sub XHCI_CODE_XFER_SHORTPKT () {28;}' unless defined(&XHCI_CODE_XFER_SHORTPKT);
    eval 'sub XHCI_CODE_MELAT () {29;}' unless defined(&XHCI_CODE_MELAT);
    eval 'sub XHCI_CODE_RESERVED () {30;}' unless defined(&XHCI_CODE_RESERVED);
    eval 'sub XHCI_CODE_ISOC_OVERRUN () {31;}' unless defined(&XHCI_CODE_ISOC_OVERRUN);
    eval 'sub XHCI_CODE_EVENT_LOST () {32;}' unless defined(&XHCI_CODE_EVENT_LOST);
    eval 'sub XHCI_CODE_UNDEFINED () {33;}' unless defined(&XHCI_CODE_UNDEFINED);
    eval 'sub XHCI_CODE_INVALID_SID () {34;}' unless defined(&XHCI_CODE_INVALID_SID);
    eval 'sub XHCI_CODE_SEC_BW () {35;}' unless defined(&XHCI_CODE_SEC_BW);
    eval 'sub XHCI_CODE_SPLIT_XACT () {36;}' unless defined(&XHCI_CODE_SPLIT_XACT);
}
1;
