require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_RSA_H)) {
    eval 'sub HEADER_RSA_H () {1;}' unless defined(&HEADER_RSA_H);
    require 'openssl/opensslconf.ph';
    require 'openssl/asn1.ph';
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    require 'openssl/crypto.ph';
    require 'openssl/ossl_typ.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	require 'openssl/bn.ph';
    }
    if(defined(&OPENSSL_NO_RSA)) {
	die("RSA\ is\ disabled\.");
    }
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_RSA_MAX_MODULUS_BITS)) {
	eval 'sub OPENSSL_RSA_MAX_MODULUS_BITS () {16384;}' unless defined(&OPENSSL_RSA_MAX_MODULUS_BITS);
    }
    unless(defined(&OPENSSL_RSA_SMALL_MODULUS_BITS)) {
	eval 'sub OPENSSL_RSA_SMALL_MODULUS_BITS () {3072;}' unless defined(&OPENSSL_RSA_SMALL_MODULUS_BITS);
    }
    unless(defined(&OPENSSL_RSA_MAX_PUBEXP_BITS)) {
	eval 'sub OPENSSL_RSA_MAX_PUBEXP_BITS () {64;}' unless defined(&OPENSSL_RSA_MAX_PUBEXP_BITS);
    }
    eval 'sub RSA_3 () {0x3;}' unless defined(&RSA_3);
    eval 'sub RSA_F4 () {0x10001;}' unless defined(&RSA_F4);
    eval 'sub RSA_METHOD_FLAG_NO_CHECK () {0x1;}' unless defined(&RSA_METHOD_FLAG_NO_CHECK);
    eval 'sub RSA_FLAG_CACHE_PUBLIC () {0x2;}' unless defined(&RSA_FLAG_CACHE_PUBLIC);
    eval 'sub RSA_FLAG_CACHE_PRIVATE () {0x4;}' unless defined(&RSA_FLAG_CACHE_PRIVATE);
    eval 'sub RSA_FLAG_BLINDING () {0x8;}' unless defined(&RSA_FLAG_BLINDING);
    eval 'sub RSA_FLAG_THREAD_SAFE () {0x10;}' unless defined(&RSA_FLAG_THREAD_SAFE);
    eval 'sub RSA_FLAG_EXT_PKEY () {0x20;}' unless defined(&RSA_FLAG_EXT_PKEY);
    eval 'sub RSA_FLAG_SIGN_VER () {0x40;}' unless defined(&RSA_FLAG_SIGN_VER);
    eval 'sub RSA_FLAG_NO_BLINDING () {0x80;}' unless defined(&RSA_FLAG_NO_BLINDING);
    eval 'sub RSA_FLAG_NO_CONSTTIME () {0x100;}' unless defined(&RSA_FLAG_NO_CONSTTIME);
    eval 'sub EVP_PKEY_CTX_set_rsa_padding {
        my($ctx, $pad) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA, -1,  &EVP_PKEY_CTRL_RSA_PADDING, $pad,  &NULL));
    }' unless defined(&EVP_PKEY_CTX_set_rsa_padding);
    eval 'sub EVP_PKEY_CTX_get_rsa_padding {
        my($ctx, $ppad) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA, -1,  &EVP_PKEY_CTRL_GET_RSA_PADDING, 0, $ppad));
    }' unless defined(&EVP_PKEY_CTX_get_rsa_padding);
    eval 'sub EVP_PKEY_CTX_set_rsa_pss_saltlen {
        my($ctx, $len) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA, ( &EVP_PKEY_OP_SIGN| &EVP_PKEY_OP_VERIFY),  &EVP_PKEY_CTRL_RSA_PSS_SALTLEN, $len,  &NULL));
    }' unless defined(&EVP_PKEY_CTX_set_rsa_pss_saltlen);
    eval 'sub EVP_PKEY_CTX_get_rsa_pss_saltlen {
        my($ctx, $plen) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA, ( &EVP_PKEY_OP_SIGN| &EVP_PKEY_OP_VERIFY),  &EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN, 0, $plen));
    }' unless defined(&EVP_PKEY_CTX_get_rsa_pss_saltlen);
    eval 'sub EVP_PKEY_CTX_set_rsa_keygen_bits {
        my($ctx, $bits) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_KEYGEN_BITS, $bits,  &NULL));
    }' unless defined(&EVP_PKEY_CTX_set_rsa_keygen_bits);
    eval 'sub EVP_PKEY_CTX_set_rsa_keygen_pubexp {
        my($ctx, $pubexp) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP, 0, $pubexp));
    }' unless defined(&EVP_PKEY_CTX_set_rsa_keygen_pubexp);
    eval 'sub EVP_PKEY_CTX_set_rsa_mgf1_md {
        my($ctx, $md) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_SIG,  &EVP_PKEY_CTRL_RSA_MGF1_MD, 0, ( &void *)$md));
    }' unless defined(&EVP_PKEY_CTX_set_rsa_mgf1_md);
    eval 'sub EVP_PKEY_CTX_get_rsa_mgf1_md {
        my($ctx, $pmd) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_SIG,  &EVP_PKEY_CTRL_GET_RSA_MGF1_MD, 0, ( &void *)$pmd));
    }' unless defined(&EVP_PKEY_CTX_get_rsa_mgf1_md);
    eval 'sub EVP_PKEY_CTRL_RSA_PADDING () {( &EVP_PKEY_ALG_CTRL + 1);}' unless defined(&EVP_PKEY_CTRL_RSA_PADDING);
    eval 'sub EVP_PKEY_CTRL_RSA_PSS_SALTLEN () {( &EVP_PKEY_ALG_CTRL + 2);}' unless defined(&EVP_PKEY_CTRL_RSA_PSS_SALTLEN);
    eval 'sub EVP_PKEY_CTRL_RSA_KEYGEN_BITS () {( &EVP_PKEY_ALG_CTRL + 3);}' unless defined(&EVP_PKEY_CTRL_RSA_KEYGEN_BITS);
    eval 'sub EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP () {( &EVP_PKEY_ALG_CTRL + 4);}' unless defined(&EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP);
    eval 'sub EVP_PKEY_CTRL_RSA_MGF1_MD () {( &EVP_PKEY_ALG_CTRL + 5);}' unless defined(&EVP_PKEY_CTRL_RSA_MGF1_MD);
    eval 'sub EVP_PKEY_CTRL_GET_RSA_PADDING () {( &EVP_PKEY_ALG_CTRL + 6);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_PADDING);
    eval 'sub EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN () {( &EVP_PKEY_ALG_CTRL + 7);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN);
    eval 'sub EVP_PKEY_CTRL_GET_RSA_MGF1_MD () {( &EVP_PKEY_ALG_CTRL + 8);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_MGF1_MD);
    eval 'sub RSA_PKCS1_PADDING () {1;}' unless defined(&RSA_PKCS1_PADDING);
    eval 'sub RSA_SSLV23_PADDING () {2;}' unless defined(&RSA_SSLV23_PADDING);
    eval 'sub RSA_NO_PADDING () {3;}' unless defined(&RSA_NO_PADDING);
    eval 'sub RSA_PKCS1_OAEP_PADDING () {4;}' unless defined(&RSA_PKCS1_OAEP_PADDING);
    eval 'sub RSA_X931_PADDING () {5;}' unless defined(&RSA_X931_PADDING);
    eval 'sub RSA_PKCS1_PSS_PADDING () {6;}' unless defined(&RSA_PKCS1_PSS_PADDING);
    eval 'sub RSA_PKCS1_PADDING_SIZE () {11;}' unless defined(&RSA_PKCS1_PADDING_SIZE);
    eval 'sub RSA_set_app_data {
        my($s,$arg) = @_;
	    eval q( &RSA_set_ex_data($s,0,$arg));
    }' unless defined(&RSA_set_app_data);
    eval 'sub RSA_get_app_data {
        my($s) = @_;
	    eval q( &RSA_get_ex_data($s,0));
    }' unless defined(&RSA_get_app_data);
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    unless(defined(&OPENSSL_NO_RC4)) {
    }
    eval 'sub RSA_FLAG_FIPS_METHOD () {0x400;}' unless defined(&RSA_FLAG_FIPS_METHOD);
    eval 'sub RSA_FLAG_NON_FIPS_ALLOW () {0x400;}' unless defined(&RSA_FLAG_NON_FIPS_ALLOW);
    eval 'sub RSA_FLAG_CHECKED () {0x800;}' unless defined(&RSA_FLAG_CHECKED);
    eval 'sub RSA_F_CHECK_PADDING_MD () {140;}' unless defined(&RSA_F_CHECK_PADDING_MD);
    eval 'sub RSA_F_DO_RSA_PRINT () {146;}' unless defined(&RSA_F_DO_RSA_PRINT);
    eval 'sub RSA_F_INT_RSA_VERIFY () {145;}' unless defined(&RSA_F_INT_RSA_VERIFY);
    eval 'sub RSA_F_MEMORY_LOCK () {100;}' unless defined(&RSA_F_MEMORY_LOCK);
    eval 'sub RSA_F_OLD_RSA_PRIV_DECODE () {147;}' unless defined(&RSA_F_OLD_RSA_PRIV_DECODE);
    eval 'sub RSA_F_PKEY_RSA_CTRL () {143;}' unless defined(&RSA_F_PKEY_RSA_CTRL);
    eval 'sub RSA_F_PKEY_RSA_CTRL_STR () {144;}' unless defined(&RSA_F_PKEY_RSA_CTRL_STR);
    eval 'sub RSA_F_PKEY_RSA_SIGN () {142;}' unless defined(&RSA_F_PKEY_RSA_SIGN);
    eval 'sub RSA_F_PKEY_RSA_VERIFY () {154;}' unless defined(&RSA_F_PKEY_RSA_VERIFY);
    eval 'sub RSA_F_PKEY_RSA_VERIFYRECOVER () {141;}' unless defined(&RSA_F_PKEY_RSA_VERIFYRECOVER);
    eval 'sub RSA_F_RSA_BUILTIN_KEYGEN () {129;}' unless defined(&RSA_F_RSA_BUILTIN_KEYGEN);
    eval 'sub RSA_F_RSA_CHECK_KEY () {123;}' unless defined(&RSA_F_RSA_CHECK_KEY);
    eval 'sub RSA_F_RSA_EAY_PRIVATE_DECRYPT () {101;}' unless defined(&RSA_F_RSA_EAY_PRIVATE_DECRYPT);
    eval 'sub RSA_F_RSA_EAY_PRIVATE_ENCRYPT () {102;}' unless defined(&RSA_F_RSA_EAY_PRIVATE_ENCRYPT);
    eval 'sub RSA_F_RSA_EAY_PUBLIC_DECRYPT () {103;}' unless defined(&RSA_F_RSA_EAY_PUBLIC_DECRYPT);
    eval 'sub RSA_F_RSA_EAY_PUBLIC_ENCRYPT () {104;}' unless defined(&RSA_F_RSA_EAY_PUBLIC_ENCRYPT);
    eval 'sub RSA_F_RSA_GENERATE_KEY () {105;}' unless defined(&RSA_F_RSA_GENERATE_KEY);
    eval 'sub RSA_F_RSA_GENERATE_KEY_EX () {155;}' unless defined(&RSA_F_RSA_GENERATE_KEY_EX);
    eval 'sub RSA_F_RSA_ITEM_VERIFY () {156;}' unless defined(&RSA_F_RSA_ITEM_VERIFY);
    eval 'sub RSA_F_RSA_MEMORY_LOCK () {130;}' unless defined(&RSA_F_RSA_MEMORY_LOCK);
    eval 'sub RSA_F_RSA_NEW_METHOD () {106;}' unless defined(&RSA_F_RSA_NEW_METHOD);
    eval 'sub RSA_F_RSA_NULL () {124;}' unless defined(&RSA_F_RSA_NULL);
    eval 'sub RSA_F_RSA_NULL_MOD_EXP () {131;}' unless defined(&RSA_F_RSA_NULL_MOD_EXP);
    eval 'sub RSA_F_RSA_NULL_PRIVATE_DECRYPT () {132;}' unless defined(&RSA_F_RSA_NULL_PRIVATE_DECRYPT);
    eval 'sub RSA_F_RSA_NULL_PRIVATE_ENCRYPT () {133;}' unless defined(&RSA_F_RSA_NULL_PRIVATE_ENCRYPT);
    eval 'sub RSA_F_RSA_NULL_PUBLIC_DECRYPT () {134;}' unless defined(&RSA_F_RSA_NULL_PUBLIC_DECRYPT);
    eval 'sub RSA_F_RSA_NULL_PUBLIC_ENCRYPT () {135;}' unless defined(&RSA_F_RSA_NULL_PUBLIC_ENCRYPT);
    eval 'sub RSA_F_RSA_PADDING_ADD_NONE () {107;}' unless defined(&RSA_F_RSA_PADDING_ADD_NONE);
    eval 'sub RSA_F_RSA_PADDING_ADD_PKCS1_OAEP () {121;}' unless defined(&RSA_F_RSA_PADDING_ADD_PKCS1_OAEP);
    eval 'sub RSA_F_RSA_PADDING_ADD_PKCS1_PSS () {125;}' unless defined(&RSA_F_RSA_PADDING_ADD_PKCS1_PSS);
    eval 'sub RSA_F_RSA_PADDING_ADD_PKCS1_PSS_MGF1 () {148;}' unless defined(&RSA_F_RSA_PADDING_ADD_PKCS1_PSS_MGF1);
    eval 'sub RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1 () {108;}' unless defined(&RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1);
    eval 'sub RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2 () {109;}' unless defined(&RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2);
    eval 'sub RSA_F_RSA_PADDING_ADD_SSLV23 () {110;}' unless defined(&RSA_F_RSA_PADDING_ADD_SSLV23);
    eval 'sub RSA_F_RSA_PADDING_ADD_X931 () {127;}' unless defined(&RSA_F_RSA_PADDING_ADD_X931);
    eval 'sub RSA_F_RSA_PADDING_CHECK_NONE () {111;}' unless defined(&RSA_F_RSA_PADDING_CHECK_NONE);
    eval 'sub RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP () {122;}' unless defined(&RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP);
    eval 'sub RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1 () {112;}' unless defined(&RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1);
    eval 'sub RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2 () {113;}' unless defined(&RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2);
    eval 'sub RSA_F_RSA_PADDING_CHECK_SSLV23 () {114;}' unless defined(&RSA_F_RSA_PADDING_CHECK_SSLV23);
    eval 'sub RSA_F_RSA_PADDING_CHECK_X931 () {128;}' unless defined(&RSA_F_RSA_PADDING_CHECK_X931);
    eval 'sub RSA_F_RSA_PRINT () {115;}' unless defined(&RSA_F_RSA_PRINT);
    eval 'sub RSA_F_RSA_PRINT_FP () {116;}' unless defined(&RSA_F_RSA_PRINT_FP);
    eval 'sub RSA_F_RSA_PRIVATE_DECRYPT () {150;}' unless defined(&RSA_F_RSA_PRIVATE_DECRYPT);
    eval 'sub RSA_F_RSA_PRIVATE_ENCRYPT () {151;}' unless defined(&RSA_F_RSA_PRIVATE_ENCRYPT);
    eval 'sub RSA_F_RSA_PRIV_DECODE () {137;}' unless defined(&RSA_F_RSA_PRIV_DECODE);
    eval 'sub RSA_F_RSA_PRIV_ENCODE () {138;}' unless defined(&RSA_F_RSA_PRIV_ENCODE);
    eval 'sub RSA_F_RSA_PUBLIC_DECRYPT () {152;}' unless defined(&RSA_F_RSA_PUBLIC_DECRYPT);
    eval 'sub RSA_F_RSA_PUBLIC_ENCRYPT () {153;}' unless defined(&RSA_F_RSA_PUBLIC_ENCRYPT);
    eval 'sub RSA_F_RSA_PUB_DECODE () {139;}' unless defined(&RSA_F_RSA_PUB_DECODE);
    eval 'sub RSA_F_RSA_SETUP_BLINDING () {136;}' unless defined(&RSA_F_RSA_SETUP_BLINDING);
    eval 'sub RSA_F_RSA_SIGN () {117;}' unless defined(&RSA_F_RSA_SIGN);
    eval 'sub RSA_F_RSA_SIGN_ASN1_OCTET_STRING () {118;}' unless defined(&RSA_F_RSA_SIGN_ASN1_OCTET_STRING);
    eval 'sub RSA_F_RSA_VERIFY () {119;}' unless defined(&RSA_F_RSA_VERIFY);
    eval 'sub RSA_F_RSA_VERIFY_ASN1_OCTET_STRING () {120;}' unless defined(&RSA_F_RSA_VERIFY_ASN1_OCTET_STRING);
    eval 'sub RSA_F_RSA_VERIFY_PKCS1_PSS () {126;}' unless defined(&RSA_F_RSA_VERIFY_PKCS1_PSS);
    eval 'sub RSA_F_RSA_VERIFY_PKCS1_PSS_MGF1 () {149;}' unless defined(&RSA_F_RSA_VERIFY_PKCS1_PSS_MGF1);
    eval 'sub RSA_R_ALGORITHM_MISMATCH () {100;}' unless defined(&RSA_R_ALGORITHM_MISMATCH);
    eval 'sub RSA_R_BAD_E_VALUE () {101;}' unless defined(&RSA_R_BAD_E_VALUE);
    eval 'sub RSA_R_BAD_FIXED_HEADER_DECRYPT () {102;}' unless defined(&RSA_R_BAD_FIXED_HEADER_DECRYPT);
    eval 'sub RSA_R_BAD_PAD_BYTE_COUNT () {103;}' unless defined(&RSA_R_BAD_PAD_BYTE_COUNT);
    eval 'sub RSA_R_BAD_SIGNATURE () {104;}' unless defined(&RSA_R_BAD_SIGNATURE);
    eval 'sub RSA_R_BLOCK_TYPE_IS_NOT_01 () {106;}' unless defined(&RSA_R_BLOCK_TYPE_IS_NOT_01);
    eval 'sub RSA_R_BLOCK_TYPE_IS_NOT_02 () {107;}' unless defined(&RSA_R_BLOCK_TYPE_IS_NOT_02);
    eval 'sub RSA_R_DATA_GREATER_THAN_MOD_LEN () {108;}' unless defined(&RSA_R_DATA_GREATER_THAN_MOD_LEN);
    eval 'sub RSA_R_DATA_TOO_LARGE () {109;}' unless defined(&RSA_R_DATA_TOO_LARGE);
    eval 'sub RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE () {110;}' unless defined(&RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE);
    eval 'sub RSA_R_DATA_TOO_LARGE_FOR_MODULUS () {132;}' unless defined(&RSA_R_DATA_TOO_LARGE_FOR_MODULUS);
    eval 'sub RSA_R_DATA_TOO_SMALL () {111;}' unless defined(&RSA_R_DATA_TOO_SMALL);
    eval 'sub RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE () {122;}' unless defined(&RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE);
    eval 'sub RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY () {112;}' unless defined(&RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY);
    eval 'sub RSA_R_DMP1_NOT_CONGRUENT_TO_D () {124;}' unless defined(&RSA_R_DMP1_NOT_CONGRUENT_TO_D);
    eval 'sub RSA_R_DMQ1_NOT_CONGRUENT_TO_D () {125;}' unless defined(&RSA_R_DMQ1_NOT_CONGRUENT_TO_D);
    eval 'sub RSA_R_D_E_NOT_CONGRUENT_TO_1 () {123;}' unless defined(&RSA_R_D_E_NOT_CONGRUENT_TO_1);
    eval 'sub RSA_R_FIRST_OCTET_INVALID () {133;}' unless defined(&RSA_R_FIRST_OCTET_INVALID);
    eval 'sub RSA_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE () {144;}' unless defined(&RSA_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE);
    eval 'sub RSA_R_INVALID_DIGEST_LENGTH () {143;}' unless defined(&RSA_R_INVALID_DIGEST_LENGTH);
    eval 'sub RSA_R_INVALID_HEADER () {137;}' unless defined(&RSA_R_INVALID_HEADER);
    eval 'sub RSA_R_INVALID_KEYBITS () {145;}' unless defined(&RSA_R_INVALID_KEYBITS);
    eval 'sub RSA_R_INVALID_MESSAGE_LENGTH () {131;}' unless defined(&RSA_R_INVALID_MESSAGE_LENGTH);
    eval 'sub RSA_R_INVALID_MGF1_MD () {156;}' unless defined(&RSA_R_INVALID_MGF1_MD);
    eval 'sub RSA_R_INVALID_PADDING () {138;}' unless defined(&RSA_R_INVALID_PADDING);
    eval 'sub RSA_R_INVALID_PADDING_MODE () {141;}' unless defined(&RSA_R_INVALID_PADDING_MODE);
    eval 'sub RSA_R_INVALID_PSS_PARAMETERS () {149;}' unless defined(&RSA_R_INVALID_PSS_PARAMETERS);
    eval 'sub RSA_R_INVALID_PSS_SALTLEN () {146;}' unless defined(&RSA_R_INVALID_PSS_SALTLEN);
    eval 'sub RSA_R_INVALID_SALT_LENGTH () {150;}' unless defined(&RSA_R_INVALID_SALT_LENGTH);
    eval 'sub RSA_R_INVALID_TRAILER () {139;}' unless defined(&RSA_R_INVALID_TRAILER);
    eval 'sub RSA_R_INVALID_X931_DIGEST () {142;}' unless defined(&RSA_R_INVALID_X931_DIGEST);
    eval 'sub RSA_R_IQMP_NOT_INVERSE_OF_Q () {126;}' unless defined(&RSA_R_IQMP_NOT_INVERSE_OF_Q);
    eval 'sub RSA_R_KEY_SIZE_TOO_SMALL () {120;}' unless defined(&RSA_R_KEY_SIZE_TOO_SMALL);
    eval 'sub RSA_R_LAST_OCTET_INVALID () {134;}' unless defined(&RSA_R_LAST_OCTET_INVALID);
    eval 'sub RSA_R_MODULUS_TOO_LARGE () {105;}' unless defined(&RSA_R_MODULUS_TOO_LARGE);
    eval 'sub RSA_R_NON_FIPS_RSA_METHOD () {157;}' unless defined(&RSA_R_NON_FIPS_RSA_METHOD);
    eval 'sub RSA_R_NO_PUBLIC_EXPONENT () {140;}' unless defined(&RSA_R_NO_PUBLIC_EXPONENT);
    eval 'sub RSA_R_NULL_BEFORE_BLOCK_MISSING () {113;}' unless defined(&RSA_R_NULL_BEFORE_BLOCK_MISSING);
    eval 'sub RSA_R_N_DOES_NOT_EQUAL_P_Q () {127;}' unless defined(&RSA_R_N_DOES_NOT_EQUAL_P_Q);
    eval 'sub RSA_R_OAEP_DECODING_ERROR () {121;}' unless defined(&RSA_R_OAEP_DECODING_ERROR);
    eval 'sub RSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE () {158;}' unless defined(&RSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE);
    eval 'sub RSA_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE () {148;}' unless defined(&RSA_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE);
    eval 'sub RSA_R_PADDING_CHECK_FAILED () {114;}' unless defined(&RSA_R_PADDING_CHECK_FAILED);
    eval 'sub RSA_R_P_NOT_PRIME () {128;}' unless defined(&RSA_R_P_NOT_PRIME);
    eval 'sub RSA_R_Q_NOT_PRIME () {129;}' unless defined(&RSA_R_Q_NOT_PRIME);
    eval 'sub RSA_R_RSA_OPERATIONS_NOT_SUPPORTED () {130;}' unless defined(&RSA_R_RSA_OPERATIONS_NOT_SUPPORTED);
    eval 'sub RSA_R_SLEN_CHECK_FAILED () {136;}' unless defined(&RSA_R_SLEN_CHECK_FAILED);
    eval 'sub RSA_R_SLEN_RECOVERY_FAILED () {135;}' unless defined(&RSA_R_SLEN_RECOVERY_FAILED);
    eval 'sub RSA_R_SSLV3_ROLLBACK_ATTACK () {115;}' unless defined(&RSA_R_SSLV3_ROLLBACK_ATTACK);
    eval 'sub RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD () {116;}' unless defined(&RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD);
    eval 'sub RSA_R_UNKNOWN_ALGORITHM_TYPE () {117;}' unless defined(&RSA_R_UNKNOWN_ALGORITHM_TYPE);
    eval 'sub RSA_R_UNKNOWN_MASK_DIGEST () {151;}' unless defined(&RSA_R_UNKNOWN_MASK_DIGEST);
    eval 'sub RSA_R_UNKNOWN_PADDING_TYPE () {118;}' unless defined(&RSA_R_UNKNOWN_PADDING_TYPE);
    eval 'sub RSA_R_UNKNOWN_PSS_DIGEST () {152;}' unless defined(&RSA_R_UNKNOWN_PSS_DIGEST);
    eval 'sub RSA_R_UNSUPPORTED_MASK_ALGORITHM () {153;}' unless defined(&RSA_R_UNSUPPORTED_MASK_ALGORITHM);
    eval 'sub RSA_R_UNSUPPORTED_MASK_PARAMETER () {154;}' unless defined(&RSA_R_UNSUPPORTED_MASK_PARAMETER);
    eval 'sub RSA_R_UNSUPPORTED_SIGNATURE_TYPE () {155;}' unless defined(&RSA_R_UNSUPPORTED_SIGNATURE_TYPE);
    eval 'sub RSA_R_VALUE_MISSING () {147;}' unless defined(&RSA_R_VALUE_MISSING);
    eval 'sub RSA_R_WRONG_SIGNATURE_LENGTH () {119;}' unless defined(&RSA_R_WRONG_SIGNATURE_LENGTH);
    if(defined(&__cplusplus)) {
    }
}
1;
