require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DRM_P_H_)) {
    eval 'sub _DRM_P_H_ () {1;}' unless defined(&_DRM_P_H_);
    if(defined(&_KERNEL) || defined(&__KERNEL__)) {
	require 'sys/param.ph';
	require 'sys/queue.ph';
	require 'sys/malloc.ph';
	require 'sys/pool.ph';
	require 'sys/kernel.ph';
	require 'sys/systm.ph';
	require 'sys/conf.ph';
	require 'sys/stat.ph';
	require 'sys/proc.ph';
	require 'sys/resource.ph';
	require 'sys/resourcevar.ph';
	require 'sys/mutex.ph';
	require 'sys/fcntl.ph';
	require 'sys/filio.ph';
	require 'sys/signalvar.ph';
	require 'sys/poll.ph';
	require 'sys/tree.ph';
	require 'sys/endian.ph';
	require 'sys/mman.ph';
	require 'sys/stdint.ph';
	require 'sys/agpio.ph';
	require 'sys/memrange.ph';
	require 'sys/extent.ph';
	require 'sys/vnode.ph';
	require 'uvm/uvm.ph';
	require 'dev/pci/pcidevs.ph';
	require 'dev/pci/pcivar.ph';
	require 'dev/pci/agpvar.ph';
	require 'dev/pci/vga_pcivar.ph';
	require 'machine/bus.ph';
	require './dev/pci/drm/drm_linux_list.ph';
	require './dev/pci/drm/drm.ph';
	require './dev/pci/drm/drm_mm.ph';
	require './dev/pci/drm/drm_atomic.ph';
	require './dev/pci/drm/agp.ph';
	eval 'sub DRM_DEBUGBITS_DEBUG () {0x1;}' unless defined(&DRM_DEBUGBITS_DEBUG);
	eval 'sub DRM_DEBUGBITS_KMS () {0x2;}' unless defined(&DRM_DEBUGBITS_KMS);
	eval 'sub DRM_DEBUGBITS_FAILED_IOCTL () {0x4;}' unless defined(&DRM_DEBUGBITS_FAILED_IOCTL);
	eval 'sub __OS_HAS_AGP () {( &NAGP > 0);}' unless defined(&__OS_HAS_AGP);
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	    eval 'sub __BIG_ENDIAN () {1;}' unless defined(&__BIG_ENDIAN);
	} else {
	    eval 'sub __LITTLE_ENDIAN () {1;}' unless defined(&__LITTLE_ENDIAN);
	}
	eval 'sub DRM_KERNEL_CONTEXT () {0;}' unless defined(&DRM_KERNEL_CONTEXT);
	eval 'sub DRM_RESERVED_CONTEXTS () {1;}' unless defined(&DRM_RESERVED_CONTEXTS);
	eval 'sub DRM_MAX_CTXBITMAP () {( &PAGE_SIZE * 8);}' unless defined(&DRM_MAX_CTXBITMAP);
	eval 'sub DRM_IF_VERSION {
	    my($maj, $min) = @_;
    	    eval q(($maj << 16| $min));
	}' unless defined(&DRM_IF_VERSION);
	eval 'sub DRM_CURRENTPID () { ($curproc->{p_pid});}' unless defined(&DRM_CURRENTPID);
	eval 'sub DRM_LOCK () {
	    eval q( &rw_enter_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_LOCK);
	eval 'sub DRM_UNLOCK () {
	    eval q( &rw_exit_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_UNLOCK);
	eval 'sub DRM_READLOCK () {
	    eval q( &rw_enter_read( ($dev->{dev_lock})));
	}' unless defined(&DRM_READLOCK);
	eval 'sub DRM_READUNLOCK () {
	    eval q( &rw_exit_read( ($dev->{dev_lock})));
	}' unless defined(&DRM_READUNLOCK);
	eval 'sub DRM_MAXUNITS () {8;}' unless defined(&DRM_MAXUNITS);
	eval 'sub DRM_SUSER {
	    my($p) = @_;
    	    eval q(( &suser($p, 0) == 0));
	}' unless defined(&DRM_SUSER);
	eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	eval 'sub PAGE_ALIGN {
	    my($addr) = @_;
    	    eval q(((($addr) +  &PAGE_MASK) & ~ &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	eval 'sub roundup2 {
	    my($x, $y) = @_;
    	    eval q(((($x)+(($y)-1))(~(($y)-1))));
	}' unless defined(&roundup2);
	eval 'sub jiffies_to_msecs {
	    my($x) = @_;
    	    eval q(((( &int64_t)($x)) * 1000/  &hz));
	}' unless defined(&jiffies_to_msecs);
	eval 'sub msecs_to_jiffies {
	    my($x) = @_;
    	    eval q(((( &int64_t)($x)) *  &hz / 1000));
	}' unless defined(&msecs_to_jiffies);
	eval 'sub time_after {
	    my($a,$b) = @_;
    	    eval q(( - ($a) < 0));
	}' unless defined(&time_after);
	eval 'sub time_after_eq {
	    my($a,$b) = @_;
    	    eval q(( - ($a) <= 0));
	}' unless defined(&time_after_eq);
	eval 'sub drm_msleep {
	    my($x, $msg) = @_;
    	    eval q( &delay($x * 1000));
	}' unless defined(&drm_msleep);
	eval 'sub TAILQ_CONCAT {
	    my($head1, $head2, $field) = @_;
    	    eval q( &do {  &if (! &TAILQ_EMPTY($head2)) { *($head1)-> &tqh_last = ($head2)-> &tqh_first; ($head2)-> ($tqh_first->{field}->{tqe_prev}) = ($head1)-> &tqh_last; ($head1)-> &tqh_last = ($head2)-> &tqh_last;  &TAILQ_INIT(($head2)); } }  &while (0));
	}' unless defined(&TAILQ_CONCAT);
	eval 'sub EXPORT_SYMBOL {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&EXPORT_SYMBOL);
	eval 'sub MODULE_FIRMWARE {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&MODULE_FIRMWARE);
	eval 'sub __iomem () {1;}' unless defined(&__iomem);
	eval 'sub __must_check () {1;}' unless defined(&__must_check);
	eval 'sub __init () {1;}' unless defined(&__init);
	eval 'sub ARRAY_SIZE () { &nitems;}' unless defined(&ARRAY_SIZE);
	eval 'sub DRM_ARRAY_SIZE () { &nitems;}' unless defined(&DRM_ARRAY_SIZE);
	eval 'sub DIV_ROUND_UP () { &howmany;}' unless defined(&DIV_ROUND_UP);
	eval 'sub ERESTARTSYS () { &EINTR;}' unless defined(&ERESTARTSYS);
	eval 'sub unlikely {
	    my($x) = @_;
    	    eval q( &__builtin_expect(!!($x), 0));
	}' unless defined(&unlikely);
	eval 'sub likely {
	    my($x) = @_;
    	    eval q( &__builtin_expect(!!($x), 1));
	}' unless defined(&likely);
	eval 'sub IS_ALIGNED {
	    my($x, $y) = @_;
    	    eval q(((($x) & (($y) - 1)) == 0));
	}' unless defined(&IS_ALIGNED);
	eval 'sub BUG () {
	    eval q( &do {  &panic(\\"BUG at %s:%d\\",  &__FILE__,  &__LINE__); }  &while (0));
	}' unless defined(&BUG);
	eval 'sub BUG_ON {
	    my($x) = @_;
    	    eval q( &KASSERT(!($x)));
	}' unless defined(&BUG_ON);
	eval 'sub WARN () {( &condition,  &fmt...) ({ \'int\'  &__ret = !!( &condition);  &if ( &__ret)  &printf( &fmt);  &unlikely( &__ret); });}' unless defined(&WARN);
	eval 'sub WARN_ONCE () {( &condition,  &fmt...) ({  &static \'int\'  &__warned; \'int\'  &__ret = !!( &condition);  &if ( &__ret  && ! &__warned) {  &printf( &fmt);  &__warned = 1; }  &unlikely( &__ret); });}' unless defined(&WARN_ONCE);
	eval 'sub _WARN_STR {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&_WARN_STR);
	eval 'sub WARN_ON {
	    my($condition) = @_;
    	    eval q(({ \'int\'  &__ret = !!($condition);  &if ( &__ret)  &printf(\\"WARNING %s failed at %s:%d\\\\n\\",  &_WARN_STR($condition),  &__FILE__,  &__LINE__);  &unlikely( &__ret); }));
	}' unless defined(&WARN_ON);
	eval 'sub WARN_ON_ONCE {
	    my($condition) = @_;
    	    eval q(({  &static \'int\'  &__warned; \'int\'  &__ret = !!($condition);  &if ( &__ret  && ! &__warned) {  &printf(\\"WARNING %s failed at %s:%d\\\\n\\",  &_WARN_STR($condition),  &__FILE__,  &__LINE__);  &__warned = 1; }  &unlikely( &__ret); }));
	}' unless defined(&WARN_ON_ONCE);
	eval 'sub IS_ERR_VALUE {
	    my($x) = @_;
    	    eval q( &unlikely(($x) >= - &ELAST));
	}' unless defined(&IS_ERR_VALUE);
	eval 'sub container_of {
	    my($ptr, $type, $member) = @_;
    	    eval q(({  &__typeof( (($type *)0)->$member ) * &__mptr = ($ptr); ($type *)(  &__mptr -  &offsetof($type,$member) );}));
	}' unless defined(&container_of);
	unless(defined(&__DECONST)) {
	    eval 'sub __DECONST {
	        my($type, $var) = @_;
    		eval q((($type)( &__uintptr_t)( &const  &void *)($var)));
	    }' unless defined(&__DECONST);
	}
	eval 'sub GFP_ATOMIC () { &M_NOWAIT;}' unless defined(&GFP_ATOMIC);
	eval 'sub GFP_KERNEL () {( &M_WAITOK |  &M_CANFAIL);}' unless defined(&GFP_KERNEL);
	eval 'sub __GFP_NOWARN () {0;}' unless defined(&__GFP_NOWARN);
	eval 'sub __GFP_NORETRY () {0;}' unless defined(&__GFP_NORETRY);
	eval 'sub min_t {
	    my($t, $a, $b) = @_;
    	    eval q(({ $t  &__min_a = ($a); $t  &__min_b = ($b);  &__min_a <  &__min_b ?  &__min_a :  &__min_b; }));
	}' unless defined(&min_t);
	if(defined(&__i386__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__alpha__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &alpha_wmb(););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__amd64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__powerpc__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"sync\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__sparc64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &membar( &Sync));
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
	eval 'sub smp_mb__before_atomic_dec () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__before_atomic_dec);
	eval 'sub smp_mb__after_atomic_dec () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__after_atomic_dec);
	eval 'sub smp_mb__before_atomic_inc () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__before_atomic_inc);
	eval 'sub smp_mb__after_atomic_inc () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__after_atomic_inc);
	eval 'sub DRM_COPY_TO_USER {
	    my($user, $kern, $size) = @_;
    	    eval q( &copyout($kern, $user, $size));
	}' unless defined(&DRM_COPY_TO_USER);
	eval 'sub DRM_COPY_FROM_USER {
	    my($kern, $user, $size) = @_;
    	    eval q( &copyin($user, $kern, $size));
	}' unless defined(&DRM_COPY_FROM_USER);
	eval 'sub le16_to_cpu {
	    my($x) = @_;
    	    eval q( &letoh16($x));
	}' unless defined(&le16_to_cpu);
	eval 'sub le32_to_cpu {
	    my($x) = @_;
    	    eval q( &letoh32($x));
	}' unless defined(&le32_to_cpu);
	eval 'sub cpu_to_le16 {
	    my($x) = @_;
    	    eval q( &htole16($x));
	}' unless defined(&cpu_to_le16);
	eval 'sub cpu_to_le32 {
	    my($x) = @_;
    	    eval q( &htole32($x));
	}' unless defined(&cpu_to_le32);
	eval 'sub be32_to_cpup {
	    my($x) = @_;
    	    eval q( &betoh32(*$x));
	}' unless defined(&be32_to_cpup);
	if(defined(&__macppc__)) {
	    eval 'sub of_machine_is_compatible {
	        my($model) = @_;
    		eval q({ \'char\' * &hw_prod; ( &strcmp($model,  &hw_prod) == 0); });
	    }' unless defined(&of_machine_is_compatible);
	}
	eval 'sub DRM_UDELAY {
	    my($udelay) = @_;
    	    eval q( &DELAY($udelay));
	}' unless defined(&DRM_UDELAY);
	eval 'sub udelay {
	    my($usecs) = @_;
    	    eval q({  &DELAY($usecs); });
	}' unless defined(&udelay);
	eval 'sub usleep_range {
	    my($min,$max) = @_;
    	    eval q({  &DELAY($min); });
	}' unless defined(&usleep_range);
	eval 'sub mdelay {
	    my($msecs) = @_;
    	    eval q({ \'int\'  &loops = $msecs;  &while ( &loops--)  &DELAY(1000); });
	}' unless defined(&mdelay);
	eval 'sub drm_can_sleep () {
	    eval q(( &hz & 1));
	}' unless defined(&drm_can_sleep);
	eval 'sub LOCK_TEST_WITH_RETURN {
	    my($dev, $file_priv) = @_;
    	    eval q( &do {  &if (! &_DRM_LOCK_IS_HELD( ($dev->{lock}->{hw_lock}->{lock})) ||  ($dev->{lock}->{file_priv}) != $file_priv) {  &DRM_ERROR(\\"%s called without lock held\\\\n\\",  &__FUNCTION__);  &return  &EINVAL; } }  &while (0));
	}' unless defined(&LOCK_TEST_WITH_RETURN);
	eval 'sub DRM_WAIT_ON {
	    my($ret, $queue, $lock,  $timeout, $msg, $condition ) = @_;
    	    eval q( &do {  &mtx_enter($lock);  &while (($ret) == 0) {  &if ($condition)  &break; $ret =  &msleep(($queue), ($lock),  &PZERO |  &PCATCH, ($msg), ($timeout)); }  &mtx_leave($lock); }  &while ( 0));
	}' unless defined(&DRM_WAIT_ON);
	eval 'sub DRM_ERROR () {( &fmt,  &arg...)  &printf("error: ["  &DRM_NAME ":pid%d:%s] *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&DRM_ERROR);
	eval 'sub DRM_INFO () {( &fmt,  &arg...)  &printf("drm: "  &fmt,   &arg);}' unless defined(&DRM_INFO);
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG);
	} else {
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG_KMS) if defined(&DRM_DEBUG_KMS);
	    eval 'sub DRM_DEBUG_KMS () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG_KMS);
	} else {
	    eval 'sub DRM_DEBUG_KMS () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG_KMS);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_LOG_KMS) if defined(&DRM_LOG_KMS);
	    eval 'sub DRM_LOG_KMS () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf( &fmt,   &arg); }  &while (0);}' unless defined(&DRM_LOG_KMS);
	} else {
	    eval 'sub DRM_LOG_KMS () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_LOG_KMS);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG_DRIVER) if defined(&DRM_DEBUG_DRIVER);
	    eval 'sub DRM_DEBUG_DRIVER () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG_DRIVER);
	} else {
	    eval 'sub DRM_DEBUG_DRIVER () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG_DRIVER);
	}
	eval 'sub dev_warn () {( &dev,  &fmt,  &arg...)  &do {  &DRM_ERROR( &fmt,   &arg); }  &while(0);}' unless defined(&dev_warn);
	eval 'sub dev_err () {( &dev,  &fmt,  &arg...)  &do {  &DRM_ERROR( &fmt,   &arg); }  &while(0);}' unless defined(&dev_err);
	eval 'sub dev_info () {( &dev,  &fmt,  &arg...)  &do {  &printf("%s: "  &fmt,  ($dev->{dv_xname}),   &arg); }  &while(0);}' unless defined(&dev_info);
	eval 'sub PCI_ANY_ID () {( &uint16_t) (~0);}' unless defined(&PCI_ANY_ID);
	eval("sub _DRM_DMA_USE_AGP () { 0x01; }") unless defined(&_DRM_DMA_USE_AGP);
	eval("sub _DRM_DMA_USE_SG () { 0x02; }") unless defined(&_DRM_DMA_USE_SG);
	eval 'sub DRM_ATI_GART_MAIN () {1;}' unless defined(&DRM_ATI_GART_MAIN);
	eval 'sub DRM_ATI_GART_FB () {2;}' unless defined(&DRM_ATI_GART_FB);
	eval 'sub DRM_ATI_GART_PCI () {1;}' unless defined(&DRM_ATI_GART_PCI);
	eval 'sub DRM_ATI_GART_PCIE () {2;}' unless defined(&DRM_ATI_GART_PCIE);
	eval 'sub DRM_ATI_GART_IGP () {3;}' unless defined(&DRM_ATI_GART_IGP);
	eval 'sub DRM_ATI_GART_R600 () {4;}' unless defined(&DRM_ATI_GART_R600);
	eval 'sub DMA_BIT_MASK {
	    my($n) = @_;
    	    eval q(((($n) == 64) ? ~0 : (1<<($n)) -1));
	}' unless defined(&DMA_BIT_MASK);
	eval 'sub lower_32_bits {
	    my($n) = @_;
    	    eval q((( &u32)($n)));
	}' unless defined(&lower_32_bits);
	eval 'sub upper_32_bits {
	    my($_val) = @_;
    	    eval q((( &u_int32_t)((($_val) >> 16) >> 16)));
	}' unless defined(&upper_32_bits);
	eval 'sub DRM_BUSY () {0x1;}' unless defined(&DRM_BUSY);
	eval 'sub DRM_WANTED () {0x2;}' unless defined(&DRM_WANTED);
	if(defined(&DRMLOCKDEBUG)) {
	}
	eval 'sub DRM_VBLANKTIME_RBSIZE () {2;}' unless defined(&DRM_VBLANKTIME_RBSIZE);
	eval 'sub DRM_CALLED_FROM_VBLIRQ () {1;}' unless defined(&DRM_CALLED_FROM_VBLIRQ);
	eval 'sub DRM_VBLANKTIME_SCANOUTPOS_METHOD () {(1<< 0);}' unless defined(&DRM_VBLANKTIME_SCANOUTPOS_METHOD);
	eval 'sub DRM_VBLANKTIME_INVBL () {(1<< 1);}' unless defined(&DRM_VBLANKTIME_INVBL);
	eval 'sub DRM_SCANOUTPOS_VALID () {(1<< 0);}' unless defined(&DRM_SCANOUTPOS_VALID);
	eval 'sub DRM_SCANOUTPOS_INVBL () {(1<< 1);}' unless defined(&DRM_SCANOUTPOS_INVBL);
	eval 'sub DRM_SCANOUTPOS_ACCURATE () {(1<< 2);}' unless defined(&DRM_SCANOUTPOS_ACCURATE);
	eval 'sub DRIVER_AGP () {0x1;}' unless defined(&DRIVER_AGP);
	eval 'sub DRIVER_AGP_REQUIRE () {0x2;}' unless defined(&DRIVER_AGP_REQUIRE);
	eval 'sub DRIVER_MTRR () {0x4;}' unless defined(&DRIVER_MTRR);
	eval 'sub DRIVER_DMA () {0x8;}' unless defined(&DRIVER_DMA);
	eval 'sub DRIVER_PCI_DMA () {0x10;}' unless defined(&DRIVER_PCI_DMA);
	eval 'sub DRIVER_SG () {0x20;}' unless defined(&DRIVER_SG);
	eval 'sub DRIVER_IRQ () {0x40;}' unless defined(&DRIVER_IRQ);
	eval 'sub DRIVER_GEM () {0x80;}' unless defined(&DRIVER_GEM);
	eval 'sub DRIVER_MODESET () {0x100;}' unless defined(&DRIVER_MODESET);
	require './dev/pci/drm/drm_crtc.ph';
	eval 'sub DRMDEVCF_CONSOLE () {0;}' unless defined(&DRMDEVCF_CONSOLE);
	eval 'sub drmdevcf_console () { $cf_loc[ &DRMDEVCF_CONSOLE];}' unless defined(&drmdevcf_console);
	eval 'sub DRMDEVCF_CONSOLE_UNK () {-1;}' unless defined(&DRMDEVCF_CONSOLE_UNK);
	eval("sub DMI_NONE () { 0; }") unless defined(&DMI_NONE);
	eval("sub DMI_BIOS_VENDOR () { 1; }") unless defined(&DMI_BIOS_VENDOR);
	eval("sub DMI_BIOS_VERSION () { 2; }") unless defined(&DMI_BIOS_VERSION);
	eval("sub DMI_BIOS_DATE () { 3; }") unless defined(&DMI_BIOS_DATE);
	eval("sub DMI_SYS_VENDOR () { 4; }") unless defined(&DMI_SYS_VENDOR);
	eval("sub DMI_PRODUCT_NAME () { 5; }") unless defined(&DMI_PRODUCT_NAME);
	eval("sub DMI_PRODUCT_VERSION () { 6; }") unless defined(&DMI_PRODUCT_VERSION);
	eval("sub DMI_PRODUCT_SERIAL () { 7; }") unless defined(&DMI_PRODUCT_SERIAL);
	eval("sub DMI_PRODUCT_UUID () { 8; }") unless defined(&DMI_PRODUCT_UUID);
	eval("sub DMI_BOARD_VENDOR () { 9; }") unless defined(&DMI_BOARD_VENDOR);
	eval("sub DMI_BOARD_NAME () { 10; }") unless defined(&DMI_BOARD_NAME);
	eval("sub DMI_BOARD_VERSION () { 11; }") unless defined(&DMI_BOARD_VERSION);
	eval("sub DMI_BOARD_SERIAL () { 12; }") unless defined(&DMI_BOARD_SERIAL);
	eval("sub DMI_BOARD_ASSET_TAG () { 13; }") unless defined(&DMI_BOARD_ASSET_TAG);
	eval("sub DMI_CHASSIS_VENDOR () { 14; }") unless defined(&DMI_CHASSIS_VENDOR);
	eval("sub DMI_CHASSIS_TYPE () { 15; }") unless defined(&DMI_CHASSIS_TYPE);
	eval("sub DMI_CHASSIS_VERSION () { 16; }") unless defined(&DMI_CHASSIS_VERSION);
	eval("sub DMI_CHASSIS_SERIAL () { 17; }") unless defined(&DMI_CHASSIS_SERIAL);
	eval("sub DMI_CHASSIS_ASSET_TAG () { 18; }") unless defined(&DMI_CHASSIS_ASSET_TAG);
	eval("sub DMI_STRING_MAX () { 19; }") unless defined(&DMI_STRING_MAX);
	eval 'sub DMI_MATCH {
	    my($a, $b) = @_;
    	    eval q({($a), ($b)});
	}' unless defined(&DMI_MATCH);
	eval 'sub DMI_EXACT_MATCH {
	    my($a, $b) = @_;
    	    eval q({($a), ($b)});
	}' unless defined(&DMI_EXACT_MATCH);
	eval 'sub drm_core_ioremap_wc () { &drm_core_ioremap;}' unless defined(&drm_core_ioremap_wc);
	eval 'sub drm_gem_object_reference {
	    my($obj) = @_;
    	    eval q({  &drm_ref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_reference);
	eval 'sub drm_gem_object_unreference {
	    my($obj) = @_;
    	    eval q({  &drm_unref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_unreference);
	eval 'sub drm_gem_object_unreference_unlocked {
	    my($obj) = @_;
    	    eval q({ \'struct drm_device\' * &dev =  ($obj->{dev});  &DRM_LOCK();  &drm_unref( ($obj->{u$obj}));  &DRM_UNLOCK(); });
	}' unless defined(&drm_gem_object_unreference_unlocked);
	eval 'sub DRM_PCIE_SPEED_25 () {1;}' unless defined(&DRM_PCIE_SPEED_25);
	eval 'sub DRM_PCIE_SPEED_50 () {2;}' unless defined(&DRM_PCIE_SPEED_50);
	eval 'sub DRM_PCIE_SPEED_80 () {4;}' unless defined(&DRM_PCIE_SPEED_80);
    }
}
1;
