/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executors {
    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(executor);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedScheduledExecutorService(executor);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static <T> Callable<T> callable(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter<T>(task, result);
    }

    public static Callable<Object> callable(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter<Object>(task, null);
    }

    public static Callable<Object> callable(final PrivilegedAction<?> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new Callable<Object>(){

            @Override
            public Object call() {
                return action.run();
            }
        };
    }

    public static Callable<Object> callable(final PrivilegedExceptionAction<?> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return action.run();
            }
        };
    }

    public static <T> Callable<T> privilegedCallable(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable<T>(callable);
    }

    public static <T> Callable<T> privilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader<T>(callable);
    }

    private Executors() {
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.e.execute(command);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.e.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PrivilegedCallable<T>
    implements Callable<T> {
        private final AccessControlContext acc;
        private final Callable<T> task;
        private T result;
        private Exception exception;

        PrivilegedCallable(Callable<T> task) {
            this.task = task;
            this.acc = AccessController.getContext();
        }

        @Override
        public T call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction<T>(this){
                final /* synthetic */ PrivilegedCallable this$1;
                {
                    this.this$1 = privilegedCallable;
                }

                public T run() {
                    try {
                        PrivilegedCallable.access$1(this.this$1, PrivilegedCallable.access$0(this.this$1).call());
                    }
                    catch (Exception ex) {
                        PrivilegedCallable.access$2(this.this$1, ex);
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ Callable access$0(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.task;
        }

        static /* synthetic */ void access$1(PrivilegedCallable privilegedCallable, Object object) {
            privilegedCallable.result = object;
        }

        static /* synthetic */ void access$2(PrivilegedCallable privilegedCallable, Exception exception) {
            privilegedCallable.exception = exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PrivilegedCallableUsingCurrentClassLoader<T>
    implements Callable<T> {
        private final ClassLoader ccl;
        private final AccessControlContext acc;
        private final Callable<T> task;
        private T result;
        private Exception exception;

        PrivilegedCallableUsingCurrentClassLoader(Callable<T> task) {
            this.task = task;
            this.ccl = Thread.currentThread().getContextClassLoader();
            this.acc = AccessController.getContext();
            this.acc.checkPermission(new RuntimePermission("getContextClassLoader"));
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        @Override
        public T call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction<T>(this){
                final /* synthetic */ PrivilegedCallableUsingCurrentClassLoader this$1;
                {
                    this.this$1 = privilegedCallableUsingCurrentClassLoader;
                }

                public T run() {
                    block9: {
                        ClassLoader savedcl = null;
                        Thread t = Thread.currentThread();
                        try {
                            try {
                                ClassLoader cl = t.getContextClassLoader();
                                if (PrivilegedCallableUsingCurrentClassLoader.access$0(this.this$1) != cl) {
                                    t.setContextClassLoader(PrivilegedCallableUsingCurrentClassLoader.access$0(this.this$1));
                                    savedcl = cl;
                                }
                                PrivilegedCallableUsingCurrentClassLoader.access$2(this.this$1, PrivilegedCallableUsingCurrentClassLoader.access$1(this.this$1).call());
                            }
                            catch (Exception ex) {
                                PrivilegedCallableUsingCurrentClassLoader.access$3(this.this$1, ex);
                                if (savedcl != null) {
                                    t.setContextClassLoader(savedcl);
                                }
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            if (savedcl != null) {
                                t.setContextClassLoader(savedcl);
                            }
                            throw throwable;
                        }
                        if (savedcl != null) {
                            t.setContextClassLoader(savedcl);
                        }
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ ClassLoader access$0(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.ccl;
        }

        static /* synthetic */ Callable access$1(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.task;
        }

        static /* synthetic */ void access$2(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, Object object) {
            privilegedCallableUsingCurrentClassLoader.result = object;
        }

        static /* synthetic */ void access$3(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, Exception exception) {
            privilegedCallableUsingCurrentClassLoader.exception = exception;
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext acc = AccessController.getContext();

        PrivilegedThreadFactory() {
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Thread newThread(Runnable r) {
            return super.newThread(new Runnable(this, r){
                final /* synthetic */ PrivilegedThreadFactory this$1;
                private final /* synthetic */ Runnable val$r;
                {
                    this.this$1 = privilegedThreadFactory;
                    this.val$r = runnable;
                }

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(this, this.val$r){
                        final /* synthetic */ 3 this$2;
                        private final /* synthetic */ Runnable val$r;
                        {
                            this.this$2 = var1_1;
                            this.val$r = runnable;
                        }

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.access$0(3.access$0(this.this$2)));
                            this.val$r.run();
                            return null;
                        }
                    }, PrivilegedThreadFactory.access$1(this.this$1));
                }

                static /* synthetic */ PrivilegedThreadFactory access$0(3 var0) {
                    return var0.this$1;
                }
            });
        }

        static /* synthetic */ ClassLoader access$0(PrivilegedThreadFactory privilegedThreadFactory) {
            return privilegedThreadFactory.ccl;
        }

        static /* synthetic */ AccessControlContext access$1(PrivilegedThreadFactory privilegedThreadFactory) {
            return privilegedThreadFactory.acc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RunnableAdapter<T>
    implements Callable<T> {
        final Runnable task;
        final T result;

        RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }
}

