/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleObject
implements AnnotatedElement {
    boolean flag = false;

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.flag;
    }

    public static void setAccessible(AccessibleObject[] array, boolean flag) {
        AccessibleObject.checkPermission();
        int i = 0;
        while (i < array.length) {
            array[i].secureSetAccessible(flag);
            ++i;
        }
    }

    public void setAccessible(boolean flag) {
        AccessibleObject.checkPermission();
        this.secureSetAccessible(flag);
    }

    private static void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
        }
    }

    private void secureSetAccessible(boolean flag) {
        if (flag && this instanceof Constructor && ((Constructor)this).getDeclaringClass() == Class.class) {
            throw new SecurityException("Cannot make object accessible: " + this);
        }
        this.flag = flag;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new AssertionError((Object)"Subclass must override this method");
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"Subclass must override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }
}

