/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Vector;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    static ThreadGroup root = new ThreadGroup();
    static boolean had_uncaught_exception;
    final ThreadGroup parent;
    final String name;
    private final Vector threads = new Vector();
    private Vector groups = new Vector();
    private boolean daemon_flag = false;
    private int maxpri;

    private ThreadGroup() {
        this.name = "main";
        this.parent = null;
        this.maxpri = 10;
    }

    public ThreadGroup(String name) {
        this(Thread.currentThread().group, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup(ThreadGroup parent, String name) {
        parent.checkAccess();
        this.parent = parent;
        this.name = name;
        this.maxpri = parent.maxpri;
        this.daemon_flag = parent.daemon_flag;
        ThreadGroup threadGroup = parent;
        synchronized (threadGroup) {
            if (parent.groups == null) {
                throw new IllegalThreadStateException();
            }
            parent.groups.add(this);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxpri;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public synchronized boolean isDestroyed() {
        return this.groups == null;
    }

    public final void setDaemon(boolean daemon) {
        this.checkAccess();
        this.daemon_flag = daemon;
    }

    public final synchronized void setMaxPriority(int maxpri) {
        this.checkAccess();
        if (maxpri < 1 || maxpri > 10) {
            return;
        }
        if (this.parent != null && maxpri > this.parent.maxpri) {
            maxpri = this.parent.maxpri;
        }
        this.maxpri = maxpri;
        if (this.groups == null) {
            return;
        }
        int i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).setMaxPriority(maxpri);
        }
    }

    public final boolean parentOf(ThreadGroup group) {
        while (group != null) {
            if (group == this) {
                return true;
            }
            group = group.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkAccess(this);
        }
    }

    public int activeCount() {
        int total = 0;
        if (this.groups == null) {
            return total;
        }
        int i = this.threads.size();
        while (--i >= 0) {
            if (!((Thread)this.threads.get(i)).isAlive()) continue;
            ++total;
        }
        i = this.groups.size();
        while (--i >= 0) {
            total += ((ThreadGroup)this.groups.get(i)).activeCount();
        }
        return total;
    }

    public int enumerate(Thread[] array) {
        return this.enumerate(array, 0, true);
    }

    public int enumerate(Thread[] array, boolean recurse) {
        return this.enumerate(array, 0, recurse);
    }

    public int activeGroupCount() {
        int total;
        if (this.groups == null) {
            return 0;
        }
        int i = total = this.groups.size();
        while (--i >= 0) {
            total += ((ThreadGroup)this.groups.get(i)).activeGroupCount();
        }
        return total;
    }

    public int enumerate(ThreadGroup[] array) {
        return this.enumerate(array, 0, true);
    }

    public int enumerate(ThreadGroup[] array, boolean recurse) {
        return this.enumerate(array, 0, recurse);
    }

    public final synchronized void stop() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).stop();
        }
        i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).stop();
        }
    }

    public final synchronized void interrupt() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).interrupt();
        }
        i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).interrupt();
        }
    }

    public final synchronized void suspend() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).suspend();
        }
        i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).suspend();
        }
    }

    public final synchronized void resume() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).resume();
        }
        i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).resume();
        }
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (!this.threads.isEmpty() || this.groups == null) {
            throw new IllegalThreadStateException();
        }
        int i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).destroy();
        }
        this.groups = null;
        if (this.parent != null) {
            this.parent.removeGroup(this);
        }
    }

    public void list() {
        this.list("");
    }

    public void uncaughtException(Thread thread, Throwable t) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, t);
        } else if (Thread.getDefaultUncaughtExceptionHandler() != null) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, t);
        } else if (!(t instanceof ThreadDeath)) {
            if (t == null) {
                throw new NullPointerException();
            }
            had_uncaught_exception = true;
            try {
                if (thread != null) {
                    System.err.print("Exception in thread \"" + thread.name + "\" ");
                }
                t.printStackTrace(System.err);
            }
            catch (Throwable x) {
                try {
                    System.err.println(t);
                    System.err.println("*** Got " + x + " while trying to print stack trace.");
                }
                catch (Throwable throwable) {
                    System.err.println("*** Catastrophic failure while handling uncaught exception.");
                    throw new InternalError();
                }
            }
        }
    }

    public boolean allowThreadSuspension(boolean allow) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.name + ",maxpri=" + this.maxpri + ']';
    }

    private int enumerate(Thread[] list2, int next, boolean recurse) {
        this.checkAccess();
        if (this.groups == null) {
            return next;
        }
        int i = this.threads.size();
        while (--i >= 0 && next < list2.length) {
            Thread t = (Thread)this.threads.get(i);
            if (!t.isAlive()) continue;
            list2[next++] = t;
        }
        if (recurse) {
            i = this.groups.size();
            while (--i >= 0 && next < list2.length) {
                ThreadGroup g = (ThreadGroup)this.groups.get(i);
                next = g.enumerate(list2, next, true);
            }
        }
        return next;
    }

    private int enumerate(ThreadGroup[] list2, int next, boolean recurse) {
        this.checkAccess();
        if (this.groups == null) {
            return next;
        }
        int i = this.groups.size();
        while (--i >= 0 && next < list2.length) {
            ThreadGroup g = (ThreadGroup)this.groups.get(i);
            list2[next++] = g;
            if (!recurse || next == list2.length) continue;
            next = g.enumerate(list2, next, true);
        }
        return next;
    }

    private void list(String indentation) {
        if (this.groups == null) {
            return;
        }
        System.out.println(String.valueOf(indentation) + this);
        indentation = String.valueOf(indentation) + "    ";
        int i = this.threads.size();
        while (--i >= 0) {
            System.out.println(String.valueOf(indentation) + this.threads.get(i));
        }
        i = this.groups.size();
        while (--i >= 0) {
            ((ThreadGroup)this.groups.get(i)).list(indentation);
        }
    }

    final synchronized void addThread(Thread t) {
        if (this.groups == null) {
            throw new IllegalThreadStateException("ThreadGroup is destroyed");
        }
        this.threads.add(t);
    }

    final synchronized void removeThread(Thread t) {
        if (this.groups == null) {
            return;
        }
        this.threads.remove(t);
        t.group = null;
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            this.groups = null;
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
        }
    }

    final synchronized void removeGroup(ThreadGroup g) {
        this.groups.remove(g);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            this.groups = null;
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
        }
    }

    static Thread getThreadFromId(long id) {
        return root.getThreadFromIdImpl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThreadFromIdImpl(long id) {
        Vector vector = this.threads;
        synchronized (vector) {
            int i = 0;
            while (i < this.threads.size()) {
                Thread t = (Thread)this.threads.get(i);
                if (t.getId() == id) {
                    return t;
                }
                ++i;
            }
        }
        Vector groups = this.groups;
        if (groups != null) {
            Vector vector2 = groups;
            synchronized (vector2) {
                int i = 0;
                while (i < groups.size()) {
                    ThreadGroup g = (ThreadGroup)groups.get(i);
                    Thread t = g.getThreadFromIdImpl(id);
                    if (t != null) {
                        return t;
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

