/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGImageReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PNGImageReaderSpi
extends ImageReaderSpi {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final String VENDOR_NAME = "GNU";
    static final String VERSION = "1.0";
    static final String READER_CLASSNAME = "gnu.javax.imageio.png.PNGImageReader";
    static final String[] NAMES = new String[]{"Portable Network Graphics"};
    static final String[] SUFFIXES = new String[]{".png", ".PNG"};
    static final String[] MIME_TYPES = new String[]{"image/png"};
    static final String[] WRITER_SPI_NAMES = new String[]{"gnu.javax.imageio.png.PNGWriterSpi"};
    static final Class[] INPUT_TYPES = new Class[]{InputStream.class, ImageInputStream.class};

    public PNGImageReaderSpi() {
        super(VENDOR_NAME, VERSION, NAMES, SUFFIXES, MIME_TYPES, READER_CLASSNAME, INPUT_TYPES, WRITER_SPI_NAMES, false, null, null, null, null, false, null, null, null, null);
    }

    public boolean canDecodeInput(Object source) throws IOException {
        boolean canDecode = false;
        if (source instanceof ImageInputStream) {
            ImageInputStream in = (ImageInputStream)source;
            in.mark();
            canDecode = true;
            int i = 0;
            while (i < SIGNATURE.length && canDecode) {
                byte sig = (byte)in.read();
                if (sig != SIGNATURE[i]) {
                    canDecode = false;
                }
                ++i;
            }
            in.reset();
        }
        return canDecode;
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new PNGImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "Portable Network Graphics";
    }
}

