/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class SignerInfo {
    private static final Logger log = Logger.getLogger(SignerInfo.class.getName());
    private final BigInteger version;
    private final BigInteger serialNumber;
    private final X500Principal issuer;
    private final OID digestAlgorithmId;
    private final byte[] digestAlgorithmParams;
    private final byte[] authenticatedAttributes;
    private final OID digestEncryptionAlgorithmId;
    private final byte[] digestEncryptionAlgorithmParams;
    private final byte[] encryptedDigest;
    private final byte[] unauthenticatedAttributes;

    public SignerInfo(BERReader ber) throws IOException {
        DERValue val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfo");
        }
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("malformed Version");
        }
        this.version = (BigInteger)val.getValue();
        log.fine("  Version: " + this.version);
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed IssuerAndSerialNumber");
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed Issuer");
        }
        this.issuer = new X500Principal(val.getEncoded());
        ber.skip(val.getLength());
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("malformed SerialNumber");
        }
        this.serialNumber = (BigInteger)val.getValue();
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifier");
        }
        DERValue val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestAlgorithmId = (OID)val2.getValue();
        if (BERValue.isIndefinite(val)) {
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                this.digestAlgorithmParams = val2.getEncoded();
                val2 = ber.read();
                if (val2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestAlgorithmParams = null;
            }
        } else if (val2.getEncodedLength() < val.getLength()) {
            val2 = ber.read();
            this.digestAlgorithmParams = val2.getEncoded();
            if (val2.isConstructed()) {
                ber.skip(val2.getLength());
            }
        } else {
            this.digestAlgorithmParams = null;
        }
        if ((val = ber.read()).getTag() == 0) {
            this.authenticatedAttributes = val.getEncoded();
            val = ber.read();
            if (val.isConstructed()) {
                ber.skip(val.getLength());
            }
            val = ber.read();
        } else {
            this.authenticatedAttributes = null;
        }
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestEncryptionAlgorithmIdentifier");
        }
        val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestEncryptionAlgorithmId = (OID)val2.getValue();
        if (BERValue.isIndefinite(val)) {
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                this.digestEncryptionAlgorithmParams = val2.getEncoded();
                val2 = ber.read();
                if (val2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestEncryptionAlgorithmParams = null;
            }
        } else if (val2.getEncodedLength() < val.getLength()) {
            val2 = ber.read();
            this.digestEncryptionAlgorithmParams = val2.getEncoded();
            if (val2.isConstructed()) {
                ber.skip(val2.getLength());
            }
        } else {
            this.digestEncryptionAlgorithmParams = null;
        }
        if ((val = ber.read()).getTag() != 4) {
            throw new BEREncodingException("malformed EncryptedDigest");
        }
        this.encryptedDigest = (byte[])val.getValue();
        this.unauthenticatedAttributes = (byte[])(ber.peek() == 1 ? ber.read().getEncoded() : null);
        if (ber.peek() == 0) {
            ber.read();
        }
    }

    public SignerInfo(X500Principal issuer, BigInteger serialNumber, OID digestAlgorithmOID, byte[] authenticatedAttributes, OID digestEncryptionAlgorithmOID, byte[] encryptedDigest, byte[] unauthenticatedAttributes) {
        this.version = BigInteger.ONE;
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        this.digestAlgorithmId = digestAlgorithmOID;
        this.digestAlgorithmParams = null;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digestEncryptionAlgorithmId = digestEncryptionAlgorithmOID;
        this.digestEncryptionAlgorithmParams = null;
        this.encryptedDigest = encryptedDigest;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public OID getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public byte[] getDigestAlgorithmParams() {
        return this.digestAlgorithmParams != null ? (byte[])this.digestAlgorithmParams.clone() : null;
    }

    public byte[] getAuthenticatedAttributes() {
        return this.authenticatedAttributes != null ? (byte[])this.authenticatedAttributes.clone() : null;
    }

    public OID getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getDigestEncryptionAlgorithmParams() {
        return this.digestEncryptionAlgorithmParams != null ? (byte[])this.digestEncryptionAlgorithmParams.clone() : null;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest != null ? (byte[])this.encryptedDigest.clone() : null;
    }

    public byte[] getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes != null ? (byte[])this.unauthenticatedAttributes.clone() : null;
    }

    public void encode(OutputStream out) throws IOException {
        DERValue derVersion = new DERValue(2, this.version);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        baos.write(this.issuer.getEncoded());
        DERValue derSerialNumber = new DERValue(2, this.serialNumber);
        DERWriter.write(baos, derSerialNumber);
        baos.flush();
        byte[] b = baos.toByteArray();
        DERValue derIssuerAndSerialNumber = new DERValue(48, b.length, b, null);
        DERValue derDigestAlgorithmOID = new DERValue(6, this.digestAlgorithmId);
        ArrayList<DERValue> digestAlgorithmIdentifier = new ArrayList<DERValue>(1);
        digestAlgorithmIdentifier.add(derDigestAlgorithmOID);
        DERValue derDigestAlgorithmIdentifier = new DERValue(48, digestAlgorithmIdentifier);
        if (this.authenticatedAttributes == null) {
            new DERValue(5, null);
        } else {
            new DERValue(49, this.authenticatedAttributes);
        }
        DERValue derDigestEncryptionAlgorithmOID = new DERValue(6, this.digestEncryptionAlgorithmId);
        ArrayList<DERValue> digestEncryptionAlgorithmIdentifier = new ArrayList<DERValue>(1);
        digestEncryptionAlgorithmIdentifier.add(derDigestEncryptionAlgorithmOID);
        DERValue derDigestEncryptionAlgorithmIdentifier = new DERValue(48, digestEncryptionAlgorithmIdentifier);
        DERValue derEncryptedDigest = new DERValue(4, this.encryptedDigest);
        if (this.unauthenticatedAttributes == null) {
            new DERValue(5, null);
        } else {
            new DERValue(49, this.unauthenticatedAttributes);
        }
        ArrayList<DERValue> signerInfo = new ArrayList<DERValue>(5);
        signerInfo.add(derVersion);
        signerInfo.add(derIssuerAndSerialNumber);
        signerInfo.add(derDigestAlgorithmIdentifier);
        signerInfo.add(derDigestEncryptionAlgorithmIdentifier);
        signerInfo.add(derEncryptedDigest);
        DERValue derSignerInfo = new DERValue(48, signerInfo);
        DERWriter.write(out, derSignerInfo);
    }
}

