# $Id: print-resources.bro 1735 2005-11-18 00:23:06Z vern $

# Logs Bro resource usage information upon termination.

@load notice

redef enum Notice += {
	ResourceSummary,        # Notice stype for this event
};
 
event bro_done()
	{
	local res = resource_usage();
	
	NOTICE([$note=ResourceSummary,
		$msg=fmt("elapsed time = %s, total CPU = %s, maximum memory = %d KB, peak connections = %d, peak timers = %d, peak fragments = %d",
		res$real_time, res$user_time + res$system_time,
		res$mem / 1024,
		res$max_TCP_conns + res$max_UDP_conns + res$max_ICMP_conns,
		res$max_timers, res$max_fragments)]);
	}
