/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

class SequenceToRegex4SDF {
    final char c;
    int occurrences;

    public SequenceToRegex4SDF(char c) {
        this.c = c;
        this.occurrences = 1;
    }

    void inc() {
        ++this.occurrences;
    }

    String toRegex() {
        switch (this.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (this.occurrences >= 3) {
                    return ".*";
                }
                return this.number(this.occurrences);
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(this.occurrences);
            }
            case 'E': {
                return ".{2,12}";
            }
            case 'a': {
                return ".{2}";
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (this.occurrences == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (this.occurrences == 1) {
            return "" + this.c;
        }
        return this.c + "{" + this.occurrences + "}";
    }

    public String toString() {
        return this.c + "(" + this.occurrences + ")";
    }

    private String number(int occurences) {
        return "\\d{" + this.occurrences + "}";
    }
}

