/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ComponentInputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

class KeyboardManager {
    static KeyboardManager manager = new KeyboardManager();
    WeakHashMap topLevelLookup = new WeakHashMap();
    Hashtable menuBarLookup = new Hashtable();

    KeyboardManager() {
    }

    public static KeyboardManager getManager() {
        return manager;
    }

    static Container findTopLevel(Component c) {
        Container topLevel = c instanceof Container ? (Container)c : c.getParent();
        while (!(topLevel == null || topLevel instanceof Window || topLevel instanceof Applet || topLevel instanceof JInternalFrame)) {
            topLevel = topLevel.getParent();
        }
        return topLevel;
    }

    Hashtable getHashtableForTopLevel(Container c) {
        Hashtable keyToComponent = (Hashtable)this.topLevelLookup.get(c);
        if (keyToComponent == null) {
            keyToComponent = new Hashtable();
            this.topLevelLookup.put(c, keyToComponent);
        }
        return keyToComponent;
    }

    public void registerBinding(JComponent comp, KeyStroke key) {
        Container topLevel = KeyboardManager.findTopLevel(comp);
        if (topLevel == null) {
            return;
        }
        Hashtable keyToComponent = this.getHashtableForTopLevel(topLevel);
        keyToComponent.put(key, comp);
    }

    public void clearBindingsForComp(JComponent comp) {
        Container topLevel = KeyboardManager.findTopLevel(comp);
        if (topLevel == null) {
            return;
        }
        Hashtable keyToComponent = this.getHashtableForTopLevel(topLevel);
        Enumeration keys = keyToComponent.keys();
        while (keys.hasMoreElements()) {
            Object temp = keys.nextElement();
            if (comp != (JComponent)keyToComponent.get(temp)) continue;
            keyToComponent.remove(temp);
        }
    }

    public void registerEntireMap(ComponentInputMap map) {
        if (map == null) {
            return;
        }
        JComponent comp = map.getComponent();
        KeyStroke[] keys = map.allKeys();
        if (keys == null) {
            return;
        }
        Container topLevel = KeyboardManager.findTopLevel(comp);
        if (topLevel == null) {
            return;
        }
        Hashtable keyToComponent = this.getHashtableForTopLevel(topLevel);
        int i = 0;
        while (i < keys.length) {
            keyToComponent.put(keys[i], comp);
            ++i;
        }
    }

    public boolean processKeyStroke(Component comp, KeyStroke key, KeyEvent e) {
        boolean pressed = e.getID() == 401;
        Container topLevel = KeyboardManager.findTopLevel(comp);
        if (topLevel == null) {
            return false;
        }
        Hashtable keyToComponent = this.getHashtableForTopLevel(topLevel);
        keyToComponent.keys();
        JComponent target = (JComponent)keyToComponent.get(key);
        if (target != null && target.processKeyBinding(key, e, 2, pressed)) {
            return true;
        }
        Vector menuBars = this.getVectorForTopLevel(topLevel);
        int i = 0;
        while (i < menuBars.size()) {
            if (((JMenuBar)menuBars.elementAt(i)).processKeyBinding(key, e, 2, pressed)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Vector getVectorForTopLevel(Container c) {
        Vector result = (Vector)this.menuBarLookup.get(c);
        if (result == null) {
            result = new Vector();
            this.menuBarLookup.put(c, result);
        }
        return result;
    }

    public void registerJMenuBar(JMenuBar menuBar) {
        Container topLevel = KeyboardManager.findTopLevel(menuBar);
        Vector menuBars = this.getVectorForTopLevel(topLevel);
        if (!menuBars.contains(menuBar)) {
            menuBars.add(menuBar);
        }
    }

    public void unregisterJMenuBar(JMenuBar menuBar) {
        Container topLevel = KeyboardManager.findTopLevel(menuBar);
        Vector menuBars = this.getVectorForTopLevel(topLevel);
        if (menuBars.contains(menuBar)) {
            menuBars.remove(menuBar);
        }
    }
}

