/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

class CipherAdapter
extends CipherSpi {
    protected IBlockCipher cipher;
    protected IMode mode;
    protected IPad pad;
    protected int keyLen;
    protected Map attributes;
    protected byte[] partBlock;
    protected int partLen;
    protected int blockLen;

    protected CipherAdapter(String cipherName, int blockLen) {
        this.cipher = CipherFactory.getInstance(cipherName);
        this.attributes = new HashMap();
        this.blockLen = blockLen;
        this.mode = ModeFactory.getInstance("ECB", this.cipher, blockLen);
        this.attributes.put("gnu.crypto.cipher.block.size", blockLen);
    }

    protected CipherAdapter(String cipherName) {
        this.cipher = CipherFactory.getInstance(cipherName);
        this.blockLen = this.cipher.defaultBlockSize();
        this.attributes = new HashMap();
        this.mode = ModeFactory.getInstance("ECB", this.cipher, this.blockLen);
        this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
    }

    protected void engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (modeName.length() >= 3 && modeName.substring(0, 3).equalsIgnoreCase("CFB")) {
            if (modeName.length() > 3) {
                try {
                    int bs = Integer.parseInt(modeName.substring(3));
                    this.attributes.put("gnu.crypto.mode.block.size", bs / 8);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException(modeName);
                }
                modeName = "CFB";
            }
        } else {
            this.attributes.remove("gnu.crypto.mode.block.size");
        }
        this.mode = ModeFactory.getInstance(modeName, this.cipher, this.blockLen);
        if (this.mode == null) {
            throw new NoSuchAlgorithmException(modeName);
        }
    }

    protected void engineSetPadding(String padName) throws NoSuchPaddingException {
        if (padName.equalsIgnoreCase("NoPadding")) {
            this.pad = null;
            return;
        }
        this.pad = PadFactory.getInstance(padName);
        if (this.pad == null) {
            throw new NoSuchPaddingException(padName);
        }
    }

    protected int engineGetBlockSize() {
        if (this.cipher != null) {
            return this.blockLen;
        }
        return 0;
    }

    protected int engineGetOutputSize(int inputLen) {
        int blockSize = this.mode.currentBlockSize();
        return (inputLen + this.partLen) / blockSize * blockSize;
    }

    protected byte[] engineGetIV() {
        byte[] iv = (byte[])this.attributes.get("gnu.crypto.mode.iv");
        if (iv == null) {
            return null;
        }
        return (byte[])iv.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params;
        byte[] iv = (byte[])this.attributes.get("gnu.crypto.mode.iv");
        int cipherBlockSize = this.cipher.currentBlockSize();
        BlockCipherParameterSpec spec = new BlockCipherParameterSpec(iv, cipherBlockSize, this.keyLen);
        try {
            params = AlgorithmParameters.getInstance("BlockCipherParameters");
            params.init(spec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        return params;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    private void engineInitHandler(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        switch (opmode) {
            case 1: {
                this.attributes.put("gnu.crypto.mode.state", 1);
                break;
            }
            case 2: {
                this.attributes.put("gnu.crypto.mode.state", 2);
            }
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("bad key format " + key.getFormat());
        }
        byte[] kb = key.getEncoded();
        int kbLength = kb.length;
        if (this.keyLen == 0) {
            Iterator it = this.cipher.keySizes();
            while (it.hasNext()) {
                int aKeySize = (Integer)it.next();
                if (aKeySize == kbLength) {
                    this.keyLen = aKeySize;
                    break;
                }
                if (aKeySize >= kbLength) break;
                this.keyLen = aKeySize;
            }
        }
        if (this.keyLen == 0) {
            this.keyLen = kbLength;
        }
        if (this.keyLen < kbLength) {
            byte[] kbb = kb;
            kb = new byte[this.keyLen];
            System.arraycopy(kbb, 0, kb, 0, this.keyLen);
        }
        this.attributes.put("gnu.crypto.cipher.key.material", kb);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            if (!this.mode.name().toLowerCase().startsWith("ecb(")) {
                switch (opmode) {
                    case 1: 
                    case 3: {
                        byte[] iv = new byte[this.blockLen];
                        random.nextBytes(iv);
                        this.attributes.put("gnu.crypto.mode.iv", iv);
                        break;
                    }
                    default: {
                        throw new InvalidAlgorithmParameterException("Required algorithm parameters are missing for mode: " + this.mode.name());
                    }
                }
            }
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.keyLen = 0;
        } else if (params instanceof BlockCipherParameterSpec) {
            BlockCipherParameterSpec bcps = (BlockCipherParameterSpec)params;
            this.blockLen = bcps.getBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.attributes.put("gnu.crypto.mode.iv", bcps.getIV());
            this.keyLen = bcps.getKeySize();
        } else if (params instanceof IvParameterSpec) {
            if (((IvParameterSpec)params).getIV().length != this.cipher.defaultBlockSize()) {
                throw new InvalidAlgorithmParameterException();
            }
            this.attributes.put("gnu.crypto.mode.iv", ((IvParameterSpec)params).getIV());
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.keyLen = 0;
        }
        this.engineInitHandler(opmode, key, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        BlockCipherParameterSpec spec = null;
        try {
            if (params != null) {
                spec = params.getParameterSpec(BlockCipherParameterSpec.class);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        this.engineInit(opmode, key, spec, random);
    }

    protected byte[] engineUpdate(byte[] input, int inOff, int inLen) {
        if (inLen == 0) {
            return new byte[0];
        }
        int blockSize = this.mode.currentBlockSize();
        int blockCount = (this.partLen + inLen) / blockSize;
        if (this.pad != null && (Integer)this.attributes.get("gnu.crypto.mode.state") == 2 && (this.partLen + inLen) % blockSize == 0) {
            --blockCount;
        }
        byte[] out = new byte[blockCount * blockSize];
        try {
            this.engineUpdate(input, inOff, inLen, out, 0);
        }
        catch (ShortBufferException x) {
            x.printStackTrace(System.err);
        }
        return out;
    }

    protected int engineUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
        byte[] buf;
        int result;
        if (inLen == 0) {
            return 0;
        }
        int blockSize = this.mode.currentBlockSize();
        int blockCount = (this.partLen + inLen) / blockSize;
        if (this.pad != null && (Integer)this.attributes.get("gnu.crypto.mode.state") == 2 && (this.partLen + inLen) % blockSize == 0) {
            --blockCount;
        }
        if ((result = blockCount * blockSize) > out.length - outOff) {
            throw new ShortBufferException();
        }
        if (blockCount == 0) {
            System.arraycopy(in, inOff, this.partBlock, this.partLen, inLen);
            this.partLen += inLen;
            return 0;
        }
        if (this.partLen == 0) {
            buf = in;
        } else {
            buf = new byte[this.partLen + inLen];
            System.arraycopy(this.partBlock, 0, buf, 0, this.partLen);
            if (in != null && inLen > 0) {
                System.arraycopy(in, inOff, buf, this.partLen, inLen);
            }
            inOff = 0;
        }
        int i = 0;
        while (i < blockCount) {
            this.mode.update(buf, inOff, out, outOff);
            inOff += blockSize;
            outOff += blockSize;
            ++i;
        }
        this.partLen += inLen - result;
        if (this.partLen > 0) {
            System.arraycopy(buf, inOff, this.partBlock, 0, this.partLen);
        }
        return result;
    }

    protected byte[] engineDoFinal(byte[] input, int off, int len) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result;
        block11: {
            byte[] buf;
            block10: {
                buf = this.engineUpdate(input, off, len);
                if (this.pad == null) break block10;
                switch ((Integer)this.attributes.get("gnu.crypto.mode.state")) {
                    case 1: {
                        byte[] padding = this.pad.pad(this.partBlock, 0, this.partLen);
                        byte[] buf2 = this.engineUpdate(padding, 0, padding.length);
                        result = new byte[buf.length + buf2.length];
                        System.arraycopy(buf, 0, result, 0, buf.length);
                        System.arraycopy(buf2, 0, result, buf.length, buf2.length);
                        break block11;
                    }
                    case 2: {
                        int padLen;
                        byte[] buf3 = new byte[buf.length + this.partLen];
                        try {
                            if (this.partLen != this.mode.currentBlockSize()) {
                                throw new WrongPaddingException();
                            }
                            System.arraycopy(buf, 0, buf3, 0, buf.length);
                            this.mode.update(this.partBlock, 0, buf3, buf.length);
                            padLen = this.pad.unpad(buf3, 0, buf3.length);
                        }
                        catch (WrongPaddingException wpe) {
                            throw new BadPaddingException(wpe.getMessage());
                        }
                        result = new byte[buf3.length - padLen];
                        System.arraycopy(buf3, 0, result, 0, result.length);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this.partLen > 0) {
                throw new IllegalBlockSizeException(String.valueOf(this.partLen) + " trailing bytes");
            }
            result = buf;
        }
        try {
            this.reset();
        }
        catch (InvalidKeyException ike) {
            throw new Error(ike);
        }
        return result;
    }

    protected int engineDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] buf = this.engineDoFinal(in, inOff, inLen);
        if (out.length + outOff < buf.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(buf, 0, out, outOff, buf.length);
        return buf.length;
    }

    private void reset() throws InvalidKeyException {
        this.mode.reset();
        this.mode.init(this.attributes);
        if (this.pad != null) {
            this.pad.reset();
            this.pad.init(this.blockLen);
        }
        this.partBlock = new byte[this.blockLen];
        this.partLen = 0;
    }
}

