/***************************************************************************
                           platform.h  -  description
                             -------------------
    begin                : Thu Jun 5 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PLATFORM_H_
#define _PLATFORM_H_

/**
  *@author Mathias Kster
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 * WIN32
 */
#ifdef WIN32
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <sys/timeb.h>
#endif

#ifdef WIN32
extern "C" {
int gettimeofday(struct timeval *tp, void * );
}

/* struct dirent - same as Unix */
struct dirent {
	long d_ino; /* inode (always 1 in WIN32) */
	off_t d_off; /* offset to this dirent */
	unsigned short d_reclen; /* length of d_name */
	char d_name[_MAX_FNAME+1]; /* filename (null terminated) */
};

/* typedef DIR - not the same as Unix */
typedef struct {
	long handle; /* _findfirst/_findnext handle */
	short offset; /* offset into directory */
	short finished; /* 1 if there are not more files */
	struct _finddata_t fileinfo; /* from _findfirst/_findnext */
	char *dir; /* the dir we are reading */
	struct dirent dent; /* the dirent to return */
} DIR;

/* Function prototypes */
DIR * opendir(const char *);
struct dirent * readdir(DIR *);
int closedir(DIR *);

#endif

/*
 *  lrint stuff 
 */
#ifndef HAVE_LRINT
 #include <math.h> 
 #define lrint(flt)   ((int) (flt)) 
#endif

#endif
