# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>
#          Philippe Normand <philippe@fluendo.com>

from elisa.core.utils.bindable import Bindable

class Model(Bindable):

    """
    A model is a data representation of a resource requested with a C{uri}.

    This one is just a general meta class, don't use it directly but create
    your own class inheriting from this one.

    *Conventions*:
     - the classname of a model should always end with 'Model' (e.g.
       AlbumModel or TrackModel).
     - all models inherit (directly or indirectly) from this model
     - the data fields of a model are set to C{None} at initialization time
     - list fields are set to an empty list at initialization time

    A model is a L{elisa.core.utils.bindable.Bindable} so that everyone can be
    informed about changes with this system (especially interesting for UIs).

    @ivar default_action: Default action for this item instance.
                          This should be set at the time of passing a model to
                          a controller.
                          None means the default action of the controller
                          should be used.
    @type default_action: C{elisa.core.action.ContextualAction} 
    @ivar extra_actions: Extra actions for this item instance.
                         This should be set at the time of passing a model to
                         a controller.  None means the extra actions specified
                         by the controller should be used.
    @type extra_actions: C{list} of C{elisa.core.action.ContextualAction} 
    """

    # FIXME: this is not a component, it should be moved to elisa.core

    def __init__(self, *args, **kw):
        super(Model, self).__init__(*args, **kw)
        self.default_action = None
        self.extra_actions = None

