# - Try to find the Taglib library
# Once done this will define
#
#  TAGLIB_FOUND - system has the taglib library
#  TAGLIB_CFLAGS - the taglib cflags
#  TAGLIB_LIBRARIES - The libraries needed to use taglib

# Copyright (c) 2006, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

find_package(PkgConfig)
include(FindLibraryWithDebug)
include(FindPackageHandleStandardArgs)

if(NOT TAGLIB_MIN_VERSION)
  set(TAGLIB_MIN_VERSION "1.4")
endif(NOT TAGLIB_MIN_VERSION)

pkg_check_modules(PC_TAGLIB taglib>=${TAGLIB_MIN_VERSION})

find_path(TAGLIB_INCLUDES
    NAMES
    tag.h
    PATH_SUFFIXES taglib
    HINTS ${PC_TAGLIB_INCLUDE_DIRS}
    )

find_library_with_debug(TAGLIB_LIBRARY
    WIN32_DEBUG_POSTFIX d
    NAMES tag
    HINTS ${PC_TAGLIB_LIBRARY_DIRS}
    )

set(TAGLIB_LIBRARIES     ${TAGLIB_LIBRARY})
set(TAGLIB_INCLUDE_DIRS  ${TAGLIB_INCLUDES})
  
find_package_handle_standard_args(Taglib DEFAULT_MSG 
                                  TAGLIB_INCLUDE_DIRS TAGLIB_LIBRARIES)
