#!/bin/sh
echo 'name: transformers
version: 0.3.0.0
id: transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1

license: BSD3
copyright:
maintainer: Ross Paterson <ross@soi.city.ac.uk>
stability:
homepage:
package-url:
synopsis: Concrete functor and monad transformers
description: A portable library of functor and monad transformers, inspired by
             the paper \"Functional Programming with Overloading and Higher-Order
             Polymorphism\", by Mark P Jones,
             in /Advanced School of Functional Programming/, 1995
             (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
             .
             This package contains:
             .
             * the monad transformer class (in "Control.Monad.Trans.Class")
             .
             * concrete functor and monad transformers, each with associated
             operations and functions to lift operations associated with other
             transformers.
             .
             It can be used on its own in portable Haskell code, or with the monad
             classes in the @mtl@ or @monads-tf@ packages, which automatically
             lift operations introduced by monad transformers through other
             transformers.
category: Control
author: Andy Gill, Ross Paterson
pkgpath: devel/hs-transformers
exposed: True
exposed-modules: Control.Applicative.Backwards
                 Control.Applicative.Lift Control.Monad.IO.Class
                 Control.Monad.Trans.Class Control.Monad.Trans.Cont
                 Control.Monad.Trans.Error Control.Monad.Trans.Identity
                 Control.Monad.Trans.List Control.Monad.Trans.Maybe
                 Control.Monad.Trans.Reader Control.Monad.Trans.RWS
                 Control.Monad.Trans.RWS.Lazy Control.Monad.Trans.RWS.Strict
                 Control.Monad.Trans.State Control.Monad.Trans.State.Lazy
                 Control.Monad.Trans.State.Strict Control.Monad.Trans.Writer
                 Control.Monad.Trans.Writer.Lazy Control.Monad.Trans.Writer.Strict
                 Data.Functor.Compose Data.Functor.Constant Data.Functor.Identity
                 Data.Functor.Product Data.Functor.Reverse
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/transformers-0.3.0.0
library-dirs: /usr/local/lib/ghc/transformers-0.3.0.0
hs-libraries: HStransformers-0.3.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-transformers-0.3.0.0/html/transformers.haddock
haddock-html: /usr/local/share/doc/hs-transformers-0.3.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
