#!/bin/sh
echo 'name: hackage-db
version: 1.4
id: hackage-db-1.4-d60c8c7ad811e1904cd65fdcc57defb8

license: BSD3
copyright: Peter Simons
maintainer: Peter Simons <simons@cryp.to>
stability:
homepage: http://github.com/peti/hackage-db
package-url:
synopsis: provide access to the Hackage database via Data.Map
description: This module provides simple access to the Hackage database by means
             of @Data.Map@. Suppose you wanted to implement a utility that queries
             the set of available versions for a given package, the following
             program would do the trick:
             .
             > import qualified Distribution.Hackage.DB as DB
             > import Distribution.Text ( display )
             > import System.Environment ( getArgs )
             >
             > main :: IO ()
             > main = do
             >   pkgs <- getArgs
             >   db <- DB.readHackage
             >   let getVersions name = maybe [] DB.keys (DB.lookup name db)
             >   mapM_ (putStrLn . unwords . map display . getVersions) pkgs
             .
             When run, it would produce the following output:
             .
             > ./a.out containers deepseq cabal-install
             > 0.1.0.0 0.1.0.1 0.2.0.0 0.2.0.1 0.3.0.0 0.4.0.0
             > 1.0.0.0 1.1.0.0 1.1.0.1 1.1.0.2
             > 0.4.0 0.5.0 0.5.1 0.5.2 0.6.0 0.6.2 0.6.4 0.8.0 0.8.2 0.10.0 0.10.2
             .
             Note that once the database has been parsed, it can be accessed
             quickly, but the inital cost of reading @00-index.tar@ is fairly
             high.
category: Distribution
author: Peter Simons <simons@cryp.to>
pkgpath: databases/hs-hackage-db
exposed: True
exposed-modules: Distribution.Hackage.DB
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-db-1.4
library-dirs: /usr/local/lib/ghc/hackage-db-1.4
hs-libraries: HShackage-db-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: Cabal-1.16.0-f5c62e9a86cba75810b9f23015a4cd98
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         directory-1.2.0.1-8ba84e5bc37997efd0921897c80d9454
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         tar-0.4.0.1-29280e26861b726fd73255cd0750529f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hackage-db-1.4/html/hackage-db.haddock
haddock-html: /usr/local/share/doc/hs-hackage-db-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
