#!/bin/sh
echo 'name: Crypto
version: 4.2.5.1
id: Crypto-4.2.5.1-1bf1ceb36f33c724888dd3108363d918

license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
homepage:
package-url:
synopsis: Collects together existing Haskell cryptographic functions into a package
description: DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
             Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
             Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
             with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
pkgpath: security/hs-crypto
exposed: True
exposed-modules: Codec.Binary.BubbleBabble Codec.Encryption.RSA
                 Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
                 Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
                 Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
                 Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
                 Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
                 Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
                 Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
hs-libraries: HSCrypto-4.2.5.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-037d72e94f82e21ad0efc3a3ca13d5e2
         QuickCheck-2.6-8d97cb4b7078515f65815e652f272dfb
         array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         pretty-1.1.1.0-2de27f83b2c1c65d629a564e9e01b27d
         random-1.0.1.1-e63672c93ea60d4fa26e4b5c7949f935
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5.1/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
