#!/bin/sh
echo 'name: atom
version: 1.0.9
id: atom-1.0.9-b7c9790b36e935331097e788b224be8b

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
synopsis: A DSL for embedded hard realtime applications.
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit Language.Atom.UeMap
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/atom-1.0.9
library-dirs: /usr/local/lib/ghc/atom-1.0.9
hs-libraries: HSatom-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bimap-0.2.4-d5d3ea0f52355fd367fa2e13f84b2f83
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         process-1.1.0.2-a830d25f0e9fb9c610aa641b7f5b20f9
         syb-0.4.0-8e7e08a060d6fc361aca595c701a94d6
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.9/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
