#!/bin/sh
echo 'name: abstract-deque
version: 0.1.6
id: abstract-deque-0.1.6-d48f4023ab37d18b56a79e8e06a60838

license: BSD3
copyright:
maintainer: rrnewton@gmail.com
stability:
homepage: https://github.com/rrnewton/haskell-lockfree-queue/wiki
package-url:
synopsis: Abstract, parameterized interface to mutable Deques.
description: An abstract interface to highly-parameterizable queues/deques.
             .
             Background: There exists a feature space for queues that extends between:
             .
             * simple, single-ended, non-concurrent, bounded queues
             .
             * double-ended, threadsafe, growable queues
             .
             ... with important points inbetween (such as
             the queues used for work-stealing).
             .
             This package includes an interface for Deques that allows the
             programmer to use a single API for all of the above, while using the
             type-system to select an efficient implementation given the
             requirements (using type families).
             .
             This package also includes a simple reference implementation based
             on '\''IORef'\'' and "Data.Sequence".
category: Data
author: Ryan R. Newton
pkgpath: devel/hs-abstract-deque
exposed: True
exposed-modules: Data.Concurrent.Deque.Class
                 Data.Concurrent.Deque.Tests Data.Concurrent.Deque.Reference
                 Data.Concurrent.Deque.Reference.DequeInstance
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/abstract-deque-0.1.6
library-dirs: /usr/local/lib/ghc/abstract-deque-0.1.6
hs-libraries: HSabstract-deque-0.1.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-037d72e94f82e21ad0efc3a3ca13d5e2
         base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-abstract-deque-0.1.6/html/abstract-deque.haddock
haddock-html: /usr/local/share/doc/hs-abstract-deque-0.1.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
