#!/bin/sh
echo 'name: HDBC
version: 2.3.1.2
id: HDBC-2.3.1.2-4bc5f908757cd75ee78768340b619f38

license: BSD3
copyright: Copyright (c) 2005-2011 John Goerzen
maintainer: Nicolas Wu <nicolas.wu@gmail.com>
stability: Stable
homepage: https://github.com/hdbc/hdbc
package-url:
synopsis: Haskell Database Connectivity
description: HDBC provides an abstraction layer between Haskell programs and SQL
             relational databases. This lets you write database code once, in
             Haskell, and have it work with any number of backend SQL databases
             (MySQL, Oracle, PostgreSQL, ODBC-compliant databases, etc.)
category: Database
author: John Goerzen
pkgpath: databases/hs-HDBC
exposed: True
exposed-modules: Database.HDBC Database.HDBC.Types
                 Database.HDBC.DriverUtils Database.HDBC.ColTypes
                 Database.HDBC.Statement Database.HDBC.SqlValue Database.HDBC.Locale
hidden-modules: Database.HDBC.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
library-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
hs-libraries: HSHDBC-2.3.1.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         convertible-1.0.11.1-5508624561c204cf1c5d742d6f492a2b
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         old-locale-1.0.0.5-753125cfaf463057d163a0cefde5b58f
         old-time-1.1.0.1-8b10e3f99ed8611456aa344014a88da2
         text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         utf8-string-0.3.8-123abdc63e716e348b66c892fc671d76
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HDBC-2.3.1.2/html/HDBC.haddock
haddock-html: /usr/local/share/doc/hs-HDBC-2.3.1.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
