%%   Autogenerated code. Do not edit.
%%
%%   The contents of this file are subject to the Mozilla Public License
%%   Version 1.1 (the "License"); you may not use this file except in
%%   compliance with the License. You may obtain a copy of the License at
%%   http://www.mozilla.org/MPL/
%%
%%   Software distributed under the License is distributed on an "AS IS"
%%   basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
%%   License for the specific language governing rights and limitations
%%   under the License.
%%
%%   The Original Code is RabbitMQ.
%%
%%   The Initial Developers of the Original Code are LShift Ltd,
%%   Cohesive Financial Technologies LLC, and Rabbit Technologies Ltd.
%%
%%   Portions created before 22-Nov-2008 00:00:00 GMT by LShift Ltd,
%%   Cohesive Financial Technologies LLC, or Rabbit Technologies Ltd
%%   are Copyright (C) 2007-2008 LShift Ltd, Cohesive Financial
%%   Technologies LLC, and Rabbit Technologies Ltd.
%%
%%   Portions created by LShift Ltd are Copyright (C) 2007-2010 LShift
%%   Ltd. Portions created by Cohesive Financial Technologies LLC are
%%   Copyright (C) 2007-2010 Cohesive Financial Technologies
%%   LLC. Portions created by Rabbit Technologies Ltd are Copyright
%%   (C) 2007-2010 Rabbit Technologies Ltd.
%%
%%   All Rights Reserved.
%%
%%   Contributor(s): ______________________________________.
%%
-module(rabbit_framing_amqp_0_9_1).
-include("rabbit_framing.hrl").

-export([version/0]).
-export([lookup_method_name/1]).
-export([method_id/1]).
-export([method_has_content/1]).
-export([is_method_synchronous/1]).
-export([method_record/1]).
-export([method_fieldnames/1]).
-export([decode_method_fields/2]).
-export([decode_properties/2]).
-export([encode_method_fields/1]).
-export([encode_properties/1]).
-export([lookup_amqp_exception/1]).
-export([amqp_exception/1]).


%% Various types
-ifdef(use_specs).
-export_type([amqp_table/0, amqp_property_type/0, amqp_method_record/0,
              amqp_method_name/0, amqp_method/0, amqp_class_id/0,
              amqp_value/0, amqp_array/0, amqp_exception/0, amqp_property_record/0]).

-type(amqp_field_type() ::
      'longstr' | 'signedint' | 'decimal' | 'timestamp' |
      'table' | 'byte' | 'double' | 'float' | 'long' |
      'short' | 'bool' | 'binary' | 'void').
-type(amqp_property_type() ::
      'shortstr' | 'longstr' | 'octet' | 'shortint' | 'longint' |
      'longlongint' | 'timestamp' | 'bit' | 'table').

-type(amqp_table() :: [{binary(), amqp_field_type(), amqp_value()}]).
-type(amqp_array() :: [{amqp_field_type(), amqp_value()}]).
-type(amqp_value() :: binary() |    % longstr
                      integer() |   % signedint
                      {non_neg_integer(), non_neg_integer()} | % decimal
                      amqp_table() |
                      amqp_array() |
                      byte() |      % byte
                      float() |     % double
                      integer() |   % long
                      integer() |   % short
                      boolean() |   % bool
                      binary() |    % binary
                      'undefined' | % void
                      non_neg_integer() % timestamp
     ).

-type(amqp_method_name() ::
       ( 'connection.start' | 'connection.start_ok' | 'connection.secure' | 'connection.secure_ok'
       | 'connection.tune' | 'connection.tune_ok' | 'connection.open' | 'connection.open_ok'
       | 'connection.close' | 'connection.close_ok' | 'channel.open' | 'channel.open_ok'
       | 'channel.flow' | 'channel.flow_ok' | 'channel.close' | 'channel.close_ok'
       | 'access.request' | 'access.request_ok' | 'exchange.declare' | 'exchange.declare_ok'
       | 'exchange.delete' | 'exchange.delete_ok' | 'queue.declare' | 'queue.declare_ok'
       | 'queue.bind' | 'queue.bind_ok' | 'queue.purge' | 'queue.purge_ok'
       | 'queue.delete' | 'queue.delete_ok' | 'queue.unbind' | 'queue.unbind_ok'
       | 'basic.qos' | 'basic.qos_ok' | 'basic.consume' | 'basic.consume_ok'
       | 'basic.cancel' | 'basic.cancel_ok' | 'basic.publish' | 'basic.return'
       | 'basic.deliver' | 'basic.get' | 'basic.get_ok' | 'basic.get_empty'
       | 'basic.ack' | 'basic.reject' | 'basic.recover_async' | 'basic.recover'
       | 'basic.recover_ok' | 'tx.select' | 'tx.select_ok' | 'tx.commit'
       | 'tx.commit_ok' | 'tx.rollback' | 'tx.rollback_ok' )).
-type(amqp_method() ::
       ( {10, 10} | {10, 11} | {10, 20} | {10, 21} | {10, 30} | {10, 31}
       | {10, 40} | {10, 41} | {10, 50} | {10, 51} | {20, 10} | {20, 11}
       | {20, 20} | {20, 21} | {20, 40} | {20, 41} | {30, 10} | {30, 11}
       | {40, 10} | {40, 11} | {40, 20} | {40, 21} | {50, 10} | {50, 11}
       | {50, 20} | {50, 21} | {50, 30} | {50, 31} | {50, 40} | {50, 41}
       | {50, 50} | {50, 51} | {60, 10} | {60, 11} | {60, 20} | {60, 21}
       | {60, 30} | {60, 31} | {60, 40} | {60, 50} | {60, 60} | {60, 70}
       | {60, 71} | {60, 72} | {60, 80} | {60, 90} | {60, 100} | {60, 110}
       | {60, 111} | {90, 10} | {90, 11} | {90, 20} | {90, 21} | {90, 30}
       | {90, 31} )).
-type(amqp_method_record() ::
       ( #'connection.start'{} | #'connection.start_ok'{} | #'connection.secure'{} | #'connection.secure_ok'{}
       | #'connection.tune'{} | #'connection.tune_ok'{} | #'connection.open'{} | #'connection.open_ok'{}
       | #'connection.close'{} | #'connection.close_ok'{} | #'channel.open'{} | #'channel.open_ok'{}
       | #'channel.flow'{} | #'channel.flow_ok'{} | #'channel.close'{} | #'channel.close_ok'{}
       | #'access.request'{} | #'access.request_ok'{} | #'exchange.declare'{} | #'exchange.declare_ok'{}
       | #'exchange.delete'{} | #'exchange.delete_ok'{} | #'queue.declare'{} | #'queue.declare_ok'{}
       | #'queue.bind'{} | #'queue.bind_ok'{} | #'queue.purge'{} | #'queue.purge_ok'{}
       | #'queue.delete'{} | #'queue.delete_ok'{} | #'queue.unbind'{} | #'queue.unbind_ok'{}
       | #'basic.qos'{} | #'basic.qos_ok'{} | #'basic.consume'{} | #'basic.consume_ok'{}
       | #'basic.cancel'{} | #'basic.cancel_ok'{} | #'basic.publish'{} | #'basic.return'{}
       | #'basic.deliver'{} | #'basic.get'{} | #'basic.get_ok'{} | #'basic.get_empty'{}
       | #'basic.ack'{} | #'basic.reject'{} | #'basic.recover_async'{} | #'basic.recover'{}
       | #'basic.recover_ok'{} | #'tx.select'{} | #'tx.select_ok'{} | #'tx.commit'{}
       | #'tx.commit_ok'{} | #'tx.rollback'{} | #'tx.rollback_ok'{} )).
-type(amqp_method_field_name() ::
       ( auto_delete | ticket | exchange | requeue
       | exchange | ticket | version_major | channel_max
       | locale | exclusive | response | queue
       | if_unused | routing_key | ticket | out_of_band
       | frame_max | delivery_tag | nowait | prefetch_count
       | known_hosts | ticket | ticket | ticket
       | no_local | if_empty | durable | realm
       | routing_key | reply_code | exclusive | ticket
       | reply_text | virtual_host | server_properties | queue
       | exchange | consumer_tag | auto_delete | prefetch_size
       | redelivered | requeue | nowait | message_count
       | passive | reply_text | queue | mandatory
       | class_id | global | no_ack | capabilities
       | channel_id | arguments | consumer_tag | delivery_tag
       | if_unused | version_minor | message_count | exchange
       | locales | routing_key | passive | class_id
       | mechanism | queue | exchange | queue
       | reply_code | delivery_tag | exchange | insist
       | delivery_tag | arguments | nowait | passive
       | routing_key | queue | exchange | ticket
       | active | channel_max | nowait | method_id
       | requeue | active | message_count | queue
       | message_count | mechanisms | durable | exchange
       | ticket | arguments | internal | frame_max
       | nowait | response | consumer_tag | client_properties
       | ticket | reply_text | multiple | write
       | routing_key | redelivered | queue | arguments
       | nowait | heartbeat | consumer_count | reply_code
       | exclusive | ticket | nowait | heartbeat
       | immediate | cluster_id | consumer_tag | challenge
       | no_ack | type | method_id | read
       | nowait | active | routing_key | arguments
       | consumer_tag )).
-type(amqp_property_record() ::
       ( #'P_connection'{} | #'P_channel'{} | #'P_access'{} | #'P_exchange'{}
       | #'P_queue'{} | #'P_basic'{} | #'P_tx'{} )).
-type(amqp_exception() ::
       ( 'frame_method' | 'frame_header' | 'frame_body' | 'frame_heartbeat'
       | 'frame_min_size' | 'frame_end' | 'reply_success' | 'content_too_large'
       | 'no_route' | 'no_consumers' | 'access_refused' | 'not_found'
       | 'resource_locked' | 'precondition_failed' | 'connection_forced' | 'invalid_path'
       | 'frame_error' | 'syntax_error' | 'command_invalid' | 'channel_error'
       | 'unexpected_frame' | 'resource_error' | 'not_allowed' | 'not_implemented'
       | 'internal_error' )).
-type(amqp_exception_code() ::
       ( 1 | 2 | 3 | 8
       | 4096 | 206 | 200 | 311
       | 312 | 313 | 403 | 404
       | 405 | 406 | 320 | 402
       | 501 | 502 | 503 | 504
       | 505 | 506 | 530 | 540
       | 541 )).
-type(amqp_class_id() ::
       ( 40 | 10 | 50 | 20
       | 90 | 60 | 30 )).
-endif. % use_specs

%% Method signatures
-ifdef(use_specs).
-spec(version/0 :: () -> {non_neg_integer(), non_neg_integer(), non_neg_integer()}).
-spec(lookup_method_name/1 :: (amqp_method()) -> amqp_method_name()).
-spec(method_id/1 :: (amqp_method_name()) -> amqp_method()).
-spec(method_has_content/1 :: (amqp_method_name()) -> boolean()).
-spec(is_method_synchronous/1 :: (amqp_method_record()) -> boolean()).
-spec(method_record/1 :: (amqp_method_name()) -> amqp_method_record()).
-spec(method_fieldnames/1 :: (amqp_method_name()) -> [amqp_method_field_name()]).
-spec(decode_method_fields/2 ::
        (amqp_method_name(), binary()) -> amqp_method_record() | rabbit_types:connection_exit()).
-spec(decode_properties/2 :: (non_neg_integer(), binary()) -> amqp_property_record()).
-spec(encode_method_fields/1 :: (amqp_method_record()) -> binary()).
-spec(encode_properties/1 :: (amqp_method_record()) -> binary()).
-spec(lookup_amqp_exception/1 :: (amqp_exception()) -> {boolean(), amqp_exception_code(), binary()}).
-spec(amqp_exception/1 :: (amqp_exception_code()) -> amqp_exception()).
-endif. % use_specs

bitvalue(true) -> 1;
bitvalue(false) -> 0;
bitvalue(undefined) -> 0.

version() -> {0, 9, 1}.
lookup_method_name({10, 10}) -> 'connection.start';
lookup_method_name({10, 11}) -> 'connection.start_ok';
lookup_method_name({10, 20}) -> 'connection.secure';
lookup_method_name({10, 21}) -> 'connection.secure_ok';
lookup_method_name({10, 30}) -> 'connection.tune';
lookup_method_name({10, 31}) -> 'connection.tune_ok';
lookup_method_name({10, 40}) -> 'connection.open';
lookup_method_name({10, 41}) -> 'connection.open_ok';
lookup_method_name({10, 50}) -> 'connection.close';
lookup_method_name({10, 51}) -> 'connection.close_ok';
lookup_method_name({20, 10}) -> 'channel.open';
lookup_method_name({20, 11}) -> 'channel.open_ok';
lookup_method_name({20, 20}) -> 'channel.flow';
lookup_method_name({20, 21}) -> 'channel.flow_ok';
lookup_method_name({20, 40}) -> 'channel.close';
lookup_method_name({20, 41}) -> 'channel.close_ok';
lookup_method_name({30, 10}) -> 'access.request';
lookup_method_name({30, 11}) -> 'access.request_ok';
lookup_method_name({40, 10}) -> 'exchange.declare';
lookup_method_name({40, 11}) -> 'exchange.declare_ok';
lookup_method_name({40, 20}) -> 'exchange.delete';
lookup_method_name({40, 21}) -> 'exchange.delete_ok';
lookup_method_name({50, 10}) -> 'queue.declare';
lookup_method_name({50, 11}) -> 'queue.declare_ok';
lookup_method_name({50, 20}) -> 'queue.bind';
lookup_method_name({50, 21}) -> 'queue.bind_ok';
lookup_method_name({50, 30}) -> 'queue.purge';
lookup_method_name({50, 31}) -> 'queue.purge_ok';
lookup_method_name({50, 40}) -> 'queue.delete';
lookup_method_name({50, 41}) -> 'queue.delete_ok';
lookup_method_name({50, 50}) -> 'queue.unbind';
lookup_method_name({50, 51}) -> 'queue.unbind_ok';
lookup_method_name({60, 10}) -> 'basic.qos';
lookup_method_name({60, 11}) -> 'basic.qos_ok';
lookup_method_name({60, 20}) -> 'basic.consume';
lookup_method_name({60, 21}) -> 'basic.consume_ok';
lookup_method_name({60, 30}) -> 'basic.cancel';
lookup_method_name({60, 31}) -> 'basic.cancel_ok';
lookup_method_name({60, 40}) -> 'basic.publish';
lookup_method_name({60, 50}) -> 'basic.return';
lookup_method_name({60, 60}) -> 'basic.deliver';
lookup_method_name({60, 70}) -> 'basic.get';
lookup_method_name({60, 71}) -> 'basic.get_ok';
lookup_method_name({60, 72}) -> 'basic.get_empty';
lookup_method_name({60, 80}) -> 'basic.ack';
lookup_method_name({60, 90}) -> 'basic.reject';
lookup_method_name({60, 100}) -> 'basic.recover_async';
lookup_method_name({60, 110}) -> 'basic.recover';
lookup_method_name({60, 111}) -> 'basic.recover_ok';
lookup_method_name({90, 10}) -> 'tx.select';
lookup_method_name({90, 11}) -> 'tx.select_ok';
lookup_method_name({90, 20}) -> 'tx.commit';
lookup_method_name({90, 21}) -> 'tx.commit_ok';
lookup_method_name({90, 30}) -> 'tx.rollback';
lookup_method_name({90, 31}) -> 'tx.rollback_ok';
lookup_method_name({_ClassId, _MethodId} = Id) -> exit({unknown_method_id, Id}).
method_id('connection.start') -> {10, 10};
method_id('connection.start_ok') -> {10, 11};
method_id('connection.secure') -> {10, 20};
method_id('connection.secure_ok') -> {10, 21};
method_id('connection.tune') -> {10, 30};
method_id('connection.tune_ok') -> {10, 31};
method_id('connection.open') -> {10, 40};
method_id('connection.open_ok') -> {10, 41};
method_id('connection.close') -> {10, 50};
method_id('connection.close_ok') -> {10, 51};
method_id('channel.open') -> {20, 10};
method_id('channel.open_ok') -> {20, 11};
method_id('channel.flow') -> {20, 20};
method_id('channel.flow_ok') -> {20, 21};
method_id('channel.close') -> {20, 40};
method_id('channel.close_ok') -> {20, 41};
method_id('access.request') -> {30, 10};
method_id('access.request_ok') -> {30, 11};
method_id('exchange.declare') -> {40, 10};
method_id('exchange.declare_ok') -> {40, 11};
method_id('exchange.delete') -> {40, 20};
method_id('exchange.delete_ok') -> {40, 21};
method_id('queue.declare') -> {50, 10};
method_id('queue.declare_ok') -> {50, 11};
method_id('queue.bind') -> {50, 20};
method_id('queue.bind_ok') -> {50, 21};
method_id('queue.purge') -> {50, 30};
method_id('queue.purge_ok') -> {50, 31};
method_id('queue.delete') -> {50, 40};
method_id('queue.delete_ok') -> {50, 41};
method_id('queue.unbind') -> {50, 50};
method_id('queue.unbind_ok') -> {50, 51};
method_id('basic.qos') -> {60, 10};
method_id('basic.qos_ok') -> {60, 11};
method_id('basic.consume') -> {60, 20};
method_id('basic.consume_ok') -> {60, 21};
method_id('basic.cancel') -> {60, 30};
method_id('basic.cancel_ok') -> {60, 31};
method_id('basic.publish') -> {60, 40};
method_id('basic.return') -> {60, 50};
method_id('basic.deliver') -> {60, 60};
method_id('basic.get') -> {60, 70};
method_id('basic.get_ok') -> {60, 71};
method_id('basic.get_empty') -> {60, 72};
method_id('basic.ack') -> {60, 80};
method_id('basic.reject') -> {60, 90};
method_id('basic.recover_async') -> {60, 100};
method_id('basic.recover') -> {60, 110};
method_id('basic.recover_ok') -> {60, 111};
method_id('tx.select') -> {90, 10};
method_id('tx.select_ok') -> {90, 11};
method_id('tx.commit') -> {90, 20};
method_id('tx.commit_ok') -> {90, 21};
method_id('tx.rollback') -> {90, 30};
method_id('tx.rollback_ok') -> {90, 31};
method_id(Name) -> exit({unknown_method_name, Name}).
method_has_content('connection.start') -> false;
method_has_content('connection.start_ok') -> false;
method_has_content('connection.secure') -> false;
method_has_content('connection.secure_ok') -> false;
method_has_content('connection.tune') -> false;
method_has_content('connection.tune_ok') -> false;
method_has_content('connection.open') -> false;
method_has_content('connection.open_ok') -> false;
method_has_content('connection.close') -> false;
method_has_content('connection.close_ok') -> false;
method_has_content('channel.open') -> false;
method_has_content('channel.open_ok') -> false;
method_has_content('channel.flow') -> false;
method_has_content('channel.flow_ok') -> false;
method_has_content('channel.close') -> false;
method_has_content('channel.close_ok') -> false;
method_has_content('access.request') -> false;
method_has_content('access.request_ok') -> false;
method_has_content('exchange.declare') -> false;
method_has_content('exchange.declare_ok') -> false;
method_has_content('exchange.delete') -> false;
method_has_content('exchange.delete_ok') -> false;
method_has_content('queue.declare') -> false;
method_has_content('queue.declare_ok') -> false;
method_has_content('queue.bind') -> false;
method_has_content('queue.bind_ok') -> false;
method_has_content('queue.purge') -> false;
method_has_content('queue.purge_ok') -> false;
method_has_content('queue.delete') -> false;
method_has_content('queue.delete_ok') -> false;
method_has_content('queue.unbind') -> false;
method_has_content('queue.unbind_ok') -> false;
method_has_content('basic.qos') -> false;
method_has_content('basic.qos_ok') -> false;
method_has_content('basic.consume') -> false;
method_has_content('basic.consume_ok') -> false;
method_has_content('basic.cancel') -> false;
method_has_content('basic.cancel_ok') -> false;
method_has_content('basic.publish') -> true;
method_has_content('basic.return') -> true;
method_has_content('basic.deliver') -> true;
method_has_content('basic.get') -> false;
method_has_content('basic.get_ok') -> true;
method_has_content('basic.get_empty') -> false;
method_has_content('basic.ack') -> false;
method_has_content('basic.reject') -> false;
method_has_content('basic.recover_async') -> false;
method_has_content('basic.recover') -> false;
method_has_content('basic.recover_ok') -> false;
method_has_content('tx.select') -> false;
method_has_content('tx.select_ok') -> false;
method_has_content('tx.commit') -> false;
method_has_content('tx.commit_ok') -> false;
method_has_content('tx.rollback') -> false;
method_has_content('tx.rollback_ok') -> false;
method_has_content(Name) -> exit({unknown_method_name, Name}).
is_method_synchronous(#'connection.start'{}) -> true;
is_method_synchronous(#'connection.start_ok'{}) -> false;
is_method_synchronous(#'connection.secure'{}) -> true;
is_method_synchronous(#'connection.secure_ok'{}) -> false;
is_method_synchronous(#'connection.tune'{}) -> true;
is_method_synchronous(#'connection.tune_ok'{}) -> false;
is_method_synchronous(#'connection.open'{}) -> true;
is_method_synchronous(#'connection.open_ok'{}) -> false;
is_method_synchronous(#'connection.close'{}) -> true;
is_method_synchronous(#'connection.close_ok'{}) -> false;
is_method_synchronous(#'channel.open'{}) -> true;
is_method_synchronous(#'channel.open_ok'{}) -> false;
is_method_synchronous(#'channel.flow'{}) -> true;
is_method_synchronous(#'channel.flow_ok'{}) -> false;
is_method_synchronous(#'channel.close'{}) -> true;
is_method_synchronous(#'channel.close_ok'{}) -> false;
is_method_synchronous(#'access.request'{}) -> true;
is_method_synchronous(#'access.request_ok'{}) -> false;
is_method_synchronous(#'exchange.declare'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'exchange.declare_ok'{}) -> false;
is_method_synchronous(#'exchange.delete'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'exchange.delete_ok'{}) -> false;
is_method_synchronous(#'queue.declare'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'queue.declare_ok'{}) -> false;
is_method_synchronous(#'queue.bind'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'queue.bind_ok'{}) -> false;
is_method_synchronous(#'queue.purge'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'queue.purge_ok'{}) -> false;
is_method_synchronous(#'queue.delete'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'queue.delete_ok'{}) -> false;
is_method_synchronous(#'queue.unbind'{}) -> true;
is_method_synchronous(#'queue.unbind_ok'{}) -> false;
is_method_synchronous(#'basic.qos'{}) -> true;
is_method_synchronous(#'basic.qos_ok'{}) -> false;
is_method_synchronous(#'basic.consume'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'basic.consume_ok'{}) -> false;
is_method_synchronous(#'basic.cancel'{nowait = NoWait}) -> not(NoWait);
is_method_synchronous(#'basic.cancel_ok'{}) -> false;
is_method_synchronous(#'basic.publish'{}) -> false;
is_method_synchronous(#'basic.return'{}) -> false;
is_method_synchronous(#'basic.deliver'{}) -> false;
is_method_synchronous(#'basic.get'{}) -> true;
is_method_synchronous(#'basic.get_ok'{}) -> false;
is_method_synchronous(#'basic.get_empty'{}) -> false;
is_method_synchronous(#'basic.ack'{}) -> false;
is_method_synchronous(#'basic.reject'{}) -> false;
is_method_synchronous(#'basic.recover_async'{}) -> false;
is_method_synchronous(#'basic.recover'{}) -> true;
is_method_synchronous(#'basic.recover_ok'{}) -> false;
is_method_synchronous(#'tx.select'{}) -> true;
is_method_synchronous(#'tx.select_ok'{}) -> false;
is_method_synchronous(#'tx.commit'{}) -> true;
is_method_synchronous(#'tx.commit_ok'{}) -> false;
is_method_synchronous(#'tx.rollback'{}) -> true;
is_method_synchronous(#'tx.rollback_ok'{}) -> false;
is_method_synchronous(Name) -> exit({unknown_method_name, Name}).
method_record('connection.start') -> #'connection.start'{};
method_record('connection.start_ok') -> #'connection.start_ok'{};
method_record('connection.secure') -> #'connection.secure'{};
method_record('connection.secure_ok') -> #'connection.secure_ok'{};
method_record('connection.tune') -> #'connection.tune'{};
method_record('connection.tune_ok') -> #'connection.tune_ok'{};
method_record('connection.open') -> #'connection.open'{};
method_record('connection.open_ok') -> #'connection.open_ok'{};
method_record('connection.close') -> #'connection.close'{};
method_record('connection.close_ok') -> #'connection.close_ok'{};
method_record('channel.open') -> #'channel.open'{};
method_record('channel.open_ok') -> #'channel.open_ok'{};
method_record('channel.flow') -> #'channel.flow'{};
method_record('channel.flow_ok') -> #'channel.flow_ok'{};
method_record('channel.close') -> #'channel.close'{};
method_record('channel.close_ok') -> #'channel.close_ok'{};
method_record('access.request') -> #'access.request'{};
method_record('access.request_ok') -> #'access.request_ok'{};
method_record('exchange.declare') -> #'exchange.declare'{};
method_record('exchange.declare_ok') -> #'exchange.declare_ok'{};
method_record('exchange.delete') -> #'exchange.delete'{};
method_record('exchange.delete_ok') -> #'exchange.delete_ok'{};
method_record('queue.declare') -> #'queue.declare'{};
method_record('queue.declare_ok') -> #'queue.declare_ok'{};
method_record('queue.bind') -> #'queue.bind'{};
method_record('queue.bind_ok') -> #'queue.bind_ok'{};
method_record('queue.purge') -> #'queue.purge'{};
method_record('queue.purge_ok') -> #'queue.purge_ok'{};
method_record('queue.delete') -> #'queue.delete'{};
method_record('queue.delete_ok') -> #'queue.delete_ok'{};
method_record('queue.unbind') -> #'queue.unbind'{};
method_record('queue.unbind_ok') -> #'queue.unbind_ok'{};
method_record('basic.qos') -> #'basic.qos'{};
method_record('basic.qos_ok') -> #'basic.qos_ok'{};
method_record('basic.consume') -> #'basic.consume'{};
method_record('basic.consume_ok') -> #'basic.consume_ok'{};
method_record('basic.cancel') -> #'basic.cancel'{};
method_record('basic.cancel_ok') -> #'basic.cancel_ok'{};
method_record('basic.publish') -> #'basic.publish'{};
method_record('basic.return') -> #'basic.return'{};
method_record('basic.deliver') -> #'basic.deliver'{};
method_record('basic.get') -> #'basic.get'{};
method_record('basic.get_ok') -> #'basic.get_ok'{};
method_record('basic.get_empty') -> #'basic.get_empty'{};
method_record('basic.ack') -> #'basic.ack'{};
method_record('basic.reject') -> #'basic.reject'{};
method_record('basic.recover_async') -> #'basic.recover_async'{};
method_record('basic.recover') -> #'basic.recover'{};
method_record('basic.recover_ok') -> #'basic.recover_ok'{};
method_record('tx.select') -> #'tx.select'{};
method_record('tx.select_ok') -> #'tx.select_ok'{};
method_record('tx.commit') -> #'tx.commit'{};
method_record('tx.commit_ok') -> #'tx.commit_ok'{};
method_record('tx.rollback') -> #'tx.rollback'{};
method_record('tx.rollback_ok') -> #'tx.rollback_ok'{};
method_record(Name) -> exit({unknown_method_name, Name}).
method_fieldnames('connection.start') -> [version_major, version_minor, server_properties, mechanisms, locales];
method_fieldnames('connection.start_ok') -> [client_properties, mechanism, response, locale];
method_fieldnames('connection.secure') -> [challenge];
method_fieldnames('connection.secure_ok') -> [response];
method_fieldnames('connection.tune') -> [channel_max, frame_max, heartbeat];
method_fieldnames('connection.tune_ok') -> [channel_max, frame_max, heartbeat];
method_fieldnames('connection.open') -> [virtual_host, capabilities, insist];
method_fieldnames('connection.open_ok') -> [known_hosts];
method_fieldnames('connection.close') -> [reply_code, reply_text, class_id, method_id];
method_fieldnames('connection.close_ok') -> [];
method_fieldnames('channel.open') -> [out_of_band];
method_fieldnames('channel.open_ok') -> [channel_id];
method_fieldnames('channel.flow') -> [active];
method_fieldnames('channel.flow_ok') -> [active];
method_fieldnames('channel.close') -> [reply_code, reply_text, class_id, method_id];
method_fieldnames('channel.close_ok') -> [];
method_fieldnames('access.request') -> [realm, exclusive, passive, active, write, read];
method_fieldnames('access.request_ok') -> [ticket];
method_fieldnames('exchange.declare') -> [ticket, exchange, type, passive, durable, auto_delete, internal, nowait, arguments];
method_fieldnames('exchange.declare_ok') -> [];
method_fieldnames('exchange.delete') -> [ticket, exchange, if_unused, nowait];
method_fieldnames('exchange.delete_ok') -> [];
method_fieldnames('queue.declare') -> [ticket, queue, passive, durable, exclusive, auto_delete, nowait, arguments];
method_fieldnames('queue.declare_ok') -> [queue, message_count, consumer_count];
method_fieldnames('queue.bind') -> [ticket, queue, exchange, routing_key, nowait, arguments];
method_fieldnames('queue.bind_ok') -> [];
method_fieldnames('queue.purge') -> [ticket, queue, nowait];
method_fieldnames('queue.purge_ok') -> [message_count];
method_fieldnames('queue.delete') -> [ticket, queue, if_unused, if_empty, nowait];
method_fieldnames('queue.delete_ok') -> [message_count];
method_fieldnames('queue.unbind') -> [ticket, queue, exchange, routing_key, arguments];
method_fieldnames('queue.unbind_ok') -> [];
method_fieldnames('basic.qos') -> [prefetch_size, prefetch_count, global];
method_fieldnames('basic.qos_ok') -> [];
method_fieldnames('basic.consume') -> [ticket, queue, consumer_tag, no_local, no_ack, exclusive, nowait, arguments];
method_fieldnames('basic.consume_ok') -> [consumer_tag];
method_fieldnames('basic.cancel') -> [consumer_tag, nowait];
method_fieldnames('basic.cancel_ok') -> [consumer_tag];
method_fieldnames('basic.publish') -> [ticket, exchange, routing_key, mandatory, immediate];
method_fieldnames('basic.return') -> [reply_code, reply_text, exchange, routing_key];
method_fieldnames('basic.deliver') -> [consumer_tag, delivery_tag, redelivered, exchange, routing_key];
method_fieldnames('basic.get') -> [ticket, queue, no_ack];
method_fieldnames('basic.get_ok') -> [delivery_tag, redelivered, exchange, routing_key, message_count];
method_fieldnames('basic.get_empty') -> [cluster_id];
method_fieldnames('basic.ack') -> [delivery_tag, multiple];
method_fieldnames('basic.reject') -> [delivery_tag, requeue];
method_fieldnames('basic.recover_async') -> [requeue];
method_fieldnames('basic.recover') -> [requeue];
method_fieldnames('basic.recover_ok') -> [];
method_fieldnames('tx.select') -> [];
method_fieldnames('tx.select_ok') -> [];
method_fieldnames('tx.commit') -> [];
method_fieldnames('tx.commit_ok') -> [];
method_fieldnames('tx.rollback') -> [];
method_fieldnames('tx.rollback_ok') -> [];
method_fieldnames(Name) -> exit({unknown_method_name, Name}).
decode_method_fields('connection.start', <<F0:8/unsigned, F1:8/unsigned, F2Len:32/unsigned, F2Tab:F2Len/binary, F3Len:32/unsigned, F3:F3Len/binary, F4Len:32/unsigned, F4:F4Len/binary>>) ->
  F2 = rabbit_binary_parser:parse_table(F2Tab),
  #'connection.start'{version_major = F0, version_minor = F1, server_properties = F2, mechanisms = F3, locales = F4};
decode_method_fields('connection.start_ok', <<F0Len:32/unsigned, F0Tab:F0Len/binary, F1Len:8/unsigned, F1:F1Len/binary, F2Len:32/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary>>) ->
  F0 = rabbit_binary_parser:parse_table(F0Tab),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'connection.start_ok'{client_properties = F0, mechanism = F1, response = F2, locale = F3};
decode_method_fields('connection.secure', <<F0Len:32/unsigned, F0:F0Len/binary>>) ->
  #'connection.secure'{challenge = F0};
decode_method_fields('connection.secure_ok', <<F0Len:32/unsigned, F0:F0Len/binary>>) ->
  #'connection.secure_ok'{response = F0};
decode_method_fields('connection.tune', <<F0:16/unsigned, F1:32/unsigned, F2:16/unsigned>>) ->
  #'connection.tune'{channel_max = F0, frame_max = F1, heartbeat = F2};
decode_method_fields('connection.tune_ok', <<F0:16/unsigned, F1:32/unsigned, F2:16/unsigned>>) ->
  #'connection.tune_ok'{channel_max = F0, frame_max = F1, heartbeat = F2};
decode_method_fields('connection.open', <<F0Len:8/unsigned, F0:F0Len/binary, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  #'connection.open'{virtual_host = F0, capabilities = F1, insist = F2};
decode_method_fields('connection.open_ok', <<F0Len:8/unsigned, F0:F0Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'connection.open_ok'{known_hosts = F0};
decode_method_fields('connection.close', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2:16/unsigned, F3:16/unsigned>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'connection.close'{reply_code = F0, reply_text = F1, class_id = F2, method_id = F3};
decode_method_fields('connection.close_ok', <<>>) ->
  #'connection.close_ok'{};
decode_method_fields('channel.open', <<F0Len:8/unsigned, F0:F0Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'channel.open'{out_of_band = F0};
decode_method_fields('channel.open_ok', <<F0Len:32/unsigned, F0:F0Len/binary>>) ->
  #'channel.open_ok'{channel_id = F0};
decode_method_fields('channel.flow', <<F0Bits:8>>) ->
  F0 = ((F0Bits band 1) /= 0),
  #'channel.flow'{active = F0};
decode_method_fields('channel.flow_ok', <<F0Bits:8>>) ->
  F0 = ((F0Bits band 1) /= 0),
  #'channel.flow_ok'{active = F0};
decode_method_fields('channel.close', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2:16/unsigned, F3:16/unsigned>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'channel.close'{reply_code = F0, reply_text = F1, class_id = F2, method_id = F3};
decode_method_fields('channel.close_ok', <<>>) ->
  #'channel.close_ok'{};
decode_method_fields('access.request', <<F0Len:8/unsigned, F0:F0Len/binary, F1Bits:8>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F1 = ((F1Bits band 1) /= 0),
  F2 = ((F1Bits band 2) /= 0),
  F3 = ((F1Bits band 4) /= 0),
  F4 = ((F1Bits band 8) /= 0),
  F5 = ((F1Bits band 16) /= 0),
  #'access.request'{realm = F0, exclusive = F1, passive = F2, active = F3, write = F4, read = F5};
decode_method_fields('access.request_ok', <<F0:16/unsigned>>) ->
  #'access.request_ok'{ticket = F0};
decode_method_fields('exchange.declare', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8, F8Len:32/unsigned, F8Tab:F8Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3 = ((F3Bits band 1) /= 0),
  F4 = ((F3Bits band 2) /= 0),
  F5 = ((F3Bits band 4) /= 0),
  F6 = ((F3Bits band 8) /= 0),
  F7 = ((F3Bits band 16) /= 0),
  F8 = rabbit_binary_parser:parse_table(F8Tab),
  #'exchange.declare'{ticket = F0, exchange = F1, type = F2, passive = F3, durable = F4, auto_delete = F5, internal = F6, nowait = F7, arguments = F8};
decode_method_fields('exchange.declare_ok', <<>>) ->
  #'exchange.declare_ok'{};
decode_method_fields('exchange.delete', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  F3 = ((F2Bits band 2) /= 0),
  #'exchange.delete'{ticket = F0, exchange = F1, if_unused = F2, nowait = F3};
decode_method_fields('exchange.delete_ok', <<>>) ->
  #'exchange.delete_ok'{};
decode_method_fields('queue.declare', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8, F7Len:32/unsigned, F7Tab:F7Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  F3 = ((F2Bits band 2) /= 0),
  F4 = ((F2Bits band 4) /= 0),
  F5 = ((F2Bits band 8) /= 0),
  F6 = ((F2Bits band 16) /= 0),
  F7 = rabbit_binary_parser:parse_table(F7Tab),
  #'queue.declare'{ticket = F0, queue = F1, passive = F2, durable = F3, exclusive = F4, auto_delete = F5, nowait = F6, arguments = F7};
decode_method_fields('queue.declare_ok', <<F0Len:8/unsigned, F0:F0Len/binary, F1:32/unsigned, F2:32/unsigned>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'queue.declare_ok'{queue = F0, message_count = F1, consumer_count = F2};
decode_method_fields('queue.bind', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4Bits:8, F5Len:32/unsigned, F5Tab:F5Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F4 = ((F4Bits band 1) /= 0),
  F5 = rabbit_binary_parser:parse_table(F5Tab),
  #'queue.bind'{ticket = F0, queue = F1, exchange = F2, routing_key = F3, nowait = F4, arguments = F5};
decode_method_fields('queue.bind_ok', <<>>) ->
  #'queue.bind_ok'{};
decode_method_fields('queue.purge', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  #'queue.purge'{ticket = F0, queue = F1, nowait = F2};
decode_method_fields('queue.purge_ok', <<F0:32/unsigned>>) ->
  #'queue.purge_ok'{message_count = F0};
decode_method_fields('queue.delete', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  F3 = ((F2Bits band 2) /= 0),
  F4 = ((F2Bits band 4) /= 0),
  #'queue.delete'{ticket = F0, queue = F1, if_unused = F2, if_empty = F3, nowait = F4};
decode_method_fields('queue.delete_ok', <<F0:32/unsigned>>) ->
  #'queue.delete_ok'{message_count = F0};
decode_method_fields('queue.unbind', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4Len:32/unsigned, F4Tab:F4Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F4 = rabbit_binary_parser:parse_table(F4Tab),
  #'queue.unbind'{ticket = F0, queue = F1, exchange = F2, routing_key = F3, arguments = F4};
decode_method_fields('queue.unbind_ok', <<>>) ->
  #'queue.unbind_ok'{};
decode_method_fields('basic.qos', <<F0:32/unsigned, F1:16/unsigned, F2Bits:8>>) ->
  F2 = ((F2Bits band 1) /= 0),
  #'basic.qos'{prefetch_size = F0, prefetch_count = F1, global = F2};
decode_method_fields('basic.qos_ok', <<>>) ->
  #'basic.qos_ok'{};
decode_method_fields('basic.consume', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8, F7Len:32/unsigned, F7Tab:F7Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3 = ((F3Bits band 1) /= 0),
  F4 = ((F3Bits band 2) /= 0),
  F5 = ((F3Bits band 4) /= 0),
  F6 = ((F3Bits band 8) /= 0),
  F7 = rabbit_binary_parser:parse_table(F7Tab),
  #'basic.consume'{ticket = F0, queue = F1, consumer_tag = F2, no_local = F3, no_ack = F4, exclusive = F5, nowait = F6, arguments = F7};
decode_method_fields('basic.consume_ok', <<F0Len:8/unsigned, F0:F0Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.consume_ok'{consumer_tag = F0};
decode_method_fields('basic.cancel', <<F0Len:8/unsigned, F0:F0Len/binary, F1Bits:8>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F1 = ((F1Bits band 1) /= 0),
  #'basic.cancel'{consumer_tag = F0, nowait = F1};
decode_method_fields('basic.cancel_ok', <<F0Len:8/unsigned, F0:F0Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.cancel_ok'{consumer_tag = F0};
decode_method_fields('basic.publish', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3 = ((F3Bits band 1) /= 0),
  F4 = ((F3Bits band 2) /= 0),
  #'basic.publish'{ticket = F0, exchange = F1, routing_key = F2, mandatory = F3, immediate = F4};
decode_method_fields('basic.return', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.return'{reply_code = F0, reply_text = F1, exchange = F2, routing_key = F3};
decode_method_fields('basic.deliver', <<F0Len:8/unsigned, F0:F0Len/binary, F1:64/unsigned, F2Bits:8, F3Len:8/unsigned, F3:F3Len/binary, F4Len:8/unsigned, F4:F4Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F4Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.deliver'{consumer_tag = F0, delivery_tag = F1, redelivered = F2, exchange = F3, routing_key = F4};
decode_method_fields('basic.get', <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>) ->
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2 = ((F2Bits band 1) /= 0),
  #'basic.get'{ticket = F0, queue = F1, no_ack = F2};
decode_method_fields('basic.get_ok', <<F0:64/unsigned, F1Bits:8, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4:32/unsigned>>) ->
  F1 = ((F1Bits band 1) /= 0),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.get_ok'{delivery_tag = F0, redelivered = F1, exchange = F2, routing_key = F3, message_count = F4};
decode_method_fields('basic.get_empty', <<F0Len:8/unsigned, F0:F0Len/binary>>) ->
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  #'basic.get_empty'{cluster_id = F0};
decode_method_fields('basic.ack', <<F0:64/unsigned, F1Bits:8>>) ->
  F1 = ((F1Bits band 1) /= 0),
  #'basic.ack'{delivery_tag = F0, multiple = F1};
decode_method_fields('basic.reject', <<F0:64/unsigned, F1Bits:8>>) ->
  F1 = ((F1Bits band 1) /= 0),
  #'basic.reject'{delivery_tag = F0, requeue = F1};
decode_method_fields('basic.recover_async', <<F0Bits:8>>) ->
  F0 = ((F0Bits band 1) /= 0),
  #'basic.recover_async'{requeue = F0};
decode_method_fields('basic.recover', <<F0Bits:8>>) ->
  F0 = ((F0Bits band 1) /= 0),
  #'basic.recover'{requeue = F0};
decode_method_fields('basic.recover_ok', <<>>) ->
  #'basic.recover_ok'{};
decode_method_fields('tx.select', <<>>) ->
  #'tx.select'{};
decode_method_fields('tx.select_ok', <<>>) ->
  #'tx.select_ok'{};
decode_method_fields('tx.commit', <<>>) ->
  #'tx.commit'{};
decode_method_fields('tx.commit_ok', <<>>) ->
  #'tx.commit_ok'{};
decode_method_fields('tx.rollback', <<>>) ->
  #'tx.rollback'{};
decode_method_fields('tx.rollback_ok', <<>>) ->
  #'tx.rollback_ok'{};
decode_method_fields(Name, BinaryFields) ->
  rabbit_misc:frame_error(Name, BinaryFields).
decode_properties(10, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_connection'{};
decode_properties(20, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_channel'{};
decode_properties(30, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_access'{};
decode_properties(40, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_exchange'{};
decode_properties(50, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_queue'{};
decode_properties(60, PropBin) ->
  [F0, F1, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, F13] = rabbit_binary_parser:parse_properties([shortstr, shortstr, table, octet, octet, shortstr, shortstr, shortstr, shortstr, timestamp, shortstr, shortstr, shortstr, shortstr], PropBin),
  #'P_basic'{content_type = F0, content_encoding = F1, headers = F2, delivery_mode = F3, priority = F4, correlation_id = F5, reply_to = F6, expiration = F7, message_id = F8, timestamp = F9, type = F10, user_id = F11, app_id = F12, cluster_id = F13};
decode_properties(90, PropBin) ->
  [] = rabbit_binary_parser:parse_properties([], PropBin),
  #'P_tx'{};
decode_properties(ClassId, _BinaryFields) -> exit({unknown_class_id, ClassId}).
encode_method_fields(#'connection.start'{version_major = F0, version_minor = F1, server_properties = F2, mechanisms = F3, locales = F4}) ->
  F2Tab = rabbit_binary_generator:generate_table(F2),
  F2Len = size(F2Tab),
  F3Len = size(F3),
  F4Len = size(F4),
  <<F0:8/unsigned, F1:8/unsigned, F2Len:32/unsigned, F2Tab:F2Len/binary, F3Len:32/unsigned, F3:F3Len/binary, F4Len:32/unsigned, F4:F4Len/binary>>;
encode_method_fields(#'connection.start_ok'{client_properties = F0, mechanism = F1, response = F2, locale = F3}) ->
  F0Tab = rabbit_binary_generator:generate_table(F0),
  F0Len = size(F0Tab),
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:32/unsigned, F0Tab:F0Len/binary, F1Len:8/unsigned, F1:F1Len/binary, F2Len:32/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary>>;
encode_method_fields(#'connection.secure'{challenge = F0}) ->
  F0Len = size(F0),
  <<F0Len:32/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'connection.secure_ok'{response = F0}) ->
  F0Len = size(F0),
  <<F0Len:32/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'connection.tune'{channel_max = F0, frame_max = F1, heartbeat = F2}) ->
  <<F0:16/unsigned, F1:32/unsigned, F2:16/unsigned>>;
encode_method_fields(#'connection.tune_ok'{channel_max = F0, frame_max = F1, heartbeat = F2}) ->
  <<F0:16/unsigned, F1:32/unsigned, F2:16/unsigned>>;
encode_method_fields(#'connection.open'{virtual_host = F0, capabilities = F1, insist = F2}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0)),
  <<F0Len:8/unsigned, F0:F0Len/binary, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>;
encode_method_fields(#'connection.open_ok'{known_hosts = F0}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'connection.close'{reply_code = F0, reply_text = F1, class_id = F2, method_id = F3}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2:16/unsigned, F3:16/unsigned>>;
encode_method_fields(#'connection.close_ok'{}) ->
  <<>>;
encode_method_fields(#'channel.open'{out_of_band = F0}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'channel.open_ok'{channel_id = F0}) ->
  F0Len = size(F0),
  <<F0Len:32/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'channel.flow'{active = F0}) ->
  F0Bits = ((bitvalue(F0) bsl 0)),
  <<F0Bits:8>>;
encode_method_fields(#'channel.flow_ok'{active = F0}) ->
  F0Bits = ((bitvalue(F0) bsl 0)),
  <<F0Bits:8>>;
encode_method_fields(#'channel.close'{reply_code = F0, reply_text = F1, class_id = F2, method_id = F3}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2:16/unsigned, F3:16/unsigned>>;
encode_method_fields(#'channel.close_ok'{}) ->
  <<>>;
encode_method_fields(#'access.request'{realm = F0, exclusive = F1, passive = F2, active = F3, write = F4, read = F5}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F1Bits = ((bitvalue(F1) bsl 0) bor (bitvalue(F2) bsl 1) bor (bitvalue(F3) bsl 2) bor (bitvalue(F4) bsl 3) bor (bitvalue(F5) bsl 4)),
  <<F0Len:8/unsigned, F0:F0Len/binary, F1Bits:8>>;
encode_method_fields(#'access.request_ok'{ticket = F0}) ->
  <<F0:16/unsigned>>;
encode_method_fields(#'exchange.declare'{ticket = F0, exchange = F1, type = F2, passive = F3, durable = F4, auto_delete = F5, internal = F6, nowait = F7, arguments = F8}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Bits = ((bitvalue(F3) bsl 0) bor (bitvalue(F4) bsl 1) bor (bitvalue(F5) bsl 2) bor (bitvalue(F6) bsl 3) bor (bitvalue(F7) bsl 4)),
  F8Tab = rabbit_binary_generator:generate_table(F8),
  F8Len = size(F8Tab),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8, F8Len:32/unsigned, F8Tab:F8Len/binary>>;
encode_method_fields(#'exchange.declare_ok'{}) ->
  <<>>;
encode_method_fields(#'exchange.delete'{ticket = F0, exchange = F1, if_unused = F2, nowait = F3}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0) bor (bitvalue(F3) bsl 1)),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>;
encode_method_fields(#'exchange.delete_ok'{}) ->
  <<>>;
encode_method_fields(#'queue.declare'{ticket = F0, queue = F1, passive = F2, durable = F3, exclusive = F4, auto_delete = F5, nowait = F6, arguments = F7}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0) bor (bitvalue(F3) bsl 1) bor (bitvalue(F4) bsl 2) bor (bitvalue(F5) bsl 3) bor (bitvalue(F6) bsl 4)),
  F7Tab = rabbit_binary_generator:generate_table(F7),
  F7Len = size(F7Tab),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8, F7Len:32/unsigned, F7Tab:F7Len/binary>>;
encode_method_fields(#'queue.declare_ok'{queue = F0, message_count = F1, consumer_count = F2}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary, F1:32/unsigned, F2:32/unsigned>>;
encode_method_fields(#'queue.bind'{ticket = F0, queue = F1, exchange = F2, routing_key = F3, nowait = F4, arguments = F5}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F4Bits = ((bitvalue(F4) bsl 0)),
  F5Tab = rabbit_binary_generator:generate_table(F5),
  F5Len = size(F5Tab),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4Bits:8, F5Len:32/unsigned, F5Tab:F5Len/binary>>;
encode_method_fields(#'queue.bind_ok'{}) ->
  <<>>;
encode_method_fields(#'queue.purge'{ticket = F0, queue = F1, nowait = F2}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0)),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>;
encode_method_fields(#'queue.purge_ok'{message_count = F0}) ->
  <<F0:32/unsigned>>;
encode_method_fields(#'queue.delete'{ticket = F0, queue = F1, if_unused = F2, if_empty = F3, nowait = F4}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0) bor (bitvalue(F3) bsl 1) bor (bitvalue(F4) bsl 2)),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>;
encode_method_fields(#'queue.delete_ok'{message_count = F0}) ->
  <<F0:32/unsigned>>;
encode_method_fields(#'queue.unbind'{ticket = F0, queue = F1, exchange = F2, routing_key = F3, arguments = F4}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F4Tab = rabbit_binary_generator:generate_table(F4),
  F4Len = size(F4Tab),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4Len:32/unsigned, F4Tab:F4Len/binary>>;
encode_method_fields(#'queue.unbind_ok'{}) ->
  <<>>;
encode_method_fields(#'basic.qos'{prefetch_size = F0, prefetch_count = F1, global = F2}) ->
  F2Bits = ((bitvalue(F2) bsl 0)),
  <<F0:32/unsigned, F1:16/unsigned, F2Bits:8>>;
encode_method_fields(#'basic.qos_ok'{}) ->
  <<>>;
encode_method_fields(#'basic.consume'{ticket = F0, queue = F1, consumer_tag = F2, no_local = F3, no_ack = F4, exclusive = F5, nowait = F6, arguments = F7}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Bits = ((bitvalue(F3) bsl 0) bor (bitvalue(F4) bsl 1) bor (bitvalue(F5) bsl 2) bor (bitvalue(F6) bsl 3)),
  F7Tab = rabbit_binary_generator:generate_table(F7),
  F7Len = size(F7Tab),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8, F7Len:32/unsigned, F7Tab:F7Len/binary>>;
encode_method_fields(#'basic.consume_ok'{consumer_tag = F0}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'basic.cancel'{consumer_tag = F0, nowait = F1}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F1Bits = ((bitvalue(F1) bsl 0)),
  <<F0Len:8/unsigned, F0:F0Len/binary, F1Bits:8>>;
encode_method_fields(#'basic.cancel_ok'{consumer_tag = F0}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'basic.publish'{ticket = F0, exchange = F1, routing_key = F2, mandatory = F3, immediate = F4}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Bits = ((bitvalue(F3) bsl 0) bor (bitvalue(F4) bsl 1)),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Bits:8>>;
encode_method_fields(#'basic.return'{reply_code = F0, reply_text = F1, exchange = F2, routing_key = F3}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary>>;
encode_method_fields(#'basic.deliver'{consumer_tag = F0, delivery_tag = F1, redelivered = F2, exchange = F3, routing_key = F4}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0)),
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F4Len = size(F4),
  if F4Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary, F1:64/unsigned, F2Bits:8, F3Len:8/unsigned, F3:F3Len/binary, F4Len:8/unsigned, F4:F4Len/binary>>;
encode_method_fields(#'basic.get'{ticket = F0, queue = F1, no_ack = F2}) ->
  F1Len = size(F1),
  if F1Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F2Bits = ((bitvalue(F2) bsl 0)),
  <<F0:16/unsigned, F1Len:8/unsigned, F1:F1Len/binary, F2Bits:8>>;
encode_method_fields(#'basic.get_ok'{delivery_tag = F0, redelivered = F1, exchange = F2, routing_key = F3, message_count = F4}) ->
  F1Bits = ((bitvalue(F1) bsl 0)),
  F2Len = size(F2),
  if F2Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  F3Len = size(F3),
  if F3Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0:64/unsigned, F1Bits:8, F2Len:8/unsigned, F2:F2Len/binary, F3Len:8/unsigned, F3:F3Len/binary, F4:32/unsigned>>;
encode_method_fields(#'basic.get_empty'{cluster_id = F0}) ->
  F0Len = size(F0),
  if F0Len > 255 -> exit(method_field_shortstr_overflow); true -> ok end,
  <<F0Len:8/unsigned, F0:F0Len/binary>>;
encode_method_fields(#'basic.ack'{delivery_tag = F0, multiple = F1}) ->
  F1Bits = ((bitvalue(F1) bsl 0)),
  <<F0:64/unsigned, F1Bits:8>>;
encode_method_fields(#'basic.reject'{delivery_tag = F0, requeue = F1}) ->
  F1Bits = ((bitvalue(F1) bsl 0)),
  <<F0:64/unsigned, F1Bits:8>>;
encode_method_fields(#'basic.recover_async'{requeue = F0}) ->
  F0Bits = ((bitvalue(F0) bsl 0)),
  <<F0Bits:8>>;
encode_method_fields(#'basic.recover'{requeue = F0}) ->
  F0Bits = ((bitvalue(F0) bsl 0)),
  <<F0Bits:8>>;
encode_method_fields(#'basic.recover_ok'{}) ->
  <<>>;
encode_method_fields(#'tx.select'{}) ->
  <<>>;
encode_method_fields(#'tx.select_ok'{}) ->
  <<>>;
encode_method_fields(#'tx.commit'{}) ->
  <<>>;
encode_method_fields(#'tx.commit_ok'{}) ->
  <<>>;
encode_method_fields(#'tx.rollback'{}) ->
  <<>>;
encode_method_fields(#'tx.rollback_ok'{}) ->
  <<>>;
encode_method_fields(Record) -> exit({unknown_method_name, element(1, Record)}).
encode_properties(#'P_connection'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(#'P_channel'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(#'P_access'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(#'P_exchange'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(#'P_queue'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(#'P_basic'{content_type = F0, content_encoding = F1, headers = F2, delivery_mode = F3, priority = F4, correlation_id = F5, reply_to = F6, expiration = F7, message_id = F8, timestamp = F9, type = F10, user_id = F11, app_id = F12, cluster_id = F13}) ->
  rabbit_binary_generator:encode_properties([shortstr, shortstr, table, octet, octet, shortstr, shortstr, shortstr, shortstr, timestamp, shortstr, shortstr, shortstr, shortstr], [F0, F1, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, F13]);
encode_properties(#'P_tx'{}) ->
  rabbit_binary_generator:encode_properties([], []);
encode_properties(Record) -> exit({unknown_properties_record, Record}).
lookup_amqp_exception(content_too_large) -> {false, ?CONTENT_TOO_LARGE, <<"CONTENT_TOO_LARGE">>};
lookup_amqp_exception(no_route) -> {false, ?NO_ROUTE, <<"NO_ROUTE">>};
lookup_amqp_exception(no_consumers) -> {false, ?NO_CONSUMERS, <<"NO_CONSUMERS">>};
lookup_amqp_exception(access_refused) -> {false, ?ACCESS_REFUSED, <<"ACCESS_REFUSED">>};
lookup_amqp_exception(not_found) -> {false, ?NOT_FOUND, <<"NOT_FOUND">>};
lookup_amqp_exception(resource_locked) -> {false, ?RESOURCE_LOCKED, <<"RESOURCE_LOCKED">>};
lookup_amqp_exception(precondition_failed) -> {false, ?PRECONDITION_FAILED, <<"PRECONDITION_FAILED">>};
lookup_amqp_exception(connection_forced) -> {true, ?CONNECTION_FORCED, <<"CONNECTION_FORCED">>};
lookup_amqp_exception(invalid_path) -> {true, ?INVALID_PATH, <<"INVALID_PATH">>};
lookup_amqp_exception(frame_error) -> {true, ?FRAME_ERROR, <<"FRAME_ERROR">>};
lookup_amqp_exception(syntax_error) -> {true, ?SYNTAX_ERROR, <<"SYNTAX_ERROR">>};
lookup_amqp_exception(command_invalid) -> {true, ?COMMAND_INVALID, <<"COMMAND_INVALID">>};
lookup_amqp_exception(channel_error) -> {true, ?CHANNEL_ERROR, <<"CHANNEL_ERROR">>};
lookup_amqp_exception(unexpected_frame) -> {true, ?UNEXPECTED_FRAME, <<"UNEXPECTED_FRAME">>};
lookup_amqp_exception(resource_error) -> {true, ?RESOURCE_ERROR, <<"RESOURCE_ERROR">>};
lookup_amqp_exception(not_allowed) -> {true, ?NOT_ALLOWED, <<"NOT_ALLOWED">>};
lookup_amqp_exception(not_implemented) -> {true, ?NOT_IMPLEMENTED, <<"NOT_IMPLEMENTED">>};
lookup_amqp_exception(internal_error) -> {true, ?INTERNAL_ERROR, <<"INTERNAL_ERROR">>};
lookup_amqp_exception(Code) ->
  rabbit_log:warning("Unknown AMQP error code '~p'~n", [Code]),
  {true, ?INTERNAL_ERROR, <<"INTERNAL_ERROR">>}.
amqp_exception(?FRAME_METHOD) -> frame_method;
amqp_exception(?FRAME_HEADER) -> frame_header;
amqp_exception(?FRAME_BODY) -> frame_body;
amqp_exception(?FRAME_HEARTBEAT) -> frame_heartbeat;
amqp_exception(?FRAME_MIN_SIZE) -> frame_min_size;
amqp_exception(?FRAME_END) -> frame_end;
amqp_exception(?REPLY_SUCCESS) -> reply_success;
amqp_exception(?CONTENT_TOO_LARGE) -> content_too_large;
amqp_exception(?NO_ROUTE) -> no_route;
amqp_exception(?NO_CONSUMERS) -> no_consumers;
amqp_exception(?ACCESS_REFUSED) -> access_refused;
amqp_exception(?NOT_FOUND) -> not_found;
amqp_exception(?RESOURCE_LOCKED) -> resource_locked;
amqp_exception(?PRECONDITION_FAILED) -> precondition_failed;
amqp_exception(?CONNECTION_FORCED) -> connection_forced;
amqp_exception(?INVALID_PATH) -> invalid_path;
amqp_exception(?FRAME_ERROR) -> frame_error;
amqp_exception(?SYNTAX_ERROR) -> syntax_error;
amqp_exception(?COMMAND_INVALID) -> command_invalid;
amqp_exception(?CHANNEL_ERROR) -> channel_error;
amqp_exception(?UNEXPECTED_FRAME) -> unexpected_frame;
amqp_exception(?RESOURCE_ERROR) -> resource_error;
amqp_exception(?NOT_ALLOWED) -> not_allowed;
amqp_exception(?NOT_IMPLEMENTED) -> not_implemented;
amqp_exception(?INTERNAL_ERROR) -> internal_error;
amqp_exception(_Code) -> undefined.
