/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.perl;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.epic.perleditor.PerlPluginImages;
import org.epic.perleditor.templates.ContextType;
import org.epic.perleditor.templates.perl.CompilationUnitContextType;
import org.epic.perleditor.templates.perl.IPerlCompletionProposal;
import org.epic.perleditor.templates.perl.PerlUnitContext;
import org.epic.perleditor.templates.perl.SubroutineProposal;

public class SubroutineEngine {
    private ContextType fContextType;
    private ArrayList fProposals = new ArrayList();

    public SubroutineEngine(ContextType contextType) {
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public IPerlCompletionProposal[] getResults() {
        return this.fProposals.toArray(new IPerlCompletionProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, Object[] identifiers) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        if (selection.y != 0) {
            try {
                document.get(selection.x, selection.y);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        ((CompilationUnitContextType)this.fContextType).setContextParameters(document, completionPosition, selection.y);
        PerlUnitContext context = (PerlUnitContext)this.fContextType.createContext();
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        String subroutine = null;
        int i = 0;
        while (i != identifiers.length) {
            subroutine = (String)identifiers[i];
            if (context.canEvaluate(subroutine, true)) {
                this.fProposals.add(new SubroutineProposal(subroutine, context, (IRegion)region, viewer, PerlPluginImages.get("org.epic.perleditor.subroutine.gif"), PerlPluginImages.get("org.epic.perleditor.subroutine.gif")));
            }
            ++i;
        }
    }
}

