/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractImportCheck;
import com.puppycrawl.tools.checkstyle.checks.ClassResolver;
import com.puppycrawl.tools.checkstyle.checks.ExceptionInfo;
import com.puppycrawl.tools.checkstyle.checks.JavadocTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.regexp.RE;

public class JavadocMethodCheck
extends AbstractImportCheck {
    private static final String MATCH_JAVADOC_ARG_PAT = "@(throws|exception|param)\\s+(\\S+)\\s+\\S";
    private static final RE MATCH_JAVADOC_ARG = Utils.createRE("@(throws|exception|param)\\s+(\\S+)\\s+\\S");
    private static final String MATCH_JAVADOC_ARG_MULTILINE_START_PAT = "@(throws|exception|param)\\s+(\\S+)\\s*$";
    private static final RE MATCH_JAVADOC_ARG_MULTILINE_START = Utils.createRE("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final String MATCH_JAVADOC_MULTILINE_CONT_PAT = "(\\*/|@|[^\\s\\*])";
    private static final RE MATCH_JAVADOC_MULTILINE_CONT = Utils.createRE("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final String MATCH_JAVADOC_NOARG_PAT = "@(return|see)\\s+\\S";
    private static final RE MATCH_JAVADOC_NOARG = Utils.createRE("@(return|see)\\s+\\S");
    private static final String MATCH_JAVADOC_NOARG_MULTILINE_START_PAT = "@(return|see)\\s*$";
    private static final RE MATCH_JAVADOC_NOARG_MULTILINE_START = Utils.createRE("@(return|see)\\s*$");
    private static final String MATCH_JAVADOC_NOARG_CURLY_PAT = "\\{\\s*@(inheritDoc)\\s*\\}";
    private static final RE MATCH_JAVADOC_NOARG_CURLY = Utils.createRE("\\{\\s*@(inheritDoc)\\s*\\}");
    private FullIdent mPackageFullIdent = null;
    private Set mImports = new HashSet();
    private Scope mScope = Scope.PRIVATE;
    private boolean mAllowUndeclaredRTE = false;
    private boolean mAllowThrowsTagsForSubclasses = false;
    private boolean mAllowMissingParamTags = false;
    private boolean mAllowMissingThrowsTags = false;
    private boolean mAllowMissingReturnTag = false;
    private ClassResolver mClassResolver;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setAllowUndeclaredRTE(boolean aFlag) {
        this.mAllowUndeclaredRTE = aFlag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean aFlag) {
        this.mAllowThrowsTagsForSubclasses = aFlag;
    }

    public void setAllowMissingParamTags(boolean aFlag) {
        this.mAllowMissingParamTags = aFlag;
    }

    public void setAllowMissingThrowsTags(boolean aFlag) {
        this.mAllowMissingThrowsTags = aFlag;
    }

    public void setAllowMissingReturnTag(boolean aFlag) {
        this.mAllowMissingReturnTag = aFlag;
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 9, 8};
    }

    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    public int[] getRequiredTokens() {
        return new int[]{16, 30};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mPackageFullIdent = FullIdent.createFullIdent(null);
        this.mImports.clear();
        this.mClassResolver = null;
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            if (this.mAllowUndeclaredRTE) {
                this.processPackage(aAST);
            }
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else {
            this.processMethod(aAST);
        }
    }

    private void processPackage(DetailAST aAST) {
        DetailAST nameAST = (DetailAST)aAST.getFirstChild();
        this.mPackageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = this.getImportText(aAST);
        if (name != null) {
            this.mImports.add(name.getText());
        }
    }

    private void processMethod(DetailAST aAST) {
        Scope surroundingScope;
        Scope targetScope;
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = targetScope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
        if (targetScope.isIn(this.mScope) && (surroundingScope = ScopeUtils.getSurroundingScope(aAST)).isIn(this.mScope)) {
            FileContents contents = this.getFileContents();
            String[] cmt = contents.getJavadocBefore(aAST.getLineNo());
            if (cmt == null) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "javadoc.missing");
            } else {
                this.checkComment(aAST, cmt);
            }
        }
    }

    private void checkComment(DetailAST aAST, String[] aComment) {
        List tags = this.getMethodTags(aComment, aAST.getLineNo() - 1);
        if (tags.size() != 1 || !((JavadocTag)tags.get(0)).isSeeOrInheritDocTag()) {
            this.checkParamTags(tags, this.getParameters(aAST));
            this.checkThrowsTags(tags, this.getThrows(aAST));
            if (this.isFunction(aAST)) {
                this.checkReturnTag(tags, aAST.getLineNo());
            }
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                JavadocTag jt = (JavadocTag)it.next();
                if (jt.isSeeOrInheritDocTag()) continue;
                this.log(jt.getLineNo(), "javadoc.unusedTagGeneral");
            }
        }
    }

    private List getMethodTags(String[] aLines, int aLastLineNo) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = aLastLineNo - aLines.length;
        int i = 0;
        while (i < aLines.length) {
            String p1;
            ++currentLine;
            if (MATCH_JAVADOC_ARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_ARG.getParen(1), MATCH_JAVADOC_ARG.getParen(2)));
            } else if (MATCH_JAVADOC_NOARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG.getParen(1)));
            } else if (MATCH_JAVADOC_NOARG_CURLY.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG_CURLY.getParen(1)));
            } else if (MATCH_JAVADOC_ARG_MULTILINE_START.match(aLines[i])) {
                p1 = MATCH_JAVADOC_ARG_MULTILINE_START.getParen(1);
                String p2 = MATCH_JAVADOC_ARG_MULTILINE_START.getParen(2);
                int remIndex = i + 1;
                while (remIndex < aLines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(aLines[remIndex])) {
                        remIndex = aLines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1, p2));
                        }
                    }
                    ++remIndex;
                }
            } else if (MATCH_JAVADOC_NOARG_MULTILINE_START.match(aLines[i])) {
                p1 = MATCH_JAVADOC_NOARG_MULTILINE_START.getParen(1);
                int remIndex = i + 1;
                while (remIndex < aLines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(aLines[remIndex])) {
                        remIndex = aLines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1));
                        }
                    }
                    ++remIndex;
                }
            }
            ++i;
        }
        return tags;
    }

    private List getParameters(DetailAST aAST) {
        DetailAST params = aAST.findFirstToken(20);
        ArrayList<DetailAST> retVal = new ArrayList<DetailAST>();
        DetailAST child = (DetailAST)params.getFirstChild();
        while (child != null) {
            if (child.getType() == 21) {
                DetailAST ident = child.findFirstToken(58);
                retVal.add(ident);
            }
            child = (DetailAST)child.getNextSibling();
        }
        return retVal;
    }

    private List getThrows(DetailAST aAST) {
        ArrayList<ExceptionInfo> retVal = new ArrayList<ExceptionInfo>();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            DetailAST child = (DetailAST)throwsAST.getFirstChild();
            while (child != null) {
                if (child.getType() == 58 || child.getType() == 59) {
                    ExceptionInfo ei = new ExceptionInfo(FullIdent.createFullIdent(child));
                    retVal.add(ei);
                }
                child = (DetailAST)child.getNextSibling();
            }
        }
        return retVal;
    }

    private void checkParamTags(List aTags, List aParams) {
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            Iterator paramIt = aParams.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = (DetailAST)paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (found) continue;
            this.log(tag.getLineNo(), "javadoc.unusedTag", (Object)"@param", (Object)tag.getArg1());
        }
        if (!this.mAllowMissingParamTags) {
            Iterator paramIt = aParams.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = (DetailAST)paramIt.next();
                this.log(param.getLineNo(), param.getColumnNo(), "javadoc.expectedTag", "@param", param.getText());
            }
        }
    }

    private boolean isSameType(String aDeclared, String aDocumented) {
        return aDeclared.equals(aDocumented) || this.isShortName(aDeclared, aDocumented) || this.isShortName(aDocumented, aDeclared);
    }

    private boolean isShortName(String aShortName, String aFullName) {
        if (aShortName.length() >= aFullName.length()) {
            return false;
        }
        String base = Utils.baseClassname(aFullName);
        if (aShortName.length() >= aFullName.length() || !base.equals(aShortName)) {
            return false;
        }
        if (this.mImports.contains(aFullName)) {
            return true;
        }
        int endIndex = aFullName.length() - base.length() - 1;
        String packageName = aFullName.substring(0, endIndex);
        String starImport = packageName + ".*";
        if (this.mImports.contains(starImport)) {
            return true;
        }
        return packageName.equals(this.mPackageFullIdent.getText());
    }

    private boolean isFunction(DetailAST aAST) {
        DetailAST typeAST;
        boolean retVal = false;
        if (aAST.getType() == 9 && (typeAST = aAST.findFirstToken(13)) != null && typeAST.findFirstToken(49) == null) {
            retVal = true;
        }
        return retVal;
    }

    private void checkReturnTag(List aTags, int aLineNo) {
        boolean found = false;
        ListIterator it = aTags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = (JavadocTag)it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.log(jt.getLineNo(), "javadoc.return.duplicate");
            }
            found = true;
            it.remove();
        }
        if (!found && !this.mAllowMissingReturnTag) {
            this.log(aLineNo, "javadoc.return.expected");
        }
    }

    private void checkThrowsTags(List aTags, List aThrows) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            boolean found = foundThrows.contains(documentedEx);
            ListIterator throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                ExceptionInfo ei = (ExceptionInfo)throwIt.next();
                FullIdent fi = ei.getFullIdent();
                String declaredEx = fi.getText();
                if (this.isSameType(declaredEx, documentedEx)) {
                    found = true;
                    ei.setFound();
                    foundThrows.add(documentedEx);
                    continue;
                }
                if (!this.mAllowThrowsTagsForSubclasses) continue;
                ClassResolver cr = this.getClassResolver();
                try {
                    Class documentedClass = cr.resolve(documentedEx);
                    try {
                        Class declaredClass = cr.resolve(declaredEx);
                        found = declaredClass.isAssignableFrom(documentedClass);
                        if (!found) continue;
                        ei.setFound();
                    }
                    catch (ClassNotFoundException e) {
                        this.log(tag.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)declaredEx);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log(tag.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)documentedEx);
                }
            }
            if (found) continue;
            boolean reqd = true;
            if (this.mAllowUndeclaredRTE) {
                ClassResolver cr = this.getClassResolver();
                try {
                    Class clazz = cr.resolve(tag.getArg1());
                    reqd = !(class$java$lang$RuntimeException == null ? JavadocMethodCheck.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(clazz) && !(class$java$lang$Error == null ? JavadocMethodCheck.class$("java.lang.Error") : class$java$lang$Error).isAssignableFrom(clazz);
                }
                catch (ClassNotFoundException e) {
                    this.log(tag.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)tag.getArg1());
                }
            }
            if (!reqd) continue;
            this.log(tag.getLineNo(), "javadoc.unusedTag", (Object)"@throws", (Object)tag.getArg1());
        }
        if (!this.mAllowMissingThrowsTags) {
            ListIterator throwIt = aThrows.listIterator();
            while (throwIt.hasNext()) {
                ExceptionInfo ei = (ExceptionInfo)throwIt.next();
                if (ei.isFound()) continue;
                FullIdent fi = ei.getFullIdent();
                this.log(fi.getLineNo(), fi.getColumnNo(), "javadoc.expectedTag", "@throws", fi.getText());
            }
        }
    }

    final ClassResolver getClassResolver() {
        if (this.mClassResolver == null) {
            this.mClassResolver = new ClassResolver(this.getClassLoader(), this.mPackageFullIdent.getText(), this.mImports);
        }
        return this.mClassResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

