/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;

public class Page {
    private static final int SHARED_KEYS = 1;
    private static final int SHARED_VALUES = 2;
    private static final int SHARED_CHILDREN = 4;
    private static final int SHARED_COUNTS = 8;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final MVMap<?, ?> map;
    private long version;
    private long pos;
    private long totalCount;
    private int keyCount;
    private int cachedCompare;
    private int sharedFlags;
    private int memory;
    private Object[] keys;
    private Object[] values;
    private long[] children;
    private Page[] childrenPages;
    private long[] counts;

    Page(MVMap<?, ?> mVMap, long l) {
        this.map = mVMap;
        this.version = l;
    }

    public static Page createEmpty(MVMap<?, ?> mVMap, long l) {
        return Page.create(mVMap, l, 0, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, null, null, null, 0L, 0, 128);
    }

    public static Page create(MVMap<?, ?> mVMap, long l, int n, Object[] objectArray, Object[] objectArray2, long[] lArray, Page[] pageArray, long[] lArray2, long l2, int n2, int n3) {
        Page page = new Page(mVMap, l);
        page.keys = objectArray;
        page.keyCount = n;
        page.values = objectArray2;
        page.children = lArray;
        page.childrenPages = pageArray;
        page.counts = lArray2;
        page.totalCount = l2;
        page.sharedFlags = n2;
        page.memory = n3 == 0 ? page.calculateMemory() : n3;
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage();
        }
        return page;
    }

    static Page read(FileChannel fileChannel, MVMap<?, ?> mVMap, long l, long l2, long l3) {
        ByteBuffer byteBuffer;
        int n = DataUtils.getPageMaxLength(l);
        int n2 = n = (int)Math.min(l3 - l2, (long)n);
        if (n == Integer.MAX_VALUE) {
            byteBuffer = ByteBuffer.allocate(128);
            DataUtils.readFully(fileChannel, l2, byteBuffer);
            n = byteBuffer.getInt();
        }
        byteBuffer = ByteBuffer.allocate(n2);
        DataUtils.readFully(fileChannel, l2, byteBuffer);
        Page page = new Page(mVMap, 0L);
        page.pos = l;
        int n3 = DataUtils.getPageChunkId(l);
        int n4 = DataUtils.getPageOffset(l);
        page.read(byteBuffer, n3, n4, n);
        return page;
    }

    public Object getKey(int n) {
        return this.keys[n];
    }

    public Page getChildPage(int n) {
        Page page = this.childrenPages[n];
        return page != null ? page : this.map.readPage(this.children[n]);
    }

    public Object getValue(int n) {
        return this.values[n];
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public long getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id: ").append(System.identityHashCode(this)).append('\n');
        stringBuilder.append("pos: ").append(this.pos).append("\n");
        for (int i = 0; i <= this.keyCount; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            if (this.children != null) {
                stringBuilder.append("[" + this.children[i] + "] ");
            }
            if (i >= this.keyCount) continue;
            stringBuilder.append(this.keys[i]);
            if (this.values == null) continue;
            stringBuilder.append(':');
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    public Page copy(long l) {
        this.map.removePage(this.pos);
        Page page = Page.create(this.map, l, this.keyCount, this.keys, this.values, this.children, this.childrenPages, this.counts, this.totalCount, 15, this.memory);
        page.cachedCompare = this.cachedCompare;
        return page;
    }

    public int binarySearch(Object object) {
        int n = 0;
        int n2 = this.keyCount - 1;
        int n3 = this.cachedCompare - 1;
        if (n3 < 0 || n3 > n2) {
            n3 = n + n2 >>> 1;
        }
        Object[] objectArray = this.keys;
        while (n <= n2) {
            int n4 = this.map.compare(object, objectArray[n3]);
            if (n4 > 0) {
                n = n3 + 1;
            } else if (n4 < 0) {
                n2 = n3 - 1;
            } else {
                this.cachedCompare = n3 + 1;
                return n3;
            }
            n3 = n + n2 >>> 1;
        }
        this.cachedCompare = n;
        return -(n + 1);
    }

    public Page split(int n) {
        return this.isLeaf() ? this.splitLeaf(n) : this.splitNode(n);
    }

    private Page splitLeaf(int n) {
        int n2 = n;
        int n3 = this.keyCount - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2, objectArray2, 0, n3);
        this.keys = objectArray;
        this.keyCount = n2;
        Object[] objectArray3 = new Object[n2];
        Object[] objectArray4 = new Object[n3];
        objectArray4 = new Object[n3];
        System.arraycopy(this.values, 0, objectArray3, 0, n2);
        System.arraycopy(this.values, n2, objectArray4, 0, n3);
        this.values = objectArray3;
        this.sharedFlags &= 0xFFFFFFFC;
        this.totalCount = n2;
        Page page = Page.create(this.map, this.version, n3, objectArray2, objectArray4, null, null, null, objectArray2.length, 0, 0);
        this.memory = this.calculateMemory();
        page.memory = page.calculateMemory();
        return page;
    }

    private Page splitNode(int n) {
        int n2 = n;
        int n3 = this.keyCount - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3 - 1];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2 + 1, objectArray2, 0, n3 - 1);
        this.keys = objectArray;
        this.keyCount = n2;
        long[] lArray = new long[n2 + 1];
        long[] lArray2 = new long[n3];
        System.arraycopy(this.children, 0, lArray, 0, n2 + 1);
        System.arraycopy(this.children, n2 + 1, lArray2, 0, n3);
        this.children = lArray;
        Page[] pageArray = new Page[n2 + 1];
        Page[] pageArray2 = new Page[n3];
        System.arraycopy(this.childrenPages, 0, pageArray, 0, n2 + 1);
        System.arraycopy(this.childrenPages, n2 + 1, pageArray2, 0, n3);
        this.childrenPages = pageArray;
        long[] lArray3 = new long[n2 + 1];
        long[] lArray4 = new long[n3];
        System.arraycopy(this.counts, 0, lArray3, 0, n2 + 1);
        System.arraycopy(this.counts, n2 + 1, lArray4, 0, n3);
        this.counts = lArray3;
        this.sharedFlags &= 0xFFFFFFF2;
        long l = 0L;
        for (long l2 : lArray3) {
            l += l2;
        }
        this.totalCount = l;
        l = 0L;
        for (long l2 : lArray4) {
            l += l2;
        }
        Object object = Page.create(this.map, this.version, n3 - 1, objectArray2, null, lArray2, pageArray2, lArray4, l, 0, 0);
        this.memory = this.calculateMemory();
        ((Page)object).memory = super.calculateMemory();
        return object;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    long getCounts(int n) {
        return this.counts[n];
    }

    public void setChild(int n, Page page) {
        if (page != this.childrenPages[n] || page.getPos() != this.children[n]) {
            if ((this.sharedFlags & 4) != 0) {
                this.children = Arrays.copyOf(this.children, this.children.length);
                this.childrenPages = Arrays.copyOf(this.childrenPages, this.childrenPages.length);
                this.sharedFlags &= 0xFFFFFFFB;
            }
            this.children[n] = page.getPos();
            this.childrenPages[n] = page;
        }
    }

    public void setCounts(int n, Page page) {
        this.setCounts(n, page.totalCount);
    }

    public void setCounts(int n, long l) {
        if (l != this.counts[n]) {
            if ((this.sharedFlags & 8) != 0) {
                this.counts = Arrays.copyOf(this.counts, this.counts.length);
                this.sharedFlags &= 0xFFFFFFF7;
            }
            long l2 = this.counts[n];
            this.counts[n] = l;
            this.totalCount += this.counts[n] - l2;
        }
    }

    public void setKey(int n, Object object) {
        if ((this.sharedFlags & 1) != 0) {
            this.keys = Arrays.copyOf(this.keys, this.keys.length);
            this.sharedFlags &= 0xFFFFFFFE;
        }
        Object object2 = this.keys[n];
        DataType dataType = this.map.getKeyType();
        if (object2 != null) {
            this.memory -= dataType.getMemory(object2);
        }
        this.memory += dataType.getMemory(object);
        this.keys[n] = object;
    }

    public Object setValue(int n, Object object) {
        Object object2 = this.values[n];
        if ((this.sharedFlags & 2) != 0) {
            this.values = Arrays.copyOf(this.values, this.values.length);
            this.sharedFlags &= 0xFFFFFFFD;
        }
        DataType dataType = this.map.getValueType();
        this.memory -= dataType.getMemory(object2);
        this.memory += dataType.getMemory(object);
        this.values[n] = object;
        return object2;
    }

    void removeAllRecursive() {
        if (this.children != null) {
            int n = this.children.length;
            for (int i = 0; i < n; ++i) {
                Page page = this.childrenPages[i];
                if (page != null) {
                    page.removeAllRecursive();
                    continue;
                }
                long l = this.children[i];
                int n2 = DataUtils.getPageType(l);
                if (n2 == 0) {
                    this.map.removePage(l);
                    continue;
                }
                this.map.readPage(l).removeAllRecursive();
            }
        }
        this.map.removePage(this.pos);
    }

    public void insertLeaf(int n, Object object, Object object2) {
        if ((this.sharedFlags & 1) == 0 && this.keys.length > this.keyCount + 1) {
            if (n < this.keyCount) {
                System.arraycopy(this.keys, n, this.keys, n + 1, this.keyCount - n);
                System.arraycopy(this.values, n, this.values, n + 1, this.keyCount - n);
            }
        } else {
            int n2 = this.keyCount + 6;
            Object[] objectArray = new Object[n2];
            DataUtils.copyWithGap(this.keys, objectArray, this.keyCount, n);
            this.keys = objectArray;
            Object[] objectArray2 = new Object[n2];
            DataUtils.copyWithGap(this.values, objectArray2, this.keyCount, n);
            this.values = objectArray2;
        }
        this.keys[n] = object;
        this.values[n] = object2;
        ++this.keyCount;
        this.sharedFlags &= 0xFFFFFFFC;
        ++this.totalCount;
        this.memory += this.map.getKeyType().getMemory(object);
        this.memory += this.map.getValueType().getMemory(object2);
    }

    public void insertNode(int n, Object object, Page page) {
        Object[] objectArray = new Object[this.keyCount + 1];
        DataUtils.copyWithGap(this.keys, objectArray, this.keyCount, n);
        objectArray[n] = object;
        this.keys = objectArray;
        ++this.keyCount;
        long[] lArray = new long[this.children.length + 1];
        DataUtils.copyWithGap(this.children, lArray, this.children.length, n);
        lArray[n] = page.getPos();
        this.children = lArray;
        Page[] pageArray = new Page[this.childrenPages.length + 1];
        DataUtils.copyWithGap(this.childrenPages, pageArray, this.childrenPages.length, n);
        pageArray[n] = page;
        this.childrenPages = pageArray;
        long[] lArray2 = new long[this.counts.length + 1];
        DataUtils.copyWithGap(this.counts, lArray2, this.counts.length, n);
        lArray2[n] = page.totalCount;
        this.counts = lArray2;
        this.sharedFlags &= 0xFFFFFFF2;
        this.totalCount += page.totalCount;
        this.memory += this.map.getKeyType().getMemory(object);
        this.memory += 16;
    }

    public void remove(int n) {
        Object[] objectArray;
        int n2 = n >= this.keyCount ? n - 1 : n;
        Object object = this.keys[n2];
        this.memory -= this.map.getKeyType().getMemory(object);
        if ((this.sharedFlags & 1) == 0 && this.keys.length > this.keyCount - 4) {
            if (n2 < this.keyCount - 1) {
                System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.keyCount - n2 - 1);
            }
            this.keys[this.keyCount - 1] = null;
        } else {
            objectArray = new Object[this.keyCount - 1];
            DataUtils.copyExcept(this.keys, objectArray, this.keyCount, n2);
            this.keys = objectArray;
            this.sharedFlags &= 0xFFFFFFFE;
        }
        if (this.values != null) {
            object = this.values[n];
            this.memory -= this.map.getValueType().getMemory(object);
            if ((this.sharedFlags & 2) == 0 && this.values.length > this.keyCount - 4) {
                if (n < this.keyCount - 1) {
                    System.arraycopy(this.values, n + 1, this.values, n, this.keyCount - n - 1);
                }
                this.values[this.keyCount - 1] = null;
            } else {
                objectArray = new Object[this.keyCount - 1];
                DataUtils.copyExcept(this.values, objectArray, this.keyCount, n);
                this.values = objectArray;
                this.sharedFlags &= 0xFFFFFFFD;
            }
            --this.totalCount;
        }
        --this.keyCount;
        if (this.children != null) {
            this.memory -= 16;
            long l = this.counts[n];
            long[] lArray = new long[this.children.length - 1];
            DataUtils.copyExcept(this.children, lArray, this.children.length, n);
            this.children = lArray;
            Page[] pageArray = new Page[this.childrenPages.length - 1];
            DataUtils.copyExcept(this.childrenPages, pageArray, this.childrenPages.length, n);
            this.childrenPages = pageArray;
            long[] lArray2 = new long[this.counts.length - 1];
            DataUtils.copyExcept(this.counts, lArray2, this.counts.length, n);
            this.counts = lArray2;
            this.sharedFlags &= 0xFFFFFFF3;
            this.totalCount -= l;
        }
    }

    void read(ByteBuffer byteBuffer, int n, int n2, int n3) {
        Object object;
        int n4;
        int n5;
        Object object2;
        boolean bl;
        int n6 = byteBuffer.position();
        int n7 = byteBuffer.getInt();
        if (n7 > n3) {
            throw DataUtils.newIllegalStateException("File corrupted, expected length =< {0}, got {1}", n3, n7);
        }
        short s = byteBuffer.getShort();
        int n8 = DataUtils.readVarInt(byteBuffer);
        if (n8 != this.map.getId()) {
            throw DataUtils.newIllegalStateException("File corrupted, expected map id {0}, got {1}", this.map.getId(), n8);
        }
        int n9 = DataUtils.getCheckValue(n) ^ DataUtils.getCheckValue(n2) ^ DataUtils.getCheckValue(n7);
        if (s != (short)n9) {
            throw DataUtils.newIllegalStateException("File corrupted, expected check value {0}, got {1}", n9, s);
        }
        int n10 = DataUtils.readVarInt(byteBuffer);
        this.keys = new Object[n10];
        this.keyCount = n10;
        byte by = byteBuffer.get();
        boolean bl2 = (by & 1) == 1;
        boolean bl3 = bl = (by & 2) != 0;
        if (bl) {
            object2 = this.map.getStore().getCompressor();
            n5 = DataUtils.readVarInt(byteBuffer);
            n4 = n7 + n6 - byteBuffer.position();
            object = DataUtils.newBytes(n4);
            byteBuffer.get((byte[])object);
            int n11 = n4 + n5;
            byteBuffer = ByteBuffer.allocate(n11);
            object2.expand((byte[])object, 0, n4, byteBuffer.array(), 0, n11);
        }
        object2 = this.map.getKeyType();
        for (n5 = 0; n5 < n10; ++n5) {
            Object object3;
            this.keys[n5] = object3 = object2.read(byteBuffer);
        }
        if (bl2) {
            this.children = new long[n10 + 1];
            for (n5 = 0; n5 <= n10; ++n5) {
                this.children[n5] = byteBuffer.getLong();
            }
            this.childrenPages = new Page[n10 + 1];
            this.counts = new long[n10 + 1];
            long l = 0L;
            for (int i = 0; i <= n10; ++i) {
                long l2 = DataUtils.readVarLong(byteBuffer);
                l += l2;
                this.counts[i] = l2;
            }
            this.totalCount = l;
        } else {
            this.values = new Object[n10];
            DataType dataType = this.map.getValueType();
            for (n4 = 0; n4 < n10; ++n4) {
                object = dataType.read(byteBuffer);
                this.values[n4] = object;
            }
            this.totalCount = n10;
        }
        this.memory = this.calculateMemory();
    }

    private ByteBuffer write(Chunk chunk, ByteBuffer byteBuffer) {
        int n;
        int n2;
        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 1024);
        int n3 = byteBuffer.position();
        byteBuffer.putInt(0);
        byteBuffer.putShort((short)0);
        DataUtils.writeVarInt(byteBuffer, this.map.getId());
        int n4 = this.keyCount;
        DataUtils.writeVarInt(byteBuffer, n4);
        int n5 = this.children != null ? 1 : 0;
        byteBuffer.put((byte)n5);
        int n6 = byteBuffer.position();
        DataType dataType = this.map.getKeyType();
        for (n2 = 0; n2 < n4; ++n2) {
            byteBuffer = dataType.write(byteBuffer, this.keys[n2]);
        }
        if (n5 == 1) {
            for (n2 = 0; n2 <= n4; ++n2) {
                byteBuffer.putLong(this.children[n2]);
            }
            for (n2 = 0; n2 <= n4; ++n2) {
                DataUtils.writeVarLong(byteBuffer, this.counts[n2]);
            }
        } else {
            DataType dataType2 = this.map.getValueType();
            for (n = 0; n < n4; ++n) {
                byteBuffer = dataType2.write(byteBuffer, this.values[n]);
            }
        }
        if (this.map.getStore().getCompress()) {
            Compressor compressor = this.map.getStore().getCompressor();
            n = byteBuffer.position() - n6;
            byte[] byArray = new byte[n];
            byteBuffer.position(n6);
            byteBuffer.get(byArray);
            byte[] byArray2 = new byte[byArray.length * 2];
            int n7 = compressor.compress(byArray, byArray.length, byArray2, 0);
            if (n7 + DataUtils.getVarIntLen(n7 - n) < n) {
                byteBuffer.position(n6 - 1);
                byteBuffer.put((byte)(n5 + 2));
                DataUtils.writeVarInt(byteBuffer, n - n7);
                byteBuffer.put(byArray2, 0, n7);
            }
        }
        int n8 = byteBuffer.position() - n3;
        byteBuffer.putInt(n3, n8);
        n = chunk.id;
        int n9 = DataUtils.getCheckValue(n) ^ DataUtils.getCheckValue(n3) ^ DataUtils.getCheckValue(n8);
        byteBuffer.putShort(n3 + 4, (short)n9);
        if (this.pos != 0L) {
            throw DataUtils.newIllegalStateException("Page already stored", new Object[0]);
        }
        this.pos = DataUtils.getPagePos(n, n3, n8, n5);
        long l = DataUtils.getPageMaxLength(this.pos);
        chunk.maxLength += l;
        chunk.maxLengthLive += l;
        ++chunk.pageCount;
        ++chunk.pageCountLive;
        return byteBuffer;
    }

    ByteBuffer writeUnsavedRecursive(Chunk chunk, ByteBuffer byteBuffer) {
        if (this.pos != 0L) {
            return byteBuffer;
        }
        if (!this.isLeaf()) {
            int n = this.children.length;
            for (int i = 0; i < n; ++i) {
                Page page = this.childrenPages[i];
                if (page == null) continue;
                byteBuffer = page.writeUnsavedRecursive(chunk, byteBuffer);
                this.children[i] = page.getPos();
            }
        }
        return this.write(chunk, byteBuffer);
    }

    void writeEnd() {
        if (!this.isLeaf()) {
            int n = this.children.length;
            for (int i = 0; i < n; ++i) {
                Page page = this.childrenPages[i];
                if (page == null) continue;
                page.writeEnd();
                this.childrenPages[i] = null;
            }
        }
    }

    long getVersion() {
        return this.version;
    }

    public int getChildPageCount() {
        return this.children.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Page) {
            if (this.pos != 0L && ((Page)object).pos == this.pos) {
                return true;
            }
            return this == object;
        }
        return false;
    }

    public int hashCode() {
        return this.pos != 0L ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    public int getMemory() {
        return this.memory;
    }

    private int calculateMemory() {
        int n = 128;
        DataType dataType = this.map.getKeyType();
        for (int i = 0; i < this.keyCount; ++i) {
            n += dataType.getMemory(this.keys[i]);
        }
        if (this.isLeaf()) {
            DataType dataType2 = this.map.getValueType();
            for (int i = 0; i < this.keyCount; ++i) {
                n += dataType2.getMemory(this.values[i]);
            }
        } else {
            n += this.getChildPageCount() * 16;
        }
        return n;
    }

    void setVersion(long l) {
        this.version = l;
    }
}

