/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.documentnavigation.outline;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.exceptions.OutlineNotLocalException;
import org.pdfbox.pdmodel.PDDestinationNameTreeNode;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceInstance;
import org.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PDOutlineItem
extends PDOutlineNode {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public PDOutlineItem() {
    }

    public PDOutlineItem(COSDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(PDOutlineItem item) {
        item.setParent(this.getParent());
        PDOutlineItem next = this.getNextSibling();
        this.setNextSibling(item);
        item.setPreviousSibling(this);
        if (next != null) {
            item.setNextSibling(next);
            next.setPreviousSibling(item);
        }
        this.updateParentOpenCount(1);
    }

    public PDOutlineItem getPreviousSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject("Prev");
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setPreviousSibling(PDOutlineNode outlineNode) {
        this.node.setItem("Prev", (COSObjectable)outlineNode);
    }

    public PDOutlineItem getNextSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject("Next");
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setNextSibling(PDOutlineNode outlineNode) {
        this.node.setItem("Next", (COSObjectable)outlineNode);
    }

    public String getTitle() {
        return this.node.getString("Title");
    }

    public void setTitle(String title) {
        this.node.setString("Title", title);
    }

    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.node.getDictionaryObject("Dest"));
    }

    public void setDestination(PDDestination dest) {
        this.node.setItem("Dest", (COSObjectable)dest);
    }

    public void setDestination(PDPage page) {
        PDPageXYZDestination dest = null;
        if (page != null) {
            dest = new PDPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    public PDPage findDestinationPage(PDDocument doc) throws IOException, OutlineNotLocalException {
        int pageNumber;
        PDPage page = null;
        PDDestination rawDest = this.getDestination();
        if (rawDest == null) {
            PDAction outlineAction = this.getAction();
            if (outlineAction instanceof PDActionGoTo) {
                rawDest = ((PDActionGoTo)outlineAction).getDestination();
            } else if (outlineAction != null) {
                throw new OutlineNotLocalException("Error: Outline does not reference a local page.");
            }
        }
        PDPageDestination pageDest = null;
        if (rawDest instanceof PDNamedDestination) {
            PDDestinationNameTreeNode destsTree;
            PDNamedDestination namedDest = (PDNamedDestination)rawDest;
            PDDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
            if (namesDict != null && (destsTree = namesDict.getDests()) != null) {
                pageDest = (PDPageDestination)destsTree.getValue(namedDest.getNamedDestination());
            }
        } else if (rawDest instanceof PDPageDestination) {
            pageDest = (PDPageDestination)rawDest;
        } else if (rawDest != null) {
            throw new IOException("Error: Unknown destination type " + rawDest);
        }
        if (pageDest != null && (page = pageDest.getPage()) == null && (pageNumber = pageDest.getPageNumber()) != -1) {
            List allPages = doc.getDocumentCatalog().getAllPages();
            page = (PDPage)allPages.get(pageNumber);
        }
        return page;
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.node.getDictionaryObject("A"));
    }

    public void setAction(PDAction action) {
        this.node.setItem("A", (COSObjectable)action);
    }

    public PDStructureElement getStructureElement() {
        PDStructureElement se = null;
        COSDictionary dic = (COSDictionary)this.node.getDictionaryObject("SE");
        if (dic != null) {
            se = new PDStructureElement(dic);
        }
        return se;
    }

    public void setAction(PDStructureElement structureElement) {
        this.node.setItem("SE", (COSObjectable)structureElement);
    }

    public PDColorSpaceInstance getTextColor() {
        PDColorSpaceInstance retval = null;
        COSArray csValues = (COSArray)this.node.getDictionaryObject("C");
        if (csValues == null) {
            csValues = new COSArray();
            csValues.growToSize(3, new COSFloat(0.0f));
            this.node.setItem("C", (COSBase)csValues);
        }
        retval = new PDColorSpaceInstance(csValues);
        retval.setColorSpace(PDDeviceRGB.INSTANCE);
        return retval;
    }

    public void setTextColor(PDColorSpaceInstance textColor) {
        this.node.setItem("C", (COSBase)textColor.getCOSColorSpaceValue());
    }

    public boolean isItalic() {
        return (this.node.getInt("F", 0) & 1) == 1;
    }

    public void setItalic(boolean italic) {
        int f = this.node.getInt("F", 0);
        f = italic ? (f |= 1) : (f ^= 1);
        this.node.setInt("F", f);
    }

    public boolean isBold() {
        return (this.node.getInt("F", 0) & 2) == 2;
    }

    public void setBold(boolean bold) {
        int f = this.node.getInt("F", 0);
        f = bold ? (f |= 2) : (f ^= 2);
        this.node.setInt("F", f);
    }
}

