/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.toString());
    public static final int PARSE_MODE_NORMAL = 0;
    public static final int PARSE_MODE_OBJECT_STREAM = 1;
    private InputStream reader;
    boolean lastTokenHString = false;
    private Stack<Object> stack = new Stack();
    private int parseMode;

    public Parser(SeekableInput seekableInput) {
        this(seekableInput, 0);
    }

    public Parser(SeekableInput seekableInput, int n) {
        this.reader = seekableInput.getInputStream();
        this.parseMode = n;
    }

    public Parser(InputStream inputStream) {
        this(inputStream, 0);
    }

    public Parser(InputStream inputStream, int n) {
        this.reader = new BufferedInputStream(inputStream);
        this.parseMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Library library) throws PDFException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        Reference reference = null;
        try {
            do {
                Object object;
                Object object2;
                Object object3;
                try {
                    object3 = this.getToken();
                }
                catch (IOException iOException) {
                    return null;
                }
                if (object3 instanceof StringObject || object3 instanceof Name || object3 instanceof Number) {
                    if (object3 instanceof StringObject) {
                        object2 = (StringObject)object3;
                        object2.setReference(reference);
                    }
                    this.stack.push(object3);
                } else if (object3.equals("obj")) {
                    n = 1;
                    bl = true;
                    object2 = (Number)this.stack.pop();
                    object = (Number)this.stack.pop();
                    reference = new Reference((Number)object, (Number)object2);
                } else {
                    Object object4;
                    if (object3.equals("endobj")) {
                        --n;
                        if (bl) {
                            bl = false;
                            return this.addPObject(library, reference);
                        }
                        return null;
                    }
                    if (object3.equals("endstream")) {
                        --n;
                        if (bl) {
                            bl = false;
                            return this.addPObject(library, reference);
                        }
                    } else if (object3.equals("stream")) {
                        Object object5;
                        Object object6;
                        Object object7;
                        ++n;
                        object2 = (Hashtable)this.stack.pop();
                        int n2 = library.getInt((Hashtable)object2, "Length");
                        try {
                            this.reader.mark(2);
                            int n3 = this.reader.read();
                            if (n3 == 13) {
                                this.reader.mark(1);
                                if (this.reader.read() != 10) {
                                    this.reader.reset();
                                }
                            } else if (n3 != 10) {
                                this.reader.reset();
                            }
                            if (this.reader instanceof SeekableInput) {
                                long l;
                                object7 = (SeekableInput)((Object)this.reader);
                                long l2 = object7.getAbsolutePosition();
                                if (n2 > 0) {
                                    l = n2;
                                    object7.seekRelative(n2);
                                    l += this.skipUntilEndstream(null);
                                } else {
                                    l = this.captureStreamData(null);
                                }
                                object4 = new SeekableInputConstrainedWrapper((SeekableInput)object7, l2, l, false);
                            } else {
                                if (!library.isLinearTraversal() && n2 > 0) {
                                    int n4;
                                    object6 = new byte[n2];
                                    for (int i = 0; i < ((byte[])object6).length && (n4 = this.reader.read((byte[])object6, i, ((byte[])object6).length - i)) > 0; i += n4) {
                                    }
                                    object7 = new ConservativeSizingByteArrayOutputStream((byte[])object6, library.memoryManager);
                                    this.skipUntilEndstream((OutputStream)object7);
                                } else {
                                    object7 = new ConservativeSizingByteArrayOutputStream(16384, library.memoryManager);
                                    this.captureStreamData((OutputStream)object7);
                                }
                                int n5 = ((ConservativeSizingByteArrayOutputStream)object7).size();
                                ((ConservativeSizingByteArrayOutputStream)object7).trim();
                                object5 = ((ConservativeSizingByteArrayOutputStream)object7).relinquishByteArray();
                                SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream((byte[])object5);
                                long l = 0L;
                                long l3 = n5;
                                object4 = new SeekableInputConstrainedWrapper(seekableByteArrayInputStream, l, l3, true);
                            }
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                        PTrailer pTrailer = null;
                        object7 = null;
                        object6 = (Name)library.getObject((Hashtable)object2, "Type");
                        object5 = (Name)library.getObject((Hashtable)object2, "Subtype");
                        if (object6 != null) {
                            if (((Name)object6).equals("Pattern")) {
                                object7 = new TilingPattern(library, (Hashtable)object2, (SeekableInputConstrainedWrapper)object4);
                            } else if (((Name)object6).equals("XRef")) {
                                object7 = new Stream(library, (Hashtable)object2, (SeekableInputConstrainedWrapper)object4);
                                ((Dictionary)object7).init();
                                InputStream inputStream = ((Stream)object7).getInputStreamForDecodedStreamBytes();
                                CrossReference crossReference = new CrossReference();
                                if (inputStream != null) {
                                    try {
                                        crossReference.addXRefStreamEntries(library, (Hashtable)object2, inputStream);
                                    }
                                    finally {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            logger.log(Level.FINE, "Error appending stream entries.", iOException);
                                        }
                                    }
                                }
                                ((Stream)object7).dispose(false);
                                Hashtable hashtable = (Hashtable)((Hashtable)object2).clone();
                                pTrailer = new PTrailer(library, hashtable, null, crossReference);
                            } else if (((Name)object6).equals("ObjStm")) {
                                object7 = new ObjectStream(library, (Hashtable)object2, (SeekableInputConstrainedWrapper)object4);
                            }
                        }
                        if (object5 != null && ((Name)object5).equals("Form") && !"pattern".equals(object6)) {
                            object7 = new Form(library, (Hashtable)object2, (SeekableInputConstrainedWrapper)object4);
                        }
                        if (pTrailer != null) {
                            this.stack.push(pTrailer);
                        } else {
                            if (object7 == null) {
                                object7 = new Stream(library, (Hashtable)object2, (SeekableInputConstrainedWrapper)object4);
                            }
                            this.stack.push(object7);
                        }
                    } else if (object3.equals("true")) {
                        this.stack.push(new Boolean(true));
                    } else if (object3.equals("false")) {
                        this.stack.push(new Boolean(false));
                    } else if (object3.equals("R")) {
                        object2 = (Number)this.stack.pop();
                        object = (Number)this.stack.pop();
                        this.stack.push(new Reference((Number)object, (Number)object2));
                    } else if (object3.equals("[")) {
                        ++n;
                        this.stack.push(object3);
                    } else if (object3.equals("]")) {
                        --n;
                        object2 = new Vector<Object>();
                        object = this.stack.pop();
                        while (!(object instanceof String) || !object.equals("[")) {
                            ((Vector)object2).insertElementAt(object, 0);
                            object = this.stack.pop();
                        }
                        this.stack.push(object2);
                    } else if (object3.equals("<<")) {
                        ++n;
                        this.stack.push(object3);
                    } else if (object3.equals(">>")) {
                        --n;
                        object2 = new Hashtable();
                        if (!this.stack.isEmpty()) {
                            object = this.stack.pop();
                            while (!(object instanceof String && object.equals("<<") || this.stack.isEmpty())) {
                                object4 = this.stack.pop();
                                ((Hashtable)object2).put(object4, object);
                                if (this.stack.isEmpty()) break;
                                object = this.stack.pop();
                            }
                            if ((object = ((Hashtable)object2).get("Type")) != null && object instanceof Name) {
                                object4 = (Name)object;
                                if (((Name)object4).equals("Catalog")) {
                                    this.stack.push(new Catalog(library, (Hashtable)object2));
                                } else if (((Name)object4).equals("Pages")) {
                                    this.stack.push(new PageTree(library, (Hashtable)object2));
                                } else if (((Name)object4).equals("Page")) {
                                    this.stack.push(new Page(library, (Hashtable)object2));
                                } else if (((Name)object4).equals("Font")) {
                                    this.stack.push(FontFactory.getInstance().getFont(library, (Hashtable)object2));
                                } else if (((Name)object4).equals("FontDescriptor")) {
                                    this.stack.push(new FontDescriptor(library, (Hashtable)object2));
                                } else if (((Name)object4).equals("CMap")) {
                                    this.stack.push(object2);
                                } else if (((Name)object4).equals("Annot")) {
                                    this.stack.push(Annotation.buildAnnotation(library, (Hashtable)object2));
                                } else {
                                    this.stack.push(object2);
                                }
                            } else {
                                this.stack.push(object2);
                            }
                            if (n == 0) {
                                return this.stack.pop();
                            }
                        }
                    } else if (object3.equals("xref")) {
                        object2 = new CrossReference();
                        ((CrossReference)object2).addXRefTableEntries(this);
                        this.stack.push(object2);
                    } else {
                        if (object3.equals("trailer")) {
                            object2 = null;
                            if (this.stack.peek() instanceof CrossReference) {
                                object2 = (CrossReference)this.stack.pop();
                            }
                            this.stack.clear();
                            object = (Hashtable)this.getObject(library);
                            return new PTrailer(library, (Hashtable)object, (CrossReference)object2, null);
                        }
                        if (!(object3 instanceof String) || !((String)object3).startsWith("%")) {
                            this.stack.push(object3);
                        }
                    }
                }
                if (this.parseMode != 1 || n != 0 || this.stack.size() <= 0) continue;
                return this.stack.pop();
            } while (!bl2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Fatal error parsing PDF file stream.", exception);
            return null;
        }
        return this.stack.pop();
    }

    public PObject addPObject(Library library, Reference reference) {
        Object object = this.stack.pop();
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            stream.setPObjectReference(reference);
        } else if (object instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object;
            dictionary.setPObjectReference(reference);
        }
        library.addObject(object, reference);
        return new PObject(object, reference);
    }

    public Object getStreamObject() throws IOException {
        Cloneable cloneable = this.getToken();
        if (cloneable instanceof String) {
            if (((Object)cloneable).equals("<<")) {
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                Object object = this.getStreamObject();
                while (!object.equals(">>")) {
                    hashtable.put(object, this.getStreamObject());
                    object = this.getStreamObject();
                }
                cloneable = hashtable;
            } else if (((Object)cloneable).equals("[")) {
                Vector<Object> vector = new Vector<Object>();
                Object object = this.getStreamObject();
                while (!object.equals("]")) {
                    vector.addElement(object);
                    object = this.getStreamObject();
                }
                cloneable = vector;
            }
        }
        return cloneable;
    }

    public Object getToken() throws IOException {
        int n;
        int n2;
        char c;
        boolean bl = false;
        boolean bl2 = false;
        this.lastTokenHString = false;
        do {
            if ((n2 = this.reader.read()) >= 0) continue;
            throw new IOException();
        } while (Parser.isWhitespace(c = (char)n2));
        if (c == '(') {
            bl = true;
        } else {
            if (c == ']') {
                return "]";
            }
            if (c == '[') {
                return "[";
            }
            if (c == '%') {
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    stringBuffer.append(c);
                    n2 = this.reader.read();
                    if (n2 >= 0) continue;
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    throw new IOException();
                } while ((c = (char)n2) != '\r' && c != '\n');
                return stringBuffer.toString();
            }
        }
        this.reader.mark(1);
        char c2 = (char)this.reader.read();
        if (c == '>' && c2 == '>') {
            return ">>";
        }
        if (c == '<') {
            if (c2 == '<') {
                return "<<";
            }
            bl = true;
            bl2 = true;
        }
        this.reader.reset();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        int n3 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            block36: {
                block34: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        block38: {
                                            block37: {
                                                block35: {
                                                    if (!bl) {
                                                        this.reader.mark(1);
                                                    }
                                                    if ((n2 = this.reader.read()) < 0) {
                                                        return stringBuffer.toString();
                                                    }
                                                    c = (char)n2;
                                                    if (!bl) break block34;
                                                    if (!bl2) break block35;
                                                    if (c == '>') {
                                                        bl3 = true;
                                                        stringBuffer.append(c);
                                                        break;
                                                    }
                                                    break block36;
                                                }
                                                if (c == '(') {
                                                    ++n3;
                                                }
                                                if (c == ')') {
                                                    if (n3 == 0) {
                                                        bl3 = true;
                                                        stringBuffer.append(c);
                                                        break;
                                                    }
                                                    --n3;
                                                }
                                                if (c != '\\') break block36;
                                                c = (char)this.reader.read();
                                                if (!Character.isDigit(c)) break block37;
                                                StringBuffer stringBuffer2 = new StringBuffer();
                                                stringBuffer2.append(c);
                                                for (n = 0; n < 2; ++n) {
                                                    this.reader.mark(1);
                                                    c = (char)this.reader.read();
                                                    if (!Character.isDigit(c)) {
                                                        this.reader.reset();
                                                        break;
                                                    }
                                                    stringBuffer2.append(c);
                                                }
                                                n = 0;
                                                try {
                                                    n = Integer.parseInt(stringBuffer2.toString(), 8);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    logger.log(Level.FINE, "Integer parse error ", numberFormatException);
                                                }
                                                c = (char)n;
                                                break block36;
                                            }
                                            if (c == '(' || c == ')' || c == '\\') break block36;
                                            if (c != 't') break block38;
                                            c = '\t';
                                            break block36;
                                        }
                                        if (c != 114) break block39;
                                        c = '\r';
                                        break block36;
                                    }
                                    if (c != 110) break block40;
                                    c = '\n';
                                    break block36;
                                }
                                if (c != 98) break block41;
                                c = '\b';
                                break block36;
                            }
                            if (c != 102) break block42;
                            c = '\f';
                            break block36;
                        }
                        if (c != 13) break block43;
                        bl4 = true;
                        break block36;
                    }
                    if (!logger.isLoggable(Level.FINE)) break block36;
                    logger.warning("C=" + c);
                    break block36;
                }
                if (Parser.isWhitespace(c)) {
                    if (n2 != 13 && n2 != 10) break;
                    this.reader.reset();
                    break;
                }
                if (Parser.isDelimiter(c)) {
                    this.reader.reset();
                    break;
                }
            }
            if (!bl4) {
                stringBuffer.append(c);
                continue;
            }
            bl4 = false;
        } while (!bl3);
        if (bl2) {
            this.lastTokenHString = true;
            return new HexStringObject(stringBuffer);
        }
        if (bl) {
            return new LiteralStringObject(stringBuffer);
        }
        if (stringBuffer.charAt(0) == '/') {
            return new Name(stringBuffer.deleteCharAt(0));
        }
        boolean bl5 = false;
        n = 0;
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c3 = stringBuffer.charAt(i);
            if (c3 == '.') {
                n = 1;
                continue;
            }
            if (c3 < '0' || c3 > '9') continue;
            bl5 = true;
        }
        if (bl5) {
            try {
                if (n != 0) {
                    return Float.valueOf(stringBuffer.toString());
                }
                return Integer.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public Object getNumberOrStringWithMark(int n) throws IOException {
        int n2;
        this.reader.mark(n);
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n && (n2 = this.reader.read()) >= 0; ++i) {
            char c = (char)n2;
            if (Parser.isWhitespace(c)) {
                if (!bl) continue;
                break;
            }
            if (Parser.isDelimiter(c)) {
                this.reader.reset();
                this.reader.mark(n);
                for (int j = 0; j < i; ++j) {
                    this.reader.read();
                }
                bl = true;
                break;
            }
            bl = true;
            if (c == '.') {
                bl3 = true;
            } else if (c >= '0' && n2 <= 57) {
                bl2 = true;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            try {
                if (bl3) {
                    return Float.valueOf(stringBuffer.toString());
                }
                return Integer.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void ungetNumberOrStringWithReset() throws IOException {
        this.reader.reset();
    }

    public int getIntSurroundedByWhitespace() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n2;
            while ((n2 = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)n2)) {
                    if (!bl2) continue;
                    break;
                }
                if (n2 == 45) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (n2 < 48 || n2 > 57) continue;
                n *= 10;
                n += n2 - 48;
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error detecting int.", iOException);
        }
        if (bl) {
            n *= -1;
        }
        return n;
    }

    public long getLongSurroundedByWhitespace() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            while ((n = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)n)) {
                    if (!bl2) continue;
                    break;
                }
                if (n == 45) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (n < 48 || n > 57) continue;
                l *= 10L;
                l += (long)(n - 48);
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error detecting long.", iOException);
        }
        if (bl) {
            l *= -1L;
        }
        return l;
    }

    public char getCharSurroundedByWhitespace() {
        char c = '\u0000';
        try {
            int n;
            while ((n = this.reader.read()) >= 0) {
                char c2 = (char)n;
                if (Character.isWhitespace(c2)) continue;
                c = c2;
                break;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error detecting char.", iOException);
        }
        return c;
    }

    int hexToInt(String string) {
        string = string.substring(1, string.length() - 1).toUpperCase();
        return Integer.parseInt(string, 16);
    }

    String hexToString(String string) {
        string = string.substring(1, string.length() - 1).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == 'F' && string.charAt(1) == 'E' && string.charAt(2) == 'F' && string.charAt(3) == 'F') {
            byte[] byArray = new byte[4];
            for (int i = 1; i < string.length() / 4; ++i) {
                byArray[0] = (byte)string.charAt(i * 4);
                byArray[1] = (byte)string.charAt(i * 4 + 1);
                byArray[2] = (byte)string.charAt(i * 4 + 2);
                byArray[3] = (byte)string.charAt(i * 4 + 3);
                stringBuffer.append((char)Integer.parseInt(new String(byArray), 16));
            }
        } else {
            byte[] byArray = new byte[2];
            for (int i = 0; i < string.length() / 2; ++i) {
                try {
                    byArray[0] = (byte)string.charAt(i * 2);
                    byArray[1] = (byte)string.charAt(i * 2 + 1);
                    stringBuffer.append((char)Short.parseShort(new String(byArray), 16));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    boolean readLineForInlineImage(OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.reader.read()) >= 0) {
            if (n2 == 0 && n == 69) {
                ++n2;
                continue;
            }
            if (n2 == 1 && n == 73) {
                ++n2;
                continue;
            }
            if (n2 == 2 && Parser.isWhitespace((char)(0xFF & n))) {
                boolean bl = Parser.isStillInlineImageData(this.reader, 32);
                if (bl) {
                    outputStream.write(69);
                    outputStream.write(73);
                    outputStream.write(n);
                    n2 = 0;
                    if (n != 13 && n != 10) continue;
                    break;
                }
                return true;
            }
            if (n2 > 0) {
                outputStream.write(69);
            }
            if (n2 > 1) {
                outputStream.write(73);
            }
            n2 = 0;
            outputStream.write((byte)n);
            if (n != 13 && n != 10) continue;
            break;
        }
        return n2 == 2;
    }

    byte readByte() throws IOException {
        return (byte)this.reader.read();
    }

    public static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private static final boolean isDelimiter(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == '<' || c == '>' || c == '{' || c == '}' || c == '/' || c == '%';
    }

    private static boolean isExpectedInContentStream(char c) {
        return c >= 'a' && c <= 'Z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Parser.isWhitespace(c) || Parser.isDelimiter(c) || c == '\\' || c == '\'' || c == '\"' || c == '*' || c == '.';
    }

    private static boolean isStillInlineImageData(InputStream inputStream, int n) throws IOException {
        boolean bl = false;
        boolean bl2 = true;
        inputStream.mark(n);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        for (int i = 0; i < n2; ++i) {
            boolean bl3;
            char c = (char)(byArray[i] & 0xFF);
            boolean bl4 = bl3 = c == 'Q' || c == 'q' || c == 'S' || c == 's';
            if (bl2 && bl3 && i + 1 < n2 && Parser.isWhitespace((char)(byArray[i + 1] & 0xFF))) break;
            if (!Parser.isWhitespace(c)) {
                bl2 = false;
            }
            if (Parser.isExpectedInContentStream(c)) continue;
            bl = true;
            break;
        }
        inputStream.reset();
        return bl;
    }

    String peek2() throws IOException {
        this.reader.mark(2);
        char[] cArray = new char[]{(char)this.reader.read(), (char)this.reader.read()};
        String string = new String(cArray);
        this.reader.reset();
        return string;
    }

    private long captureStreamData(OutputStream outputStream) throws IOException {
        long l = 0L;
        while (true) {
            int n;
            if ((n = this.reader.read()) == 101) {
                this.reader.mark(10);
                if (this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) break;
                this.reader.reset();
            } else if (n < 0) break;
            if (outputStream != null) {
                outputStream.write(n);
            }
            ++l;
        }
        return l;
    }

    private long skipUntilEndstream(OutputStream outputStream) throws IOException {
        long l = 0L;
        while (true) {
            this.reader.mark(10);
            int n = this.reader.read();
            if (n == 101 && this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) {
                this.reader.reset();
                break;
            }
            if (n < 0) break;
            if (n == 10 || n == 13 || n == 32) continue;
            if (outputStream != null) {
                outputStream.write(n);
            }
            ++l;
        }
        return l;
    }
}

