/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.security.EncryptionDictionary;
import org.icepdf.core.pobjects.security.Permissions;
import org.icepdf.core.pobjects.security.SecurityHandler;
import org.icepdf.core.pobjects.security.StandardSecurityHandler;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class SecurityManager {
    private static final Logger logger = Logger.getLogger(SecurityManager.class.toString());
    private EncryptionDictionary encryptDictionary = null;
    private SecurityHandler securityHandler = null;
    private static boolean foundProvider = false;

    public void dispose() {
    }

    public SecurityManager(Library library, Hashtable hashtable, Vector vector) throws PDFSecurityException {
        try {
            Class.forName("javax.crypto.Cipher");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, "Sun JCE Support Not Found");
            throw new PDFSecurityException("Sun JCE Support Not Found");
        }
        if (!foundProvider) {
            logger.log(Level.SEVERE, "Security Provider was not found on classpath.");
            throw new PDFSecurityException("Security Provider Not Found.");
        }
        this.encryptDictionary = new EncryptionDictionary(library, hashtable, vector);
        if (!this.encryptDictionary.getPerferredSecurityHandlerName().equalsIgnoreCase("Standard")) {
            throw new PDFSecurityException("Security Provider Not Found.");
        }
        this.securityHandler = new StandardSecurityHandler(this.encryptDictionary);
        this.securityHandler.init();
    }

    public Permissions getPermissions() {
        return this.securityHandler.getPermissions();
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public EncryptionDictionary getEncryptionDictionary() {
        return this.encryptDictionary;
    }

    public byte[] getEncryptionKey() {
        return this.securityHandler.getEncryptionKey();
    }

    public byte[] getDecryptionKey() {
        return this.securityHandler.getDecryptionKey();
    }

    public byte[] encrypt(Reference reference, byte[] byArray, byte[] byArray2) {
        return this.securityHandler.encrypt(reference, byArray, byArray2);
    }

    public byte[] decrypt(Reference reference, byte[] byArray, byte[] byArray2) {
        return this.securityHandler.decrypt(reference, byArray, byArray2);
    }

    public InputStream getEncryptionInputStream(Reference reference, byte[] byArray, InputStream inputStream, boolean bl) {
        InputStream inputStream2 = this.securityHandler.getEncryptionInputStream(reference, byArray, inputStream);
        if (bl && inputStream2 == null) {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }

    public boolean isAuthorized(String string) {
        return this.securityHandler.isAuthorized(string);
    }

    static {
        String string = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        String string2 = Defs.sysProperty("org.icepdf.core.security.jceProvider");
        if (string2 != null) {
            string = string2;
        }
        try {
            Object obj = Class.forName(string).newInstance();
            Security.insertProviderAt((Provider)obj, 2);
            foundProvider = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, "Security Handler Not found");
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, "Security Handler could not be instantiated");
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, "Security Handler could not be created");
        }
    }
}

