/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.util.Library;

public class LinkAnnotation
extends Annotation {
    public static final int HIGHLIGHT_NONE = 0;
    public static final int HIGHLIGHT_INVERT = 1;
    public static final int HIGHLIGHT_OUTLINE = 2;
    public static final int HIGHLIGHT_PUSH = 3;

    public LinkAnnotation(Library library, Hashtable hashtable) {
        super(library, hashtable);
        this.borderColor = Color.black;
        Vector vector = (Vector)this.getObject("C");
        if (vector != null && vector.size() >= 3) {
            float f = ((Number)vector.get(0)).floatValue();
            float f2 = ((Number)vector.get(1)).floatValue();
            float f3 = ((Number)vector.get(2)).floatValue();
            f = Math.max(0.0f, Math.min(1.0f, f));
            f2 = Math.max(0.0f, Math.min(1.0f, f2));
            f3 = Math.max(0.0f, Math.min(1.0f, f3));
            this.borderColor = new Color(f, f2, f3);
        }
    }

    public int getHighlightMode() {
        Object object = this.getObject("H");
        if (object instanceof Name) {
            Name name = (Name)object;
            if (name.getName().equalsIgnoreCase("N")) {
                return 0;
            }
            if (name.getName().equalsIgnoreCase("O")) {
                return 2;
            }
            if (name.getName().equalsIgnoreCase("P")) {
                return 3;
            }
        }
        return 1;
    }

    public Destination getDestination() {
        Object object = this.library.getObject(this.entries, "Dest");
        if (object != null) {
            return new Destination(this.library, object);
        }
        return null;
    }
}

